/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.liquibase;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.OracleSkippedChangeVisitor;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.ext.OracleDatabaseV2;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.report.DiffToReport;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.ext.ora.generator.Generator;
import liquibase.ext.ora.utils.StringUtils;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.LiquibaseUtil;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExport;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportV1;
import oracle.dbtools.raptor.newscriptrunner.apex.AppNotInstalledException;
import oracle.dbtools.raptor.newscriptrunner.apex.DoNothingException;
import oracle.dbtools.raptor.newscriptrunner.apex.InvalidParameterException;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.ArgumentTokenizer;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.ProcessFailedException;
import oracle.dbtools.util.Service;

public class liquibaseCommand
extends CommandListener
implements IHelp,
SQLCLService {
    public static final String CONTROLLER_STRING = "controller";
    private final String VERSION = "2.0.0.0.0";
    private final String NAME = "Liquibase Command";
    private final String DESC = "Liquibase change management commands";
    private static List<String> commands = new ArrayList<String>(){
        {
            this.add("genobject");
            this.add("genschema");
            this.add("gencontrolfile");
            this.add("update");
            this.add("updatesql");
            this.add("rollback");
            this.add("rollbacksql");
            this.add("diff");
            this.add("dbdoc");
            this.add("status");
            this.add("validate");
            this.add("changelogsync");
            this.add("listlocks");
            this.add("releaselocks");
            this.add("clearchecksums");
            this.add("help");
            this.add("version");
        }
    };
    private String[] _args = null;
    private String _command = null;
    private final HashMap<String, String> _parms = new HashMap();
    private final ArrayList<String> _apexparms = new ArrayList();

    public void beginEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public void endEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public String getCommand() {
        return "LIQUIBASE";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return "Liquibase change management commands";
    }

    public String getExtensionName() {
        return "Liquibase Command";
    }

    public String getExtensionVersion() {
        return "2.0.0.0.0";
    }

    public String getHelp() {
        return Messages.getString("LB_HELP_OVERVIEW");
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write("\n");
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("lb") || cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("liquibase")) {
            try {
                this.processArgs(cmd.getSql());
            }
            catch (Exception e) {
                if (e instanceof ProcessFailedException) {
                    Exception e1 = ((ProcessFailedException)e).getOriginalException();
                    if (this.getBool("debug")) {
                        ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR2"), "Location \n" + e.getMessage(), "Message \n" + e1.getMessage()));
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e1.getMessage()));
                    }
                } else {
                    ctx.write(this.getHelp());
                }
                return true;
            }
            try {
                if (conn == null || !conn.isValid(10)) {
                    ctx.write(Messages.getString("LB_NO_CONNECTION"));
                    return true;
                }
            }
            catch (SQLException e) {
                ctx.write(Messages.getString("LB_NO_CONNECTION"));
                return true;
            }
            try {
                if (this._command.equalsIgnoreCase("help")) {
                    this.doHelp(conn, ctx);
                } else if (this._command.equalsIgnoreCase("genobject")) {
                    if (this._parms.get("type").equalsIgnoreCase("ords")) {
                        this.genObjectOrds(conn, ctx);
                    } else if (this._parms.get("type").equalsIgnoreCase("apex")) {
                        this.genObjectApex(conn, ctx);
                    } else {
                        this.genObjectDB(conn, ctx);
                    }
                } else if (this._command.equalsIgnoreCase("genschema")) {
                    this.genSchema(conn, ctx);
                } else if (this._command.equalsIgnoreCase("gencontrolfile")) {
                    this.genControlFile(conn, ctx);
                } else if (this._command.equalsIgnoreCase("update")) {
                    this.doUpadate(conn, ctx, null);
                } else if (this._command.equalsIgnoreCase("updatesql")) {
                    StringWriter writer = new StringWriter();
                    this.doUpadate(conn, ctx, writer);
                    ctx.write(writer.toString());
                } else if (this._command.equalsIgnoreCase("rollback")) {
                    this.doRollback(conn, ctx, null);
                } else if (this._command.equalsIgnoreCase("rollbacksql")) {
                    StringWriter writer = new StringWriter();
                    this.doRollback(conn, ctx, writer);
                    ctx.write(writer.toString());
                } else if (this._command.equalsIgnoreCase("diff")) {
                    this.doDiff(conn, ctx);
                } else if (this._command.equalsIgnoreCase("dbdoc")) {
                    this.doDoc(conn, ctx);
                } else if (this._command.equalsIgnoreCase("status")) {
                    this.doStatus(conn, ctx);
                } else if (this._command.equalsIgnoreCase("validate")) {
                    this.doValidate(conn, ctx);
                } else if (this._command.equalsIgnoreCase("changelogsync")) {
                    this.doLogSync(conn, ctx);
                } else if (this._command.equalsIgnoreCase("listlocks")) {
                    this.doListLocks(conn, ctx);
                } else if (this._command.equalsIgnoreCase("releaselocks")) {
                    this.doReleaseLocks(conn, ctx);
                } else if (this._command.equalsIgnoreCase("clearchecksums")) {
                    this.doClearCheckSums(conn, ctx);
                } else if (this._command.equalsIgnoreCase("version")) {
                    ctx.write("\nLiquibase version:   " + LiquibaseUtil.getBuildVersion());
                    ctx.write("\nExtension Version:   2.0.0.0.0");
                    ctx.write("\n\n");
                } else {
                    ctx.write(this.getHelp());
                }
                return true;
            }
            catch (Exception e) {
                if (e instanceof ProcessFailedException) {
                    Exception e1 = ((ProcessFailedException)e).getOriginalException();
                    if (this.getBool("debug")) {
                        e1.printStackTrace();
                        ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR2"), "Location \n" + e.getMessage(), "Message \n" + e1.getMessage()));
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e1.getMessage()));
                    }
                } else {
                    if (this.getBool("debug")) {
                        e.printStackTrace();
                    }
                    ctx.write(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e.getMessage()));
                }
                try {
                    this.doReleaseLocks(conn, ctx);
                }
                catch (ProcessFailedException processFailedException) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    public boolean isSqlPlus() {
        return false;
    }

    private void writeFile(String fileName, ScriptRunnerContext ctx, String data) throws ProcessFailedException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(ctx.prependCD(FileUtils.decodeIfFile((String)fileName))));
            writer.write(data);
            writer.close();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private String toString(DiffResult diffResult) throws ProcessFailedException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)out, true, "UTF-8");
            DiffToReport diffToReport = new DiffToReport(diffResult, printStream);
            diffToReport.print();
            printStream.close();
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private String toChangeLog(DiffResult diffResult) throws ProcessFailedException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)out, true, "UTF-8");
            DiffOutputControl diffOutputControl = new DiffOutputControl();
            diffOutputControl.setIncludeCatalog(false);
            diffOutputControl.setIncludeSchema(false);
            DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffResult, diffOutputControl);
            diffToChangeLog.print(printStream);
            printStream.close();
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private Liquibase getLiquibase(ScriptRunnerContext ctx, String changelog, String current, DatabaseConnection conn) throws ProcessFailedException {
        try {
            Liquibase liquibase = null;
            changelog = changelog != null ? StringUtils.trim(changelog) : "";
            File lwd = null;
            lwd = current == null ? new File("") : new File(current);
            liquibase = lwd != null && lwd.isDirectory() ? new Liquibase(ctx.prependCD(changelog), (ResourceAccessor)new FileSystemResourceAccessor(lwd.getAbsolutePath()), conn) : new Liquibase(ctx.prependCD(changelog), (ResourceAccessor)new FileSystemResourceAccessor(), conn);
            return liquibase;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void genObjectHelp(ScriptRunnerContext ctx, Connection conn) {
        ctx.write(Messages.getString("LB_HELP_GENOBJECT"));
        ctx.write(Messages.getString("LB_OBJECT_TYPES"));
        ctx.write("==================================================================\n\n");
        ctx.write(Messages.getString("LB_HELP_GENOBJECT_ORDS"));
        ctx.write("==================================================================\n\n");
        ctx.write(Messages.getString("LB_HELP_GENOBJECT_APEX"));
        try {
            if (Generator.newApexVersion(conn)) {
                APEXExport.usage((OutputStream)ctx.getOutputStream());
            } else {
                APEXExportV1.usage((OutputStream)ctx.getOutputStream());
            }
        }
        catch (AppNotInstalledException appNotInstalledException) {
            // empty catch block
        }
    }

    private void printArgs() {
        System.out.println(Arrays.asList(this._parms));
    }

    private void resetParms() {
        this._command = null;
        this._parms.clear();
        this._parms.put("emit_schema", "false");
        this._parms.put("silent", "false");
        this._parms.put("report", "true");
        this._parms.put("debug", "false");
        this._parms.put("enable", "true");
        this._parms.put("privs", "true");
        this._parms.put("synonyms", "false");
        this._parms.put("grants", "false");
        this._parms.put("log", "false");
        this._parms.put("fail", "false");
        this._parms.put("replace", "false");
        this._parms.put("runonchange", "false");
        this._parms.put("runalways", "false");
        this._parms.put("help", "");
        this._parms.put("changelog", "");
        this._parms.put("type", "");
        this._parms.put("name", "");
        this._parms.put("label", "");
        this._parms.put("context", "");
        this._parms.put("count", "");
        this._parms.put("url", "");
        this._parms.put("user", "");
        this._parms.put("password", "");
        this._parms.put("filename", "");
    }

    private String checkArg(String parm) throws ProcessFailedException {
        if (parm == null || parm.startsWith("-")) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("Bad Arguemnt value " + parm), "checkArg");
        }
        return parm;
    }

    private void processArgs(String cmd) throws DoNothingException, ProcessFailedException {
        this.resetParms();
        List<String> rawArgs = ArgumentTokenizer.tokenize(cmd, false);
        this._args = rawArgs.toArray(new String[0]);
        if (this._args.length == 2 && this._args[1].equalsIgnoreCase("help") || this._args.length < 2) {
            throw new DoNothingException();
        }
        for (int i = 1; i < this._args.length; ++i) {
            try {
                if (!this._args[i].startsWith("-")) {
                    if (this._args[i].equalsIgnoreCase("help")) {
                        if (this._command == null || this._command.isEmpty()) {
                            this._command = this._args[i];
                        } else {
                            this._parms.put("help", this._command);
                            this._command = this._args[i];
                        }
                    } else if (this._command == null || this._command.isEmpty()) {
                        this._command = this._args[i];
                    } else {
                        if (!commands.contains(this._args[i])) {
                            throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Unknown parameter or bad value supplied " + this._args[i]), "process_args");
                        }
                        this._parms.put("help", this._args[i]);
                    }
                    this._parms.put("command", this._command);
                    continue;
                }
                if (!this._args[i].startsWith("-") && !this._args[i].equalsIgnoreCase("help")) {
                    this._parms.put("command", this._command);
                    this._command = this._args[i];
                    this._parms.put("help", this._args[i]);
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-changelog")) {
                    this._parms.put("changelog", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-type")) {
                    this._parms.put("type", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-name")) {
                    this._parms.put("name", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-emit_schema")) {
                    this._parms.put("emit_schema", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-label")) {
                    this._parms.put("label", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-context")) {
                    this._parms.put("context", this.checkArg(this.checkArg(this._args[++i])));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-count")) {
                    this._parms.put("count", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-url")) {
                    this._parms.put("url", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-user")) {
                    this._parms.put("user", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-password")) {
                    this._parms.put("password", this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-silent")) {
                    this._parms.put("silent", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-noreport")) {
                    this._parms.put("report", "false");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-debug")) {
                    this._parms.put("debug", "true");
                    this._apexparms.add("-debug");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-noenable")) {
                    this._parms.put("enable", "false");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-noprivs")) {
                    this._parms.put("privs", "false");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-synonyms")) {
                    this._parms.put("synonyms", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-grants")) {
                    this._parms.put("grants", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-log")) {
                    this._parms.put("log", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-fail")) {
                    this._parms.put("fail", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-replace")) {
                    this._parms.put("replace", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-runonchange")) {
                    this._parms.put("runonchange", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-runalways")) {
                    this._parms.put("runalways", "true");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-h")) {
                    this._apexparms.add("-h");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-db")) {
                    this._apexparms.add("-db");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-user")) {
                    this._apexparms.add("-user");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-password")) {
                    this._apexparms.add("-password");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-workspaceid")) {
                    this._apexparms.add("-workspaceid");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-applicationid")) {
                    this._apexparms.add("-applicationid");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-skipExportDate")) {
                    this._apexparms.add("-skipExportDate");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expPubReports")) {
                    this._apexparms.add("-expPubReports");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expSavedReports")) {
                    this._apexparms.add("-expSavedReports");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expIRNotif")) {
                    this._apexparms.add("-expIRNotif");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expTranslations")) {
                    this._apexparms.add("-expTranslations");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-instance")) {
                    this._apexparms.add("instance");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expWorkspace")) {
                    this._apexparms.add("-expWorkspace");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expMinimal")) {
                    this._apexparms.add("-expMinimal");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expFiles")) {
                    this._apexparms.add("-expFiles");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expFeedback")) {
                    this._apexparms.add("-expFeedback");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expTeamdevdata")) {
                    this._apexparms.add("-expTeamdevdata");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-deploymentSystem")) {
                    this._apexparms.add("-deploymentSystem");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expFeedbackSince")) {
                    SimpleDateFormat dtFmt = new SimpleDateFormat("yyyyMMdd");
                    String mydate = "";
                    try {
                        mydate = this.checkArg(this._args[++i]);
                        dtFmt.parse(mydate);
                        this._apexparms.add("-expFeedbackSince");
                        this._apexparms.add(mydate);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad expFeedbackSince " + mydate), "process_args");
                    }
                }
                if (this._args[i].equalsIgnoreCase("-expOriginalIds")) {
                    this._apexparms.add("-expOriginalIds");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-split")) {
                    this._apexparms.add("-split");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expNoSubscriptions")) {
                    this._apexparms.add("-expNoSubscriptions");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expComments")) {
                    this._apexparms.add("-expComments");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expSupportingObjects")) {
                    String _expSupportingObjects = this.checkArg(this._args[++i]);
                    if (!Arrays.asList("Y", "I", "N").contains(_expSupportingObjects)) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad expSupportingObjects " + this.checkArg(this._args[++i])), "process_args");
                    }
                    this._apexparms.add("-expSupportingObjects");
                    this._apexparms.add(_expSupportingObjects);
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expACLAssignments")) {
                    this._apexparms.add("-expACLAssignments");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expLocked")) {
                    this._apexparms.add("-expLocked");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-nochecksum")) {
                    this._apexparms.add("-nochecksum");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-dir")) {
                    if (i == this._args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -dir "), "process_args");
                    }
                    String dir = this._args[++i];
                    this._apexparms.add("-dir");
                    this._apexparms.add(this.checkArg(dir));
                    this._parms.put("dir", dir);
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-list")) {
                    this._apexparms.add("-list");
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-changesSince")) {
                    if (i == this._args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -changesSince "), "process_args");
                    }
                    this._apexparms.add("-changesSince");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-changesBy")) {
                    if (i == this._args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -changesBy "), "process_args");
                    }
                    this._apexparms.add("-changesBy");
                    this._apexparms.add(this.checkArg(this._args[++i]));
                    continue;
                }
                if (this._args[i].equalsIgnoreCase("-expComponents")) {
                    String _components = null;
                    while (++i < this._args.length) {
                        _components = _components + "#" + this._args[i];
                    }
                    this._apexparms.add("-expComponents");
                    this._apexparms.add(_components);
                    continue;
                }
                throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Unknown parameter or bad value supplied " + this._args[i]), "process_args");
            }
            catch (Exception e) {
                if (!(e instanceof ProcessFailedException)) continue;
                throw e;
            }
        }
        if (!commands.contains(this._command)) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Unknown command supplied please check your arguments. - " + this._command), "processArgs");
        }
        if (!(this._args.length != 2 || this._command.equalsIgnoreCase("genschema") || this._command.equalsIgnoreCase("version") || this._command.equalsIgnoreCase("gencontrolfile"))) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Invalid number or parameters supplied unable to do anything. "), "processArgs");
        }
        if (this.getBool("debug")) {
            this.printArgs();
        }
    }

    private void doHelp(Connection conn, ScriptRunnerContext ctx) {
        String _help = this._parms.get("help");
        String _type = this._parms.get("type");
        if (_help.equalsIgnoreCase("genobject")) {
            if (_type.equalsIgnoreCase("APEX")) {
                ctx.write(Messages.getString("LB_HELP_GENOBJECT_APEX"));
            } else if (_type.equalsIgnoreCase("ORDS")) {
                ctx.write(Messages.getString("LB_HELP_GENOBJECT_ORDS"));
            } else if (!_type.equalsIgnoreCase("")) {
                ctx.write(Messages.getString("LB_HELP_GENOBJECT"));
                ctx.write(Messages.getString("LB_OBJECT_TYPES"));
            } else {
                this.genObjectHelp(ctx, conn);
            }
        } else if (_help.equalsIgnoreCase("genschema")) {
            ctx.write(Messages.getString("LB_HELP_GENSCHEMA"));
        } else if (_help.equalsIgnoreCase("gencontrolfile")) {
            ctx.write(Messages.getString("LB_HELP_GENCONTROLFILE"));
        } else if (_help.equalsIgnoreCase("update")) {
            ctx.write(Messages.getString("LB_HELP_UPDATE"));
        } else if (_help.equalsIgnoreCase("updatesql")) {
            ctx.write(Messages.getString("LB_HELP_UPDATESQL"));
        } else if (_help.equalsIgnoreCase("rollback")) {
            ctx.write(Messages.getString("LB_HELP_ROLLBACK"));
        } else if (_help.equalsIgnoreCase("rollbacksql")) {
            ctx.write(Messages.getString("LB_HELP_ROLLBACKSQL"));
        } else if (_help.equalsIgnoreCase("diff")) {
            ctx.write(Messages.getString("LB_HELP_DIFF"));
        } else if (_help.equalsIgnoreCase("dbdoc")) {
            ctx.write(Messages.getString("LB_HELP_DBDOC"));
        } else if (_help.equalsIgnoreCase("status")) {
            ctx.write(Messages.getString("LB_HELP_STATUS"));
        } else if (_help.equalsIgnoreCase("version")) {
            ctx.write(Messages.getString("LB_HELP_VERSION"));
        } else if (_help.equalsIgnoreCase("validate")) {
            ctx.write(Messages.getString("LB_HELP_VALIDATE"));
        } else if (_help.equalsIgnoreCase("changelogsync")) {
            ctx.write(Messages.getString("LB_HELP_CHANGELOGSYNC"));
        } else if (_help.equalsIgnoreCase("listlocks")) {
            ctx.write(Messages.getString("LB_HELP_LISTLOCKS"));
        } else if (_help.equalsIgnoreCase("releaselocks")) {
            ctx.write(Messages.getString("LB_HELP_RELEASELOCKS"));
        } else if (_help.equalsIgnoreCase("clearchecksums")) {
            ctx.write(Messages.getString("LB_HELP_CLEARCHECKSUMS"));
        } else {
            ctx.write(this.getHelp());
        }
    }

    private boolean getBool(String name) {
        String parm = this._parms.get(name);
        return Boolean.parseBoolean(parm);
    }

    private void genSchema(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        Generator gen = new Generator(conn, ctx);
        try {
            gen.doSchemaExport(this._parms);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            gen.Destroy();
        }
    }

    private void genObjectApex(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        Generator gen = new Generator(conn, ctx);
        gen.setApexArgs(this._apexparms);
        try {
            gen.writeApexChangeLog(this._parms);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            gen.Destroy();
        }
    }

    private void genObjectOrds(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        Generator gen = new Generator(conn, ctx);
        String fileName = null;
        fileName = this._parms.get("name") != null ? ("ords-rest_" + this._parms.get("name")).toLowerCase() : "ords-rest_schema".toLowerCase();
        int count = 1;
        File file = new File(ctx.prependCD(FileUtils.decodeIfFile((String)(fileName + ".xml"))));
        while (file.exists()) {
            fileName = (fileName + count++ + ".xml").toLowerCase();
            file = new File(ctx.prependCD(FileUtils.decodeIfFile((String)fileName)));
        }
        fileName = file.getName();
        try {
            this._parms.replace("filename", fileName);
            gen.writeOrdsChangeLog(this._parms);
            ctx.write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), fileName));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            gen.Destroy();
        }
    }

    private void genObjectDB(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        String name = this._parms.get("name").contains("\"") ? Service.handleMixedCase((String)this._parms.get("name"), (boolean)true) : this._parms.get("name").toUpperCase();
        this._parms.replace("name", name);
        Generator gen = new Generator(conn, ctx);
        String fileName = (name + "_" + this._parms.get("type") + ".xml").toLowerCase();
        int count = 1;
        File file = new File(ctx.prependCD(FileUtils.decodeIfFile((String)fileName)));
        while (file.exists()) {
            fileName = (name + "_" + this._parms.get("type") + count++ + ".xml").toLowerCase();
            file = new File(ctx.prependCD(FileUtils.decodeIfFile((String)fileName)));
        }
        try {
            this._parms.replace("filename", fileName);
            gen.writeChangeLog(this._parms);
            ctx.write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), fileName));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            gen.Destroy();
        }
    }

    private void genControlFile(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        Generator gen = new Generator(conn, ctx);
        String fileName = ctx.prependCD("controller.XML".toLowerCase());
        try {
            gen.writeMasterLog(fileName);
            ctx.write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), fileName));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            gen.Destroy();
        }
    }

    private void doDoc(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            Database database = liquibase.getDatabase();
            if (database instanceof OracleDatabaseV2) {
                ((OracleDatabaseV2)database).includeSchema(this.getBool("schema"));
            }
            liquibase.generateDocumentation(this._parms.get("dir"), new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog, Database database) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ShouldRunChangeSetFilter(database, true), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(database), new IgnoreChangeSetFilter()});
    }

    private void doUpadate(Connection conn, ScriptRunnerContext ctx, StringWriter writer) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            Database database = liquibase.getDatabase();
            if (database instanceof OracleDatabaseV2) {
                ((OracleDatabaseV2)database).includeSchema(this.getBool("schema"));
            }
            if (this.getBool("log")) {
                String fileName = this._parms.get("changelog") + "-" + new Date().getTime() + ".log";
                FileOutputStream fw = new FileOutputStream(ctx.prependCD("") + fileName);
                BufferedOutputStream out = new BufferedOutputStream(fw);
                ((OracleDatabaseV2)database).setOutWriter(out);
            }
            DatabaseChangeLog changeLog = liquibase.getDatabaseChangeLog();
            ChangeLogIterator changeLogIterator = this.getStandardChangelogIterator(new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")), changeLog, database);
            ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).generateDeploymentId();
            changeLogIterator.run((ChangeSetVisitor)new OracleSkippedChangeVisitor(ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getDeploymentId()), new RuntimeEnvironment(database, new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label"))));
            if (writer == null) {
                liquibase.update(new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")));
            } else {
                liquibase.update(new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")), (Writer)writer);
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void doRollback(Connection conn, ScriptRunnerContext ctx, StringWriter writer) throws ProcessFailedException {
        block19: {
            try {
                Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(conn));
                Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), database.getConnection());
                SimpleDateFormat dtFmt = new SimpleDateFormat("MM/dd/yyyy");
                String mydate = this._parms.get("date");
                int count = 0;
                Date date = null;
                try {
                    count = Integer.valueOf(this._parms.get("count"));
                }
                catch (Exception e) {
                    count = 0;
                }
                try {
                    date = dtFmt.parse(mydate);
                }
                catch (Exception e) {
                    date = null;
                }
                if (date == null && count == 0) {
                    throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: count or date must be supplied"), Thread.currentThread().getStackTrace()[1].getMethodName());
                }
                if (date != null && count > 0) {
                    throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: either count or date must be supplied not both "), Thread.currentThread().getStackTrace()[1].getMethodName());
                }
                if (database instanceof OracleDatabaseV2) {
                    DatabaseChangeLog changeLog = liquibase.getDatabaseChangeLog();
                    for (ChangeSet set : changeLog.getChangeSets()) {
                        String action = ((OracleDatabaseV2)database).getXmlFromActionsLog(set.getId(), set.getAuthor(), set.getFilePath());
                        if (action == null || !action.equalsIgnoreCase("--skipped")) continue;
                        Executor oldExecutor = ExecutorService.getInstance().getExecutor(database);
                        if (writer != null) {
                            ExecutorService.getInstance().setExecutor(database, (Executor)new LoggingExecutor(ExecutorService.getInstance().getExecutor(database), (Writer)writer, database));
                            ExecutorService.getInstance().getExecutor(database).comment("Due to Custom rollback process this needs to be prepended to the rollback Script.");
                            ExecutorService.getInstance().getExecutor(database).comment("Rolling Back ChangeSet: " + set.getFilePath() + "::" + set.getId() + "::" + set.getAuthor());
                            ExecutorService.getInstance().getExecutor(database).execute(((OracleDatabaseV2)database).getRollbackAction(set.getId(), set.getAuthor(), set.getFilePath()));
                            ExecutorService.getInstance().setExecutor(database, oldExecutor);
                        } else {
                            ExecutorService.getInstance().getExecutor(database).execute(((OracleDatabaseV2)database).getRollbackAction(set.getId(), set.getAuthor(), set.getFilePath()));
                            database.commit();
                        }
                        set.setIgnore(true);
                    }
                }
                if (count > 0) {
                    if (writer == null) {
                        liquibase.rollback(count, new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")));
                    } else {
                        liquibase.rollback(count, new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")), (Writer)writer);
                    }
                    break block19;
                }
                if (date != null) {
                    if (writer == null) {
                        liquibase.rollback(date, new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")));
                    } else {
                        liquibase.rollback(date, new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")), (Writer)writer);
                    }
                    break block19;
                }
                throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Don't knwo how to apply rollback "), Thread.currentThread().getStackTrace()[1].getMethodName());
            }
            catch (Exception e) {
                if (e instanceof ProcessFailedException) {
                    throw (ProcessFailedException)e;
                }
                throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
            }
        }
    }

    private void doStatus(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            liquibase.reportStatus(true, this._parms.get("context"), (Writer)new OutputStreamWriter((OutputStream)ctx.getOutputStream()));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void doValidate(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            liquibase.validate();
            ctx.write(MessageFormat.format(Messages.getString("LB_FILE_VALID"), this._parms.get("changelog")));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void doClearCheckSums(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            liquibase.clearCheckSums();
            ctx.write(MessageFormat.format(Messages.getString("LB_CHECK_SUCCESS"), this._parms.get("changelog")));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void doReleaseLocks(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            liquibase.forceReleaseLocks();
            ctx.write(MessageFormat.format(Messages.getString("LB_LOCK_SUCCESS"), this._parms.get("changelog")));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void doLogSync(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            liquibase.changeLogSync(new Contexts(this._parms.get("context")), new LabelExpression(this._parms.get("label")), (Writer)new OutputStreamWriter((OutputStream)ctx.getOutputStream()));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void doListLocks(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Liquibase liquibase = this.getLiquibase(ctx, this._parms.get("changelog"), ctx.prependCD(""), (DatabaseConnection)new JdbcConnection(conn));
            DatabaseChangeLogLock[] locks = liquibase.listLocks();
            if (locks.length > 0) {
                ctx.write("\nID\t\tUSER\n");
                for (DatabaseChangeLogLock lock : locks) {
                    ctx.write(Messages.getString(lock.getId() + "\t\t" + lock.getLockedBy() + "\n"));
                }
            } else {
                ctx.write(Messages.getString("LB_NO_LOCKS"));
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void doDiff(Connection conn, ScriptRunnerContext ctx) throws ProcessFailedException {
        try {
            Connection c = DriverManager.getConnection("jdbc:oracle:thin:@" + this._parms.get("url"), this._parms.get("user"), this._parms.get("password"));
            Liquibase liquibase = this.getLiquibase(ctx, null, null, (DatabaseConnection)new JdbcConnection(c));
            Database source = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(conn));
            Database dest = liquibase.getDatabase();
            DiffResult diff = liquibase.diff(source, dest, CompareControl.STANDARD);
            if (this.getBool("report")) {
                this.writeFile("diffResult.txt", ctx, this.toString(diff));
                ctx.write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), "diffResult.txt"));
            } else {
                this.writeFile("diffResult.xml", ctx, this.toChangeLog(diff));
                ctx.write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), "diffResult.xml"));
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }
}

