/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ListenerUserPasswdPanel
extends JPanel {
    private JLabel _usernameLbl;
    private JTextField _usernameTxtFld;
    private JPasswordField _password;
    private JPasswordField _confirmPassword;
    private StringBuilder errMsg;
    private String _descripKey;
    private boolean _canModifyUser;
    private boolean _requiresPassword;
    private boolean _isGlobalSetting;
    private boolean _includeUserName;

    public ListenerUserPasswdPanel(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, true);
    }

    public ListenerUserPasswdPanel(String string, boolean bl, boolean bl2, boolean bl3) {
        this._descripKey = string;
        this._canModifyUser = bl;
        this._requiresPassword = bl2;
        this._includeUserName = bl3;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = null;
        if (this._includeUserName) {
            if (this._canModifyUser) {
                this._usernameTxtFld = new JTextField();
            } else {
                this._usernameLbl = new JLabel();
            }
            jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)(this._canModifyUser ? this._usernameTxtFld : this._usernameLbl), (String)StringUtils.stripMnemonic((String)ListenerArb.getString("USERNAME")));
        }
        this._password = new JPasswordField();
        this._confirmPassword = new JPasswordField();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._password, (String)ListenerArb.getString("PASSWORD"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._confirmPassword, (String)ListenerArb.getString("CONFIRM_PASSWORD"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(ListenerArb.getString(this._descripKey));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        if (this._includeUserName) {
            jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP));
            if (this._canModifyUser) {
                jPanel.add((Component)this._usernameTxtFld, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            } else {
                jPanel.add((Component)this._usernameLbl, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            }
        }
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this._password, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this._confirmPassword, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        n = 0;
        this.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)this, (int)(++n));
    }

    public void setUsername(String string) {
        if (this._canModifyUser) {
            this._usernameTxtFld.setText(string);
        } else {
            this._usernameLbl.setText(string);
        }
    }

    public String getUsername() {
        if (this._canModifyUser) {
            return this._usernameTxtFld.getText();
        }
        return this._usernameLbl.getText();
    }

    public void setPasswords(String string) {
        String string2 = string;
        if (string != null && !string.isEmpty() && string.trim().length() > 0 && string.startsWith("@")) {
            string2 = string.length() > 1 ? Passwords.comingIn((String)string.substring(1)) : "";
        }
        this._password.setText(string2);
        this._confirmPassword.setText(string2);
    }

    public String getPassword() {
        if (this._password.getPassword() != null && this._password.getPassword().length > 0) {
            String string = new String(this._password.getPassword());
            if (string != null && !(string = string.trim()).isEmpty()) {
                string = "@" + Passwords.goingOut((String)string);
            }
            return string;
        }
        return null;
    }

    protected JTextField getUsernameTextField() {
        return this._usernameTxtFld;
    }

    protected JPasswordField getPasswordField() {
        return this._password;
    }

    protected JPasswordField getConfirmPasswordField() {
        return this._confirmPassword;
    }

    protected void setRequiresPassword(boolean bl) {
        this._requiresPassword = bl;
    }

    protected void setGlobalSetting(boolean bl) {
        this._isGlobalSetting = bl;
    }

    public boolean validInfo() {
        boolean bl = true;
        this.initErrorMessage();
        String string = null;
        if (this._includeUserName) {
            String string2 = string = this._canModifyUser ? this._usernameTxtFld.getText() : this._usernameLbl.getText();
        }
        if (this._requiresPassword) {
            if (this._includeUserName && (this._canModifyUser && string == null || string.trim().length() == 0)) {
                this._usernameTxtFld.requestFocus();
                this.errMsg.append(ListenerArb.getString("ERROR_USERNAME_MISSING"));
                return false;
            }
            bl = this.validatePasswords();
        } else if (this._includeUserName && this._canModifyUser) {
            if (string != null && string.trim().length() > 0) {
                if (!this._isGlobalSetting || this._password != null && !this.isAllWhiteSpace(this._password.getPassword()) || this._confirmPassword != null && !this.isAllWhiteSpace(this._confirmPassword.getPassword())) {
                    bl = this.validatePasswords();
                }
            } else if (this._password != null && !this.isAllWhiteSpace(this._password.getPassword()) || this._confirmPassword != null && !this.isAllWhiteSpace(this._confirmPassword.getPassword())) {
                this._usernameTxtFld.requestFocus();
                this.errMsg.append(ListenerArb.getString("ERROR_USERNAME_MISSING"));
                return false;
            }
        } else if (this._password != null && !this.isAllWhiteSpace(this._password.getPassword()) || this._confirmPassword != null && !this.isAllWhiteSpace(this._confirmPassword.getPassword())) {
            bl = this.validatePasswords();
        }
        return bl;
    }

    private void initErrorMessage() {
        if (this.errMsg == null) {
            this.errMsg = new StringBuilder();
        } else if (this.errMsg.length() > 0) {
            this.errMsg.delete(0, this.errMsg.length());
        }
    }

    public boolean isAllWhiteSpace(char[] cArray) {
        if (cArray != null && cArray.length > 0) {
            for (char c : cArray) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validatePasswords() {
        String string = "";
        if (this._includeUserName) {
            String string2 = string = this._canModifyUser ? this._usernameTxtFld.getText() : this._usernameLbl.getText();
        }
        if (this._password != null && this._password.getPassword().length > 0 && this._confirmPassword != null && this._confirmPassword.getPassword().length > 0) {
            if (!this.isAllWhiteSpace(this._password.getPassword())) {
                if (!this.isAllWhiteSpace(this._confirmPassword.getPassword())) {
                    if (Arrays.equals(this._password.getPassword(), this._confirmPassword.getPassword())) {
                        return true;
                    }
                    this._password.requestFocus();
                    String string3 = !string.isEmpty() ? "ERROR_TRY_AGAIN_PASSWORD" : "ERROR_TRY_AGAIN_PASSWORD2";
                    this.errMsg.append(ListenerArb.format(string3, string));
                } else {
                    this._confirmPassword.requestFocus();
                    String string4 = !string.isEmpty() ? "ERROR_CONFIRM_PWD_ALL_SPACES" : "ERROR_CONFIRM_PWD_ALL_SPACES2";
                    this.errMsg.append(ListenerArb.format(string4, string));
                }
            } else {
                this._password.requestFocus();
                String string5 = !string.isEmpty() ? "ERROR_PWD_ALL_SPACES" : "ERROR_PWD_ALL_SPACES2";
                this.errMsg.append(ListenerArb.format(string5, string));
            }
        } else {
            if (this._password == null || this._password.getPassword().length == 0) {
                this._password.requestFocus();
                this.errMsg.append(ListenerArb.format("ERROR_MISSING_PASSWORD", string));
            }
            if (this._confirmPassword == null || this._confirmPassword.getPassword().length == 0) {
                if (this.errMsg.length() == 0) {
                    this._confirmPassword.requestFocus();
                } else {
                    this.errMsg.append("\n");
                }
                this.errMsg.append(ListenerArb.format("ERROR_MISSING_CONFIRM_PASSWORD", string));
            }
        }
        return this.errMsg.length() <= 0;
    }

    public void showErrors(String string) {
        if (this.errMsg != null && this.errMsg.length() > 0) {
            MessageDialog.error((Component)this, (Object)this.errMsg.toString(), (String)ListenerArb.format("ERROR_TITLE", ListenerArb.getString(string)), null);
        }
    }
}

