/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.migration;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import oracle.jdevimpl.db.resource.ConnBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConnectionsInfo {
    private final URL m_url;
    private boolean m_containsPasswords;
    private boolean m_requiresPassphrase;
    private Boolean m_legacy;

    private ConnectionsInfo(URL uRL) {
        this.m_url = uRL;
    }

    public URL getURL() {
        return this.m_url;
    }

    public boolean containsPasswords() {
        return this.m_containsPasswords;
    }

    public boolean requiresPassphrase() {
        return this.m_requiresPassphrase;
    }

    public boolean isLegacyCMFormat() {
        return Boolean.TRUE.equals(this.m_legacy);
    }

    public static ConnectionsInfo getConnectionsInfo(URL uRL) throws ConnectionException {
        ConnectionsInfo connectionsInfo = new ConnectionsInfo(uRL);
        PasswordHandler passwordHandler = new PasswordHandler(connectionsInfo);
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(passwordHandler);
            xMLReader.parse(uRL.toString());
        }
        catch (WeGotWhatWeWantedException weGotWhatWeWantedException) {
        }
        catch (IOException iOException) {
            throw new ConnectionException(ConnBundle.format("INFOPARSE_ERR", iOException.getMessage()), iOException);
        }
        catch (SAXException sAXException) {
            throw new ConnectionException(ConnBundle.format("INFOPARSE_ERR", sAXException.getMessage()), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConnectionException(ConnBundle.format("INFOPARSE_ERR", parserConfigurationException.getMessage()), parserConfigurationException);
        }
        if (connectionsInfo.m_legacy == null) {
            throw new ConnectionException(ConnBundle.get("INFOPARSE_FORMAT_ERR"));
        }
        return connectionsInfo;
    }

    private static class WeGotWhatWeWantedException
    extends SAXException {
        private WeGotWhatWeWantedException() {
        }
    }

    private static class PasswordHandler
    extends DefaultHandler {
        private final String CONNECTIONS = "connections";
        private final String PWD = "PWD";
        private final String REFERENCES = "References";
        private final String REFERENCE = "Reference";
        private final String FACTORY = "Factory";
        private final String STRING_REF_ADDR = "StringRefAddr";
        private final String ADDR_TYPE = "addrType";
        private final String CLASS_NAME = "className";
        private ConnectionsInfo m_info;
        private boolean m_inDBConn;

        PasswordHandler(ConnectionsInfo connectionsInfo) {
            this.m_info = connectionsInfo;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("References".equals(string2)) {
                this.m_info.m_legacy = false;
            } else if ("connections".equals(string2)) {
                this.m_info.m_legacy = true;
            } else if (Boolean.FALSE.equals(this.m_info.m_legacy)) {
                if ("Reference".equals(string2)) {
                    if ("oracle.jdeveloper.db.adapter.DatabaseProvider".equals(attributes.getValue("className"))) {
                        this.m_inDBConn = true;
                    }
                } else if (this.m_inDBConn) {
                    if ("Factory".equals(string2)) {
                        String string4 = attributes.getValue("className");
                        if (DatabaseProviderFactory1212.class.getName().equals(string4)) {
                            this.m_info.m_requiresPassphrase = true;
                        }
                    } else if ("StringRefAddr".equals(string2) && "password".equals(attributes.getValue("addrType"))) {
                        this.m_info.m_containsPasswords = true;
                    }
                }
            } else if (Boolean.TRUE.equals(this.m_info.m_legacy) && "PWD".equals(string2)) {
                this.m_info.m_containsPasswords = true;
            }
            if (this.m_info.m_containsPasswords && this.m_info.m_requiresPassphrase) {
                throw new WeGotWhatWeWantedException();
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("Reference".equals(string2)) {
                this.m_inDBConn = false;
            }
        }
    }
}

