/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.migration;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ide.util.MetaClass;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import oracle.jdeveloper.db.adapter.DatabaseProviderFactory;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConnectionsReader {
    private static final String REFERENCES_ELEMENT = "References";
    private static final String REFERENCE_ELEMENT = "Reference";
    private static final String FACTORY_ELEMENT = "Factory";
    private static final String STRING_REF_ADDR_ELEMENT = "StringRefAddr";
    private static final String REF_ADDRS_ELEMENT = "RefAddresses";
    private static final String ADDR_TYPE_ATTRIBUTE = "addrType";
    private static final String CLASS_NAME_ATTRIBUTE = "className";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CONTENTS_ELEMENT = "Contents";
    static final String LEGACY_DATABASE_PROVIDER_NAME = "oracle.jdeveloper.db.adapter.DatabaseProvider";
    private final Hashtable mEnv;
    private Map<String, List<Pair<String, ConnectionReferenceable>>> mConnections = new HashMap<String, List<Pair<String, ConnectionReferenceable>>>();
    private CAHandler mHandler = new CAHandler();

    public static ConnectionsReader readConnections(URL uRL, ReferenceWorker referenceWorker) {
        Hashtable<String, ReferenceWorker> hashtable = new Hashtable<String, ReferenceWorker>();
        hashtable.put(ReferenceWorker.KEY, referenceWorker);
        ConnectionsReader connectionsReader = new ConnectionsReader(hashtable);
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(connectionsReader.getContentHandler());
            xMLReader.parse(uRL.toString());
        }
        catch (InvalidCAFormatException invalidCAFormatException) {
            connectionsReader = null;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            Logger.severe(ConnectionsReader.class, (Throwable)exception);
        }
        return connectionsReader;
    }

    public static void registerObjectFactoryClass(MetaClass<? extends ObjectFactory> metaClass) {
        ClassRegistry.registerClass(metaClass);
    }

    private ConnectionsReader(Hashtable hashtable) {
        this.mEnv = hashtable;
    }

    private ContentHandler getContentHandler() {
        return this.mHandler;
    }

    public Set<String> getConnectionTypes() {
        return this.mConnections.keySet();
    }

    private void addConnection(String string, String string2, ConnectionReferenceable connectionReferenceable) {
        List<Pair<String, ConnectionReferenceable>> list = this.mConnections.get(string);
        if (list == null) {
            list = new ArrayList<Pair<String, ConnectionReferenceable>>();
            this.mConnections.put(string, list);
        }
        list.add((Pair<String, ConnectionReferenceable>)new Pair((Object)string2, (Object)connectionReferenceable));
    }

    public Collection<Pair<String, ConnectionReferenceable>> getConnections(String string) {
        return this.mConnections.get(string);
    }

    private class CAHandler
    extends DefaultHandler {
        private Stage mStage = null;
        private ConnectionData mCurrentConnection;

        private CAHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.mStage = Stage.DOCUMENT;
        }

        @Override
        public void endDocument() throws SAXException {
            this.mStage = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (this.mStage) {
                case DOCUMENT: {
                    if (ConnectionsReader.REFERENCES_ELEMENT.equals(string2)) {
                        this.mStage = Stage.REFERENCES;
                        break;
                    }
                    throw new InvalidCAFormatException();
                }
                case REFERENCES: {
                    String string4;
                    String string5;
                    if (!ConnectionsReader.REFERENCE_ELEMENT.equals(string2)) break;
                    this.mStage = Stage.REFERENCE;
                    String string6 = attributes.getValue(ConnectionsReader.NAME_ATTRIBUTE);
                    if (!ModelUtil.hasLength((String)string6)) break;
                    String string7 = attributes.getValue(ConnectionsReader.CLASS_NAME_ATTRIBUTE);
                    int n = string6.indexOf(47);
                    if (n >= 0) {
                        string5 = string6.substring(0, n);
                        string4 = string6.substring(n + 1);
                    } else {
                        string4 = string6;
                        string5 = ConnectionsReader.LEGACY_DATABASE_PROVIDER_NAME.equals(string7) ? "jdbc" : null;
                    }
                    if (string5 == null || string4 == null) break;
                    this.mCurrentConnection = new ConnectionData(string5, string4, string7);
                    break;
                }
                case REFERENCE: {
                    if (this.mCurrentConnection == null) break;
                    if (ConnectionsReader.FACTORY_ELEMENT.equals(string2)) {
                        this.mCurrentConnection.setFactoryClass(attributes.getValue(ConnectionsReader.CLASS_NAME_ATTRIBUTE));
                        break;
                    }
                    if (!ConnectionsReader.REF_ADDRS_ELEMENT.equals(string2)) break;
                    this.mStage = Stage.PROPERTIES;
                    break;
                }
                case PROPERTIES: {
                    if (this.mCurrentConnection == null || !ConnectionsReader.STRING_REF_ADDR_ELEMENT.equals(string2)) break;
                    this.mStage = Stage.PROPERTY_NAME;
                    String string8 = attributes.getValue(ConnectionsReader.ADDR_TYPE_ATTRIBUTE);
                    if (string8 == null) break;
                    this.mCurrentConnection.startProperty(string8);
                    break;
                }
                case PROPERTY_NAME: {
                    if (this.mCurrentConnection == null || !ConnectionsReader.CONTENTS_ELEMENT.equals(string2)) break;
                    this.mStage = Stage.PROPERTY_VALUE;
                    break;
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.mCurrentConnection != null && this.mStage == Stage.PROPERTY_VALUE) {
                this.mCurrentConnection.propertyCharacters(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.mStage) {
                case DOCUMENT: {
                    break;
                }
                case REFERENCES: {
                    this.mStage = Stage.DOCUMENT;
                    break;
                }
                case REFERENCE: {
                    if (!ConnectionsReader.REFERENCE_ELEMENT.equals(string2)) break;
                    this.mStage = Stage.REFERENCES;
                    ConnectionsReader.this.addConnection(this.mCurrentConnection.getType(), this.mCurrentConnection.getName(), this.mCurrentConnection.getConnection(ConnectionsReader.this.mEnv));
                    this.mCurrentConnection = null;
                    break;
                }
                case PROPERTIES: {
                    this.mStage = Stage.REFERENCE;
                    break;
                }
                case PROPERTY_NAME: {
                    this.mStage = Stage.PROPERTIES;
                    break;
                }
                case PROPERTY_VALUE: {
                    this.mCurrentConnection.endProperty();
                    this.mStage = Stage.PROPERTY_NAME;
                }
            }
        }
    }

    private static class ConnectionData {
        private final String mType;
        private final String mName;
        private final Reference mReference;
        private String mFactoryClass;
        private String mCurrentPropertyName;
        private StringBuffer mCurrentPropertyValue;

        ConnectionData(String string, String string2, String string3) {
            this.mType = string;
            this.mName = string2;
            this.mReference = new Reference(string3);
        }

        String getType() {
            return this.mType;
        }

        String getName() {
            return this.mName;
        }

        void setFactoryClass(String string) {
            this.mFactoryClass = string;
        }

        void startProperty(String string) {
            this.mCurrentPropertyName = string;
            this.mCurrentPropertyValue = new StringBuffer();
        }

        void propertyCharacters(char[] cArray, int n, int n2) {
            if (this.mCurrentPropertyValue != null) {
                this.mCurrentPropertyValue.append(cArray, n, n2);
            }
        }

        void endProperty() {
            if (this.mCurrentPropertyName != null) {
                StringRefAddr stringRefAddr = new StringRefAddr(this.mCurrentPropertyName, this.mCurrentPropertyValue.toString());
                this.mReference.add(stringRefAddr);
                this.mCurrentPropertyName = null;
                this.mCurrentPropertyValue = null;
            }
        }

        public ConnectionReferenceable getConnection(Hashtable hashtable) {
            ConnectionReferenceable connectionReferenceable = null;
            try {
                ObjectFactory objectFactory = ClassRegistry.getFactory(this.mFactoryClass);
                if (objectFactory != null) {
                    connectionReferenceable = (ConnectionReferenceable)objectFactory.getObjectInstance(this.mReference, NameImpl.createName(this.mName), null, hashtable);
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                Logger.severe(ConnectionsReader.class, (Throwable)reflectiveOperationException);
            }
            catch (Exception exception) {
                Logger.severe(ConnectionsReader.class, (Throwable)exception);
            }
            return connectionReferenceable;
        }
    }

    private static final class NameImpl
    extends CompoundName {
        public static final String DIRECTION = "left_to_right";
        public static final String SEPARATOR = "/";
        public static final boolean IGNORE_CASE = false;
        public static final String ESCAPE = "\\";
        public static final String BEGIN_QUOTE = "'";
        private static final Properties syntax = new Properties();

        static NameImpl createName(String string) {
            NameImpl nameImpl = null;
            try {
                nameImpl = new NameImpl(string);
            }
            catch (InvalidNameException invalidNameException) {
                Logger.severe(ConnectionsReader.class, (Throwable)invalidNameException);
            }
            return nameImpl;
        }

        NameImpl(String string) throws InvalidNameException {
            super(string, syntax);
        }

        static {
            syntax.put("jndi.syntax.direction", DIRECTION);
            syntax.put("jndi.syntax.separator", SEPARATOR);
            syntax.put("jndi.syntax.ignorecase", (Object)false);
            syntax.put("jndi.syntax.escape", ESCAPE);
            syntax.put("jndi.syntax.beginquote", BEGIN_QUOTE);
        }
    }

    private static class ClassRegistry {
        private static Map<String, MetaClass<? extends ObjectFactory>> mClasses = new HashMap<String, MetaClass<? extends ObjectFactory>>();

        private ClassRegistry() {
        }

        static void registerClass(MetaClass<? extends ObjectFactory> metaClass) {
            mClasses.put(metaClass.getClassName(), metaClass);
        }

        static ObjectFactory getFactory(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            MetaClass<? extends ObjectFactory> metaClass = mClasses.get(string);
            if (metaClass != null) {
                return (ObjectFactory)metaClass.newInstance();
            }
            return null;
        }

        static {
            ClassRegistry.registerClass((MetaClass<? extends ObjectFactory>)MetaClass.newMetaClass(DatabaseProviderFactory1212.class));
            ClassRegistry.registerClass((MetaClass<? extends ObjectFactory>)MetaClass.newMetaClass(DatabaseProviderFactory.class));
        }
    }

    private static enum Stage {
        DOCUMENT,
        REFERENCES,
        REFERENCE,
        PROPERTIES,
        PROPERTY_NAME,
        PROPERTY_VALUE;

    }

    private static class InvalidCAFormatException
    extends SAXException {
        private InvalidCAFormatException() {
        }
    }
}

