/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptorArgument;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.UnresolvedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class FunctionDescriptorTypedExpressionArgument
extends FunctionDescriptorArgument {
    public static final int NO_EFFECT = 0;
    public static final int LOSSLESS_TYPE = 1;
    public static final int CLOB_OR_VARCHAR2 = 2;
    private String m_ArgumentName = null;
    private int m_DataTypeCategory = -1;
    private int m_ReturnTypeEffect = 0;

    FunctionDescriptorTypedExpressionArgument(String string, int n, int n2, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.m_ArgumentName = string;
        this.m_DataTypeCategory = n;
        this.m_ReturnTypeEffect = n2;
    }

    @Override
    int validate(FunctionArgument[] functionArgumentArray, FunctionArgument[] functionArgumentArray2, ValidationContext validationContext, int n) {
        FunctionArgument functionArgument = null;
        if (functionArgumentArray.length > n) {
            functionArgument = functionArgumentArray[n];
        }
        if (functionArgument instanceof UnresolvedExpression) {
            functionArgument = ((UnresolvedExpression)functionArgument).resolveToColumnExpression(validationContext);
        }
        if (functionArgument instanceof TypedExpression) {
            TypedExpression typedExpression = (TypedExpression)functionArgument;
            if ((typedExpression = (TypedExpression)validationContext.validate(typedExpression)).getDataType().matchesCategory(this.getDataTypeCategory(), true)) {
                switch (this.getReturnTypeEffect()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (null == validationContext.getCurrentDataType()) {
                            validationContext.setCurrentDataType(typedExpression.getDataType());
                            break;
                        }
                        validationContext.setCurrentDataType(validationContext.getCurrentDataType().getLosslessType(typedExpression.getDataType()));
                        break;
                    }
                    case 2: {
                        if (typedExpression.getDataType().matchesCategory(1)) {
                            validationContext.setCurrentDataType(DataType.VARCHAR2);
                            break;
                        }
                        validationContext.setCurrentDataType(DataType.CLOB);
                    }
                }
                functionArgumentArray2[n] = typedExpression;
                return n + 1;
            }
        }
        return -1;
    }

    @Override
    public void toSyntaxInternal(StringBuffer stringBuffer) {
        stringBuffer.append("'");
        stringBuffer.append(this.getArgumentName());
        stringBuffer.append("'");
    }

    public String getArgumentName() {
        return this.m_ArgumentName;
    }

    public int getDataTypeCategory() {
        return this.m_DataTypeCategory;
    }

    public int getReturnTypeEffect() {
        return this.m_ReturnTypeEffect;
    }
}

