/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.WaitCursor;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.explorer.IconOverlayTreeCellRenderer;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Attributes;
import oracle.ide.model.AutoExpandable;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NonAutoSelectable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Subject;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.task.Task;
import oracle.ide.task.TaskManager;
import oracle.ide.task.event.TaskListener;
import oracle.ide.util.Assert;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.CustomTreeKeyNavigation;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideimpl.explorer.NodeUpdateListener;
import oracle.ideimpl.explorer.dnd.DragDropListener;
import oracle.ideimpl.explorer.dnd.JTreeDragHandler;
import oracle.ideimpl.explorer.dnd.JTreeDropHandler;
import oracle.ideimpl.model.TechnologyScanTask;
import oracle.ideimpl.model.TechnologyScanningTaskListener;
import oracle.ideimpl.model.TechnologyScopeUpdateMigrator;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.ui.KeyNavigationManager;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;

public class BaseTreeExplorer
extends TreeExplorer
implements NodeUpdateListener,
TreeSelectionListener,
TreeExpansionListener,
KeyListener,
MouseListener,
ActionListener,
FocusListener,
DragDropListener {
    protected CustomTree tree;
    private final JScrollPane _gui = new JScrollPane();
    private Comparator _comparator;
    private IconOverlayCache _overlayCache;
    private FilterCache _filterCache = FilterCache.access$000();
    private KeyNavigationManager _keyMgr;
    private WeakReference _lastActiveNodeWeakRef;
    private CellRendererAttributes _attributes;
    private final Timer _timer;
    private static final String FILTER_PROP = "filter";
    private static final String KEY_PROP = ".key";
    private static final String FILTER_CLS_PROP = ".filterCls";
    private static final String FILTER_OPTS_PROP = ".options";
    private static final String DISABLE_EXPLORER_DRAG_AND_DROP_PROP = "TreeExplorer.DisableDragAndDrop";
    private static AtomicBoolean m_alreadyScanning = new AtomicBoolean(false);
    private final ArrayList _updates = new ArrayList();

    public BaseTreeExplorer() {
        if (Themes.isThemed()) {
            this._gui.setOpaque(false);
            this._gui.getViewport().setOpaque(false);
        }
        this._gui.setBorder(BorderFactory.createEmptyBorder());
        if (this.coalesceObserverUpdates()) {
            this._timer = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseTreeExplorer.this.updateImpl();
                }
            });
            this._timer.setRepeats(false);
        } else {
            this._timer = null;
        }
    }

    public final void cacheFilter(TNode tnode, ChildFilter filter) {
        this._filterCache.cacheFilter(tnode, filter);
    }

    public final ChildFilter findCacheFilter(TNode tnode) {
        return this._filterCache.findCacheFilter(tnode);
    }

    public final TNode createTNode(Element element) {
        ExplorerNode tnode = new ExplorerNode(element);
        this.checkLeafState(tnode);
        tnode.addNodeUpdateListener(this);
        return tnode;
    }

    public final TNode findTNode(Element element, TNode root) {
        return this.findNodeDepthFirst(element, root, true, null);
    }

    public final TNode findTNode(Element element, TNode root, Context context) {
        return this.findNodeDepthFirst(element, root, true, context);
    }

    public final TNode findTNodeBreadthFirst(Element element, TNode root) {
        return this.findNodeBreadthFirst(element, root, true);
    }

    public final TNode searchTNode(Element element, TNode root) {
        return this.findNodeDepthFirst(element, root, false, null);
    }

    public final TNode searchTNode(Element element, TNode root, Context context) {
        return this.findNodeDepthFirst(element, root, false, context);
    }

    public final TNode searchTNodeBreadthFirst(Element element, TNode root) {
        return this.findNodeBreadthFirst(element, root, false);
    }

    public final void expand(TNode node, boolean all) {
        this.expand(node, all, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expand(final TNode node, final boolean all, final boolean select) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTreeExplorer.this.expand(node, all, select);
                }
            });
            return;
        }
        ExplorerNode tnode = (ExplorerNode)node;
        if (tnode == null || tnode.isLeaf()) {
            return;
        }
        TreePath path = new TreePath(tnode.getPath());
        boolean suppressCursorChanges = Ide.isStarting() || !Ide.getIdeArgs().getCreateUI();
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        try {
            if (!suppressCursorChanges) {
                wc.show(0);
            }
            this.open(tnode);
            this.tree.expandPath(path);
            if (select) {
                this.setSelected(tnode);
            }
            if (all) {
                Enumeration children = tnode.children();
                while (children.hasMoreElements()) {
                    this.expand((TNode)children.nextElement(), all, select);
                }
            }
        }
        finally {
            if (!suppressCursorChanges) {
                wc.hide();
            }
        }
    }

    public final void refresh(TNode tnode) {
        this.refreshImpl(tnode, tnode);
    }

    public final void refresh(TNode tnode, Class cls) {
        TNode target = tnode.getAncestorTNode(cls, true);
        this.refreshImpl(target, tnode);
    }

    public final void collapse(final TNode tnode, final boolean drop) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTreeExplorer.this.collapse(tnode, drop);
                }
            });
            return;
        }
        if (!tnode.isLeaf()) {
            TreePath path = new TreePath(tnode.getPath());
            if (this.tree.isExpanded(path)) {
                try {
                    this.tree.collapsePath(path);
                }
                catch (ArrayIndexOutOfBoundsException t) {
                    t.printStackTrace();
                }
            }
            if (drop) {
                this.dropNodeSubtree((ExplorerNode)tnode);
            }
        }
    }

    public void addChildren(TNode troot) {
        ExplorerNode parent;
        ExplorerNode root = (ExplorerNode)troot;
        if (root == null || root.isSet(TNodeConstants.IS_OPENED)) {
            return;
        }
        if (root.getChildCount() > 0) {
            root.removeAllChildren();
            try {
                ChildFilter filter = root.getChildFilter();
                if (filter != null) {
                    filter.closeChildren();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Iterator iter = null;
        ChildFilter filter = root.getChildFilter();
        iter = filter != null ? filter.getChildren() : root.getChildNodes();
        if (iter == null) {
            return;
        }
        if (filter == null && (parent = (ExplorerNode)root.getParent()) != null) {
            filter = parent.findChildFilter();
        }
        ArrayList<ExplorerNode> toBeAdded = new ArrayList<ExplorerNode>();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            ExplorerNode node = (ExplorerNode)this.createTNode(child);
            toBeAdded.add(node);
        }
        for (ExplorerNode node : toBeAdded) {
            root.add(node);
            if (filter == null) continue;
            filter.cache((TNode)node);
        }
        root.setBit(TNodeConstants.IS_OPENED);
    }

    public final JTree getJTree() {
        return this.getTree(null);
    }

    public final DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    public final void nodeChanged(TNode tnode) {
        if (tnode == null) {
            return;
        }
        DefaultTreeModel model = this.getTreeModel();
        if (model != null) {
            model.nodeChanged((TreeNode)tnode);
        }
    }

    public final void saveFilters(PropertyAccess layout) {
        this._filterCache.saveFilters(layout);
    }

    public final void openFilters(PropertyAccess layout) {
        this._filterCache.openFilters(layout);
    }

    private void renameFilters(TNode parent, TNode child, UpdateMessage rename) {
        this._filterCache.renameFilters(parent, child, rename);
    }

    public final Comparator getComparator() {
        return this._comparator;
    }

    public final void setComparator(Comparator comparator) {
        if (!ModelUtil.areEqual((Object)comparator, (Object)this._comparator)) {
            this._comparator = comparator;
            TNode root = this.getRoot();
            if (root != null) {
                Element element = root.getData();
                this.setRoot(element);
            }
        }
    }

    public void setContext(final Context context) {
        super.setContext(context);
        if (SwingUtilities.isEventDispatchThread()) {
            this.getTree(context);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTreeExplorer.this.getTree(context);
                }
            });
        }
    }

    public final Context getContext(EventObject event) {
        TNode lastTNode;
        Project prj;
        Context context = super.getContext(event);
        if (null == this.tree) {
            return context;
        }
        TreePath[] paths = this.tree.getSelectionPaths();
        TNode[] tnodes = new TNode[paths != null ? paths.length : 0];
        for (int i = 0; i < tnodes.length; ++i) {
            tnodes[i] = (TNode)paths[i].getLastPathComponent();
        }
        if (context.getWorkspace() == null && tnodes.length > 0) {
            TNode lastTNode2 = tnodes[tnodes.length - 1];
            Workspace wsp = (Workspace)lastTNode2.getAncestor(Workspace.class, true);
            context.setWorkspace(wsp);
        }
        if (tnodes.length > 0 && (prj = (Project)(lastTNode = tnodes[tnodes.length - 1]).getAncestor(Project.class, true)) != null) {
            context.setProject(prj);
        }
        ExplorerContext.setTNodes((Context)context, (TNode[])tnodes);
        this.initializeContextNode(context, tnodes);
        return context;
    }

    public final Component getGUI() {
        return this._gui;
    }

    public final void setSelected(final TNode tnode) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTreeExplorer.this.setSelected(tnode);
                }
            });
            return;
        }
        if (tnode == null) {
            return;
        }
        TreePath path = new TreePath(tnode.getPath());
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    public final void setSelected(final TNode[] tnodes) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTreeExplorer.this.setSelected(tnodes);
                }
            });
            return;
        }
        if (tnodes == null) {
            return;
        }
        TreePath[] treePaths = new TreePath[tnodes.length];
        for (int i = 0; i < tnodes.length; ++i) {
            treePaths[i] = new TreePath(tnodes[i].getPath());
        }
        this.tree.setSelectionPaths(treePaths);
    }

    public final void updateTitle(Object object) {
        if (this.owner() == null) {
            return;
        }
        this.owner().updateTitle(object);
    }

    public final TNode removeChild(TNode tchild, DefaultTreeModel model) {
        ExplorerNode child = (ExplorerNode)tchild;
        child.removeNodeUpdateListener(this);
        ExplorerNode tnode = BaseTreeExplorer.getClosestTNode(child);
        model.removeNodeFromParent(child);
        return tnode;
    }

    private TNode removeChildren(TNode parent, List removed, DefaultTreeModel model) {
        ArrayList<TNode> childNodes = new ArrayList<TNode>(removed.size());
        Enumeration e = parent.children();
        while (e.hasMoreElements()) {
            TNode tnode = (TNode)e.nextElement();
            if (!removed.contains(tnode.getData())) continue;
            childNodes.add(tnode);
        }
        if (childNodes.isEmpty()) {
            return null;
        }
        Assert.check((boolean)(model instanceof TreeExplorerModel));
        Assert.check((boolean)(parent instanceof MutableTreeNode));
        int size = childNodes.size();
        MutableTreeNode[] children = childNodes.toArray(new ExplorerNode[size]);
        for (int i = 0; i < size; ++i) {
            ExplorerNode tnode = children[i];
            tnode.removeNodeUpdateListener(this);
        }
        ExplorerNode ret = BaseTreeExplorer.getClosestTNode(children[size - 1]);
        ((TreeExplorerModel)model).removeNodesFromParent((MutableTreeNode)parent, children);
        return ret;
    }

    public final TNode childrenRemoved(final UpdateMessage updateMessage, final TNode node, final DefaultTreeModel model, final ChildFilter filter) {
        final TNode[] child = new TNode[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreePath tp;
                TreePath[] selectionPaths = BaseTreeExplorer.this.tree.getSelectionPaths();
                TreePath adjustedSelection = BaseTreeExplorer.this.adjustSelectionForChildRemoval();
                BaseTreeExplorer.this.tree.clearSelection();
                child[0] = filter == null ? BaseTreeExplorer.this.removeChildren(node, updateMessage.getRemoveObjects(), model) : filter.childrenRemoved(updateMessage, node, (TreeExplorer)BaseTreeExplorer.this);
                if (selectionPaths != null && selectionPaths.length > 0) {
                    for (int i = 0; i < selectionPaths.length; ++i) {
                        TreePath path = ExplorerContext.findNewPath((TNode)BaseTreeExplorer.this.getRoot(), (TreePath)selectionPaths[i], (boolean)true);
                        if (path == null) continue;
                        BaseTreeExplorer.this.tree.addSelectionPath(path);
                    }
                }
                if (adjustedSelection != null && BaseTreeExplorer.this.tree.isSelectionEmpty() && (tp = ExplorerContext.findNewPath((TNode)BaseTreeExplorer.this.getRoot(), (TreePath)adjustedSelection, (boolean)false)) != null) {
                    BaseTreeExplorer.this.tree.setSelectionPath(tp);
                }
                if (child[0] != null && BaseTreeExplorer.this.tree.isSelectionEmpty()) {
                    BaseTreeExplorer.this.setSelected(child[0]);
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
            }
        } else {
            runnable.run();
        }
        return child[0];
    }

    private TreePath adjustSelectionForChildRemoval() {
        int leadSelectionRow = this.tree.getLeadSelectionRow();
        if (leadSelectionRow == -1) {
            return null;
        }
        SiblingIterator iter = new SiblingIterator(leadSelectionRow);
        TreePath tp = iter.nextSiblingPath();
        while (tp != null) {
            if (!this.tree.isPathSelected(tp)) {
                return tp;
            }
            tp = iter.nextSiblingPath();
        }
        TreePath leadSelectionPath = this.tree.getLeadSelectionPath();
        return leadSelectionPath.getParentPath();
    }

    public final TNode addChild(Element element, TNode parent, DefaultTreeModel model) {
        return this.addChild(element, parent.getChildCount(), parent, model);
    }

    private TNode addChild(Element element, int elementIndex, TNode parent, DefaultTreeModel model) {
        ExplorerNode child = (ExplorerNode)this.createTNode(element);
        model.insertNodeInto(child, (ExplorerNode)parent, elementIndex);
        return child;
    }

    public final TNode childrenAdded(final UpdateMessage updateMessage, final TNode parent, final DefaultTreeModel model, final ChildFilter filter, final boolean select) {
        if (this.isHideChildren(parent)) {
            return null;
        }
        final TNode[] child = new TNode[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                child[0] = BaseTreeExplorer.this.open(parent) ? parent : null;
                List children = updateMessage.getAddObjects();
                if (filter == null) {
                    ArrayList arList = new ArrayList(children);
                    Enumeration echildren = parent.children();
                    while (echildren.hasMoreElements()) {
                        child[0] = (TNode)echildren.nextElement();
                        Element element = child[0].getData();
                        if (!arList.contains(element)) continue;
                        arList.remove(element);
                    }
                    for (Element element : arList) {
                        child[0] = BaseTreeExplorer.this.addChild(element, parent, model);
                    }
                    arList.clear();
                } else {
                    child[0] = filter.childrenAdded(updateMessage, parent, (TreeExplorer)BaseTreeExplorer.this);
                }
                if (select && child != null && BaseTreeExplorer.this.isViewActive()) {
                    TreePath path = new TreePath(child[0].getPath());
                    BaseTreeExplorer.this.tree.scrollPathToVisible(path);
                    int row = BaseTreeExplorer.this.tree.getRowForPath(path);
                    BaseTreeExplorer.this.tree.setSelectionRow(row);
                    if (child[0] == parent && !child[0].isLeaf()) {
                        BaseTreeExplorer.this.tree.expandPath(path);
                    }
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.INFO, e.getMessage(), e);
            }
        } else {
            runnable.run();
        }
        return child[0];
    }

    private static boolean hasBeenMigrated(Project project, String migratorKey) {
        ProjectVersion projectVersion = new ProjectVersion((PropertyStorage)project);
        return projectVersion.containsKey(migratorKey);
    }

    private static void detectProjectTechnologies(Collection<Project> projects, TechnologyScopeUpdateMigrator migrator) {
        TechnologyScanTask techScanTask = new TechnologyScanTask(Ide.getActiveWorkspace(), projects, migrator);
        TechnologyScanningTaskListener taskListener = new TechnologyScanningTaskListener((Component)Ide.getMainWindow(), projects.size());
        techScanTask.addTaskListener((TaskListener)taskListener);
        TaskManager manager = TaskManager.getInstance();
        manager.enqueueTask((Task)techScanTask);
        taskListener.startAndBlock();
    }

    private static Collection<Project> getAllProjectsThatNeedUpdating(Project rootProject, Collection<Project> projectsSoFar) {
        projectsSoFar.add(rootProject);
        List list = DependencyConfiguration.getInstance((Project)rootProject).getAllDependenciesList();
        for (Object obj : list) {
            Project project;
            if (!(obj instanceof Dependable) || !(((Dependable)obj).getSource() instanceof Project) || BaseTreeExplorer.hasBeenMigrated(project = (Project)((Dependable)obj).getSource(), TechnologyScopeUpdateMigrator.class.getName())) continue;
            projectsSoFar.add(project);
        }
        return projectsSoFar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean open(final TNode node) {
        if (node.isSet(TNodeConstants.IS_OPENED)) {
            return false;
        }
        boolean suppressCursorChanges = Ide.isStarting() || !Ide.getIdeArgs().getCreateUI();
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        try {
            if (!suppressCursorChanges) {
                wc.show(0);
            }
            this.addChildren(node);
            Element data = node.getData();
            if (data instanceof Node) {
                try {
                    ((Node)data).open();
                    if (data instanceof Project) {
                        Collection unknownTechnologies;
                        final Project project = (Project)data;
                        if (!GraphicsEnvironment.isHeadless() && !project.isMigrating() && !BaseTreeExplorer.hasBeenMigrated(project, TechnologyScopeUpdateMigrator.class.getName()) && m_alreadyScanning.compareAndSet(false, true)) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    TechnologyScopeUpdateMigrator migrator = new TechnologyScopeUpdateMigrator();
                                    Collection projects = BaseTreeExplorer.getAllProjectsThatNeedUpdating(project, new HashSet());
                                    BaseTreeExplorer.detectProjectTechnologies(projects, migrator);
                                    m_alreadyScanning.set(false);
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable.run();
                            } else {
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                        if ((unknownTechnologies = TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getUnknownTechnologies()).size() > 0) {
                            TechnologyRegistry.getLogger().warning(unknownTechnologies + " features were found in " + project + " but are not installed. Install these technologies before you proceed.");
                        }
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                    e.printStackTrace();
                }
            }
            Runnable updateModel = new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = BaseTreeExplorer.this.getTreeModel();
                    if (model != null) {
                        model.reload((TreeNode)node);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                updateModel.run();
            } else {
                SwingUtilities.invokeLater(updateModel);
            }
        }
        finally {
            if (!suppressCursorChanges) {
                wc.hide();
            }
        }
        return true;
    }

    public final boolean updateActiveNode(TNode newActiveNode) {
        ExplorerNode lastActiveNode;
        if (newActiveNode == null) {
            return false;
        }
        if (this._lastActiveNodeWeakRef != null && (lastActiveNode = (ExplorerNode)this._lastActiveNodeWeakRef.get()) != null) {
            if (lastActiveNode == newActiveNode) {
                return false;
            }
            lastActiveNode.unsetBit(ElementAttributes.ACTIVE);
            this.nodeChanged(lastActiveNode);
        }
        this._lastActiveNodeWeakRef = new WeakReference<TNode>(newActiveNode);
        newActiveNode.setBit(ElementAttributes.ACTIVE);
        this.nodeChanged(newActiveNode);
        return true;
    }

    public final TNode getRoot() {
        TreeModel model = this.tree.getModel();
        return model != null ? (TNode)model.getRoot() : null;
    }

    public final void setRootElement(Element element) {
        if (element != null) {
            this.setContext(Context.newIdeContext((Element)element));
        }
    }

    public final Attributes getCellRendererAttributes() {
        if (this._attributes == null) {
            this._attributes = new CellRendererAttributes();
        }
        return this._attributes;
    }

    private static boolean refreshNodes(TNode[] tnodes, boolean doRefresh) {
        boolean ret = false;
        if (tnodes != null && tnodes.length > 0) {
            ChildFilter filter;
            TNode tnode;
            int i;
            boolean ancestorsRefreshed = false;
            for (i = 0; i < tnodes.length; ++i) {
                tnode = tnodes[i];
                if (!doRefresh && !tnode.isSet(TNodeConstants.IS_OPENED) || (filter = tnode.findChildFilter()) == null || tnode == filter.getOwner()) continue;
                if (BaseTreeExplorer.refreshAncestor(tnode, doRefresh)) {
                    ret = true;
                }
                ancestorsRefreshed = true;
                if (!filter.canRefresh(tnodes)) break;
                ret = true;
                if (!doRefresh) break;
                filter.refresh(tnodes);
                break;
            }
            if (!ancestorsRefreshed && BaseTreeExplorer.refreshAncestor(tnodes[0], doRefresh)) {
                ret = true;
            }
            for (i = 0; i < tnodes.length; ++i) {
                tnode = tnodes[i];
                if (!doRefresh && !tnode.isSet(TNodeConstants.IS_OPENED) || (filter = tnode.findChildFilter()) == null || tnode != filter.getOwner() || !filter.canRefresh(tnodes)) continue;
                ret = true;
                if (!doRefresh) continue;
                filter.refresh(tnodes);
            }
        }
        return ret;
    }

    public final boolean canRefresh(TNode tnode, Class cls) {
        TNode target = tnode.getAncestorTNode(cls, true);
        if (target == null || target.isLeaf()) {
            TNode[] tnodes = new TNode[]{tnode};
            return BaseTreeExplorer.refreshNodes(tnodes, false);
        }
        if (!target.isSet(TNodeConstants.IS_OPENED)) {
            return false;
        }
        ChildFilter filter = target.findChildFilter();
        TNode[] tnodes = new TNode[]{target};
        return filter != null && target == filter.getOwner() && filter.canRefresh(tnodes);
    }

    private static boolean refreshAncestor(TNode tnode, boolean doRefresh) {
        ChildFilter parentFilter;
        TNode parent;
        boolean ret = false;
        if (tnode != null && (parent = (TNode)tnode.getParent()) != null && (parentFilter = parent.findChildFilter()) != null) {
            TNode[] tnodes;
            if (BaseTreeExplorer.refreshAncestor(parentFilter.getOwner(), doRefresh)) {
                ret = true;
            }
            if (parentFilter.canRefresh(tnodes = new TNode[]{tnode})) {
                if (doRefresh) {
                    parentFilter.refresh(tnodes);
                }
                ret = true;
            }
        }
        return ret;
    }

    public final IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    public final void setOverlayCache(IconOverlayCache cache) {
        this._overlayCache = cache;
    }

    public final Element getElement(Object value) {
        Element elem;
        if (value instanceof ExplorerNode) {
            Object wrapped;
            ExplorerNode tnode = (ExplorerNode)value;
            elem = (Element)tnode.getUserObject();
            if (elem.getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT) && (wrapped = elem.getData()) instanceof Element) {
                elem = (Element)wrapped;
            }
        } else {
            elem = ((TNode)value).getData();
        }
        return elem;
    }

    protected void nodeExpanded(TNode tnode, boolean expansionAlsoTriggeredOpen) {
    }

    protected boolean coalesceObserverUpdates() {
        return true;
    }

    protected void initializeContextNode(Context context, TNode[] tnodes) {
        switch (tnodes.length) {
            case 0: {
                context.setNode(this.defaultNode);
                break;
            }
            case 1: {
                Node node = (Node)tnodes[0].getAncestor(Node.class, true);
                context.setNode(node != null ? node : this.defaultNode);
                break;
            }
            default: {
                TNode tnode = tnodes[0];
                if (tnode.getData() instanceof Node) {
                    context.setNode(null);
                    break;
                }
                Node node = (Node)tnode.getAncestor(Node.class, true);
                context.setNode(node != null ? node : this.defaultNode);
                break;
            }
        }
    }

    protected Element[] getSelectionFromUI() {
        TreePath[] paths = this.getTree(null).getSelectionPaths();
        Element[] selection = new Element[paths != null ? paths.length : 0];
        int n = selection.length;
        for (int i = 0; i < n; ++i) {
            TNode tnode = (TNode)paths[i].getLastPathComponent();
            selection[i] = ContextMenu.unwrapDecoratedElement((Element)tnode.getData());
        }
        return selection;
    }

    protected synchronized CustomTree getTree(Context context) {
        if (this.tree == null) {
            String dftName;
            this.tree = this.createCustomTree();
            this.tree.putClientProperty("JTree.expandOnMouseRelease", Boolean.TRUE);
            if (this._overlayCache != null) {
                this.tree.setCellRenderer((TreeCellRenderer)new IconOverlayTreeCellRenderer((IconOverlayConsumer)this, (DefaultTreeCellRenderer)this.tree.getCellRenderer()));
            }
            if ((dftName = this.getDFTName()) != null) {
                this.tree.setName(dftName);
            }
            this.tree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.tree.setCellRendererAttributes(this.getCellRendererAttributes());
            this.installTreeKeyManager();
            if (context != null) {
                this.setRoot(this.annotate(context));
            }
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setScrollsOnExpand(true);
            this.tree.addTreeSelectionListener(this);
            this.tree.addTreeExpansionListener(this);
            this.tree.setPreMouseListener(this);
            this.tree.addFocusListener(this);
            this.tree.getActionMap().put(20, (Action)IdeAction.get((int)20, (String)"oracle.ide.cmd.DeleteTNodeCommand", (String)ExplorerArb.getString((int)3)));
            this.createDragDropSupportIfEnabled();
            this._gui.setViewportView(this.tree);
        } else if (context != null) {
            TNode tnode = this.getRoot();
            Element oldRoot = tnode != null ? tnode.getData() : null;
            Element newRoot = this.annotate(context);
            if (newRoot == null || newRoot != oldRoot && !newRoot.equals(oldRoot) || context.getBoolean("NAVIGATOR.ForceExplorerReroot")) {
                this.setRoot(newRoot);
            }
        }
        return this.tree;
    }

    protected void createDragSource() {
        new JTreeDragHandler(this.tree, 3, this);
    }

    protected void createDropTarget() {
        new JTreeDropHandler(this.tree, 3);
    }

    protected Element annotate(Context context) {
        return context != null ? context.getElement() : null;
    }

    protected final void setRoot(final Element element) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTreeExplorer.this.setRoot(element);
                }
            });
            return;
        }
        ExplorerNode root = (ExplorerNode)this.getRoot();
        if (root != null) {
            this.dropNodeSubtree(root);
            root.setOwner(null);
            root.removeNodeUpdateListener(this);
        }
        root = new ExplorerNode(element);
        root.setOwner(this);
        root.addNodeUpdateListener(this);
        this.addChildren(root);
        this.tree.setModel(new TreeExplorerModel(root));
    }

    private void refreshImpl(TNode target, TNode tnode) {
        if (target == null || target.isLeaf()) {
            if (tnode != null) {
                this.refreshTNode(tnode);
            }
        } else if (target.isSet(TNodeConstants.IS_OPENED)) {
            this.refreshTNode(target);
        }
    }

    private void refreshTNode(TNode target) {
        List selectedNodes = ExplorerContext.storeSelectionState((TreeExplorer)this);
        List expandedSet = ExplorerContext.storeExpansionState((TNode)target, (TreeExplorer)this);
        this.releaseFilters(target, false);
        this.collapse(target, true);
        ExplorerContext.restoreExpansionState((TNode)target, (TreeExplorer)this, (List)expandedSet);
        ExplorerContext.restoreSelectionState((TreeExplorer)this, (List)selectedNodes);
    }

    private TNode findNodeBreadthFirst(Element element, TNode root, boolean searchUnopened) {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
        if (root == null) {
            root = this.getRoot();
        }
        ArrayList<Object> output = new ArrayList<Object>();
        ArrayList<Object> sources = new ArrayList<Object>();
        sources.add(root);
        TNode result = null;
        while ((result = this.findNodeBreadthFirst(element, sources, searchUnopened, output)) == null) {
            if (output.size() == 0) {
                return null;
            }
            sources.clear();
            sources.addAll(output);
            output.clear();
        }
        return result;
    }

    private TNode findNodeDepthFirst(Element element, TNode root, boolean searchUnopened, Context expansionContext) {
        if (EventQueue.isDispatchThread()) {
            this.updateImpl();
        }
        if (root == null) {
            root = this.getRoot();
        }
        if (root.getData() != null && root.getData().equals(element)) {
            return root;
        }
        if (root.isLeaf()) {
            return null;
        }
        if (!(root.isSet(TNodeConstants.IS_OPENED) || searchUnopened && this.open(root))) {
            return null;
        }
        Enumeration children = root.children();
        TNode result = null;
        while (children.hasMoreElements()) {
            AutoExpandable autoExpandable;
            Element elem;
            TNode child = (TNode)children.nextElement();
            if (expansionContext == null || !this.wasCalledFromAutoSelectionEvent(expansionContext) || this.wasCalledOnAutoSelectableTData(child)) {
                result = this.findNodeDepthFirst(element, child, searchUnopened, expansionContext);
            }
            if (result == null) continue;
            if (expansionContext == null || !expansionContext.getBoolean("oracle.ide.model.ProjectContent.AutoSelecter") || !((elem = child.getData()) instanceof AutoExpandable) || (autoExpandable = (AutoExpandable)elem).shouldAutoExpand(expansionContext)) break;
            result = child;
            break;
        }
        return result;
    }

    private boolean wasCalledFromAutoSelectionEvent(Context context) {
        return context.containsProperty("oracle.ide.model.ProjectContent.AutoSelecter") && context.getBoolean("oracle.ide.model.ProjectContent.AutoSelecter");
    }

    private boolean wasCalledOnAutoSelectableTData(TNode tnode) {
        return tnode.getData() != null && !(tnode.getData() instanceof NonAutoSelectable);
    }

    private static String buildPathKey(TreePath path) {
        int count = path.getPathCount();
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            Element elem = ((TNode)path.getPathComponent(i)).getData();
            String label = elem.getLongLabel();
            tmp.append(ModelUtil.hasLength((String)label) ? label : " ");
        }
        return tmp.toString();
    }

    private void installTreeKeyManager() {
        CustomTreeKeyNavigation kca = new CustomTreeKeyNavigation(this.tree);
        this._keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)kca);
        this.tree.setPreKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                BaseTreeExplorer.this._keyMgr.preKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                BaseTreeExplorer.this._keyMgr.preKeyReleased(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                BaseTreeExplorer.this._keyMgr.preKeyTyped(e);
            }
        });
        this.tree.setPostKeyListener(this);
    }

    protected CustomTree createCustomTree() {
        CustomTree newCustomTree = new CustomTree();
        newCustomTree.putClientProperty("JTree.expandOnMouseRelease", Boolean.TRUE);
        return newCustomTree;
    }

    protected String getDFTName() {
        try {
            String simpleName = this.getClass().getSimpleName();
            if (simpleName.length() > 1 && !simpleName.startsWith("$")) {
                String newName = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1, simpleName.length());
                return "der-" + newName;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        return null;
    }

    private void createDragDropSupportIfEnabled() {
        if (!Ide.getIdeProperties().isPropertySet(DISABLE_EXPLORER_DRAG_AND_DROP_PROP, Boolean.toString(true), Boolean.toString(false))) {
            this.createDragSource();
            this.createDropTarget();
        }
    }

    public void dispose() {
        ExplorerNode root = (ExplorerNode)this.getRoot();
        if (root != null) {
            root.removeNodeUpdateListener(this);
            if (root.getChildCount() > 0) {
                Enumeration<TreeNode> descendants = root.breadthFirstEnumeration();
                descendants.nextElement();
                while (descendants.hasMoreElements()) {
                    ExplorerNode descendant = (ExplorerNode)descendants.nextElement();
                    descendant.removeNodeUpdateListener(this);
                }
            }
        }
    }

    private static final ExplorerNode getClosestTNode(ExplorerNode tnode) {
        TreeNode nextTNode = tnode.getNextSibling();
        if (nextTNode == null && (nextTNode = tnode.getPreviousSibling()) == null && (nextTNode = tnode.getParent()) == null) {
            nextTNode = tnode.getNextNode();
        }
        return (ExplorerNode)nextTNode;
    }

    private void fireDefaultAction(InputEvent e) {
        ContextMenu menu = this.getContextMenu();
        if (menu == null) {
            return;
        }
        View view = this.owner();
        Context context = view != null ? view.getContext((EventObject)e) : this.getContext();
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null && nodes.length > 0 && menu.fireDefaultAction(context)) {
            e.consume();
        }
    }

    private static String buildPathKey(TNode tnode) {
        TreePath path = new TreePath(tnode.getPath());
        return BaseTreeExplorer.buildPathKey(path);
    }

    private void releaseFilters(TNode tnode, boolean recurse) {
        this._filterCache.releaseFilters(tnode, recurse);
    }

    private boolean isViewActive() {
        return this.owner() != null && this.owner() == Ide.getMainWindow().getLastActiveView();
    }

    private TNode findNodeBreadthFirst(Element element, List sources, boolean searchUnopened, List<Object> output) {
        for (TNode node : sources) {
            if (element == node.getData()) {
                return node;
            }
            if (node.isLeaf() || !node.isSet(TNodeConstants.IS_OPENED) && (!searchUnopened || !this.open(node))) continue;
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                output.add(children.nextElement());
            }
        }
        return null;
    }

    private void dropNodeSubtree(final ExplorerNode node) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTreeExplorer.this.dropNodeSubtree(node);
                }
            });
            return;
        }
        ChildFilter filter = node.getFilter();
        if (filter != null) {
            filter.uncache((TNode)node);
        }
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> descendants = node.breadthFirstEnumeration();
            descendants.nextElement();
            while (descendants.hasMoreElements()) {
                ExplorerNode descendant = (ExplorerNode)descendants.nextElement();
                descendant.removeNodeUpdateListener(this);
                this.releaseFilters(descendant, false);
                if (filter == null) continue;
                filter.uncache((TNode)descendant);
            }
            node.removeAllChildren();
            this.collapse(node, false);
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(node);
        }
        node.unsetBit(TNodeConstants.IS_OPENED);
    }

    private void checkLeafState(TNode node) {
        if (this.isHideChildren(node)) {
            ((ExplorerNode)node).makeLeaf();
        }
    }

    private boolean isHideChildren(TNode node) {
        Element element = node.getData();
        return this.getCellRendererAttributes().isSet(CellRendererAttributes.HIDE_CHILDREN) && element.getAttributes().isSet(ElementAttributes.HIDE_CHILDREN) && element.mayHaveChildren();
    }

    @Override
    public void focusGained(FocusEvent e) {
        ExplorerNode lastActiveNode;
        this.nodeChanged(this.getRoot());
        if (this._lastActiveNodeWeakRef != null && (lastActiveNode = (ExplorerNode)this._lastActiveNodeWeakRef.get()) != null) {
            this.nodeChanged(lastActiveNode);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focusGained(e);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.scheduleUpdateSelection();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        final TNode tnode = (TNode)path.getLastPathComponent();
        if (!tnode.isLeaf()) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    final String key1 = this.getClass().getName() + ".treeExpanded.1." + tnode;
                    String key2 = this.getClass().getName() + ".treeExpanded.2." + tnode;
                    Assert.startTiming((String)key1, null, (boolean)false, (boolean)false);
                    Assert.startTiming((String)key2, null, (boolean)false, (boolean)false);
                    boolean starting = Ide.isStarting();
                    WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
                    if (!starting) {
                        wc.show(0);
                    }
                    boolean tnodeWasClosed = !tnode.isSet(TNodeConstants.IS_OPENED);
                    try {
                        if (tnodeWasClosed) {
                            BaseTreeExplorer.this.open(tnode);
                            IdeMainWindow.updateVisibleActions();
                            Assert.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    String autoExpandProp;
                                    final Element data = tnode.getData();
                                    if (data instanceof Workspace && Boolean.valueOf(autoExpandProp = System.getProperty("jdev.autoexpand.workspace")).booleanValue()) {
                                        Assert.println((String)"Autoexpanding {0}...", (Object)data.getLongLabel());
                                        BaseTreeExplorer.this.expand(tnode, true);
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                Assert.endTiming((String)key1, (String)("Autoexpanded " + data.getLongLabel()), null, (boolean)false, (boolean)false);
                                            }
                                        });
                                    }
                                }
                            });
                        }
                        BaseTreeExplorer.this.nodeExpanded(tnode, tnodeWasClosed);
                        if (starting) return;
                    }
                    catch (Throwable throwable) {
                        if (starting) throw throwable;
                        wc.hide();
                        Assert.execute((Runnable)new Runnable(tnodeWasClosed, key2){
                            final /* synthetic */ boolean val$tnodeWasClosed;
                            final /* synthetic */ String val$key2;
                            {
                                this.val$tnodeWasClosed = bl;
                                this.val$key2 = string;
                            }

                            @Override
                            public void run() {
                                if (this.val$tnodeWasClosed) {
                                    Assert.endTiming((String)this.val$key2, (String)("Expanded node for " + tnode), null, (boolean)false, (boolean)false);
                                }
                            }
                        });
                        throw throwable;
                    }
                    wc.hide();
                    Assert.execute((Runnable)new /* invalid duplicate definition of identical inner class */);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        int keyCode;
        this._keyMgr.postKeyPressed(event);
        if (!event.isConsumed() && (keyCode = event.getKeyCode()) == 10) {
            if ((event.getModifiers() & 8) != 0) {
                try {
                    IdeAction propertiesAction = IdeActions.getEditPropertiesAction();
                    propertiesAction.updateAction();
                    if (propertiesAction.isEnabled()) {
                        propertiesAction.performAction();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.fireDefaultAction(event);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        this._keyMgr.postKeyTyped(event);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this._keyMgr.postKeyReleased(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dblClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (e.getClickCount() == 2) {
            if (!SwingUtilities.isLeftMouseButton(e) || (e.getModifiersEx() & 0x1800) != 0) {
                return;
            }
            if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                boolean suppressCursorChanges = Ide.isStarting() || !Ide.getIdeArgs().getCreateUI();
                WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
                try {
                    if (!suppressCursorChanges) {
                        wc.show();
                    }
                    this.fireDefaultAction(e);
                }
                finally {
                    if (!suppressCursorChanges) {
                        wc.hide();
                    }
                }
            }
        } else if (e.getClickCount() > 2) {
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.tryPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.dblClicked(e);
        } else {
            this.tryPopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected void tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            View view;
            Context context;
            ContextMenu menu = this.getContextMenu();
            if (menu == null) {
                return;
            }
            TreePath current = this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (current == null) {
                this.tryPopupInBlankSpace(menu, e);
                return;
            }
            TreePath[] paths = this.tree.getSelectionPaths();
            boolean isSelected = false;
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    if (paths[i].getLastPathComponent() != current.getLastPathComponent()) continue;
                    isSelected = true;
                    break;
                }
            }
            if (!isSelected) {
                this.tree.setSelectionPath(current);
            }
            Context context2 = context = (view = this.owner()) != null ? view.getContext((EventObject)e) : this.getContext(e);
            if (context.getElement() == null) {
                return;
            }
            menu.show(context);
        }
    }

    protected void tryPopupInBlankSpace(ContextMenu contextMenu, MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(TNode node, UpdateMessage change) {
        ArrayList arrayList = this._updates;
        synchronized (arrayList) {
            this._updates.add(node);
            this._updates.add(change);
        }
        if (this._timer != null) {
            this._timer.restart();
        } else {
            this.updateImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImpl() {
        ArrayList updates = new ArrayList();
        ArrayList arrayList = this._updates;
        synchronized (arrayList) {
            if (this._updates.isEmpty()) {
                return;
            }
            updates.addAll(this._updates);
            this._updates.clear();
        }
        Iterator iter = updates.iterator();
        while (iter.hasNext()) {
            TNode tnode = (TNode)iter.next();
            UpdateMessage change = (UpdateMessage)iter.next();
            this.updateImpl(tnode, change);
        }
    }

    private void updateImpl(final TNode node, UpdateMessage change) {
        DefaultTreeModel model = this.getTreeModel();
        TreeNode[] p = node.getPath();
        if (p == null || p.length == 0) {
            return;
        }
        if (!p[0].equals(this.getRoot())) {
            return;
        }
        int id = change.getMessageID();
        if (id == UpdateMessage.OBJECT_RENAMED) {
            this.nodeChanged(node);
            if (node != this.getRoot()) {
                return;
            }
            this.updateTitle(node);
            this.setSelected(node);
        }
        if (id == UpdateMessage.OBJECT_RENAMED || id == UpdateMessage.CHILD_RENAMED) {
            TNode tn;
            Node rn;
            TNode tchild;
            List addedObjects;
            ChildFilter filter = node.getChildFilter();
            List removedObjects = change.getRemoveObjects();
            if (removedObjects.size() > 0) {
                this.childrenRemoved(change, node, model, filter);
            }
            if ((addedObjects = change.getAddObjects()).size() > 0 && (tchild = this.childrenAdded(change, node, model, filter, true)) != null) {
                this.renameFilters(node, tchild, change);
                this.nodeChanged(tchild);
                this.setSelected(tchild);
            }
            if (id == UpdateMessage.CHILD_RENAMED && (rn = RenameMessage.getRenamedNode((UpdateMessage)change)) != null && (tn = this.findNodeBreadthFirst((Element)rn, node, false)) != null) {
                this.setSelected(tn);
            }
        } else if (id == UpdateMessage.CHILD_REMOVED) {
            this.childrenRemoved(change, node, model, node.getChildFilter());
        } else if (id == UpdateMessage.CHILD_ADDED) {
            boolean select = TreeExplorer.isSelectAddedChild((UpdateMessage)change, (boolean)true);
            this.childrenAdded(change, node, model, node.getChildFilter(), select);
        } else if (id == UpdateMessage.STRUCTURE_CHANGED) {
            this.update(node, change, false);
        } else if (id == UpdateMessage.PROPERTY_SET) {
            this.update(node, change, true);
        } else if (id == UpdateMessage.OBJECT_CLOSED) {
            if (node.getData().getAttributes().isSet(ElementAttributes.COMPOSITE)) {
                return;
            }
            this.releaseFilters(node, true);
            this.collapse(node, true);
            node.unsetBit(TNodeConstants.IS_OPENED);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (node == BaseTreeExplorer.this.getRoot() && !BaseTreeExplorer.this.tree.isRootVisible()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UpdateMessage.fireStructureChanged((Subject)((Subject)node.getData()));
                            }
                        });
                    }
                }
            });
        } else if (id == UpdateMessage.ATTRIBUTE_CHANGED) {
            this.nodeChanged(node);
        } else if (this.owner() instanceof NodeUpdateListener) {
            ((NodeUpdateListener)this.owner()).update(node, change);
        }
    }

    private void update(TNode node, UpdateMessage change, boolean propertySet) {
        ChildFilter filter = node.getChildFilter();
        if (filter != null) {
            if (!propertySet || filter.canUpdate(node, change)) {
                this.refresh(node, Project.class);
            }
        } else if (!node.isLeaf()) {
            this.refresh(node);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateSelection();
    }

    @Override
    public Transferable[] dragStarted(DragGestureEvent event) {
        Point origin = event.getDragOrigin();
        if (this.tree.getPathForLocation(origin.x, origin.y) == null) {
            return new Transferable[0];
        }
        Context context = this.getContext(event);
        TransferableContext transferableContext = new TransferableContext(context);
        final InputEvent inputEvent = event.getTriggerEvent();
        Transferable triggerEventTransferable = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DndUtils.FLAVOR_TRIGGER_EVENT};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DndUtils.FLAVOR_TRIGGER_EVENT.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return inputEvent;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        return new Transferable[]{transferableContext, triggerEventTransferable};
    }

    @Override
    public void dropOccurred(DragSourceDropEvent dsde, Object dropTargetObject) {
        if (dsde.getDropSuccess()) {
            this.nodeChanged((TNode)dropTargetObject);
        }
    }

    private static final class FilterInfo {
        private String _className;
        private int _options;
        private ChildFilter _filter;

        FilterInfo(String className, int options) {
            this._className = className;
            this._options = options;
        }

        FilterInfo(ChildFilter filter) {
            this._className = filter.getClass().getName();
            this._options = filter.getOptions();
            this._filter = filter;
        }

        ChildFilter getFilter() {
            if (this._filter == null) {
                try {
                    Class<?> filterClass = Class.forName(this._className);
                    this._filter = (ChildFilter)filterClass.newInstance();
                    this._filter.setOptions(this._options);
                    return this._filter;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return this._filter;
        }

        String getClassName() {
            return this._className;
        }

        int getOptions() {
            return this._options;
        }

        ChildFilter releaseFilter() {
            ChildFilter filter = this._filter;
            this._filter = null;
            if (filter != null) {
                filter.closeChildren();
            }
            return filter;
        }
    }

    private static abstract class FilterCache {
        private static final FilterCache NO_CACHING = new FilterCache(){

            @Override
            public ChildFilter findCacheFilter(TNode node) {
                return null;
            }

            @Override
            public void cacheFilter(TNode node, ChildFilter filter) {
            }

            @Override
            public void saveFilters(PropertyAccess layout) {
            }

            @Override
            public void openFilters(PropertyAccess layout) {
            }

            @Override
            public void renameFilters(TNode parent, TNode child, UpdateMessage rename) {
            }

            @Override
            public void releaseFilters(TNode tnode, boolean recurse) {
                ChildFilter childFilter;
                if (tnode.isLeaf()) {
                    return;
                }
                if (tnode.getData() == null || !(tnode.getData() instanceof Project) && !(tnode.getData() instanceof Workspace)) {
                    tnode.setChildFilter(null);
                }
                if ((childFilter = tnode.getChildFilter()) != null) {
                    childFilter.closeChildren();
                }
                if (recurse && tnode.isSet(TNodeConstants.IS_OPENED)) {
                    Enumeration children = tnode.children();
                    while (children.hasMoreElements()) {
                        this.releaseFilters((TNode)children.nextElement(), true);
                    }
                }
            }
        };
        private static final FilterCache ORIGINAL_CACHING = new FilterCache(){
            private final Map<String, FilterInfo> _filterCache = new HashMap<String, FilterInfo>();
            private final Map _filterCache4Rename = new HashMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void cacheFilter(TNode tnode, ChildFilter filter) {
                if (filter != null) {
                    String key = BaseTreeExplorer.buildPathKey(tnode);
                    Map<String, FilterInfo> map = this._filterCache;
                    synchronized (map) {
                        this._filterCache.put(key, new FilterInfo(filter));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final ChildFilter findCacheFilter(TNode tnode) {
                FilterInfo info;
                String key = BaseTreeExplorer.buildPathKey(tnode);
                Map<String, FilterInfo> map = this._filterCache;
                synchronized (map) {
                    info = this._filterCache.get(key);
                }
                return info != null ? info.getFilter() : null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void saveFilters(PropertyAccess layout) {
                Map<String, FilterInfo> map = this._filterCache;
                synchronized (map) {
                    int size = this._filterCache.size();
                    if (size == 0) {
                        return;
                    }
                    String prop = BaseTreeExplorer.FILTER_PROP;
                    layout.setProperty(prop, Integer.toString(size));
                    int ctr = 0;
                    for (Map.Entry<String, FilterInfo> entry : this._filterCache.entrySet()) {
                        String key = entry.getKey();
                        if (key == null) continue;
                        FilterInfo info = entry.getValue();
                        String filterClass = null;
                        int filterOptions = 0;
                        if (info != null) {
                            filterClass = info.getClassName();
                            filterOptions = info.getOptions();
                        }
                        prop = new StringBuffer().append(BaseTreeExplorer.FILTER_PROP).append(ctr).append(BaseTreeExplorer.KEY_PROP).toString();
                        layout.setProperty(prop, key);
                        prop = new StringBuffer().append(BaseTreeExplorer.FILTER_PROP).append(ctr).append(BaseTreeExplorer.FILTER_CLS_PROP).toString();
                        layout.setProperty(prop, filterClass);
                        if (filterOptions != -1) {
                            prop = new StringBuffer().append(BaseTreeExplorer.FILTER_PROP).append(ctr).append(BaseTreeExplorer.FILTER_OPTS_PROP).toString();
                            layout.setProperty(prop, Integer.toString(filterOptions));
                        }
                        ++ctr;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openFilters(PropertyAccess layout) {
                String prop = BaseTreeExplorer.FILTER_PROP;
                int size = Integer.parseInt(layout.getProperty(prop, "0"));
                if (size == 0) {
                    return;
                }
                Map<String, FilterInfo> map = this._filterCache;
                synchronized (map) {
                    for (int i = 0; i < size; ++i) {
                        prop = new StringBuffer().append(BaseTreeExplorer.FILTER_PROP).append(i).append(BaseTreeExplorer.KEY_PROP).toString();
                        String key = layout.getProperty(prop, null);
                        prop = new StringBuffer().append(BaseTreeExplorer.FILTER_PROP).append(i).append(BaseTreeExplorer.FILTER_CLS_PROP).toString();
                        String filterCls = layout.getProperty(prop, null);
                        if (key == null || filterCls == null) continue;
                        prop = new StringBuffer().append(BaseTreeExplorer.FILTER_PROP).append(i).append(BaseTreeExplorer.FILTER_OPTS_PROP).toString();
                        String options = layout.getProperty(prop, null);
                        int filterOptions = options != null ? Integer.parseInt(options) : 0;
                        FilterInfo info = this._filterCache.get(key);
                        if (info != null && info.getClassName().equals(filterCls) && info.getOptions() == filterOptions) continue;
                        this._filterCache.put(key, new FilterInfo(filterCls, filterOptions));
                    }
                }
            }

            @Override
            public void renameFilters(TNode parent, TNode child, UpdateMessage rename) {
                TreePath path;
                if (child.getParent() == null) {
                    TreePath parentPath = new TreePath(parent.getPath());
                    path = parentPath.pathByAddingChild(child);
                } else {
                    path = new TreePath(child.getPath());
                }
                String pathKey = BaseTreeExplorer.buildPathKey(path);
                if (RenameMessage.isPreRenameMessage((UpdateMessage)rename)) {
                    HashMap renamedKeys = new HashMap();
                    this._filterCache4Rename.put(pathKey, renamedKeys);
                    int pathKeyLength = pathKey.length();
                    Iterator<Map.Entry<String, FilterInfo>> i = this._filterCache.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<String, FilterInfo> entry = i.next();
                        String key = entry.getKey();
                        if (key == null || !key.startsWith(pathKey)) continue;
                        i.remove();
                        key = key.substring(pathKeyLength);
                        this._filterCache4Rename.put(key, entry.getValue());
                    }
                } else {
                    for (Map.Entry entry : this._filterCache4Rename.entrySet()) {
                        String key = (String)entry.getKey();
                        FilterInfo info = (FilterInfo)entry.getValue();
                        ChildFilter filter = info.getFilter();
                        if (filter == null) continue;
                        this._filterCache.put(pathKey + key, new FilterInfo(filter));
                        if (key.length() != 0) continue;
                        child.setChildFilter(filter);
                        filter.setOwner(child);
                        filter.refresh(null);
                    }
                    this._filterCache4Rename.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseFilters(TNode tnode, boolean recurse) {
                if (tnode.isLeaf()) {
                    return;
                }
                String key = BaseTreeExplorer.buildPathKey(tnode);
                Map<String, FilterInfo> map = this._filterCache;
                synchronized (map) {
                    FilterInfo info = this._filterCache.get(key);
                    if (info != null) {
                        if (tnode.getData() == null || !(tnode.getData() instanceof Project) && !(tnode.getData() instanceof Workspace)) {
                            tnode.setChildFilter(null);
                        }
                        info.releaseFilter();
                    }
                }
                if (recurse && tnode.isSet(TNodeConstants.IS_OPENED)) {
                    Enumeration children = tnode.children();
                    while (children.hasMoreElements()) {
                        this.releaseFilters((TNode)children.nextElement(), true);
                    }
                }
            }
        };

        private FilterCache() {
        }

        private static FilterCache getInstance() {
            return NO_CACHING;
        }

        public abstract ChildFilter findCacheFilter(TNode var1);

        public abstract void cacheFilter(TNode var1, ChildFilter var2);

        public abstract void saveFilters(PropertyAccess var1);

        public abstract void openFilters(PropertyAccess var1);

        public abstract void renameFilters(TNode var1, TNode var2, UpdateMessage var3);

        public abstract void releaseFilters(TNode var1, boolean var2);

        static /* synthetic */ FilterCache access$000() {
            return FilterCache.getInstance();
        }
    }

    private final class TreeExplorerModel
    extends DefaultTreeModel {
        private TreeExplorerModel(TreeNode root) {
            super(root);
        }

        @Override
        public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int index) {
            if (parent instanceof ExplorerNode && !((ExplorerNode)parent).isSet(TNodeConstants.IS_OPENED)) {
                ((ExplorerNode)parent).removeAllChildren();
            }
            parent.insert(child, index);
            int[] childIndices = new int[1];
            int i = parent.getIndex(child);
            if (i >= 0) {
                childIndices[0] = i;
                this.nodesWereInserted(parent, childIndices);
            } else {
                Assert.println((String)("Unable to insert child " + child.toString() + " into parent " + parent.toString()));
            }
        }

        private void removeNodesFromParent(MutableTreeNode parent, MutableTreeNode[] children) {
            int i;
            int size = children.length;
            int[] childIndices = new int[size];
            for (i = 0; i < size; ++i) {
                childIndices[i] = parent.getIndex(children[i]);
            }
            for (i = 0; i < size; ++i) {
                parent.remove(children[i]);
            }
            this.nodesWereRemoved(parent, childIndices, children);
        }
    }

    private class SiblingIterator {
        private int _relativeToRow;
        private TreePath _relativeToPath;
        private TNode _relativeToParent;
        private int _searchRow;
        private boolean _backward;

        SiblingIterator(int relativeToRow) {
            this._relativeToRow = relativeToRow;
            this._searchRow = relativeToRow;
            this._relativeToPath = BaseTreeExplorer.this.tree.getPathForRow(relativeToRow);
            this._relativeToParent = this.getParentNode(this._relativeToPath);
        }

        TreePath nextSiblingPath() {
            TreePath tp;
            if (!this._backward) {
                while (this._searchRow + 1 <= BaseTreeExplorer.this.tree.getRowCount()) {
                    ++this._searchRow;
                    tp = BaseTreeExplorer.this.tree.getPathForRow(this._searchRow);
                    if (tp == null) continue;
                    if (this.isSiblingPath(tp)) {
                        return tp;
                    }
                    if (this.sameSubtree(tp)) continue;
                    break;
                }
                this._backward = true;
                this._searchRow = this._relativeToRow;
            }
            while (this._searchRow - 1 >= 0) {
                --this._searchRow;
                tp = BaseTreeExplorer.this.tree.getPathForRow(this._searchRow);
                if (tp == null) continue;
                if (this.isSiblingPath(tp)) {
                    return tp;
                }
                if (this.sameSubtree(tp)) continue;
                break;
            }
            return null;
        }

        private boolean isSiblingPath(TreePath tp) {
            return this.getParentNode(tp) == this._relativeToParent;
        }

        private boolean sameSubtree(TreePath tp) {
            for (TreePath search = tp; search != null; search = search.getParentPath()) {
                if (search != this._relativeToParent) continue;
                return true;
            }
            return false;
        }

        private TNode getParentNode(TreePath tp) {
            int pathCount = tp.getPathCount();
            if (pathCount >= 2) {
                return (TNode)tp.getPathComponent(pathCount - 2);
            }
            return null;
        }
    }
}

