/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.post;

import java.security.PrivateKey;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.post.IPostContainerReply;
import oracle.cloudstorage.api.post.IPostObjectReply;
import oracle.cloudstorage.api.post.IPostRequestBuilder;
import oracle.cloudstorage.api.post.IPostRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.builder.AbstractRequestBuilder;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;

public class PostRequestBuilder
extends AbstractRequestBuilder<IPostRequestBuilder, IPostRequestProcessor>
implements IPostRequestBuilder {
    private PrivateKey decryptionKey = null;

    public PostRequestBuilder(IRequestBuilder that) {
        super(that, Method.post);
    }

    @Override
    public PrivateKey getDecryptionKey() {
        return this.decryptionKey;
    }

    @Override
    public RetryStrategy root(ISession session, IPostRequestProcessor processor) {
        this.createContext(session, processor);
        return new RetryStrategy();
    }

    private class Object
    implements IPostRequestBuilder.Object {
        private Object() {
        }

        @Override
        public IPostObjectReply send() throws RetryException, InterruptedException {
            IPostObjectReply reply = ((IPostRequestProcessor)PostRequestBuilder.this.getProcessor()).object();
            return reply;
        }
    }

    private class CipherKey
    extends Object
    implements IPostRequestBuilder.CipherKeyPair {
        private CipherKey() {
        }

        @Override
        public IPostRequestBuilder.Object rotate(PrivateKey decryptionKey) {
            PostRequestBuilder.this.decryptionKey = decryptionKey;
            return new Object();
        }
    }

    private class Container
    implements IPostRequestBuilder.Container {
        private Container() {
        }

        @Override
        public IPostRequestBuilder.CipherKeyPair object(String objectId) {
            PostRequestBuilder.this.setObjectId(objectId);
            return new CipherKey();
        }

        @Override
        public IPostContainerReply send() throws RetryException {
            IPostContainerReply reply = ((IPostRequestProcessor)PostRequestBuilder.this.getProcessor()).container();
            return reply;
        }
    }

    private class Account
    implements IPostRequestBuilder.Account {
        private Account() {
        }

        @Override
        public Container container(String containerId) {
            PostRequestBuilder.this.setContainerId(containerId);
            return new Container();
        }
    }

    private class QueryParam
    extends Account
    implements IPostRequestBuilder.QueryParam {
        private QueryParam() {
        }

        @Override
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> paramProvider) {
            PostRequestBuilder.this.getQueryParams().put(paramProvider);
            return this;
        }

        @Override
        public Account account(String accountId) {
            PostRequestBuilder.this.setAccountId(accountId);
            return new Account();
        }
    }

    private class Header
    extends QueryParam
    implements IPostRequestBuilder.Header {
        private Header() {
        }

        @Override
        public Header header(Iterable<Map.Entry<String, String>> headerProvider) {
            PostRequestBuilder.this.addHeaders(headerProvider);
            return this;
        }
    }

    private class ReadTimeout
    extends Header
    implements IPostRequestBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public IPostRequestBuilder.Header read(long timeout, TimeUnit units) {
            PostRequestBuilder.this.setReadTimeout(units.toMillis(timeout));
            return new Header();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements IPostRequestBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public IPostRequestBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            PostRequestBuilder.this.setConnectTimeout(units.toMillis(timeout));
            return new ReadTimeout();
        }
    }

    private class RetryStrategy
    extends ConnectTimeout
    implements IPostRequestBuilder.RetryStrategy {
        private RetryStrategy() {
        }

        @Override
        public ConnectTimeout retry(IRetryStrategy retryStrategy) {
            PostRequestBuilder.this.setRetryStrategy(retryStrategy);
            return new ConnectTimeout();
        }
    }
}

