/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.cloudstorage.api.retry.RetryState;

public class CompositeRetryState
extends RetryState {
    private final List<RetryState> parts;
    private Iterator<RetryState> iterator;
    private RetryState current = null;

    public CompositeRetryState(int count) {
        this.parts = new ArrayList<RetryState>(count);
    }

    public void add(RetryState retryState) {
        this.parts.add(retryState == null ? new RetryState() : retryState);
    }

    public void first() {
        this.iterator = this.parts.iterator();
    }

    RetryState next() {
        if (this.iterator == null) {
            this.iterator = this.parts.iterator();
        }
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        return this.current;
    }

    @Override
    public int getAttempt() {
        return this.current == null ? -1 : this.current.getAttempt();
    }

    @Override
    public void incrementAttempt() {
        if (this.current != null) {
            this.current.incrementAttempt();
        }
    }
}

