/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITRevertCommitCustomizer;
import oracle.jdevimpl.vcs.xspi.VCSBugTrackingManager;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevertResult;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationRevertCommit
extends GITExtendedAbstractOperation {
    private static final String COMMAND_ID = "oracle.jdeveloper.git.revertcommit";
    private URL _root;
    private Collection<File> _failures;
    private Collection<File> _conflicts;
    private GitRevertResult.Status _status;
    private String _activeBranch;

    public GITOperationRevertCommit() {
        super(COMMAND_ID);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        return this.getLocatableFromNavOrProfile(profile);
    }

    protected String getDialogHint() {
        if (this._activeBranch != null) {
            return Resource.format("OPERATION_REVERT_COMMIT_DIALOG_HINT", this._activeBranch);
        }
        return super.getDialogHint();
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        try {
            Locatable[] locatables = this.getOperands(this.getProfile());
            if (locatables.length > 0) {
                Map<String, Object> options = null;
                this._root = locatables[0].getURL();
                Map<String, GitBranch> branches = GITUtil.getBranches(this._root, false);
                GitBranch active = GITUtil.getActiveBranch(branches);
                if (active != null) {
                    this._activeBranch = active.getName();
                    options = this.getBranchRevisionOptions(this._root, this._activeBranch, false);
                }
                VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.git", (VCSOptionsCustomizer)new GITRevertCommitCustomizer());
                customizer.setOptions(options);
                return customizer;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITOperationRevertCommit.class.getName()).log(Level.WARNING, "Merge Operation failed ", e);
        }
        return null;
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        String revision = (String)options.get("Git-use-revision");
        Boolean commitRevert = (Boolean)options.get("git-commit-revert");
        String comment = (String)options.get("setting_comments");
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("REVERT_OPERATION"));
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("REVERT_PROGRESS_TITLE"), (Object)Resource.get("REVERT_PROGRESS"), null);
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return progress.isCanceled();
            }
        };
        progress.start();
        GitClient client = null;
        try {
            Collection<Object> modifiedFiles = Collections.emptyList();
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            client = GITClientAdaptor.getClient(this._root);
            Collection<String> revisions = this.getRevisions(client, revision, monitor);
            if (this._activeBranch != null) {
                modifiedFiles = GITUtil.getModifiedFiles(client, revision, this._activeBranch, monitor);
            }
            GitRevertResult result = client.revert(revision, comment, commitRevert.booleanValue(), (ProgressMonitor)monitor);
            this._status = result.getStatus();
            this._conflicts = result.getConflicts();
            this._failures = result.getFailures();
            GITUtil.logFiles(this._conflicts, Resource.get("REVERT_CONFLICTS"));
            GITUtil.logFiles(this._failures, Resource.get("REVERT_FAILURES"));
            if (this._status != GitRevertResult.Status.NO_CHANGE) {
                this.setProcessedUrls(commandState, GITUtil.convertFileToUrl(modifiedFiles.toArray(new File[0])).toArray(new URL[0]));
            }
            VCSBugTrackingManager.getInstance().removeCommits(revisions, "Git");
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationRevertCommit.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.get("REVERT_COMMMIT_ERROR"), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
            monitor.logCompleted();
            progress.finish();
        }
        return true;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        if (this._status == GitRevertResult.Status.NO_CHANGE) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Resource.get("REVERT_COMMIT_FAILED"), (String)Resource.get("REVERT_COMMIT_ERROR_TITLE"), null);
            return;
        }
        if (!this._failures.isEmpty() && !this._conflicts.isEmpty()) {
            GITUtil.reportFiles(this._failures, this._conflicts, Resource.get("REVERT_COMMIT_ERROR_TITLE"));
        } else {
            GITUtil.reportFiles(this._failures, Resource.get("REVERT_COMMIT_ERROR_TITLE"), Resource.get("REVERT_COMMIT_ERROR_FAILURE"));
            GITUtil.reportFiles(this._conflicts, Resource.get("REVERT_COMMIT_ERROR_TITLE"), Resource.get("REVERT_COMMIT_ERROR_CONFLICT"));
        }
    }
}

