/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchSelector;
import oracle.jdevimpl.vcs.git.ui.GITRevisionSelector;
import oracle.jdevimpl.vcs.git.ui.GITTagSelector;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITBranchRevisionPanel
extends JPanel {
    private JLabel _lblBranch = new JLabel();
    private JTextField _fldBranch = new JTextField();
    private JButton _btnBranch = new JButton();
    private JLabel _lblTag = new JLabel();
    private JTextField _fldTag = new JTextField();
    private JButton _btnTag = new JButton();
    private JCheckBox _checkRev = new JCheckBox();
    private JTextField _fldRev = new JTextField();
    private JButton _btnRev = new JButton();
    private int _row = 0;
    private URL _root;

    public GITBranchRevisionPanel() {
        this.init();
        this.initLayout();
        this.addListeners();
    }

    private void init() {
        ResourceUtils.resLabel((JLabel)this._lblBranch, (Component)this._fldBranch, (String)Resource.get("CHECKOUT_BRANCH"));
        ResourceUtils.resButton((AbstractButton)this._btnBranch, (String)Resource.get("CHECKOUT_SELECT_BRANCH"));
        ResourceUtils.resLabel((JLabel)this._lblTag, (Component)this._fldTag, (String)Resource.get("CHECKOUT_TAG"));
        ResourceUtils.resButton((AbstractButton)this._btnTag, (String)Resource.get("CHECKOUT_SELECT_TAG"));
        ResourceUtils.resButton((AbstractButton)this._checkRev, (String)Resource.get("CHECKOUT_REVISION"));
        ResourceUtils.resButton((AbstractButton)this._btnRev, (String)Resource.get("CHECKOUT_SELECT_REVISION"));
        this._fldRev.setEditable(false);
        this._checkRev.setEnabled(false);
    }

    private void initLayout() {
        Insets insL = new Insets(5, 0, 5, 5);
        Insets insR = new Insets(5, 5, 5, 0);
        Insets ins = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._lblBranch, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 17, 0, insL, 0, 0));
        this.add((Component)this._fldBranch, new GridBagConstraints(1, this._row, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._btnBranch, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 17, 2, insR, 0, 0));
        ++this._row;
        this.add((Component)this._lblTag, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 17, 0, insL, 0, 0));
        this.add((Component)this._fldTag, new GridBagConstraints(1, this._row, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._btnTag, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 17, 2, insR, 0, 0));
        ++this._row;
        this.add((Component)this._checkRev, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 17, 0, insL, 0, 0));
        this.add((Component)this._fldRev, new GridBagConstraints(1, this._row, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._btnRev, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 17, 0, insR, 0, 0));
    }

    void addLayoutRow(Component left, Component middle, Component right) {
        Insets insL = new Insets(5, 0, 5, 5);
        Insets insR = new Insets(5, 5, 5, 0);
        Insets ins = new Insets(5, 5, 5, 5);
        ++this._row;
        this.add(left, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 17, 0, insL, 0, 0));
        this.add(middle, new GridBagConstraints(1, this._row, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(right, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 17, 0, insR, 0, 0));
    }

    String getSelectedBranch() {
        if (this._fldBranch.isEnabled()) {
            return this._fldBranch.getText();
        }
        return null;
    }

    void setSelectedBranch(String branch) {
        this._fldBranch.setText(branch);
    }

    String getSelectedTag() {
        if (this._fldTag.isEnabled()) {
            return this._fldTag.getText();
        }
        return null;
    }

    void setSelectedTag(String tag) {
        this._fldTag.setText(tag);
    }

    String getSelectedRevision() {
        if (this._checkRev.isSelected()) {
            return this._fldRev.getText();
        }
        try {
            if (this._fldBranch.isEnabled()) {
                return this.getLatestRevisionBranch();
            }
            return this.getTagCommitId();
        }
        catch (GITProcessException e) {
            GITProfile.getQualifiedLogger(GITBranchRevisionPanel.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        catch (URISyntaxException e) {
            GITProfile.getQualifiedLogger(GITBranchRevisionPanel.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        return null;
    }

    void setSelectedRevision(String revision) {
        this._fldRev.setText(revision);
        this._checkRev.setSelected(true);
        this._checkRev.setEnabled(true);
    }

    void setUseRevision(boolean enable) {
        this._checkRev.setSelected(enable);
    }

    boolean isUseRevision() {
        return this._checkRev.isSelected();
    }

    void setRepositoryRoot(URL root) {
        this._root = root;
    }

    URL getRepositoryRoot() {
        return this._root;
    }

    Component getDefaultComp() {
        return this._fldBranch;
    }

    private void addListeners() {
        this._btnBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITBranchSelector selector = new GITBranchSelector(GITBranchRevisionPanel.this._root);
                selector.addObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        String branch = (String)arg;
                        if (branch != null) {
                            GITBranchRevisionPanel.this.setSelectedBranch(branch);
                            GITBranchRevisionPanel.this.setSelectedRevision("");
                            GITBranchRevisionPanel.this.setUseRevision(false);
                        }
                    }
                });
                selector.showLister();
            }
        });
        this._fldBranch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.enableFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.enableFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void enableFields() {
                GITBranchRevisionPanel.this._fldBranch.setEnabled(true);
                if (GITBranchRevisionPanel.this._fldBranch.getText().length() == 0) {
                    GITBranchRevisionPanel.this._fldTag.setEnabled(true);
                } else {
                    GITBranchRevisionPanel.this._fldTag.setEnabled(false);
                }
            }
        });
        this._btnTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITTagSelector selector = new GITTagSelector(GITBranchRevisionPanel.this._root);
                selector.addObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        String tag = (String)arg;
                        if (tag != null) {
                            GITBranchRevisionPanel.this.setSelectedTag(tag);
                            GITBranchRevisionPanel.this.setSelectedRevision("");
                            GITBranchRevisionPanel.this.setUseRevision(false);
                        }
                    }
                });
                selector.showLister();
            }
        });
        this._fldTag.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.enableFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.enableFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void enableFields() {
                GITBranchRevisionPanel.this._fldTag.setEnabled(true);
                if (GITBranchRevisionPanel.this._fldTag.getText().length() == 0) {
                    GITBranchRevisionPanel.this._fldBranch.setEnabled(true);
                } else {
                    GITBranchRevisionPanel.this._fldBranch.setEnabled(false);
                }
            }
        });
        this._btnRev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITRevisionSelector selector = new GITRevisionSelector(this.getRevision(), GITBranchRevisionPanel.this._root);
                selector.addObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        String rev = (String)arg;
                        if (rev != null && !rev.isEmpty()) {
                            GITBranchRevisionPanel.this._fldRev.setText(rev);
                            GITBranchRevisionPanel.this._checkRev.setSelected(true);
                            GITBranchRevisionPanel.this._checkRev.setEnabled(true);
                        }
                    }
                });
                selector.showLister();
            }

            private String getRevision() {
                String revision;
                String string = revision = GITBranchRevisionPanel.this._fldTag.isEnabled() ? GITBranchRevisionPanel.this._fldTag.getText() : GITBranchRevisionPanel.this._fldBranch.getText();
                if (revision.equals("(no branch)")) {
                    revision = "HEAD";
                }
                return revision;
            }
        });
    }

    private String getLatestRevisionBranch() throws URISyntaxException, GITProcessException {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Log");
            client = GITClientAdaptor.getClient(this._root);
            SearchCriteria sc = new SearchCriteria();
            File[] files = new File[]{new File(this._root.toURI())};
            sc.setFiles(files);
            sc.setRevisionTo(this._fldBranch.getText().equals("(no branch)") ? "HEAD" : this._fldBranch.getText());
            sc.setLimit(1);
            GitRevisionInfo[] revisions = client.log(sc, (ProgressMonitor)monitor);
            if (monitor.getError() == null) {
                String string = revisions[0].getRevision();
                return string;
            }
            try {
                throw new GITProcessException(Resource.format("ERROR_COMMITID_BRANCH", this._fldBranch.getText()), monitor.getError());
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITBranchRevisionPanel.class.getName()).log(Level.SEVERE, e.getMessage());
                throw new GITProcessException(Resource.format("ERROR_COMMITID_BRANCH", this._fldBranch.getText()), e.getMessage());
            }
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTagCommitId() throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("tag");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(this._root);
            Map tags = client.getTags((ProgressMonitor)monitor, false);
            GitTag tag = (GitTag)tags.get(this._fldTag.getText());
            if (tag != null) {
                String string = tag.getTaggedObjectId();
                return string;
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITBranchRevisionPanel.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return null;
    }
}

