/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.plsql.Function;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.FunctionBuilder;
import oracle.javatools.db.plsql.parser.PlSqlFragmentBuilder;
import oracle.javatools.db.plsql.parser.PlSqlReferenceBuilder;
import oracle.javatools.db.plsql.parser.PlSqlSourceObjectBuilder;
import oracle.javatools.db.plsql.parser.PlSqlSpecAndBodyBuilder;
import oracle.javatools.db.plsql.parser.TriggerBuilder;
import oracle.javatools.db.plsql.parser.TypeBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.sql.BaseSqlAliasExpander;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLDerivedPropertySupport;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.IndexValidator;
import oracle.javatools.db.validators.SchemaValidator;
import oracle.javatools.db.validators.TableValidator;

public abstract class BaseDatabaseDescriptor
extends DatabaseDescriptor {
    protected BaseDatabaseDescriptor(Class<? extends Database> clazz) {
        super(clazz);
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)((Object)this));
    }

    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, SchemaValidator> map = DBObjectRegistry.isActive() ? DBObjectRegistry.getInstance().getValidators(this.getDatabaseType(), this.getDatabaseVersion(), dBObjectProvider) : new HashMap<String, SchemaValidator>();
        map.put("SCHEMA", new SchemaValidator(dBObjectProvider));
        map.put("INDEX", (SchemaValidator)((Object)new IndexValidator(dBObjectProvider)));
        map.put("CONSTRAINT", (SchemaValidator)((Object)new ConstraintValidator(dBObjectProvider)));
        map.put("COLUMN", (SchemaValidator)((Object)new ColumnValidator(dBObjectProvider)));
        map.put("DataTypeUsage", (SchemaValidator)((Object)new DataTypeUsageValidator(dBObjectProvider)));
        map.put("TABLE", (SchemaValidator)((Object)new TableValidator(dBObjectProvider)));
        return map;
    }

    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider dBObjectProvider) {
        ArrayList<PropertyInitializer> arrayList = new ArrayList<PropertyInitializer>();
        arrayList.add(new BasePropertyInitializer(dBObjectProvider));
        return arrayList;
    }

    public List<UpdateProcessor> getUpdateProcessors() {
        ArrayList<UpdateProcessor> arrayList = new ArrayList<UpdateProcessor>();
        arrayList.add((UpdateProcessor)new TemplateExpander());
        return arrayList;
    }

    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider dBObjectProvider, Schema schema) {
        return new BaseSqlAliasExpander(dBObjectProvider, schema);
    }

    public DerivedPropertyBuilder getDerivedPropertyBuilder(Class<? extends AbstractBuildableObject> clazz, DBObjectProvider dBObjectProvider) {
        AbstractPlSqlBuilder abstractPlSqlBuilder = super.getDerivedPropertyBuilder(clazz, dBObjectProvider);
        if (abstractPlSqlBuilder == null) {
            if (CheckConstraint.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = SQLDerivedPropertySupport.createCheckConstraintBuilder(dBObjectProvider);
            } else if (Column.class.isAssignableFrom(clazz)) {
                if (dBObjectProvider.getPropertyManager().findPropertyInfo(clazz, "virtualExpressionSource") != null) {
                    abstractPlSqlBuilder = SQLDerivedPropertySupport.createVirtualExpressionBuilder(dBObjectProvider);
                }
            } else if (IndexObject.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = SQLDerivedPropertySupport.createIndexExpressionBuilder(dBObjectProvider);
            } else if (SQLQuery.class.isAssignableFrom(clazz)) {
                SQLQueryBuilder sQLQueryBuilder = this.getSQLQueryBuilderFactory().createSQLQueryBuilder(dBObjectProvider);
                if (sQLQueryBuilder instanceof DerivedPropertyBuilder) {
                    abstractPlSqlBuilder = (DerivedPropertyBuilder)sQLQueryBuilder;
                }
            } else if (SynonymUsage.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new SQLDerivedPropertySupport.SynonymUsageBuilder((AbstractDBObjectProvider)dBObjectProvider);
            } else if (Relation.class.isAssignableFrom(clazz) && SQLQueryOwner.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new SQLDerivedPropertySupport.SQLQueryColumnsBuilder((AbstractDBObjectProvider)dBObjectProvider, Metadata.getType(clazz));
            } else if (Function.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new FunctionBuilder((AbstractDBObjectProvider)dBObjectProvider);
            } else if (Procedure.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new PlSqlSourceObjectBuilder((AbstractDBObjectProvider)dBObjectProvider, "PROCEDURE");
            } else if (Trigger.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new TriggerBuilder((AbstractDBObjectProvider)dBObjectProvider);
            } else if (Package.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new PlSqlSpecAndBodyBuilder((AbstractDBObjectProvider)dBObjectProvider, "PACKAGE");
            } else if (PackageBody.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new PlSqlSpecAndBodyBuilder((AbstractDBObjectProvider)dBObjectProvider, "PACKAGE BODY");
            } else if (Type.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new TypeBuilder((AbstractDBObjectProvider)dBObjectProvider);
            } else if (TypeBody.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new PlSqlSpecAndBodyBuilder((AbstractDBObjectProvider)dBObjectProvider, "TYPE BODY");
            } else if (PlSqlReference.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new PlSqlReferenceBuilder((AbstractDBObjectProvider)dBObjectProvider);
            } else if (PlSqlCodeFragment.class.isAssignableFrom(clazz)) {
                abstractPlSqlBuilder = new PlSqlFragmentBuilder((AbstractDBObjectProvider)dBObjectProvider, Metadata.getType(clazz));
            }
        }
        return abstractPlSqlBuilder;
    }

    private static class BasePropertyInitializer
    extends PropertyInitializer {
        private static String[] s_names = new String[]{"name"};
        private final boolean m_lower = this.getProvider().getDescriptor().getCasePolicy() == 1;

        BasePropertyInitializer(DBObjectProvider dBObjectProvider) {
            super(dBObjectProvider);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clazz) {
            return s_names;
        }

        public Object getPropertyInitialValue(DBObject dBObject, String string) throws PropertyInitializer.InitializationVeto {
            String string2 = null;
            if ("name".equals(string)) {
                Object object;
                boolean bl;
                DBObject dBObject2;
                boolean bl2;
                String string3;
                if (dBObject.getName() != null) {
                    throw new PropertyInitializer.InitializationVeto();
                }
                DBObjectProvider dBObjectProvider = this.getProvider();
                if (dBObjectProvider.supportsObjectType(string3 = dBObject.getType())) {
                    bl2 = true;
                    dBObject2 = DBUtil.getSchema((DBObject)dBObject);
                    bl = !(dBObject instanceof SchemaObject) || dBObject2 != null;
                } else {
                    dBObject2 = dBObject.getParent();
                    object = ((AbstractDBObjectProvider)dBObjectProvider).getValidatorForType(string3);
                    bl = object != null && object.getNamespaceType() != DBObjectValidator.NamespaceType.NONE;
                    boolean bl3 = bl2 = object != null && object.initializeWithDefaultName();
                }
                if (bl2) {
                    object = dBObject instanceof MaterializedView ? "MVIEW" : string3.replaceAll(" ", "_");
                    string2 = dBObject instanceof Index && dBObject.getParent() instanceof Table ? dBObject.getParent().getName() + "_" + (String)object + "1" : (String)object + "1";
                    if (this.m_lower) {
                        string2 = string2.toLowerCase();
                    }
                    if (bl) {
                        string2 = dBObjectProvider.getUniqueName(dBObject.getType(), dBObject2, string2);
                    }
                } else {
                    throw new PropertyInitializer.InitializationVeto();
                }
            }
            return string2;
        }
    }
}

