/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.db2.DB2DDLType;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.db2.DB2v9UniversalDatabaseImpl;
import oracle.javatools.db.ddl.BundleDDLGenerator;

class DB2DDLGenerator
extends BundleDDLGenerator<DB2DDLType> {
    private static final String BASE = "/oracle/javatools/db/db2/";
    private static final String DB2_DDL_BASE = "/oracle/javatools/db/db2/DB2DDL.properties";
    private static final String DB2_V9_DDL = "/oracle/javatools/db/db2/DB2v9DDL.properties";

    public DB2DDLGenerator(Class<? extends DB2UniversalDatabase> clazz, DBObjectProvider dBObjectProvider) {
        super(clazz, dBObjectProvider, DB2DDLGenerator.getBundles(clazz));
    }

    protected DB2DDLType getDDLType(String string) {
        return DB2DDLType.getDDLType(string);
    }

    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        if (string.equals("onDeleteAction")) {
            return Arrays.asList(FKConstraint.ReferentialAction.RESTRICT, FKConstraint.ReferentialAction.CASCADE, FKConstraint.ReferentialAction.SET_NULL, FKConstraint.ReferentialAction.NO_ACTION);
        }
        if (dBObject2 instanceof Index && "indexType".equals(string)) {
            ArrayList<Index.IndexType> arrayList = new ArrayList<Index.IndexType>();
            arrayList.add(Index.IndexType.NORMAL);
            arrayList.add(Index.IndexType.UNIQUE);
            return arrayList;
        }
        return super.getAllowedPropertyValues(dBObject, dBObject2, string);
    }

    private static String[] getBundles(Class<? extends DB2UniversalDatabase> clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DB2_DDL_BASE);
        if (DB2v9UniversalDatabaseImpl.class.isAssignableFrom(clazz)) {
            arrayList.add(DB2_V9_DDL);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

