/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.db2.DB2ColumnValidator;
import oracle.javatools.db.db2.DB2DDLGenerator;
import oracle.javatools.db.db2.DB2IndexValidator;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.db2.DB2v10UniversalDatabaseImpl;
import oracle.javatools.db.db2.DB2v9UniversalDatabaseImpl;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SynonymValidator;

public class DB2DatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "AFTER", "ALL", "ALLOCATE", "ALLOW", "ALTER", "AND", "ANY", "AS", "ASSOCIATE", "ASUTIME", "AUDIT", "AUX", "AUXILIARY", "BEFORE", "BEGIN", "BETWEEN", "BUFFERPOOL", "BY", "CALL", "CAPTURE", "CASCADED", "CASE", "CAST", "CCSID", "CHAR", "CHARACTER", "CHECK", "CLOSE", "CLUSTER", "COLLECTION", "COLLID", "COLUMN", "COMMENT", "COMMIT", "CONCAT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONTAINS", "CONTINUE", "CREATE", "CURRENT", "CURRENT_DATE", "CURRENT_LC_CTYPE", "CURRENT_PATH", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURSOR", "DATA", "DATABASE", "DAY", "DAYS", "DBINFO", "DB2SQL", "DECLARE", "DEFAULT", "DELETE", "DESCRIPTOR", "DETERMINISTIC", "DISALLOW", "DISTINCT", "DO", "DOUBLE", "DROP", "DSNHATTR", "DSSIZE", "DYNAMIC", "EDITPROC", "ELSE", "ELSEIF", "ENCODING", "END", "ERASE", "ESCAPE", "EXCEPT", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "FENCED", "FETCH", "FIELDPROC", "FINAL", "FOR", "FROM", "FULL", "FUNCTION", "GENERAL", "GENERATED", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HANDLER", "HAVING", "HOUR", "HOURS", "IF", "IMMEDIATE", "IN", "INDEX", "INHERIT", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INTO", "IS", "ISOBID", "JAR", "JAVA", "JOIN", "KEY", "LABEL", "LANGUAGE", "LC_CTYPE", "LEAVE", "LEFT", "LIKE", "LOCAL", "LOCALE", "LOCATOR", "LOCATORS", "LOCK", "LOCKMAX", "LOCKSIZE", "LONG", "LOOP", "MICROSECOND", "MICROSECONDS", "MINUTE", "MINUTES", "MODIFIES", "MONTH", "MONTHS", "NO", "NOT", "NULL", "NULLS", "NUMPARTS", "OBID", "OF", "ON", "OPEN", "OPTIMIZATION", "OPTIMIZE", "OR", "ORDER", "OUT", "OUTER", "PACKAGE", "PARAMETER", "PART", "PATH", "PIECESIZE", "PLAN", "PRECISION", "PREPARE", "PRIQTY", "PRIVILEGES", "PROCEDURE", "PROGRAM", "PSID", "QUERYNO", "READS", "REFERENCES", "RELEASE", "RENAME", "REPEAT", "RESTRICT", "RESULT", "RESULT_SET_LOCATOR", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "RUN", "SAVEPOINT", "SCHEMA", "SCRATCHPAD", "SECOND", "SECONDS", "SECQTY", "SECURITY", "SELECT", "SENSITIVE", "SIMPLE", "SETUSER", "SOME", "SOURCE", "SPECIFIC", "STANDARD", "STATIC", "STAY", "STOGROUP", "STORES", "STYLE", "SUBPAGES", "SYNONYM", "SYSFUN", "SYSIBM", "SYSPROC", "SYSTEM", "TABLE", "TABLESPACE", "THEN", "TO", "TRIGGER", "UNDO", "UNION", "UNIQUE", "UNTIL", "UPDATE", "USER", "USING", "VALIDPROC", "VALUES", "VARIANT", "VCAT", "VIEW", "VOLUMES", "WHEN", "WHERE", "WHILE", "WITH", "WLM", "YEAR", "YEARS"));

    public DB2DatabaseDescriptor(Class<? extends DB2UniversalDatabase> clazz) {
        super(clazz);
    }

    @Override
    public int getCasePolicy() {
        return 2;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 128;
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        DB2DatabaseDescriptor.validateIdentifier((String)string2, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("INDEX", (DBObjectValidator)new DB2IndexValidator(dBObjectProvider));
        map.put("COLUMN", new DB2ColumnValidator(dBObjectProvider));
        map.put("ALIAS", (DBObjectValidator)new SynonymValidator(dBObjectProvider));
        return map;
    }

    protected boolean isValidFKDataTypeImpl(DataType dataType, DataType dataType2) {
        boolean bl = super.isValidFKDataTypeImpl(dataType, dataType2);
        if (!bl && this.isCharType(dataType) && this.isCharType(dataType2)) {
            bl = true;
        }
        return bl;
    }

    private boolean isCharType(DataType dataType) {
        String string = dataType == null ? null : dataType.getName();
        return "CHAR".equals(string) || "CHAR VARYING".equals(string) || "CHARACTER".equals(string) || "CHARACTER VARYING".equals(string) || "VARCHAR".equals(string);
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new DB2DDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    public final String getDatabaseType() {
        return "DB2";
    }

    @Override
    public int getDatabaseVersion() {
        int n = DB2v10UniversalDatabaseImpl.class.isAssignableFrom(this.getDatabaseClass()) ? 101 : (DB2v9UniversalDatabaseImpl.class.isAssignableFrom(this.getDatabaseClass()) ? 95 : 81);
        return n;
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    public String getPublicSchemaName() {
        return "SYSPUBLIC";
    }

    public boolean isNullConstraintColumnAllowed(ColumnConstraint columnConstraint) {
        return !(columnConstraint instanceof UniqueConstraint) || !columnConstraint.isEnabled();
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        int n = this.getDatabaseVersion();
        if (n == 95) {
            dataTypeCache.registerDataType("XML");
        } else if (n == 81) {
            dataTypeCache.registerDataType("BIGINT");
            dataTypeCache.registerDataType("BLOB");
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("CLOB");
            dataTypeCache.registerDataType("DATALINK");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DBCLOB");
            dataTypeCache.registerDataType("DEC");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("DOUBLE PRECISION");
            dataTypeCache.registerDataType("DOUBLE");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("GRAPHIC");
            dataTypeCache.registerDataType("INT");
            dataTypeCache.registerDataType("INTEGER");
            dataTypeCache.registerDataType("LONG VARCHAR");
            dataTypeCache.registerDataType("LONG VARGRAPHIC");
            dataTypeCache.registerDataType("REAL");
            dataTypeCache.registerDataType("REF");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("TIME");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataType("VARGRAPHIC");
            dataTypeCache.registerDataTypeSynonym("BINARY LARGE OBJECT", "BLOB");
            dataTypeCache.registerDataTypeSynonym("CHAR LARGE OBJECT", "CLOB");
            dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER LARGE OBJECT", "CLOB");
            dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("NUM", "DEC");
            dataTypeCache.registerDataTypeSynonym("NUMERIC", "DECIMAL");
        }
    }
}

