/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.ModelUtil;

public class LocalIndexPartitionHelper {
    public static Collection<OracleIndexPartitions> getLocalIndexPartitionModels(Table table) {
        Index[] indexArray = table.getIndexes();
        ArrayList<OracleIndexPartitions> arrayList = new ArrayList<OracleIndexPartitions>();
        for (Index index : indexArray) {
            OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
            if (!LocalIndexPartitionHelper.isPartitionedLocally(oracleIndexPartitions)) continue;
            arrayList.add(oracleIndexPartitions);
        }
        return arrayList;
    }

    public static boolean isPartitionedLocally(OracleIndexPartitions oracleIndexPartitions) {
        return oracleIndexPartitions != null && (oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_COMP || oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_HASH || oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_OTHER);
    }

    public static IndexPartition createLocalIndexPartition(TablePartition tablePartition, String string) {
        IndexPartition indexPartition;
        block6: {
            int n;
            OracleIndexPartitions oracleIndexPartitions;
            block8: {
                TablePartition[] tablePartitionArray;
                block7: {
                    indexPartition = new IndexPartition();
                    indexPartition.setName(string);
                    if (tablePartition == null) break block6;
                    OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)tablePartition.getParent();
                    OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
                    oracleIndexPartitions = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
                    OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
                    n = 0;
                    if (oracleTablePartitions2 == null) break block6;
                    if (oracleTablePartitions3 == null) {
                        oracleTablePartitions3 = oracleTablePartitions2;
                    }
                    if ((tablePartitionArray = oracleTablePartitions3.getPartitions()).length != 0) break block7;
                    n = 1;
                    if (oracleTablePartitions3.getPartitionType() != OracleTablePartitions.PartitionType.HASH) break block8;
                    Object object = oracleTablePartitions3.getHashQuantity();
                    if (object == null) {
                        object = oracleTablePartitions2.getHashQuantity();
                    }
                    if (object == null || (Integer)object <= 0) break block8;
                    n = (Integer)object;
                    break block8;
                }
                for (TablePartition tablePartition2 : tablePartitionArray) {
                    String string2 = indexPartition.getName() + "_" + tablePartition2.getName();
                    if (tablePartition2.getObjectType() == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                        string2 = tablePartition2.getName();
                    }
                    oracleIndexPartitions.addPartition(LocalIndexPartitionHelper.createLocalIndexPartition(null, string2));
                }
            }
            if (n > 0) {
                for (int i = 1; i <= n; ++i) {
                    oracleIndexPartitions.addPartition(LocalIndexPartitionHelper.createLocalIndexPartition(null, string + "_" + "SUBPARTITION" + i));
                }
            }
            indexPartition.setSubpartitions(oracleIndexPartitions);
        }
        return indexPartition;
    }

    public static TablePartition getBaseTablePartition(IndexPartition indexPartition) {
        TablePartition tablePartition = null;
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)indexPartition.getParent();
        DBObject dBObject = oracleIndexPartitions.getParent();
        Index index = null;
        if (dBObject instanceof Index) {
            index = (Index)dBObject;
            tablePartition = LocalIndexPartitionHelper.getCorrespondingTablePartition(indexPartition, index, null);
        } else {
            IndexPartition indexPartition2;
            TablePartition tablePartition2;
            index = (Index)DBUtil.findParentOfType((DBObject)indexPartition, Index.class);
            if (index != null && (tablePartition = LocalIndexPartitionHelper.getCorrespondingTablePartition(indexPartition, index, tablePartition2 = LocalIndexPartitionHelper.getCorrespondingTablePartition(indexPartition2 = (IndexPartition)indexPartition.getParent().getParent(), index, null))) != null && tablePartition.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                TablePartition tablePartition3 = new TablePartition();
                tablePartition.copyTo((Object)tablePartition3);
                tablePartition3.setName(tablePartition2.getName() + "_" + tablePartition.getName());
                tablePartition = tablePartition3;
            }
        }
        return tablePartition;
    }

    private static TablePartition getCorrespondingTablePartition(IndexPartition indexPartition, Index index, TablePartition tablePartition) {
        TablePartition tablePartition2 = null;
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)indexPartition.getParent();
        IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
        for (int i = 0; i < indexPartitionArray.length; ++i) {
            IndexPartition indexPartition2 = indexPartitionArray[i];
            if (!ModelUtil.areEqual((Object)indexPartition.getName(), (Object)indexPartition2.getName())) continue;
            TablePartition[] tablePartitionArray = LocalIndexPartitionHelper.getCorrespondingTablePartitions(tablePartition, index);
            if (i >= tablePartitionArray.length) break;
            tablePartition2 = tablePartitionArray[i];
            break;
        }
        return tablePartition2;
    }

    private static TablePartition[] getCorrespondingTablePartitions(TablePartition tablePartition, Index index) {
        TablePartition[] tablePartitionArray = new TablePartition[]{};
        if (tablePartition == null) {
            Table table = (Table)DBUtil.findParentOfType((DBObject)index, Table.class);
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (oracleTablePartitions != null) {
                tablePartitionArray = oracleTablePartitions.getPartitions();
            }
        } else {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)tablePartition.getParent();
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
            OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
            if (oracleTablePartitions2 != null) {
                if (oracleTablePartitions3 == null) {
                    oracleTablePartitions3 = oracleTablePartitions2;
                }
                tablePartitionArray = oracleTablePartitions3.getPartitions();
            }
        }
        return tablePartitionArray;
    }

    public static boolean areTableAndIndexPartitionsSameShape(OracleTablePartitions oracleTablePartitions, OracleIndexPartitions oracleIndexPartitions) {
        boolean bl = true;
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        IndexPartition[] indexPartitionArray = oracleIndexPartitions.getPartitions();
        if (oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
            int n = tablePartitionArray.length;
            if (n == 0) {
                Integer n2 = oracleTablePartitions.getHashQuantity();
                int n3 = n = n2 != null ? n2 : 1;
            }
            if (n != indexPartitionArray.length) {
                bl = false;
            }
        } else if (tablePartitionArray.length == indexPartitionArray.length) {
            for (int i = 0; i < tablePartitionArray.length; ++i) {
                TablePartition tablePartition = tablePartitionArray[i];
                IndexPartition indexPartition = indexPartitionArray[i];
                int n = ReferencePartitionHelper.getSubPartitionsCount(tablePartition);
                int n4 = 0;
                OracleIndexPartitions oracleIndexPartitions2 = indexPartition.getSubpartitions();
                if (oracleIndexPartitions2 != null) {
                    n4 = oracleIndexPartitions2.getPartitions().length;
                }
                if (n == n4) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static void cascadeTablePartitions(SystemObject systemObject, OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2, Database database) throws DBException {
        DBObjectValidator dBObjectValidator = ((AbstractDBObjectProvider)database).getValidatorForType("TABLE");
        Difference difference = database.getDiffEngine().difference((Object)oracleTablePartitions, (Object)oracleTablePartitions2);
        boolean bl = oracleTablePartitions2.getSubpartitionModel() != null;
        difference.setSame(false);
        Difference difference2 = difference.getChildDifference("partitions");
        if (difference2 != null) {
            Collection collection = difference2.getChildren();
            for (Difference difference3 : collection) {
                Difference difference4;
                Difference difference5;
                int n = difference3.getIndexOfOriginalObject();
                int n2 = difference3.getIndexOfUpdatedObject();
                TablePartition tablePartition = (TablePartition)difference3.getUpdatedObject();
                if (difference3.isSame() || n != n2) continue;
                Difference difference6 = difference3.getChildDifference("name", true);
                if (difference6 != null) {
                    if (TemporaryObjectID.getOriginalObject((DBObject)tablePartition) == null) continue;
                    difference3.setSame(true);
                    continue;
                }
                if (!bl || (difference5 = difference3.getChildDifference("partitionLevelSubpartitions")) == null || (difference4 = difference5.getChildDifference("partitions")) == null || difference4.isSame()) continue;
                for (Difference difference7 : difference4.getChildren()) {
                    Difference difference8;
                    int n3 = difference7.getIndexOfOriginalObject();
                    int n4 = difference7.getIndexOfUpdatedObject();
                    TablePartition tablePartition2 = (TablePartition)difference7.getUpdatedObject();
                    if (n3 != n4 || difference7.isSame() || (difference8 = difference7.getChildDifference("name", true)) == null || TemporaryObjectID.getOriginalObject((DBObject)tablePartition2) == null) continue;
                    difference7.setSame(true);
                }
            }
        }
        dBObjectValidator.cascadeUpdate(difference, (DBObject)systemObject);
    }
}

