/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.property.Property;

public class OracleTablespaceUtil {
    public static DBObjectID getTablespaceID(DBObjectProvider dBObjectProvider, String string) {
        ReferenceID referenceID = null;
        try {
            Tablespace tablespace;
            if (dBObjectProvider != null && dBObjectProvider.supportsObjectType("TABLESPACE") && (tablespace = (Tablespace)dBObjectProvider.getObject(DBObjectCriteria.createSingleObjectCriteria((String)"TABLESPACE", (Schema)null, (String)string))) != null) {
                referenceID = tablespace.getID();
            }
            if (referenceID == null) {
                referenceID = new ReferenceID("TABLESPACE", (Schema)null, string);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return referenceID;
    }

    public static Map<String, Tablespace.TablespaceType> getTypeSpecificProperties() {
        HashMap<String, Tablespace.TablespaceType> hashMap = new HashMap<String, Tablespace.TablespaceType>();
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "tablespaceGroup"}), Tablespace.TablespaceType.TEMPORARY);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "retention"}), Tablespace.TablespaceType.UNDO);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "blockSize"}), Tablespace.TablespaceType.PERMANENT);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "logging"}), Tablespace.TablespaceType.PERMANENT);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "forceLogging"}), Tablespace.TablespaceType.PERMANENT);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"}), Tablespace.TablespaceType.PERMANENT);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "onlineStatus"}), Tablespace.TablespaceType.PERMANENT);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "segmentManagement"}), Tablespace.TablespaceType.PERMANENT);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties"}), Tablespace.TablespaceType.PERMANENT);
        hashMap.put(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleInMemoryProperties"}), Tablespace.TablespaceType.PERMANENT);
        return hashMap;
    }
}

