/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class TablePartitionsValidator
extends AbstractChildDBObjectValidator<OracleTablePartitions> {
    public TablePartitionsValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    private void validateAll(OracleTablePartitions oracleTablePartitions) throws ValidationException {
        OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
        if (oracleTablePartitions2 != null) {
            for (TablePartition tablePartition : oracleTablePartitions.getPartitions()) {
                OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
                if (oracleTablePartitions3 != null && oracleTablePartitions3.getHashQuantity() != null && oracleTablePartitions2.getPartitionType() == OracleTablePartitions.PartitionType.HASH && oracleTablePartitions2.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_PLS_QUANTITY"));
                }
                if (oracleTablePartitions2.getPartitions().length <= 0 || oracleTablePartitions3 != null && oracleTablePartitions3.getPartitions().length != 0) continue;
                int n = tablePartition.getName() != null ? tablePartition.getName().length() : 0;
                for (TablePartition tablePartition2 : oracleTablePartitions2.getPartitions()) {
                    int n2 = n + tablePartition2.getName().length() + 1;
                    if (n2 <= 30) continue;
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.format((String)"TABLE_SUBPARTITION_ERROR_NAME_TOO_LONG", (Object[])new Object[]{tablePartition.getName() + '_' + tablePartition2.getName(), tablePartition.getName(), tablePartition2.getName()}));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitionColumns"})
    public void validateColumns(ValidationContext<OracleTablePartitions> validationContext) throws ValidationException {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)validationContext.getUpdatedObject();
        ValidationLevel validationLevel = validationContext.getLevel();
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
        OracleTablePartitions.ObjectType objectType = oracleTablePartitions.getObjectType();
        DBObjectID[] dBObjectIDArray = oracleTablePartitions.getPartitionColumns();
        if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION || objectType == OracleTablePartitions.ObjectType.PARTITIONSET_LEVEL_SUBPARTITION_TEMPLATE) {
            if (dBObjectIDArray.length > 0) {
                throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_LEVEL_SUBPARTITION_ERROR_INVALID_COLUMN_COUNT"));
            }
        } else {
            if (partitionType == OracleTablePartitions.PartitionType.LIST) {
                if (dBObjectIDArray.length != 1 || validationLevel == ValidationLevel.FULL && dBObjectIDArray.length == 1 && LOBDescriptor.isLOBColumn((DBObjectID)dBObjectIDArray[0], (DBObject)oracleTablePartitions)) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_LIST_PARTITION_ERROR_INVALID_COLUMN_COUNT"));
                }
            } else if (partitionType != OracleTablePartitions.PartitionType.REFERENCE) {
                if (dBObjectIDArray.length < 1) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_COLUMN_COUNT"));
                }
                if (validationLevel == ValidationLevel.FULL && partitionType == OracleTablePartitions.PartitionType.HASH && dBObjectIDArray.length > 16) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_HASH_PARTITION_ERROR_TOO_MANY_COLUMNS"));
                }
            }
            if (validationLevel == ValidationLevel.FULL) {
                for (DBObjectID dBObjectID : dBObjectIDArray) {
                    if (!this.isInvalidColumn(dBObjectID)) continue;
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_COLUMN_TYPE"));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"referenceConstraintID"})
    public void validateReferenceConstraint(ValidationContext<OracleTablePartitions> validationContext) throws ValidationException {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)validationContext.getUpdatedObject();
        ValidationLevel validationLevel = validationContext.getLevel();
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
        if (partitionType == OracleTablePartitions.PartitionType.REFERENCE) {
            if (oracleTablePartitions.getReferenceConstraintID() == null) {
                throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_NO_REF_ID"));
            }
            if (validationLevel == ValidationLevel.FULL) {
                Constraint constraint = ReferencePartitionHelper.resolveReferenceConstraintID(oracleTablePartitions);
                Table table = (Table)oracleTablePartitions.getParent();
                if (!(constraint instanceof FKConstraint)) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_NOT_FK"));
                }
                FKConstraint fKConstraint = (FKConstraint)constraint;
                if (!fKConstraint.isEnabled()) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_NOT_ENABLED"));
                }
                if (fKConstraint.getDeferrableState() != null) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_NOT_NON_DEFERRABLE"));
                }
                if (fKConstraint.getOnDeleteAction() == FKConstraint.ReferentialAction.SET_NULL) {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_ON_DELETE_SET"));
                }
                for (Column column : fKConstraint.getColumns()) {
                    if (column.isNotNull()) continue;
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_ALL_COLS_NOT_NULL"));
                }
                Constraint constraint2 = null;
                try {
                    constraint2 = (Constraint)fKConstraint.getReferenceID().resolveID();
                }
                catch (DBException dBException) {
                    this.getLogger().warning("Error resolving referenced constraint for Reference Partitions on table " + table.getName());
                }
                if (constraint2 != null) {
                    if (!(constraint2 instanceof UniqueConstraint)) {
                        throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_NOT_PK"));
                    }
                    Table table2 = (Table)constraint2.getParent();
                    if (table2 == table) {
                        throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_SELF_REF"));
                    }
                    if (table2.getProperty("PARTITIONED TABLE") == null) {
                        throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_NOT_PARTITIONED"));
                    }
                } else {
                    throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_NOT_PK"));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"hashQuantity"})
    public void validateHashQuantity(OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions2.getPartitionType();
        OracleTablePartitions.ObjectType objectType = oracleTablePartitions2.getObjectType();
        TablePartition[] tablePartitionArray = oracleTablePartitions2.getPartitions();
        Integer n = oracleTablePartitions2.getHashQuantity();
        DBObjectID[] dBObjectIDArray = oracleTablePartitions2.getHashQuantityTablespaceIds();
        if (partitionType == OracleTablePartitions.PartitionType.HASH) {
            if (tablePartitionArray.length != 0 && n != null) {
                throw new ValidationException((DBObject)oracleTablePartitions2, APIBundle.get((String)"TABLE_HASH_PARTITION_ERROR_INVALID_COMBINATION"));
            }
            if (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && tablePartitionArray.length == 0 && n == null) {
                throw new ValidationException((DBObject)oracleTablePartitions2, APIBundle.get((String)"TABLE_HASH_SUBPARTITION_TEMPLATE_ERROR_MISSING_DEFINITION"));
            }
        } else if (n != null || dBObjectIDArray.length != 0) {
            throw new ValidationException((DBObject)oracleTablePartitions2, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_PROPERTIES"));
        }
        if (n == null && dBObjectIDArray.length != 0) {
            throw new ValidationException((DBObject)oracleTablePartitions2, APIBundle.get((String)"TABLE_HASH_PARTITION_ERROR_INVALID_TABLESPACES"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitions"})
    public void validatePartitions(ValidationContext<OracleTablePartitions> validationContext) throws ValidationException {
        int n;
        Table table;
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)validationContext.getUpdatedObject();
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
        OracleTablePartitions.ObjectType objectType = oracleTablePartitions.getObjectType();
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        if (partitionType != OracleTablePartitions.PartitionType.HASH && partitionType != OracleTablePartitions.PartitionType.REFERENCE && partitionType != OracleTablePartitions.PartitionType.CONSISTENT_HASH && objectType == OracleTablePartitions.ObjectType.PARTITION && tablePartitionArray.length < 1) {
            throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.format((String)"TABLE_PARTITION_ERROR_INVALID_PARTITION_COUNT", (Object[])new Object[]{partitionType}));
        }
        if (partitionType == OracleTablePartitions.PartitionType.LIST && (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE || objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) && tablePartitionArray.length < 1) {
            throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_LIST_SUBPARTITION_ERROR_MISSING_SUBPARTITIONS"));
        }
        ValidationLevel validationLevel = validationContext.getLevel();
        if (validationLevel == ValidationLevel.FULL && partitionType == OracleTablePartitions.PartitionType.REFERENCE && oracleTablePartitions.getPartitions().length > 0 && (table = ReferencePartitionHelper.getReferencedTable(oracleTablePartitions)) != null && (n = ReferencePartitionHelper.getReferencedTablePartitionsCount(table)) != oracleTablePartitions.getPartitions().length) {
            throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.get((String)"TABLE_PARTITION_ERROR_REF_PARTS_NOT_MATCH"));
        }
        if (validationLevel == ValidationLevel.FULL) {
            table = new HashMap();
            for (TablePartition tablePartition : tablePartitionArray) {
                if (tablePartition.getPartitionType() == partitionType) {
                    this.validateOwnedObjects(ValidationLevel.FULL, new DBObject[]{tablePartition});
                    OracleTablePartitions oracleTablePartitions2 = tablePartition.getPartitionLevelSubpartitions();
                    if (oracleTablePartitions2 == null || oracleTablePartitions2.getPartitions() == null) continue;
                    for (TablePartition tablePartition2 : oracleTablePartitions2.getPartitions()) {
                        String string = tablePartition2.getName();
                        if (table.get(string) != null) {
                            throw new NameInUseException((DBObject)tablePartition2, (DBObject)table.get(string));
                        }
                        table.put(string, tablePartition2);
                    }
                    continue;
                }
                throw new ValidationException((DBObject)oracleTablePartitions, APIBundle.format((String)"TABLE_PARTITION_ERROR_INVALID_PARTITION_TYPES", (Object[])new Object[]{partitionType}));
            }
        } else {
            this.validateOwnedObjects(validationLevel, (DBObject[])tablePartitionArray);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"subpartitionModel"})
    public void validateSubpartitionModel(ValidationContext<OracleTablePartitions> validationContext) throws ValidationException {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)validationContext.getOriginalObject();
        OracleTablePartitions oracleTablePartitions2 = (OracleTablePartitions)validationContext.getUpdatedObject();
        OracleTablePartitions oracleTablePartitions3 = oracleTablePartitions2.getSubpartitionModel();
        if (oracleTablePartitions3 != null) {
            OracleTablePartitions.PartitionType partitionType = oracleTablePartitions3.getPartitionType();
            Collection collection = this.getProvider().getPropertyManager().getAllowedPropertyValues((DBObject)(oracleTablePartitions == null ? null : oracleTablePartitions.getSubpartitionModel()), (DBObject)oracleTablePartitions3, "partitionType");
            if (collection == null || !collection.contains(partitionType)) {
                throw new ValidationException((DBObject)oracleTablePartitions2, APIBundle.format((String)"TABLE_PARTITION_ERROR_INVALID_SUBPARTITIONS", (Object[])new Object[]{oracleTablePartitions2.getPartitionType()}));
            }
            this.validateOwnedObjects(validationContext.getLevel(), new DBObject[]{oracleTablePartitions3});
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitionType"})
    public void validatePartitionType(OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions2.getPartitionType();
        if (partitionType == null) {
            throw new ValidationException((DBObject)oracleTablePartitions2, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_PARTITION_TYPE"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"objectType"})
    public void validateObjectType(OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2) throws ValidationException {
        OracleTablePartitions.ObjectType objectType = oracleTablePartitions2.getObjectType();
        if (objectType == null) {
            throw new ValidationException((DBObject)oracleTablePartitions2, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_OBJECT_TYPE"));
        }
    }

    private boolean isInvalidColumn(DBObjectID dBObjectID) throws ValidationException {
        try {
            Column column = (Column)dBObjectID.resolveID();
            if (column != null) {
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
                if (dataType instanceof Type) {
                    return true;
                }
                if (dataType != null) {
                    String string = dataType.getName();
                    return "LONG".equalsIgnoreCase(string) || "LONG RAW".equalsIgnoreCase(string) || "ROWID".equalsIgnoreCase(string) || "UROWID".equalsIgnoreCase(string) || "BLOB".equalsIgnoreCase(string) || "CLOB".equalsIgnoreCase(string) || "NCLOB".equalsIgnoreCase(string) || "BFILE".equalsIgnoreCase(string);
                }
            }
        }
        catch (DBException dBException) {
            this.logException(dBException, Level.FINE);
        }
        return false;
    }

    public Set<String> getCascadeProperties() {
        Set set = super.getCascadeProperties();
        set.add("partitions");
        set.add("hashQuantity");
        set.add("subpartitionModel");
        return set;
    }
}

