/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.TextFieldInputHandler;
import oracle.ewt.lwAWT.lwText.NumberTextField;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.EventQueueUtils;

public class NumberInputHandler
extends TextFieldInputHandler {
    boolean _dirty;
    private NumberTextField _numberTextField;
    private boolean _textInitedOnKeyTyped;

    public final NumberTextField getNumberTextField() {
        return (NumberTextField)this.getEditControl(null, -1, -1);
    }

    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._numberTextField == null) {
            this._numberTextField = this.createNumberTextField();
            TxtFldHandlers txtFldHandlers = new TxtFldHandlers();
            this._numberTextField.addFocusListener(txtFldHandlers);
            this._numberTextField.addTextListener(txtFldHandlers);
            this._numberTextField.setBorderPainter(new FixedBorderPainter(0, 2, 0, 0));
        }
        return this._numberTextField;
    }

    public boolean isDirty(Grid grid, int n, int n2) {
        return this._dirty;
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(n, n2);
        NumberTextField numberTextField = this.getNumberTextField();
        if (keyEvent.getKeyChar() == '\b') {
            numberTextField.setText("");
            this._dirty = true;
            this._textInitedOnKeyTyped = true;
        } else {
            char c = keyEvent.getKeyChar();
            if (c >= '0' && c <= '9') {
                numberTextField.setText(String.valueOf(c));
                numberTextField.select(1, 1);
                this._dirty = true;
                this._textInitedOnKeyTyped = true;
            }
        }
        keyEvent.consume();
    }

    public void startEdit(Grid grid, int n, int n2, Object object) {
        if (object != null && !(object instanceof Number)) {
            throw new IllegalArgumentException("data " + object + " must be a number");
        }
        if (!this._textInitedOnKeyTyped) {
            NumberTextField numberTextField = this.getNumberTextField();
            numberTextField.setNumber((Number)object);
            if (object != null) {
                numberTextField.setDataType(object.getClass());
                numberTextField.selectAll();
            }
            this._dirty = false;
        }
    }

    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        NumberTextField numberTextField = this.getNumberTextField();
        return numberTextField.getNumber();
    }

    public static CellInputHandler getCellInputHandler() {
        return new NumberInputHandler();
    }

    protected NumberTextField createNumberTextField() {
        return new NumberTextField();
    }

    private class TxtFldHandlers
    extends FocusAdapter
    implements TextListener,
    Runnable {
        private TxtFldHandlers() {
        }

        public void textValueChanged(TextEvent textEvent) {
            NumberInputHandler.this._dirty = true;
        }

        public void focusGained(FocusEvent focusEvent) {
            EventQueueUtils.invokeLater(this);
        }

        public void run() {
            if (NumberInputHandler.this._textInitedOnKeyTyped) {
                NumberInputHandler.this._numberTextField.select(1, 1);
            }
            NumberInputHandler.this._textInitedOnKeyTyped = false;
        }
    }
}

