/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.laf.basic.BasicComponentUI;
import oracle.ewt.laf.generic.GenericButtonPainter;
import oracle.ewt.laf.generic.GenericFocusPainter;
import oracle.ewt.layout.EqualLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ShuttleUI;
import oracle.ewt.shuttle.Shuttle;

public class GenericShuttleUI
extends BasicComponentUI
implements ShuttleUI {
    private static Painter[] _sPainters;
    private static final String[] _sImages;

    public GenericShuttleUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public Painter getButtonPainter(LWComponent lWComponent, int n) {
        if (_sPainters == null) {
            _sPainters = new Painter[12];
        }
        if (_sPainters[n] != null) {
            return _sPainters[n];
        }
        ImageStrip imageStrip = new ImageStrip(this.createButtonImage(lWComponent, n), 1);
        GenericShuttleUI._sPainters[n] = n >= 8 ? this._createReorderPainter(new ImageSetPainter(imageStrip)) : this._createPainter(new ImageSetPainter(imageStrip));
        return _sPainters[n];
    }

    public Image createButtonImage(LWComponent lWComponent, int n) {
        return this.getUIDefaults(lWComponent).getImage(_sImages[n]);
    }

    public int getComponentGap(LWComponent lWComponent) {
        return 5;
    }

    public LayoutManager getHorizontalButtonLayout(LWComponent lWComponent) {
        return new ButtonLayout(this.getComponentGap(lWComponent), (Shuttle)lWComponent, true);
    }

    public LayoutManager getVerticalButtonLayout(LWComponent lWComponent) {
        return new ButtonLayout(this.getComponentGap(lWComponent), (Shuttle)lWComponent, false);
    }

    private Painter _createPainter(Painter painter) {
        return new AlignmentPainter(new FixedBorderPainter(painter, 0, 2, 0, 2));
    }

    private Painter _createReorderPainter(Painter painter) {
        return new GenericButtonPainter(new GenericFocusPainter(this._createPainter(painter), true));
    }

    static {
        _sImages = new String[]{"Shuttle.rightArrow", "Shuttle.rightAllArrow", "Shuttle.leftArrow", "Shuttle.leftAllArrow", "Shuttle.downArrow", "Shuttle.downAllArrow", "Shuttle.upArrow", "Shuttle.upAllArrow", "Shuttle.reorderUpRight", "Shuttle.reorderDownRight", "Shuttle.reorderUpLeft", "Shuttle.reorderDownLeft"};
    }

    private class ButtonLayout
    extends EqualLayout {
        private Shuttle _shuttle;
        private boolean _horizontal;

        ButtonLayout(int n, Shuttle shuttle, boolean bl) {
            super(n);
            this._shuttle = shuttle;
            this._horizontal = bl;
        }

        protected Dimension getInsetLayoutSize(Container container, boolean bl) {
            if (this._horizontal) {
                return this._getHorizontalLayoutSize(container, bl);
            }
            return this._getVerticalLayoutSize(container, bl);
        }

        public void layoutContainer(Container container) {
            if (this._horizontal) {
                this._layoutHorizontal(container);
            } else {
                this._layoutVertical(container);
            }
        }

        private Dimension _getHorizontalLayoutSize(Container container, boolean bl) {
            int n = ButtonLayout.getNumberVisibleChildren(container);
            Dimension dimension = this.getCellSize(container, bl);
            dimension.height -= 2;
            int n2 = dimension.height * n;
            int n3 = n - 1;
            if (this._shuttle.isMoveAllAllowed()) {
                n3 -= 2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 0) {
                n2 += this.getInteriorGap() * n3;
            }
            return new Dimension(dimension.width, n2 += 2);
        }

        private Dimension _getVerticalLayoutSize(Container container, boolean bl) {
            int n = ButtonLayout.getNumberVisibleChildren(container);
            Dimension dimension = this.getCellSize(container, bl);
            dimension.width -= 2;
            int n2 = dimension.width * n;
            int n3 = n - 1;
            if (this._shuttle.isMoveAllAllowed()) {
                n3 -= 2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 0) {
                n2 += this.getInteriorGap() * n3;
            }
            return new Dimension(n2 += 2, dimension.height);
        }

        private void _layoutHorizontal(Container container) {
            int n;
            int n2 = ButtonLayout.getNumberVisibleChildren(container);
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            int n5 = ButtonLayout.getNumberVisibleChildren(container);
            Dimension dimension2 = this.getCellSize(container, true);
            int n6 = dimension2.height;
            int n7 = n5 - 1;
            if (this._shuttle.isMoveAllAllowed()) {
                n7 -= 2;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            Dimension dimension3 = this.getCellSize(container, true);
            if (n6 > dimension3.height) {
                n6 = dimension3.height;
            }
            if ((n = n3 - insets.left - insets.right) > dimension3.width) {
                n = dimension3.width;
            }
            int n8 = insets.top;
            int n9 = (n6 - 2) * n5;
            if (n5 > 1) {
                n9 += this.getInteriorGap() * n7;
            }
            int n10 = this.getPerpendicularAlignment();
            Enumeration enumeration = this.getComponentEnumeration(container);
            int n11 = 0;
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                if (component.isVisible()) {
                    int n12 = insets.left;
                    if (n10 != 0) {
                        n12 = n10 == 2 ? n3 - insets.right - n : (n12 += n3 - insets.left - insets.right - n >> 1);
                    }
                    component.setBounds(n12, n8, n, n6);
                    n8 += n6 - 2;
                    if (!this._shuttle.isMoveAllAllowed() || n11 != 0 && n11 != n2 - 2) {
                        n8 += this.getInteriorGap();
                    }
                }
                ++n11;
            }
        }

        private void _layoutVertical(Container container) {
            int n;
            int n2 = ButtonLayout.getNumberVisibleChildren(container);
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            int n5 = ButtonLayout.getNumberVisibleChildren(container);
            Dimension dimension2 = this.getCellSize(container, true);
            int n6 = dimension2.width;
            int n7 = n5 - 1;
            if (this._shuttle.isMoveAllAllowed()) {
                n7 -= 2;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            Dimension dimension3 = this.getCellSize(container, true);
            if (n6 > dimension3.width) {
                n6 = dimension3.width;
            }
            if ((n = n4 - insets.top - insets.bottom) > dimension3.height) {
                n = dimension3.height;
            }
            int n8 = insets.left;
            int n9 = (n6 - 2) * n5;
            if (n5 > 1) {
                n9 += this.getInteriorGap() * n7;
            }
            int n10 = this.getPerpendicularAlignment();
            Enumeration enumeration = this.getComponentEnumeration(container);
            int n11 = 0;
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                if (component.isVisible()) {
                    int n12 = insets.top;
                    if (n10 != 0) {
                        n12 = n10 == 2 ? n4 - insets.bottom - n : (n12 += n4 - insets.top - insets.bottom - n >> 1);
                    }
                    component.setBounds(n8, n12, n6, n);
                    n8 += n6 - 2;
                    if (!this._shuttle.isMoveAllAllowed() || n11 != 0 && n11 != n2 - 2) {
                        n8 += this.getInteriorGap();
                    }
                }
                ++n11;
            }
        }
    }
}

