/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.util.Locale;
import java.util.Vector;
import oracle.ewt.lwAWT.lwText.displayFilter.DisplayStringFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.Range;
import oracle.ewt.util.BIDIText;

class BIDIFilter
implements DisplayStringFilter {
    private BIDIText _bt;
    private int _baseDirection;
    private Locale _locale;
    private String _displayText;
    private String _logicalText;

    public BIDIFilter(int n, Locale locale) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid reading order value");
        }
        this._baseDirection = n;
        this._locale = locale;
        this._displayText = null;
    }

    public int displayIndexToValueIndex(String string, int n) {
        if (string == null) {
            return 0;
        }
        this.convertString(string);
        int[] nArray = this._bt.getVisualOrder();
        if (nArray.length == 0) {
            return 0;
        }
        if (n > nArray.length - 1) {
            if (2 == this._bt.getBaseDirection()) {
                return this._bt.getRightmostIndex();
            }
            return this._bt.getLogicalLength();
        }
        if (n < 0) {
            if (2 == this._bt.getBaseDirection()) {
                return this._bt.getLogicalLength();
            }
            return this._bt.getLeftmostIndex();
        }
        return nArray[n];
    }

    public int valueIndexToDisplayIndex(String string, int n) {
        boolean bl = false;
        if (string == null) {
            return 0;
        }
        this.convertString(string);
        int[] nArray = this._bt.getLogicalOrder();
        if (nArray.length == 0) {
            return 0;
        }
        if (n > this._bt.getLogicalLength() - 1) {
            n = this._bt.getLogicalLength() - 1;
            bl = true;
        } else if (n < 0) {
            n = 0;
        }
        int n2 = nArray[n];
        char c = string.charAt(n);
        int[] nArray2 = this._bt.getLogicalDirections();
        if (2 == nArray2[n] && !Character.isDigit(c)) {
            if (!bl) {
                ++n2;
            }
        } else if (bl) {
            ++n2;
        }
        return n2;
    }

    public Range[] getDisplaySelectionRanges(String string, int n, int n2) {
        int n3;
        this.convertString(string);
        if (n <= 0 && n2 >= string.length()) {
            return new Range[]{new Range(0, this._displayText.length())};
        }
        Vector<Range> vector = new Vector<Range>(10);
        if (n2 > string.length() - 1) {
            n2 = string.length();
        }
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        if (n < 0) {
            n = 0;
        }
        int[] nArray = this._bt.getLogicalOrder();
        int n5 = n;
        for (int i = n; i <= n2; ++i) {
            int n6;
            int n7;
            while (i <= n2 && i < string.length()) {
                n7 = n3 = nArray[i];
                if (i - 1 >= n5) {
                    n7 = nArray[i - 1];
                }
                if (Math.abs(n3 - n7) > 1) break;
                ++i;
            }
            n6 = (n7 = nArray[n5]) > (n6 = nArray[(n3 = i > n2 ? n2 : i) - 1]) ? --n6 : ++n6;
            if (n7 > n6) {
                int n8 = n7;
                n7 = n6;
                n6 = n8;
                ++n7;
                ++n6;
            }
            n5 = n3;
            vector.addElement(new Range(n7, n6));
        }
        Range[] rangeArray = new Range[vector.size()];
        for (n3 = vector.size() - 1; n3 >= 0; --n3) {
            rangeArray[n3] = (Range)vector.elementAt(n3);
        }
        return rangeArray;
    }

    public synchronized String convertString(String string) {
        if (string == null) {
            return null;
        }
        if (this._logicalText == null || !string.equals(this._logicalText)) {
            this._logicalText = string;
            this._bt = new BIDIText(string, this._baseDirection, this._locale);
            this._displayText = this._bt.getVisualText();
        }
        return this._displayText;
    }

    public void setReadingDirection(int n) {
        if (n == this._baseDirection) {
            return;
        }
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this._baseDirection = n;
        this._logicalText = null;
    }

    public int getReadingDirection() {
        return this._baseDirection;
    }

    int __getFirstR2LChar() {
        String string = this._displayText;
        int n = this._bt.getLogicalLength();
        int[] nArray = this._bt.getLogicalOrder();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            char c = string.charAt(n2);
            if (!BIDIText.isRightToLeft(c)) continue;
            return i;
        }
        return -1;
    }
}

