/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.table;

import oracle.ewt.event.Cancelable;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderEvent;
import oracle.ewt.header.HeaderFocusListener;
import oracle.ewt.header.HeaderMoveListener;
import oracle.ewt.header.HeaderResizeListener;
import oracle.ewt.header.HeaderScrollListener;
import oracle.ewt.header.HeaderSelectListener;
import oracle.ewt.table.SpreadTable;

final class TableHeaderAdapter
implements HeaderSelectListener,
HeaderMoveListener,
HeaderResizeListener,
HeaderScrollListener,
HeaderFocusListener {
    private int _oldIndex;
    private SpreadTable _table;
    private Header _header;

    public TableHeaderAdapter(SpreadTable spreadTable, Header header) {
        this._table = spreadTable;
        this._header = header;
    }

    public void itemSelecting(HeaderEvent headerEvent) {
        boolean bl = this._header.isHorizontal() ? this._table.fireCancelableColumnEvent(2009, headerEvent.getHeaderItem()) : this._table.fireCancelableRowEvent(2005, headerEvent.getHeaderItem());
        if (bl) {
            ((Cancelable)((Object)headerEvent)).cancel();
        }
    }

    public void itemSelected(HeaderEvent headerEvent) {
        Grid grid = this._table.getGrid();
        GridSelection gridSelection = grid.getGridSelection();
        int n = headerEvent.getHeaderItem();
        grid.freezeRepaints();
        grid.commitCellEdit();
        if (this._header.isHorizontal()) {
            gridSelection.setColumnSelected(n, true);
            this._table.fireColumnEvent(2010, n);
        } else {
            gridSelection.setRowSelected(n, true);
            this._table.fireRowEvent(2006, n);
        }
        grid.unfreezeRepaints();
    }

    public void itemDeselecting(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        boolean bl = this._header.isHorizontal() ? this._table.fireCancelableColumnEvent(2011, n) : this._table.fireCancelableRowEvent(2007, n);
        if (bl) {
            ((Cancelable)((Object)headerEvent)).cancel();
        }
    }

    public void itemDeselected(HeaderEvent headerEvent) {
        Grid grid = this._table.getGrid();
        GridSelection gridSelection = grid.getGridSelection();
        int n = headerEvent.getHeaderItem();
        grid.freezeRepaints();
        if (this._header.isHorizontal()) {
            gridSelection.setColumnSelected(n, false);
            this._table.fireColumnEvent(2012, n);
        } else {
            gridSelection.setRowSelected(n, false);
            this._table.fireRowEvent(2008, n);
        }
        grid.unfreezeRepaints();
    }

    public void itemMoving(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        boolean bl = this._header.isHorizontal() ? this._table.fireCancelableColumnEvent(2023, n) : this._table.fireCancelableRowEvent(2025, n);
        if (bl) {
            ((Cancelable)((Object)headerEvent)).cancel();
        }
    }

    public void itemMoved(HeaderEvent headerEvent) {
        this._table.getGrid().commitCellEdit();
        int n = headerEvent.getHeaderItem();
        int n2 = this._header.getItemVisibleIndex(n);
        if (this._header.isHorizontal()) {
            this._table.getGrid().setColumnVisibleIndex(n, n2);
            this._table.fireColumnEvent(2024, n);
        } else {
            this._table.getGrid().setRowVisibleIndex(n, n2);
            this._table.fireRowEvent(2026, n);
        }
    }

    public void itemResizing(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        boolean bl = this._header.isHorizontal() ? this._table.fireCancelableColumnEvent(2013, n) : this._table.fireCancelableRowEvent(2015, n);
        if (bl) {
            ((Cancelable)((Object)headerEvent)).cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemResized(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        int n2 = this._header.getItemSize(n);
        this._table.freezeRepaints();
        try {
            if (this._header.isHorizontal()) {
                this._table.getGrid().setColumnWidth(n, n2 -= this._table.getVerticalSeparatorSize());
                this._table.fireColumnEvent(2014, n);
            } else {
                this._table.getGrid().setRowHeight(n, n2 -= this._table.getHorizontalSeparatorSize());
                this._table.fireRowEvent(2016, n);
            }
        }
        finally {
            this._table.unfreezeRepaints();
        }
    }

    public void itemScrolling(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        boolean bl = this._header.isHorizontal() ? this._table.fireCancelableColumnEvent(2019, n) : this._table.fireCancelableRowEvent(2021, n);
        if (bl) {
            ((Cancelable)((Object)headerEvent)).cancel();
        }
    }

    public void itemScrolled(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        Grid grid = this._table.getGrid();
        if (this._header.isHorizontal()) {
            grid.setFirstColumnOnScreen(n);
            int n2 = this._table.getScrollByColumn() ? n : grid.getColumnPosition(n);
            this._table.updateHScrollBarValue(n2);
            this._table.fireColumnEvent(2020, n);
        } else {
            grid.setFirstRowOnScreen(n);
            if (this._table.getScrollByRow()) {
                int n3 = n;
            } else {
                int n4 = grid.getRowPosition(n);
            }
            this._table.updateVScrollBarValue(n);
            this._table.fireRowEvent(2022, n);
        }
    }

    public void focusItemChanging(HeaderEvent headerEvent) {
    }

    public void focusItemChanged(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        Cell cell = this._table.getGrid().getFocusCell();
        if (n != -1 && cell != null) {
            if (this._header.isHorizontal()) {
                this._table.getGrid().requestFocus(n, cell.row, null);
            } else {
                this._table.getGrid().requestFocus(cell.column, n, null);
            }
        }
    }
}

