/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import ilog.views.util.java2d.IlvPolygon2D;
import ilog.views.util.java2d.IlvTranslatedShape;
import ilog.views.util.java2d.internal.IlvMath;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class IlvShapeUtil {
    public static Rectangle2D getTightBounds2D(Shape shape) {
        if (shape instanceof Line2D || shape instanceof Rectangle2D || shape instanceof Polygon || shape instanceof IlvPolygon2D || shape instanceof RoundRectangle2D || shape instanceof Ellipse2D || shape instanceof Arc2D || shape instanceof Area) {
            return shape.getBounds2D();
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[6];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d7 = dArray[0];
                    d8 = dArray[1];
                    if (d > d7) {
                        d = d7;
                    }
                    if (d2 < d7) {
                        d2 = d7;
                    }
                    if (d3 > d8) {
                        d3 = d8;
                    }
                    if (d4 < d8) {
                        d4 = d8;
                    }
                    d5 = d7;
                    d6 = d8;
                    break;
                }
                case 1: {
                    double d9 = dArray[0];
                    double d10 = dArray[1];
                    if (d > d9) {
                        d = d9;
                    }
                    if (d2 < d9) {
                        d2 = d9;
                    }
                    if (d3 > d10) {
                        d3 = d10;
                    }
                    if (d4 < d10) {
                        d4 = d10;
                    }
                    d7 = d9;
                    d8 = d10;
                    break;
                }
                case 2: {
                    double d11;
                    double d12;
                    double d9 = dArray[0];
                    double d10 = dArray[1];
                    double d13 = dArray[2];
                    double d14 = dArray[3];
                    if (d > d13) {
                        d = d13;
                    }
                    if (d2 < d13) {
                        d2 = d13;
                    }
                    double d15 = d7 - 2.0 * d9 + d13;
                    double d16 = -d7 + d9;
                    if (d15 != 0.0 && (d12 = -d16 / d15) > 0.0 && d12 < 1.0) {
                        d11 = (1.0 - d12) * (1.0 - d12) * d7 + 2.0 * d12 * (1.0 - d12) * d9 + d12 * d12 * d13;
                        if (d > d11) {
                            d = d11;
                        }
                        if (d2 < d11) {
                            d2 = d11;
                        }
                    }
                    if (d3 > d14) {
                        d3 = d14;
                    }
                    if (d4 < d14) {
                        d4 = d14;
                    }
                    d15 = d8 - 2.0 * d10 + d14;
                    d16 = -d8 + d10;
                    if (d15 != 0.0 && (d12 = -d16 / d15) > 0.0 && d12 < 1.0) {
                        d11 = (1.0 - d12) * (1.0 - d12) * d8 + 2.0 * d12 * (1.0 - d12) * d10 + d12 * d12 * d14;
                        if (d3 > d11) {
                            d3 = d11;
                        }
                        if (d4 < d11) {
                            d4 = d11;
                        }
                    }
                    d7 = d13;
                    d8 = d14;
                    break;
                }
                case 3: {
                    double d17;
                    double d18;
                    double d19;
                    double d20;
                    double d9 = dArray[0];
                    double d10 = dArray[1];
                    double d13 = dArray[2];
                    double d14 = dArray[3];
                    double d15 = dArray[4];
                    double d16 = dArray[5];
                    if (d > d15) {
                        d = d15;
                    }
                    if (d2 < d15) {
                        d2 = d15;
                    }
                    double d12 = -d7 + 3.0 * d9 - 3.0 * d13 + d15;
                    double d11 = 2.0 * d7 - 4.0 * d9 + 2.0 * d13;
                    double d21 = -d7 + d9;
                    if (d12 != 0.0) {
                        d20 = d11 * d11 - 4.0 * d12 * d21;
                        if (d20 >= 0.0) {
                            d19 = Math.sqrt(d20);
                            d18 = (d19 - d11) / (2.0 * d12);
                            if (d18 > 0.0 && d18 < 1.0) {
                                d17 = (1.0 - d18) * (1.0 - d18) * (1.0 - d18) * d7 + 3.0 * d18 * (1.0 - d18) * (1.0 - d18) * d9 + 3.0 * d18 * d18 * (1.0 - d18) * d13 + d18 * d18 * d18 * d15;
                                if (d > d17) {
                                    d = d17;
                                }
                                if (d2 < d17) {
                                    d2 = d17;
                                }
                            }
                            if ((d18 = (-d19 - d11) / (2.0 * d12)) > 0.0 && d18 < 1.0) {
                                d17 = (1.0 - d18) * (1.0 - d18) * (1.0 - d18) * d7 + 3.0 * d18 * (1.0 - d18) * (1.0 - d18) * d9 + 3.0 * d18 * d18 * (1.0 - d18) * d13 + d18 * d18 * d18 * d15;
                                if (d > d17) {
                                    d = d17;
                                }
                                if (d2 < d17) {
                                    d2 = d17;
                                }
                            }
                        }
                    } else if (d11 != 0.0 && (d20 = -d21 / d11) > 0.0 && d20 < 1.0) {
                        d19 = (1.0 - d20) * (1.0 - d20) * (1.0 - d20) * d7 + 3.0 * d20 * (1.0 - d20) * (1.0 - d20) * d9 + 3.0 * d20 * d20 * (1.0 - d20) * d13 + d20 * d20 * d20 * d15;
                        if (d > d19) {
                            d = d19;
                        }
                        if (d2 < d19) {
                            d2 = d19;
                        }
                    }
                    if (d3 > d16) {
                        d3 = d16;
                    }
                    if (d4 < d16) {
                        d4 = d16;
                    }
                    d12 = -d8 + 3.0 * d10 - 3.0 * d14 + d16;
                    d11 = 2.0 * d8 - 4.0 * d10 + 2.0 * d14;
                    d21 = -d8 + d10;
                    if (d12 != 0.0) {
                        d20 = d11 * d11 - 4.0 * d12 * d21;
                        if (d20 >= 0.0) {
                            d19 = Math.sqrt(d20);
                            d18 = (d19 - d11) / (2.0 * d12);
                            if (d18 > 0.0 && d18 < 1.0) {
                                d17 = (1.0 - d18) * (1.0 - d18) * (1.0 - d18) * d8 + 3.0 * d18 * (1.0 - d18) * (1.0 - d18) * d10 + 3.0 * d18 * d18 * (1.0 - d18) * d14 + d18 * d18 * d18 * d16;
                                if (d3 > d17) {
                                    d3 = d17;
                                }
                                if (d4 < d17) {
                                    d4 = d17;
                                }
                            }
                            if ((d18 = (-d19 - d11) / (2.0 * d12)) > 0.0 && d18 < 1.0) {
                                d17 = (1.0 - d18) * (1.0 - d18) * (1.0 - d18) * d8 + 3.0 * d18 * (1.0 - d18) * (1.0 - d18) * d10 + 3.0 * d18 * d18 * (1.0 - d18) * d14 + d18 * d18 * d18 * d16;
                                if (d3 > d17) {
                                    d3 = d17;
                                }
                                if (d4 < d17) {
                                    d4 = d17;
                                }
                            }
                        }
                    } else if (d11 != 0.0 && (d20 = -d21 / d11) > 0.0 && d20 < 1.0) {
                        d19 = (1.0 - d20) * (1.0 - d20) * (1.0 - d20) * d8 + 3.0 * d20 * (1.0 - d20) * (1.0 - d20) * d10 + 3.0 * d20 * d20 * (1.0 - d20) * d14 + d20 * d20 * d20 * d16;
                        if (d3 > d19) {
                            d3 = d19;
                        }
                        if (d4 < d19) {
                            d4 = d19;
                        }
                    }
                    d7 = d15;
                    d8 = d16;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new Error("Invalid seg type: " + n);
                }
            }
            pathIterator.next();
        }
        if (Double.isInfinite(d) || Double.isInfinite(d2) || Double.isInfinite(d3) || Double.isInfinite(d4)) {
            return new Rectangle2D.Double();
        }
        return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
    }

    public static double distanceTo(Line2D line2D, double d, double d2, Point2D point2D) {
        double d3;
        double d4 = line2D.getX1();
        double d5 = line2D.getY1();
        double d6 = line2D.getX2();
        double d7 = (d6 - d4) * (d6 - d4) + ((d3 = line2D.getY2()) - d5) * (d3 - d5);
        if (d7 == 0.0) {
            if (point2D != null) {
                point2D.setLocation(d4, d5);
            }
            return Math.sqrt((d - d4) * (d - d4) + (d2 - d5) * (d2 - d5));
        }
        double d8 = (d - d4) * (d6 - d4) + (d2 - d5) * (d3 - d5);
        double d9 = (d - d4) * (d3 - d5) - (d2 - d5) * (d6 - d4);
        if (d8 < 0.0) {
            if (point2D != null) {
                point2D.setLocation(d4, d5);
            }
            d8 = -d8;
        } else if (d8 > d7) {
            if (point2D != null) {
                point2D.setLocation(d6, d3);
            }
            d8 -= d7;
        } else {
            if (point2D != null) {
                point2D.setLocation(d4 + d8 / d7 * (d6 - d4), d5 + d8 / d7 * (d3 - d5));
            }
            d8 = 0.0;
        }
        return Math.sqrt((d8 * d8 + d9 * d9) / d7);
    }

    public static double distanceTo(Rectangle2D rectangle2D, double d, double d2, Point2D point2D) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = rectangle2D.getMinX();
        double d8 = rectangle2D.getMaxX();
        double d9 = rectangle2D.getMinY();
        double d10 = rectangle2D.getMaxY();
        if (d >= d7) {
            if (d <= d8) {
                d6 = d;
                d5 = 0.0;
            } else {
                d6 = d8;
                d5 = d - d8;
            }
        } else {
            d6 = d7;
            d5 = d7 - d;
        }
        if (d2 >= d9) {
            if (d2 <= d10) {
                d4 = d2;
                d3 = 0.0;
            } else {
                d4 = d10;
                d3 = d2 - d10;
            }
        } else {
            d4 = d9;
            d3 = d9 - d2;
        }
        if (point2D != null) {
            point2D.setLocation(d6, d4);
        }
        if (d5 == 0.0) {
            return d3;
        }
        if (d3 == 0.0) {
            return d5;
        }
        return Math.sqrt(d5 * d5 + d3 * d3);
    }

    public static double distanceTo(Shape shape, double d, double d2, Point2D point2D) {
        return IlvShapeUtil.a(shape, true, d, d2, point2D);
    }

    public static double distanceToBorder(Shape shape, double d, double d2, Point2D point2D) {
        return IlvShapeUtil.a(shape, false, d, d2, point2D);
    }

    private static double a(Shape shape, boolean bl, double d, double d2, Point2D point2D) {
        if (shape instanceof Line2D) {
            return IlvShapeUtil.distanceTo((Line2D)shape, d, d2, point2D);
        }
        if (bl) {
            if (shape instanceof Rectangle2D) {
                return IlvShapeUtil.distanceTo((Rectangle2D)shape, d, d2, point2D);
            }
            if (shape.contains(d, d2)) {
                if (point2D != null) {
                    point2D.setLocation(d, d2);
                }
                return 0.0;
            }
        }
        double d3 = Double.POSITIVE_INFINITY;
        if (point2D != null) {
            point2D.setLocation(Double.NaN, Double.NaN);
        }
        double[] dArray = new double[6];
        Point2D.Double double_ = point2D != null ? new Point2D.Double() : null;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d6 = dArray[0];
                    d7 = dArray[1];
                    double d8 = Math.sqrt((d - d6) * (d - d6) + (d2 - d7) * (d2 - d7));
                    if (d8 < d3) {
                        d3 = d8;
                        if (point2D != null) {
                            point2D.setLocation(d6, d7);
                        }
                    }
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 1: {
                    double d8 = dArray[0];
                    double d9 = dArray[1];
                    double d10 = IlvShapeUtil.distanceTo(new Line2D.Double(d6, d7, d8, d9), d, d2, (Point2D)double_);
                    if (d10 < d3) {
                        d3 = d10;
                        if (point2D != null) {
                            point2D.setLocation(double_.x, double_.y);
                        }
                    }
                    d6 = d8;
                    d7 = d9;
                    break;
                }
                case 2: {
                    double d11;
                    double d12;
                    double d13;
                    double d14;
                    double d8 = dArray[0];
                    double d9 = dArray[1];
                    double d10 = dArray[2];
                    double d15 = dArray[3];
                    double d16 = d6 - 2.0 * d8 + d10;
                    double d17 = 2.0 * (d8 - d6);
                    double d18 = d6 - d;
                    double d19 = d7 - 2.0 * d9 + d15;
                    double d20 = 2.0 * (d9 - d7);
                    double d21 = d7 - d2;
                    double d22 = 2.0 * (d16 * d16 + d19 * d19);
                    double d23 = 3.0 * (d16 * d17 + d19 * d20);
                    double d24 = d17 * d17 + 2.0 * d16 * d18 + d20 * d20 + 2.0 * d19 * d21;
                    double d25 = d17 * d18 + d20 * d21;
                    int n2 = IlvMath.calcPolynomialSolution(3, new double[]{d25, d24, d23, d22}, 0.0, 1.0, dArray);
                    for (int i = 0; i < n2; ++i) {
                        d14 = dArray[i];
                        d13 = (d16 * d14 + d17) * d14 + d18;
                        d12 = (d19 * d14 + d20) * d14 + d21;
                        d11 = Math.sqrt(d13 * d13 + d12 * d12);
                        if (!(d11 < d3)) continue;
                        d3 = d11;
                        if (point2D == null) continue;
                        point2D.setLocation(d13 + d, d12 + d2);
                    }
                    d16 = Math.sqrt((d - d10) * (d - d10) + (d2 - d15) * (d2 - d15));
                    if (d16 < d3) {
                        d3 = d16;
                        if (point2D != null) {
                            point2D.setLocation(d10, d15);
                        }
                    }
                    d6 = d10;
                    d7 = d15;
                    break;
                }
                case 3: {
                    double d8 = dArray[0];
                    double d9 = dArray[1];
                    double d10 = dArray[2];
                    double d15 = dArray[3];
                    double d16 = dArray[4];
                    double d17 = dArray[5];
                    double d18 = 3.0 * (d8 - d10) + d16 - d6;
                    double d19 = 3.0 * (d6 - 2.0 * d8 + d10);
                    double d20 = 3.0 * (d8 - d6);
                    double d21 = d6 - d;
                    double d22 = 3.0 * (d9 - d15) + d17 - d7;
                    double d23 = 3.0 * (d7 - 2.0 * d9 + d15);
                    double d24 = 3.0 * (d9 - d7);
                    double d25 = d7 - d2;
                    double d26 = 3.0 * (d18 * d18 + d22 * d22);
                    double d14 = 5.0 * (d18 * d19 + d22 * d23);
                    double d13 = 4.0 * d18 * d20 + 2.0 * d19 * d19 + 4.0 * d22 * d24 + 2.0 * d23 * d23;
                    double d12 = 3.0 * (d18 * d21 + d19 * d20 + d22 * d25 + d23 * d24);
                    double d11 = 2.0 * d19 * d21 + d20 * d20 + 2.0 * d23 * d25 + d24 * d24;
                    double d27 = d20 * d21 + d24 * d25;
                    int n3 = IlvMath.calcPolynomialSolution(5, new double[]{d27, d11, d12, d13, d14, d26}, 0.0, 1.0, dArray);
                    for (int i = 0; i < n3; ++i) {
                        double d28 = dArray[i];
                        double d29 = ((d18 * d28 + d19) * d28 + d20) * d28 + d21;
                        double d30 = ((d22 * d28 + d23) * d28 + d24) * d28 + d25;
                        double d31 = Math.sqrt(d29 * d29 + d30 * d30);
                        if (!(d31 < d3)) continue;
                        d3 = d31;
                        if (point2D == null) continue;
                        point2D.setLocation(d29 + d, d30 + d2);
                    }
                    d18 = Math.sqrt((d - d16) * (d - d16) + (d2 - d17) * (d2 - d17));
                    if (d18 < d3) {
                        d3 = d18;
                        if (point2D != null) {
                            point2D.setLocation(d16, d17);
                        }
                    }
                    d6 = d16;
                    d7 = d17;
                    break;
                }
                case 4: {
                    double d8 = IlvShapeUtil.distanceTo(new Line2D.Double(d6, d7, d4, d5), d, d2, (Point2D)double_);
                    if (!(d8 < d3)) break;
                    d3 = d8;
                    if (point2D == null) break;
                    point2D.setLocation(double_.x, double_.y);
                    break;
                }
                default: {
                    throw new Error("Invalid seg type: " + n);
                }
            }
            pathIterator.next();
        }
        return d3;
    }

    public static Shape getTranslatedShape(Shape shape, double d, double d2) {
        Shape shape2;
        if (d == 0.0 && d2 == 0.0) {
            return shape;
        }
        if (shape instanceof IlvTranslatedShape) {
            shape2 = (IlvTranslatedShape)shape;
            shape = ((IlvTranslatedShape)shape2).getOriginalShape();
            if ((d += ((IlvTranslatedShape)shape2).getOffsetX()) == 0.0 && (d2 += ((IlvTranslatedShape)shape2).getOffsetY()) == 0.0) {
                return shape;
            }
        }
        if (shape instanceof Line2D) {
            shape2 = (Line2D)shape;
            return new Line2D.Double(((Line2D)shape2).getX1() + d, ((Line2D)shape2).getY1() + d2, ((Line2D)shape2).getX2() + d, ((Line2D)shape2).getY2() + d2);
        }
        if (shape instanceof Rectangle2D) {
            shape2 = (Rectangle2D)shape;
            return new Rectangle2D.Double(((RectangularShape)shape2).getX() + d, ((RectangularShape)shape2).getY() + d2, ((RectangularShape)shape2).getWidth(), ((RectangularShape)shape2).getHeight());
        }
        if (shape instanceof RoundRectangle2D) {
            shape2 = (RoundRectangle2D)shape;
            return new RoundRectangle2D.Double(((RectangularShape)shape2).getX() + d, ((RectangularShape)shape2).getY() + d2, ((RectangularShape)shape2).getWidth(), ((RectangularShape)shape2).getHeight(), ((RoundRectangle2D)shape2).getArcWidth(), ((RoundRectangle2D)shape2).getArcHeight());
        }
        if (shape instanceof Ellipse2D) {
            shape2 = (Ellipse2D)shape;
            return new Ellipse2D.Double(((RectangularShape)shape2).getX() + d, ((RectangularShape)shape2).getY() + d2, ((RectangularShape)shape2).getWidth(), ((RectangularShape)shape2).getHeight());
        }
        if (shape instanceof Polygon) {
            shape2 = (Polygon)shape;
            int n = ((Polygon)shape2).npoints;
            if ((double)((int)d) == d && (double)((int)d2) == d2) {
                int n2 = (int)d;
                int n3 = (int)d2;
                int[] nArray = new int[n];
                int[] nArray2 = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = ((Polygon)shape2).xpoints[i] + n2;
                    nArray2[i] = ((Polygon)shape2).xpoints[i] + n3;
                }
                return new Polygon(nArray, nArray2, n);
            }
            Point2D[] point2DArray = new Point2D.Double[n];
            for (int i = 0; i < n; ++i) {
                point2DArray[i] = new Point2D.Double((double)((Polygon)shape2).xpoints[i] + d, (double)((Polygon)shape2).ypoints[i] + d2);
            }
            return new IlvPolygon2D.Double(point2DArray);
        }
        if (shape instanceof IlvPolygon2D) {
            shape2 = ((IlvPolygon2D)shape).getPoints();
            int n = ((Shape)shape2).length;
            Point2D[] point2DArray = new Point2D.Double[n];
            for (int i = 0; i < n; ++i) {
                point2DArray[i] = new Point2D.Double(((Point2D)((Object)shape2[i])).getX() + d, ((Point2D)((Object)shape2[i])).getY() + d2);
            }
            return new IlvPolygon2D.Double(point2DArray);
        }
        if (shape instanceof GeneralPath) {
            shape2 = (GeneralPath)shape;
            AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, d, d2);
            return ((Path2D)shape2).createTransformedShape(affineTransform);
        }
        return new IlvTranslatedShape(shape, d, d2);
    }

    private IlvShapeUtil() {
    }
}

