/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.ide.config.IdeSettings;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.UpdateLrb;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.wizard.UpdateWizard;
import oracle.javatools.icons.OracleIcons;

public class UpdatePreferences
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox _autoCheck = new JCheckBox();
    private JButton _checkNow = new JButton();
    private JLabel _errorMessage = new JLabel();
    private transient TraversableContext _tc = null;
    private String _lastErrorType = "none";

    public UpdatePreferences() {
        this.layoutControls();
        this.resControls();
        this.initListeners();
    }

    private void resControls() {
        ResourceUtils.resButton((AbstractButton)this._autoCheck, (String)this._getBundleString("AUTO_CHECK"));
        ResourceUtils.resButton((AbstractButton)this._checkNow, (String)this._getBundleString("CHECK"));
        this._errorMessage.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._errorMessage.setText(this._getBundleString("LAST_CHECK_FAILED"));
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 0, 10, 0);
        this.add(this._checkNow, c);
        ++c.gridy;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 5, 0);
        this.add(this._errorMessage, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(this._autoCheck, c);
    }

    private void initListeners() {
        this._checkNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UpdatePreferences.this.checkForUpdates();
            }
        });
        this._autoCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UpdatePreferences.this.updateErrorControls();
                UpdatePreferences.this.getParent().invalidate();
            }
        });
    }

    private void checkForUpdates() {
        boolean restartRequired = new UpdateWizard(UpdateManager.getInstance()).runWizard((Component)((Object)this), null);
        if (restartRequired) {
            IdeSettings settings = (IdeSettings)this._tc.find("ide-options");
            settings.setAskExit(true);
        }
    }

    public void onEntry(TraversableContext tc) {
        this._tc = tc;
        CheckForUpdatesPreferences prefs = CheckForUpdatesPreferences.getInstance(tc.getPropertyStorage());
        this._autoCheck.setSelected(prefs.getCheckOnStartup());
        this._lastErrorType = prefs.getLastErrorType();
        if ("generic".equals(this._lastErrorType)) {
            this._errorMessage.setText(this._getBundleString("UNABLE_TO_CONNECT"));
        } else if ("proxy".equals(this._lastErrorType)) {
            this._errorMessage.setText(this._getBundleString("PROXY_PROBLEM"));
        }
        this.updateErrorControls();
    }

    private void updateErrorControls() {
        this._errorMessage.setVisible(this._autoCheck.isSelected() && !"none".equals(this._lastErrorType));
    }

    public void onExit(TraversableContext tc) {
        this._tc = null;
        CheckForUpdatesPreferences prefs = CheckForUpdatesPreferences.getInstance(tc.getPropertyStorage());
        prefs.setCheckOnStartup(this._autoCheck.isSelected());
    }

    public void apply(ApplyEvent e) {
        if (!this._autoCheck.isSelected()) {
            UpdateManager.getInstance().getAutomaticCheckForUpdates().updateSkipCheckbox();
            UpdateManager.getInstance().getAutomaticCheckForUpdates().uninstallNotificationIcon();
        }
    }

    public void cancel(ApplyEvent e) {
    }

    private String _getBundleString(String s) {
        return UpdateLrb.getBundle().getString(s);
    }
}

