/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.osgi.Platform;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.HttpPing;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ide.webbrowser.internal.Util;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.CustomTypeDefinition;
import oracle.ideimpl.webupdate.CustomUpdateType;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateCenterMonitor;
import oracle.ideimpl.webupdate.UpdateHandlerHook;
import oracle.ideimpl.webupdate.UpdateHelper;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.ideimpl.webupdate.WebupdateShaping;
import oracle.ideimpl.webupdate.WebupdateShapingHook;
import oracle.ideimpl.webupdate.parser.Problems;
import oracle.ideimpl.webupdate.wizard.UpdateCenterPanel;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.RichHintLabel;
import org.osgi.framework.Bundle;

final class UpdateSourcePage
extends UpdateWizardPage {
    private final RichHintLabel _lbHint = new RichHintLabel();
    private final JRadioButton _rbUpdateCenter = new JRadioButton();
    private final NiceList _lstUpdateCenters = new NiceList();
    private final JButton _btnAddCenter = new JButton();
    private final JButton _btnRemoveCenter = new JButton();
    private final JButton _btnEditCenter = new JButton();
    private final JRadioButton _rbLocalFile = new JRadioButton();
    private final JLabel _lbFileName = new JLabel();
    private final URLTextField _tfLocalFileName = new URLTextField(){

        protected URLChooser createChooser(URL url) {
            URLChooser chooser = super.createChooser(url);
            chooser.setShowJarsAsDirs(false);
            chooser.setSelectionMode(2);
            return chooser;
        }
    };
    private final JButton _btnBrowse = new JButton();
    private final JPanel _panProgress = new JPanel();
    private final JProgressBar _pbUpdates = new JProgressBar();
    private final JLabel _lbProgress = new JLabel();
    private final JLabel _lbError = new JLabel();
    private final HyperlinkButton _hlError = new HyperlinkButton();
    private final GridBagLayout _layout = new GridBagLayout();
    private SimpleListModel _listModel;
    private boolean _checkedMasterList = false;
    private boolean _firstTime = true;
    private boolean _firstTimeForAutoupdate = true;
    private transient CheckMasterListRunnable _masterListChecker;
    private final HyperlinkButton _proxySettings = new HyperlinkButton();
    private ActionListener _errorDetailsListener;
    private transient List<LocalUpdateBundle> _localBundles = new ArrayList<LocalUpdateBundle>();
    private boolean _isSaved = false;
    private long _currentMasterListCheckId = 0L;
    private long _cancelledMasterListCheckId = -1L;
    private PropertyChangeListener _modelListener = null;
    private JCheckBox _automaticCheckForUpdatesCheckbox = new JCheckBox();

    UpdateSourcePage() {
        this.resControls();
        this.layoutControls();
        this.installListeners();
        NiceListRenderer renderer = new NiceListRenderer(){

            public String getTitle(Object center) {
                return ((UpdateCenter)center).getName();
            }

            public String getDescription(Object center) {
                return URLFileSystem.getPlatformPathName((URL)URLFactory.newURL((String)((UpdateCenter)center).getURL()));
            }

            public boolean isItemSelected(Object center) {
                return ((UpdateCenter)center).isEnabled();
            }
        };
        renderer.setGradientColor(IdeUIManager.getActiveTitleGradientLightColor(), IdeUIManager.getActiveTitleGradientDarkColor());
        this._lstUpdateCenters.setCellRenderer((ListCellRenderer)renderer);
        this._lstUpdateCenters.setFireCheckboxActionOnDoubleClick(true);
        this._lstUpdateCenters.setSelectionMode(0);
        this._lstUpdateCenters.setName("UpdateSourcePage.ListUpdateCenters");
        this._tfLocalFileName.setValidateExistingFile(true);
        this.updateControls();
    }

    private void resControls() {
        this._lbHint.setText(UpdateArb.getString(110));
        ResourceUtils.resButton((AbstractButton)this._rbUpdateCenter, (String)UpdateArb.getString(111));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._rbUpdateCenter, (String)"_rbUpdateCenter");
        ResourceUtils.resButton((AbstractButton)this._proxySettings, (String)UpdateArb.getString(118));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._proxySettings, (String)"_proxySettings");
        ResourceUtils.resButton((AbstractButton)this._btnAddCenter, (String)UpdateArb.getString(112));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._btnAddCenter, (String)"_btnAddCenter");
        ResourceUtils.resButton((AbstractButton)this._btnEditCenter, (String)UpdateArb.getString(114));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._btnEditCenter, (String)"_btnEditCenter");
        ResourceUtils.resButton((AbstractButton)this._btnRemoveCenter, (String)UpdateArb.getString(113));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._btnRemoveCenter, (String)"_btnRemoveCenter");
        ResourceUtils.resButton((AbstractButton)this._rbLocalFile, (String)UpdateArb.getString(115));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._rbLocalFile, (String)"_rbLocalFile");
        ResourceUtils.resLabel((JLabel)this._lbFileName, (Component)this._tfLocalFileName, (String)UpdateArb.getString(116));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._tfLocalFileName, (String)"_tfLocalFileName");
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)UpdateArb.getString(117));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._btnBrowse, (String)"_btnBrowse");
        ResourceUtils.resButton((AbstractButton)this._automaticCheckForUpdatesCheckbox, (String)UpdateArb.getString(107));
        ResourceUtils.setComponentName((Object)((Object)this), (Component)this._automaticCheckForUpdatesCheckbox, (String)"_automaticCheckForUpdatesCheckbox");
        this._pbUpdates.setIndeterminate(true);
        this._tfLocalFileName.setDirectoryOnly(false);
        this._tfLocalFileName.setChooserInit(new URLChooserInit(){

            public void initURLChooser(URLChooser urlChooser) {
                urlChooser.clearChooseableURLFilters();
                urlChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
                WildcardURLFilter allFilesFilter = new WildcardURLFilter("*.zip", false, UpdateArb.getString(135));
                urlChooser.addChooseableURLFilter((URLFilter)allFilesFilter);
                urlChooser.setURLFilter((URLFilter)allFilesFilter);
            }
        });
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = INSETS_HINT;
        this.add((Component)this._lbHint, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 10, 0);
        this.add(this._automaticCheckForUpdatesCheckbox, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.5;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = INSETS_GAP_BELOW;
        this.add(this._rbUpdateCenter, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.insets = INSETS_ZERO;
        gbc.anchor = 13;
        this.add((Component)this._proxySettings, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 24, 5, 0);
        JScrollPane scrollPane = new JScrollPane((Component)this._lstUpdateCenters);
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.add(scrollPane, gbc);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setOrientation(1);
        buttonBar.setAlignment(1);
        buttonBar.add((Component)this._btnAddCenter);
        buttonBar.add((Component)this._btnRemoveCenter);
        buttonBar.add((Component)this._btnEditCenter);
        gbc.gridx += 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 5, 0);
        this.add((Component)buttonBar, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 24, 5, 0);
        this._panProgress.setLayout(new BorderLayout(5, 0));
        this._panProgress.setVisible(false);
        this.add(this._panProgress, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 3;
        gbc.fill = 0;
        gbc.insets = INSETS_GAP_BELOW;
        this.add(this._rbLocalFile, gbc);
        JPanel localFile = new JPanel();
        localFile.setLayout(new GridBagLayout());
        localFile.add((Component)this._lbFileName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        localFile.add((Component)this._tfLocalFileName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 24, 0, 0);
        this.add(localFile, gbc);
        gbc.gridx += 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.add(this._btnBrowse, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._rbUpdateCenter);
        bg.add(this._rbLocalFile);
    }

    private void installListeners() {
        Listener l = new Listener();
        this._rbUpdateCenter.addActionListener(l);
        this._proxySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UpdateSourcePage.this.proxyPrompt()) {
                    UpdateSourcePage.this.checkMasterList(UpdateSourcePage.this.getTraversableContext(), ++UpdateSourcePage.this._currentMasterListCheckId);
                    UpdateSourcePage.this._checkedMasterList = true;
                }
            }
        });
        this._rbLocalFile.addActionListener(l);
        this._btnBrowse.addActionListener(l);
        this._btnAddCenter.addActionListener(l);
        this._btnEditCenter.addActionListener(l);
        this._btnRemoveCenter.addActionListener(l);
        this._tfLocalFileName.getDocument().addDocumentListener(l);
        this._lstUpdateCenters.getSelectionModel().addListSelectionListener(l);
        this._lstUpdateCenters.addListActionListener((NiceListActionListener)l);
        this._lstUpdateCenters.addKeyListener((KeyListener)l);
        this._automaticCheckForUpdatesCheckbox.addActionListener(l);
        this._rbUpdateCenter.setSelected(true);
        this._automaticCheckForUpdatesCheckbox.setSelected(WebUpdateAddin.getPreferences().getCheckOnStartup());
        this.updateEnabledControls();
    }

    private void updateControls() {
        WebupdateShaping webupdateShapings = WebupdateShapingHook.getWebupdateShapings();
        if (webupdateShapings != null) {
            if (!webupdateShapings.isInstallLocalFileVisible()) {
                this._rbLocalFile.setVisible(false);
                this._lbFileName.setVisible(false);
                this._tfLocalFileName.setVisible(false);
                this._btnBrowse.setVisible(false);
            }
            if (!webupdateShapings.isAutoCFUVisible()) {
                this._automaticCheckForUpdatesCheckbox.setVisible(false);
            }
        }
    }

    @Override
    public boolean isComplete() {
        if (this._rbUpdateCenter.isSelected()) {
            if (this._masterListChecker != null && this._masterListChecker.isRunning()) {
                return false;
            }
            for (int i = 0; i < this._lstUpdateCenters.getModel().getSize(); ++i) {
                UpdateCenter center = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(i);
                if (!center.isEnabled()) continue;
                return true;
            }
            return false;
        }
        return this._tfLocalFileName.getText().trim().length() > 0;
    }

    @Override
    public Component getInitialFocus() {
        return this._rbUpdateCenter;
    }

    @Override
    public void pageSelected(TraversableContext context) {
        this._isSaved = false;
        UpdateWizardModel model = this.getModel(context);
        if (model.hasRequestedExtensions()) {
            this._lstUpdateCenters.setEnabled(false);
        }
        if (this._firstTimeForAutoupdate && this.getModel(context).isSourceSkipped()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this.getTraversableContext().getWizardCallbacks().nextPage();
                }
            });
            this._firstTimeForAutoupdate = false;
            return;
        }
        if (this._firstTime) {
            this._listModel = new SimpleListModel(this.getModel(context).getAllUpdateCenters());
            this._lstUpdateCenters.setModel((ListModel)this._listModel);
            this._firstTime = false;
        }
        if (!this._checkedMasterList && !this._rbLocalFile.isSelected()) {
            this.checkMasterList(context, ++this._currentMasterListCheckId);
            this._checkedMasterList = true;
        }
        this.defaultLocalFilename();
        this.completeValueChanged();
    }

    private void defaultLocalFilename() {
        if (this._tfLocalFileName.getText().trim().length() > 0) {
            return;
        }
        URL lastLocalBundle = WebUpdateAddin.getPreferences().getLastLocalBundleURL();
        if (lastLocalBundle == null) {
            return;
        }
        this._tfLocalFileName.setURL(lastLocalBundle);
    }

    private void storeLocalFilename() {
        if (this._tfLocalFileName.getText().trim().length() == 0) {
            return;
        }
        URL url = this._tfLocalFileName.getURL();
        if (url == null) {
            return;
        }
        WebUpdateAddin.getPreferences().setLastLocalBundleURL(url);
    }

    private void checkMasterList(final TraversableContext context, final long id) {
        final Runnable enableProxyButtonAsRunnable = new Runnable(){

            @Override
            public void run() {
                boolean isRunning = UpdateSourcePage.this._masterListChecker != null;
                UpdateSourcePage.this._proxySettings.setEnabled(!isRunning);
            }
        };
        SwingUtilities.invokeLater(enableProxyButtonAsRunnable);
        final String masterServerURL = this.getModel(context).getUpdateManager().getMasterServerURL();
        this._masterListChecker = new CheckMasterListRunnable(masterServerURL){

            @Override
            public void run() {
                try {
                    new HttpPing(ProxyOptions.getProxyOptions(), URLFactory.newURL((String)masterServerURL)).ping();
                    super.run();
                }
                catch (HttpPing.PingFailedException ex) {
                    this.failed(ex);
                }
                finally {
                    SwingUtilities.invokeLater(enableProxyButtonAsRunnable);
                }
            }

            @Override
            protected void failed(final Throwable t) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateSourcePage.this._masterListChecker = null;
                        UpdateSourcePage.this.masterListUpdateError(context, t, id);
                        UpdateSourcePage.this.completeValueChanged();
                    }
                });
            }

            protected void finished(final List l) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateSourcePage.this._masterListChecker = null;
                        UpdateSourcePage.this.processMasterList(context, l);
                        UpdateSourcePage.this.completeValueChanged();
                        if (!CheckUpdatesRunnable.isAdmin()) {
                            UpdateSourcePage.this._lbProgress.setText("<HTML>" + UpdateArb.getString(234) + "</HTML>");
                            UpdateSourcePage.this._pbUpdates.setVisible(false);
                            UpdateSourcePage.this._panProgress.setVisible(true);
                        }
                    }
                });
            }
        };
        ProgressMonitor monitor = new ProgressMonitor();
        this._masterListChecker.setMonitor(monitor);
        Thread t = new Thread((Runnable)this._masterListChecker, "Update Master List Checker " + id);
        this.addCancelListener(context);
        t.start();
    }

    private void addCancelListener(TraversableContext context) {
        if (this._modelListener == null) {
            this._modelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == Boolean.TRUE) {
                        UpdateSourcePage.this._onPage = false;
                        UpdateSourcePage.this.abortMasterListChecker(UpdateSourcePage.this._currentMasterListCheckId);
                    }
                }
            };
            this.getModel(context).addPropertyChangeListener("wizardCancelled", this._modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proxyPrompt() {
        ProxyOptions options = ProxyOptions.getProxyOptions();
        ProxySettingsPanel psp = new ProxySettingsPanel();
        psp.setProxyOptions(options);
        psp.updateProxyAuthFields();
        MessagePanel mp = new MessagePanel();
        mp.setMessageType(4);
        if (Util.isInsideOracle()) {
            mp.setMessageText(UpdateArb.getString(194));
        } else {
            mp.setMessageText(UpdateArb.getString(193));
        }
        mp.addMessageComponent((Component)psp);
        HelpUtils.setHelpID((JComponent)mp, (String)"f1_idewideupdatetimeout_html");
        JEWTDialog jd = JEWTDialog.createDialog((Component)((Object)this), (String)UpdateArb.getString(195), (int)7);
        jd.setContent((Component)mp);
        try {
            if (jd.runDialog()) {
                ProxyOptions.setProxyOptions((ProxyOptions)psp.getProxyOptions());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            jd.dispose();
        }
    }

    private void masterListUpdateError(TraversableContext context, Throwable t, long id) {
        if (this.isMasterListCheckerRunnable(id)) {
            if (!this._rbLocalFile.isSelected() && this.proxyPrompt()) {
                this.checkMasterList(context, id);
                return;
            }
            this.displayWarningStatus(t, UpdateArb.getString(126), UpdateArb.getString(127), UpdateArb.getString(124), UpdateArb.format(125, Ide.getProgramShortName()));
        } else if (id == this._currentMasterListCheckId) {
            this.displayWarningStatus(t, UpdateArb.getString(130), UpdateArb.getString(131), UpdateArb.getString(128), UpdateArb.format(129, Ide.getProgramShortName()));
        }
    }

    private void displayWarningStatus(Throwable t, String inline, String hyper, String title, String message) {
        if (this._onPage) {
            this._panProgress.removeAll();
            this._panProgress.add((Component)this._lbError, "West");
            this._panProgress.add((Component)this._hlError, "East");
            this._lbError.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this._lbError.setText(inline);
            this._hlError.setText(hyper);
            if (this._errorDetailsListener != null) {
                this._hlError.removeActionListener(this._errorDetailsListener);
            }
            this._errorDetailsListener = new ErrorDetailsListener(t, title, message);
            this._hlError.addActionListener(this._errorDetailsListener);
            this._panProgress.invalidate();
            this._panProgress.validate();
            this._panProgress.setVisible(true);
        }
    }

    private void processMasterList(TraversableContext context, List masterListCenters) {
        UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
        masterListCenters.addAll(updateHook.getUpdateCenters());
        for (UpdateCenter masterServer : masterListCenters) {
            if (masterServer.getMasterId() == null) continue;
            UpdateCenter existingEntry = this.findCenterByMasterId(masterServer.getMasterId(), this.getModel(context).getAllUpdateCenters());
            if (existingEntry == null) {
                masterServer.setEnabled(masterServer.isSelectedByDefault());
                UpdateWizardModel model = this.getModel(context);
                masterServer.setEnabledChangedByJDev(model.hasRequestedExtensions());
                this._listModel.addElement((Object)masterServer);
                continue;
            }
            boolean different = false;
            if (!existingEntry.isEnabledChangedByUser()) {
                existingEntry.setEnabled(masterServer.isSelectedByDefault());
            }
            if (!existingEntry.getURL().equals(masterServer.getURL())) {
                existingEntry.setURL(masterServer.getURL());
                different = true;
            }
            if (!existingEntry.getName().equals(masterServer.getName())) {
                existingEntry.setName(masterServer.getName());
                different = true;
            }
            if (existingEntry.isProtected() != masterServer.isProtected()) {
                existingEntry.setProtected(masterServer.isProtected());
                different = true;
            }
            if (!different) continue;
            int index = this.getModel(context).getAllUpdateCenters().indexOf(existingEntry);
            this._listModel.changed(index);
        }
        ArrayList<UpdateCenter> serversToRemove = new ArrayList<UpdateCenter>();
        for (UpdateCenter localServer : this.getModel(context).getAllUpdateCenters()) {
            UpdateCenter masterEntry;
            if (localServer.getMasterId() == null || (masterEntry = this.findCenterByMasterId(localServer.getMasterId(), masterListCenters)) != null) continue;
            serversToRemove.add(localServer);
        }
        Iterator i = serversToRemove.iterator();
        while (i.hasNext()) {
            this._listModel.removeElement(i.next());
        }
    }

    private UpdateCenter findCenterByMasterId(String masterId, List centers) {
        for (UpdateCenter thisCenter : centers) {
            if (!masterId.equals(thisCenter.getMasterId())) continue;
            return thisCenter;
        }
        return null;
    }

    private boolean haveLicenseAgreement(List<LocalUpdateBundle> localBundles) {
        for (LocalUpdateBundle localBundle : localBundles) {
            UpdateBundle bundle = localBundle.getBundle();
            if (bundle == null) {
                return false;
            }
            for (UpdateInfo update : bundle.getUpdates()) {
                if (update.getClickThroughURL() == null) continue;
                return true;
            }
        }
        return false;
    }

    public Object getExitTransition() {
        try {
            this.doSave(this.getTraversableContext());
            UpdateWizardModel model = this.getModel(this.getTraversableContext());
            UpdatePageConditions state = new UpdatePageConditions(this._rbLocalFile.isSelected(), this._rbLocalFile.isSelected() && model.getLocalBundles().size() > 0 && this.haveLicenseAgreement(model.getLocalBundles()), (Collection<UpdateInfo>)(this._rbLocalFile.isSelected() ? this.getUpdates(model) : Collections.EMPTY_SET));
            if (state.isLocal()) {
                if (state.isLicense()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToLicence");
                    return "sourceToLicence";
                }
                if (state.isSingleUser()) {
                    this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToSummary");
                    return "sourceToSummary";
                }
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToDlLocation");
                return "sourceToDlLocation";
            }
            return null;
        }
        catch (TraversalException te) {
            return null;
        }
    }

    private Set<UpdateInfo> getUpdates(UpdateWizardModel model) {
        HashSet<UpdateInfo> updates = new HashSet<UpdateInfo>();
        List<LocalUpdateBundle> localBundles = model.getLocalBundles();
        for (LocalUpdateBundle localBundle : localBundles) {
            UpdateBundle bundle = localBundle.getBundle();
            updates.addAll(bundle.getUpdates());
        }
        return updates;
    }

    private void doSave(TraversableContext context) throws TraversalException {
        if (!this._isSaved) {
            if (!this.doValidation(context)) {
                throw new TraversalException(null);
            }
            this.save(context);
            this._isSaved = true;
        }
    }

    @Override
    public final void onExit(TraversableContext context) throws TraversalException {
        this.doSave(context);
        this.pageDeselected(context);
        this._onPage = false;
        this.abortMasterListChecker(this._currentMasterListCheckId);
    }

    private void abortMasterListChecker(long abortId) {
        this._cancelledMasterListCheckId = abortId;
        this._checkedMasterList = false;
    }

    private boolean isMasterListCheckerRunnable(long id) {
        return id > this._cancelledMasterListCheckId;
    }

    @Override
    public void save(TraversableContext context) {
        try {
            UpdateManager.getInstance().setUpdateCenters(this.getModel(context).getAllUpdateCenters());
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
        }
        if (this._rbLocalFile.isSelected()) {
            this.getModel(context).setLocalBundles(this._localBundles);
        } else {
            this.getModel(context).setLocalBundles(null);
        }
    }

    @Override
    public boolean doValidation(TraversableContext context) {
        if (context.getDirection() == 2) {
            return true;
        }
        if (this._rbLocalFile.isSelected()) {
            return this.validateLocalBundle();
        }
        return true;
    }

    private boolean validateLocalBundle() {
        this.storeLocalFilename();
        List theURLs = this._tfLocalFileName.getURLs();
        this._localBundles.clear();
        for (int c = 0; c < theURLs.size(); ++c) {
            URL theURL = (URL)theURLs.get(c);
            if (theURL != null && "file".equals(theURL.getProtocol())) {
                File f = new File(URLFileSystem.getPlatformPathName((URL)theURL));
                try {
                    LocalUpdateBundle localBundle = LocalUpdateBundle.createInstance(f);
                    this._localBundles.add(localBundle);
                    if (localBundle.getBundle().getUpdates().size() == 0) {
                        MessageDialog.error((Component)((Object)this), (Object)UpdateArb.getString(174), (String)UpdateArb.getString(173), null);
                        return false;
                    }
                    ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
                    for (UpdateInfo update : localBundle.getBundle().getUpdates()) {
                        boolean result;
                        if (!this.validateUpdateDependencies(update)) {
                            return false;
                        }
                        if (update.isNew()) continue;
                        Version newVersion = update.getVersion();
                        Version currentVersion = null;
                        Extension extension = extReg.findExtension(update.getID());
                        if (extension == null) {
                            Bundle bundle = Platform.getBundleRegistry().findBundle(update.getID());
                            if (bundle != null) {
                                currentVersion = new Version(bundle.getVersion().toString());
                            } else {
                                CustomTypeDefinition ctd = UpdateHandlerHook.getCustomTypeDefinition();
                                List<CustomUpdateType> cuts = ctd.getCustomUpdateTypes();
                                for (CustomUpdateType t : cuts) {
                                    UpdateHelper uh = t.getUpdateHelper();
                                    if (uh == null || !uh.isInstalled(update.getID()) || uh.getCurrentlyInstalledVersion(update.getID()) == null) continue;
                                    currentVersion = uh.getCurrentlyInstalledVersion(update.getID());
                                }
                            }
                        } else {
                            currentVersion = extension.getVersion();
                        }
                        if (!(currentVersion == null || newVersion.compareTo(currentVersion) == 0 ? !(result = MessageDialog.confirm((Component)((Object)this), (Object)UpdateArb.format(176, newVersion.toString(), update.getName()), (String)UpdateArb.getString(175), null, (boolean)false, (String)UpdateArb.getString(177), (String)UpdateArb.getString(178))) : newVersion.compareTo(currentVersion) < 0 && !(result = MessageDialog.confirm((Component)((Object)this), (Object)UpdateArb.format(180, newVersion.toString(), update.getName(), currentVersion.toString()), (String)UpdateArb.getString(179), null, (boolean)true, (String)UpdateArb.getString(181), (String)UpdateArb.getString(182))))) continue;
                        return false;
                    }
                    continue;
                }
                catch (InvalidLocalBundleException nabe) {
                    if (nabe.problems() != null) {
                        this.logLocalBundleProblems(theURL, nabe.problems());
                    }
                    MessageDialog.error((Component)((Object)this), (Object)nabe.getMessage(), (String)UpdateArb.getString(154), null);
                    return false;
                }
            }
            MessageDialog.error((Component)((Object)this), (Object)UpdateArb.getString(156), (String)UpdateArb.getString(157), null);
            return false;
        }
        return true;
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    private void logLocalBundleProblems(URL url, Problems problems) {
        LogManager logManager = LogManager.getLogManager();
        LogPage msgPage = logManager.getMsgPage();
        msgPage.log((Object)UpdateArb.format(206, URLFileSystem.getPlatformPathName((URL)url), this.descriptionsAsString(problems)));
    }

    private String descriptionsAsString(Problems problems) {
        StringBuilder sb = new StringBuilder();
        for (String s : problems.descriptions()) {
            sb.append(s);
            sb.append('\n');
        }
        return sb.toString();
    }

    private boolean validateUpdateDependencies(UpdateInfo update) {
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection requiredIds = update.getRequiredIds();
        ArrayList<String> missingIds = new ArrayList<String>();
        for (String id : requiredIds) {
            boolean compatible = true;
            Extension extension = extReg.findExtension(id);
            if (extension == null) {
                Bundle bundle = Platform.getBundleRegistry().findBundle(id);
                if (bundle != null) {
                    compatible = CheckUpdatesRunnable.testCompatibleVersion(update, id, new Version(bundle.getVersion().toString()));
                } else {
                    compatible = false;
                    CustomTypeDefinition ctd = UpdateHandlerHook.getCustomTypeDefinition();
                    List<CustomUpdateType> cuts = ctd.getCustomUpdateTypes();
                    for (CustomUpdateType t : cuts) {
                        UpdateHelper uh = t.getUpdateHelper();
                        if (uh == null || !uh.isInstalled(id) || uh.getCurrentlyInstalledVersion(id) != null && !CheckUpdatesRunnable.testCompatibleVersion(update, id, uh.getCurrentlyInstalledVersion(id))) continue;
                        compatible = true;
                    }
                }
            } else {
                compatible = CheckUpdatesRunnable.testCompatibleVersion(update, id, extension.getVersion());
            }
            if (compatible) continue;
            missingIds.add(id);
        }
        if (!missingIds.isEmpty()) {
            TableModel model = this.createMissingDependenciesTableModel(update, missingIds);
            NiceTable table = new NiceTable(model);
            BaseMessageDialog bmd = BaseMessageDialog.createMessageDialogImpl((Component)((Object)this), (String)UpdateArb.getString(197), (int)3);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout(0, 5));
            p.add((Component)new JWrappedLabel(UpdateArb.getString(198)), "North");
            p.add((Component)new JScrollPane((Component)table), "Center");
            bmd.setMessage((Object)p);
            table.setAutoResizeMode(0);
            table.autoSizeColumnsToFit();
            table.autoSizeViewportToFit(new Dimension(100, 100), new Dimension(800, 400));
            bmd.runDialog();
            return false;
        }
        return true;
    }

    private TableModel createMissingDependenciesTableModel(final UpdateInfo info, final List<String> missingIds) {
        class TM
        extends AbstractTableModel
        implements NiceTableModel {
            TM() {
            }

            public int getColumnAlignment(int column) {
                return 2;
            }

            public Comparator getColumnSortComparator(int column) {
                return null;
            }

            @Override
            public int getRowCount() {
                return missingIds.size();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String id = (String)missingIds.get(rowIndex);
                Version max = info.getRequiredMaxVersion(id);
                Version min = info.getRequiredMinVersion(id);
                String installedVersion = null;
                Extension extension = ExtensionRegistry.getExtensionRegistry().findExtension(id);
                if (extension == null) {
                    Bundle bundle = Platform.getBundleRegistry().findBundle(id);
                    if (bundle != null) {
                        installedVersion = bundle.getVersion().toString();
                    } else {
                        CustomTypeDefinition ctd = UpdateHandlerHook.getCustomTypeDefinition();
                        List<CustomUpdateType> cuts = ctd.getCustomUpdateTypes();
                        for (CustomUpdateType t : cuts) {
                            UpdateHelper uh = t.getUpdateHelper();
                            if (uh == null || !uh.isInstalled(id)) continue;
                            if (uh.getCurrentlyInstalledVersion(id) != null) {
                                installedVersion = uh.getCurrentlyInstalledVersion(id).toString();
                                continue;
                            }
                            installedVersion = UpdateArb.getString(201);
                        }
                    }
                } else {
                    installedVersion = extension.getVersion().toString();
                }
                switch (columnIndex) {
                    case 0: {
                        return id;
                    }
                    case 1: {
                        if (max != null && min != null) {
                            return UpdateArb.format(202, min.toString(), max.toString());
                        }
                        if (max != null) {
                            return UpdateArb.format(204, max.toString());
                        }
                        if (min != null) {
                            return UpdateArb.format(203, min.toString());
                        }
                        return "";
                    }
                    case 2: {
                        return installedVersion != null ? installedVersion : UpdateArb.getString(49);
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return UpdateArb.getString(199);
                    }
                    case 1: {
                        return UpdateArb.getString(200);
                    }
                    case 2: {
                        return UpdateArb.getString(201);
                    }
                }
                return "";
            }
        }
        return new TM();
    }

    private void addUpdateCenter() {
        UpdateCenter newCenter = UpdateCenterPanel.runCreateDialog((Component)((Object)this));
        if (newCenter != null) {
            newCenter.setEnabled(true);
            this._listModel.addElement((Object)newCenter);
            this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            this._lstUpdateCenters.ensureIndexIsVisible(this._listModel.getSize() - 1);
            this.completeValueChanged();
        }
    }

    private void removeUpdateCenter() {
        int[] sel = this._lstUpdateCenters.getSelectedIndices();
        if (sel != null && sel.length > 0) {
            int firstSel = sel[0];
            this._listModel.removeIndices(sel);
            if (this._listModel.getSize() > firstSel) {
                this._lstUpdateCenters.setSelectedIndex(firstSel);
            } else if (this._listModel.getSize() > 0) {
                this._lstUpdateCenters.setSelectedIndex(this._listModel.getSize() - 1);
            }
        }
    }

    private void editUpdateCenter() {
        UpdateCenter selected = (UpdateCenter)this._lstUpdateCenters.getSelectedValue();
        if (UpdateCenterPanel.runEditDialog((Component)((Object)this), selected)) {
            int selIdx = this._lstUpdateCenters.getSelectedIndex();
            this._listModel.changed(selIdx);
        }
    }

    private void updateEnabledControls() {
        boolean remote = this._rbUpdateCenter.isSelected();
        if (this.getTraversableContext() != null) {
            if (remote) {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToUpdates");
            } else {
                this.getTraversableContext().getWizardCallbacks().wizardUpdateExpectedTransition((Object)"sourceToLicence");
            }
        }
        this._lstUpdateCenters.setEnabled(remote);
        this._lstUpdateCenters.setBackground(remote ? UIManager.getColor("window") : UIManager.getColor("control"));
        Object[] sel = this._lstUpdateCenters.getSelectedValues();
        this._btnAddCenter.setEnabled(remote);
        if (!remote || sel == null || sel.length == 0) {
            this._btnEditCenter.setEnabled(false);
            this._btnRemoveCenter.setEnabled(false);
        } else {
            if (sel.length == 1) {
                UpdateCenter center = (UpdateCenter)sel[0];
                this._btnEditCenter.setEnabled(!center.isFromMasterList());
            }
            boolean removeEnabled = true;
            for (int i = 0; i < sel.length; ++i) {
                UpdateCenter thisCenter = (UpdateCenter)sel[i];
                if (!thisCenter.isFromMasterList()) continue;
                removeEnabled = false;
                break;
            }
            this._btnRemoveCenter.setEnabled(removeEnabled);
        }
        this._lbFileName.setEnabled(!remote);
        this._tfLocalFileName.setEnabled(!remote);
        this._btnBrowse.setEnabled(!remote);
    }

    private void toggleCenterEnabled(int row) {
        UpdateCenter center;
        center.setEnabled(!(center = (UpdateCenter)this._lstUpdateCenters.getModel().getElementAt(row)).isEnabled());
        center.setEnabledChangedByUser(true);
        this._listModel.changed(row);
        this.completeValueChanged();
    }

    private class ErrorDetailsListener
    implements ActionListener {
        private final Throwable _throwable;
        private final String _title;
        private final String _message;

        ErrorDetailsListener(Throwable throwable, String title, String message) {
            this._throwable = throwable;
            this._title = title;
            this._message = message;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ExceptionDialog.showExceptionDialog((Component)((Object)UpdateSourcePage.this), (Throwable)this._throwable, (String)this._title, (String)this._message, null);
        }
    }

    private class ProgressMonitor
    implements UpdateCenterMonitor {
        private ProgressMonitor() {
        }

        @Override
        public void setMessage(final String message) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this._lbProgress.setText(message);
                    UpdateSourcePage.this._panProgress.invalidate();
                    UpdateSourcePage.this._panProgress.validate();
                }
            });
        }

        @Override
        public void setMaximum(int max) {
        }

        @Override
        public void setProgress(int progress) {
        }

        @Override
        public void start() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this._panProgress.removeAll();
                    UpdateSourcePage.this._panProgress.add((Component)UpdateSourcePage.this._lbProgress, "North");
                    UpdateSourcePage.this._panProgress.add((Component)UpdateSourcePage.this._pbUpdates, "Center");
                    UpdateSourcePage.this._panProgress.setVisible(true);
                    UpdateSourcePage.this._panProgress.invalidate();
                    UpdateSourcePage.this._panProgress.validate();
                }
            });
        }

        @Override
        public void finish() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateSourcePage.this._panProgress.setVisible(false);
                    UpdateSourcePage.this._panProgress.invalidate();
                    UpdateSourcePage.this._panProgress.validate();
                }
            });
        }

        @Override
        public boolean isStopped() {
            return false;
        }
    }

    private class Listener
    implements DocumentListener,
    ActionListener,
    ListSelectionListener,
    KeyListener,
    NiceListActionListener {
        private Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            UpdateSourcePage.this.completeValueChanged();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == UpdateSourcePage.this._btnAddCenter) {
                UpdateSourcePage.this.addUpdateCenter();
            } else if (src == UpdateSourcePage.this._btnRemoveCenter) {
                UpdateSourcePage.this.removeUpdateCenter();
            } else if (src == UpdateSourcePage.this._btnEditCenter) {
                UpdateSourcePage.this.editUpdateCenter();
            } else if (src == UpdateSourcePage.this._btnBrowse) {
                URL fileName = UpdateSourcePage.this._tfLocalFileName.getURL();
                if (fileName != null && new File(fileName.getFile()).isFile()) {
                    try {
                        File parent = new File(fileName.getFile()).getParentFile();
                        UpdateSourcePage.this._tfLocalFileName.setURL(parent.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                UpdateSourcePage.this._tfLocalFileName.actionPerformed(ae);
            } else if (src == UpdateSourcePage.this._rbLocalFile) {
                UpdateSourcePage.this._panProgress.setVisible(false);
                UpdateSourcePage.this._panProgress.invalidate();
                UpdateSourcePage.this._panProgress.validate();
                UpdateSourcePage.this.abortMasterListChecker(UpdateSourcePage.this._currentMasterListCheckId);
            } else if (src == UpdateSourcePage.this._rbUpdateCenter) {
                UpdateSourcePage.this._lbError.removeAll();
                UpdateSourcePage.this._hlError.removeAll();
                UpdateSourcePage.this._panProgress.removeAll();
                UpdateSourcePage.this._panProgress.invalidate();
                UpdateSourcePage.this._panProgress.validate();
                if (!UpdateSourcePage.this._checkedMasterList) {
                    UpdateSourcePage.this.checkMasterList(UpdateSourcePage.this.getTraversableContext(), ++UpdateSourcePage.this._currentMasterListCheckId);
                    UpdateSourcePage.this._checkedMasterList = true;
                }
            } else if (src == UpdateSourcePage.this._automaticCheckForUpdatesCheckbox) {
                WebUpdateAddin.getPreferences().setCheckOnStartup(UpdateSourcePage.this._automaticCheckForUpdatesCheckbox.isSelected());
            }
            UpdateSourcePage.this.completeValueChanged();
            UpdateSourcePage.this.updateEnabledControls();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            UpdateSourcePage.this.updateEnabledControls();
        }

        @Override
        public void keyPressed(KeyEvent ke) {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            if (ke.getKeyCode() == 127) {
                if (UpdateSourcePage.this._btnRemoveCenter.isEnabled()) {
                    UpdateSourcePage.this.removeUpdateCenter();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public void listActionPerformed(NiceListActionEvent lae) {
            if (lae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                UpdateSourcePage.this.toggleCenterEnabled(lae.getRow());
            }
        }
    }
}

