/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls.classpick;

import java.util.regex.Pattern;
import oracle.jdeveloper.controls.classpick.DualFiter;

class PatternFilter
implements DualFiter {
    private Pattern _pattern;

    public void setMatchName(String matchName) {
        String patternText = matchName.replaceAll("\\*", ".*") + ".*";
        this._pattern = Pattern.compile(patternText, 2);
    }

    public boolean acceptPackageName(String packageName) {
        return this._pattern.matcher(packageName).matches();
    }

    public boolean acceptClassName(String className, String packagePrefix) {
        String fqClassName = packagePrefix.length() > 0 ? packagePrefix + '.' + className : className;
        return this._pattern.matcher(fqClassName).matches();
    }
}

