/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.IdeConstants;
import oracle.ide.natives.accessibility.HighContrast;
import oracle.ide.util.Assert;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.ui.AnimatedCellIcon;
import oracle.javatools.ui.KeyNavigationManager;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.layout.CenterLayout;
import oracle.javatools.util.AccessibleUtils;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaClassLocator2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageTreePanel
extends JPanel
implements ClassPackageView {
    private final JScrollPane pkgScrollPane = new JScrollPane();
    private final JTree pkgTree = KeyNavigationManager.createNavigableTree();
    private final DefaultTreeModel pkgModel = new DefaultTreeModel(new PackageNode(""));
    private final DefaultTreeCellRenderer renderer = new TreeRenderer();
    private final TreeSelectionModel selModel = new DefaultTreeSelectionModel();
    private final JPanel loadingPanel = new JPanel((LayoutManager)new CenterLayout());
    private volatile boolean active;
    private int loadingCounter;
    private JavaManager _jmgr;
    private int mode = 1;
    private ClassPackageBrowserFilterV2 _filter;
    private boolean _multiSelect;
    private final ClassPackageBrowserContext _browserContext;
    private final List<SwingWorker> workers = new CopyOnWriteArrayList<SwingWorker>();

    public ClassPackageTreePanel(ClassPackageBrowserContext browseContext, ClassPackageBrowserFilterV2 filter) {
        this._browserContext = browseContext;
        this._filter = filter;
        this.jbInit();
    }

    @Override
    public void activateView() {
        this.active = true;
        if (this._jmgr != null) {
            ((PackageNode)this.pkgModel.getRoot()).loadChildren(false);
        }
        this.enableControls();
    }

    @Override
    public String getTitle() {
        return DialogsArb.getString((int)19);
    }

    @Override
    public Component getComponent() {
        return this.pkgTree;
    }

    @Override
    public void setSelection(String singleSelection) {
        if (singleSelection != null) {
            String[] multiSelection = new String[]{singleSelection};
            this.setSelectedItems(multiSelection);
        }
    }

    @Override
    public String getSelection() {
        String[] sels = this.getSelectedItems();
        return sels.length > 0 ? sels[0] : null;
    }

    @Override
    public void setSelectedItems(String[] multiSelection) {
        this.setSelectedItemsImpl(multiSelection);
    }

    @Override
    public String[] getSelectedItems() {
        ArrayList<String> resultList = new ArrayList<String>();
        TreePath[] paths = this.pkgTree.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object o = paths[i].getLastPathComponent();
                if (o instanceof PackageNode && (this.mode & 1) > 0) {
                    resultList.add(((PackageNode)o).getPackage());
                    continue;
                }
                if (!(o instanceof ClassNode) || (this.mode & 2) <= 0) continue;
                resultList.add(((ClassNode)o).getClassName());
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    @Override
    public void setJavaManager(JavaManager javaManager) {
        this._jmgr = javaManager;
        this.cancelWorkers();
        this.pkgModel.setRoot(new PackageNode(""));
        if (this.active) {
            ((PackageNode)this.pkgModel.getRoot()).loadChildren(false);
        }
    }

    @Override
    public void setClassAndPackageNameFilters(ClassNameFilter classFilter, PackageNameFilter pkgFilter) {
    }

    @Override
    public void setFilter(ClassPackageBrowserFilterV2 filterV2) {
        this._filter = filterV2;
        this.cancelWorkers();
        this.pkgModel.setRoot(new PackageNode(""));
        if (this._jmgr != null && this.active) {
            ((PackageNode)this.pkgModel.getRoot()).loadChildren(false);
        }
    }

    @Override
    public void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect != this._multiSelect) {
            this._multiSelect = isMultiSelect;
        }
        this.selModel.setSelectionMode(this._multiSelect ? 4 : 1);
    }

    @Override
    public void setMode(int classPackageMode) {
        this.mode = classPackageMode;
    }

    @Override
    public void dispose() {
        this.cancelWorkers();
    }

    private void jbInit() {
        this.pkgTree.setVisibleRowCount(10);
        this.pkgTree.setRootVisible(false);
        this.pkgTree.setShowsRootHandles(true);
        this.pkgTree.setModel(this.pkgModel);
        this.pkgTree.setCellRenderer(this.renderer);
        TreeAdapter treeListener = new TreeAdapter();
        this.pkgTree.addTreeSelectionListener(treeListener);
        this.pkgTree.addTreeWillExpandListener(treeListener);
        this.pkgTree.addFocusListener(treeListener);
        this.pkgTree.setSelectionModel(this.selModel);
        this.selModel.setSelectionMode(1);
        this.selModel.addTreeSelectionListener(treeListener);
        this.pkgScrollPane.getViewport().add((Component)this.pkgTree, null);
        this.loadingPanel.setBackground(HighContrast.isHighContrastModeEnabled() ? SystemColor.window : Color.white);
        this.loadingPanel.setForeground(HighContrast.isHighContrastModeEnabled() ? SystemColor.windowText : Color.black);
        this.loadingPanel.setOpaque(true);
        this.loadingPanel.setFocusCycleRoot(true);
        JLabel label = new JLabel(DialogsArb.getString((int)20));
        Icon throbber = OracleIcons.getIcon((String)"throbber.gif");
        label.setIcon(throbber);
        label.setIconTextGap(6);
        this.loadingPanel.add(label);
        this.loadingPanel.setBorder(new LineBorder(IdeConstants.COLOR_IDE_LINES, 1));
        this.loadingPanel.putClientProperty(UIConstants.VETO_HIERARCHY_CONVERSION, Boolean.TRUE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.loadingPanel, "Center");
    }

    private void showLoadingMessage() {
        if (this.loadingCounter++ == 0 && this.loadingPanel.getParent() == null) {
            this.remove(this.pkgScrollPane);
            this.add((Component)this.loadingPanel, "Center");
            this.validate();
        }
    }

    private void hideLoadingMessage() {
        if (--this.loadingCounter == 0) {
            this.remove(this.loadingPanel);
            this.add((Component)this.pkgScrollPane, "Center");
            this.validate();
            if (!AccessibleUtils.isAssistiveTechnologySet() || !this.isPanelInGhostPalette()) {
                this.pkgTree.requestFocus();
            }
        }
    }

    private boolean isPanelInGhostPalette() {
        for (Container p = this.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
            if (!(p instanceof GhostPalette)) continue;
            return true;
        }
        return false;
    }

    private Collection<String> getPackages(String packagePrefix) throws InterruptedException {
        JavaClassLocator locator = this._jmgr.getJavaClassLocator();
        if (locator instanceof JavaClassLocator2) {
            return ((JavaClassLocator2)locator).getPackagesInterruptibly(packagePrefix);
        }
        return locator.getPackages(packagePrefix);
    }

    private Collection<String> getClassesInPackage(String packagePrefix) throws InterruptedException {
        JavaClassLocator locator = this._jmgr.getJavaClassLocator();
        if (locator instanceof JavaClassLocator2) {
            return ((JavaClassLocator2)locator).getClassesInPackageInterruptibly(packagePrefix);
        }
        return locator.getClassesInPackage(packagePrefix);
    }

    private void setSelectedItemsImpl(String[] sel) {
        if (sel == null || sel.length == 0) {
            this.pkgTree.setSelectionRow(0);
        } else {
            String[] cleanSel = new String[sel.length];
            System.arraycopy(sel, 0, cleanSel, 0, sel.length);
            HashSet<String> pathSet = new HashSet<String>();
            for (int i = 0; i < cleanSel.length; ++i) {
                String path = cleanSel[i];
                if (path.endsWith(".*")) {
                    cleanSel[i] = path = path.substring(0, path.length() - 2);
                }
                int idx = path.lastIndexOf(46);
                while (idx != -1) {
                    path = path.substring(0, idx);
                    pathSet.add(path);
                    idx = path.lastIndexOf(46);
                }
            }
            Object[] paths = pathSet.toArray(new String[pathSet.size()]);
            Arrays.sort(paths);
            final PackageNode root = (PackageNode)this.pkgModel.getRoot();
            this.showLoadingMessage();
            SwingWorker<Map<String, TreePath>, Void> worker = new SwingWorker<Map<String, TreePath>, Void>((String[])paths, cleanSel){
                final /* synthetic */ String[] val$paths;
                final /* synthetic */ String[] val$cleanSel;
                {
                    this.val$paths = stringArray;
                    this.val$cleanSel = stringArray2;
                }

                @Override
                public Map<String, TreePath> doInBackground() {
                    HashMap<String, TreePath> pathMap = new HashMap<String, TreePath>();
                    pathMap.put("", new TreePath(root));
                    root.loadChildren(true);
                    for (int i = 0; i < this.val$paths.length; ++i) {
                        MutableTreeNode parentNode;
                        TreeNode child;
                        String pkg = this.val$paths[i];
                        int idx = pkg.lastIndexOf(46);
                        String base = idx != -1 ? pkg.substring(0, idx) : "";
                        String rest = pkg.substring(idx + 1);
                        TreePath parent = (TreePath)pathMap.get(base);
                        if (parent == null || !((child = this.getChild(parentNode = (MutableTreeNode)parent.getLastPathComponent(), rest)) instanceof PackageNode)) continue;
                        ((PackageNode)child).loadChildren(true);
                        TreePath childPath = parent.pathByAddingChild(child);
                        pathMap.put(pkg, childPath);
                    }
                    return pathMap;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done() {
                    try {
                        Object path;
                        int i;
                        Map pathMap = (Map)this.get();
                        for (i = 0; i < this.val$paths.length; ++i) {
                            path = (TreePath)pathMap.get(this.val$paths[i]);
                            if (path == null) continue;
                            ClassPackageTreePanel.this.pkgTree.expandPath((TreePath)path);
                        }
                        ClassPackageTreePanel.this.selModel.clearSelection();
                        for (i = 0; i < this.val$cleanSel.length; ++i) {
                            MutableTreeNode parentNode;
                            TreeNode child;
                            path = this.val$cleanSel[i];
                            int idx = ((String)path).lastIndexOf(46);
                            String base = idx != -1 ? ((String)path).substring(0, idx) : "";
                            String rest = ((String)path).substring(idx + 1);
                            TreePath parent = (TreePath)pathMap.get(base);
                            if (parent == null || (child = this.getChild(parentNode = (MutableTreeNode)parent.getLastPathComponent(), rest)) == null) continue;
                            TreePath newPath = parent.pathByAddingChild(child);
                            ClassPackageTreePanel.this.selModel.addSelectionPath(newPath);
                            ClassPackageTreePanel.this.pkgTree.scrollPathToVisible(newPath);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {
                    }
                    finally {
                        ClassPackageTreePanel.this.workers.remove(this);
                        ClassPackageTreePanel.this.hideLoadingMessage();
                    }
                }

                private TreeNode getChild(MutableTreeNode parentNode, String name) {
                    TreeNode child = null;
                    int childCount = parentNode.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        TreeNode node = parentNode.getChildAt(i);
                        if (!name.equals(node.toString())) continue;
                        child = node;
                        break;
                    }
                    return child;
                }
            };
            worker.execute();
            this.workers.add(worker);
        }
    }

    private void cancelWorkers() {
        for (SwingWorker worker : this.workers) {
            worker.cancel(true);
        }
    }

    private void enableControls() {
        boolean validSelection = false;
        TreePath[] paths = this.selModel.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; !validSelection && i < paths.length; ++i) {
                TreePath path = paths[i];
                if (path == null) continue;
                Object o = path.getLastPathComponent();
                if (o instanceof PackageNode) {
                    validSelection = (this.mode & 1) > 0;
                    continue;
                }
                if (!(o instanceof ClassNode)) continue;
                validSelection = (this.mode & 2) > 0;
            }
        }
        this._browserContext.enableControls(validSelection);
    }

    void pkgTree_treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        TreePath path = e.getPath();
        Object o = path.getLastPathComponent();
        if (o instanceof PackageNode) {
            ((PackageNode)o).loadChildren(false);
        }
    }

    private class TreeAdapter
    implements FocusListener,
    MouseListener,
    TreeSelectionListener,
    TreeWillExpandListener {
        int y;

        private TreeAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (ClassPackageTreePanel.this.pkgTree.getSelectionCount() == 0) {
                ClassPackageTreePanel.this.pkgTree.setSelectionInterval(0, 0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ClassPackageTreePanel.this.enableControls();
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            ClassPackageTreePanel.this.pkgTree_treeWillExpand(e);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            int clicks = e.getClickCount();
            if (clicks == 1) {
                this.y = e.getY();
            }
            if (this.y == e.getY() && clicks == 2 && (path = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof ClassNode) {
                ClassPackageTreePanel.this._browserContext.classPackageSelected();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        private static Icon progressIcon = new AnimatedCellIcon(OracleIcons.getIcon((String)"nodeprocessing_anim.gif"));

        private TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof PackageNode) {
                if (leaf) {
                    this.setLeafIcon(OracleIcons.getIcon((String)"package.png"));
                }
                if (expanded) {
                    this.setOpenIcon(OracleIcons.getIcon((String)"package.png"));
                } else {
                    this.setClosedIcon(OracleIcons.getIcon((String)"package.png"));
                }
            } else if (value instanceof ClassNode) {
                this.setLeafIcon(((ClassNode)value).isInterface() ? OracleIcons.getIcon((String)"interface.png") : OracleIcons.getIcon((String)"class.png"));
            } else if (value instanceof ProgressNode) {
                this.setLeafIcon(progressIcon);
            } else {
                this.setLeafIcon(null);
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    private class ClassNode
    extends DefaultMutableTreeNode {
        private String displayName;
        private JavaClass cls;

        ClassNode(JavaClass cls) {
            super(cls, false);
            this.cls = cls;
            String qname = cls.getQualifiedName();
            String pkg = cls.getPackageName();
            this.displayName = pkg != null && !pkg.isEmpty() ? qname.substring(pkg.length() + 1) : qname;
        }

        @Override
        public String toString() {
            return this.displayName;
        }

        String getClassName() {
            return this.cls.getQualifiedName();
        }

        @Override
        public Object getUserObject() {
            return this.displayName;
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }
    }

    private class PackageNode
    extends DefaultMutableTreeNode {
        String displayName;
        String pkgName;
        boolean childrenFetched;
        SwingWorker<List<MutableTreeNode>, Void> worker;

        PackageNode(String pkgName) {
            this.pkgName = pkgName;
            int idx = pkgName.lastIndexOf(".");
            this.displayName = idx != -1 ? pkgName.substring(idx + 1) : pkgName;
        }

        @Override
        public String toString() {
            return this.displayName;
        }

        public String getPackage() {
            return this.pkgName;
        }

        @Override
        public boolean isLeaf() {
            return !this.childrenFetched ? false : super.isLeaf();
        }

        private boolean isRootPackage() {
            return this.pkgName.isEmpty();
        }

        private synchronized SwingWorker<List<MutableTreeNode>, Void> getWorker() {
            if (this.worker == null) {
                if (this.isRootPackage()) {
                    if (EventQueue.isDispatchThread()) {
                        ClassPackageTreePanel.this.showLoadingMessage();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ClassPackageTreePanel.this.showLoadingMessage();
                            }
                        });
                    }
                }
                this.worker = new SwingWorker<List<MutableTreeNode>, Void>(){

                    @Override
                    public List<MutableTreeNode> doInBackground() {
                        try {
                            List list = PackageNode.this._loadChildList();
                            return list;
                        }
                        finally {
                            ClassPackageTreePanel.this.workers.remove(this);
                        }
                    }

                    @Override
                    public void done() {
                        if (PackageNode.this.getChildCount() > 0) {
                            PackageNode.this.remove(0);
                        }
                        try {
                            PackageNode.this._finishChildLoad(this.get());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (ExecutionException executionException) {
                        }
                        finally {
                            if (PackageNode.this.isRootPackage()) {
                                ClassPackageTreePanel.this.hideLoadingMessage();
                            }
                        }
                    }
                };
                this.worker.execute();
                ClassPackageTreePanel.this.workers.add(this.worker);
            }
            return this.worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadChildren(boolean wait) {
            SwingWorker<List<MutableTreeNode>, Void> worker = this.getWorker();
            if (!this.isRootPackage() && EventQueue.isDispatchThread()) {
                try {
                    worker.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (this.getChildCount() == 0) {
                        ClassPackageTreePanel.this.pkgModel.insertNodeInto(new ProgressNode(), this, 0);
                    }
                }
                catch (CancellationException e) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            if (wait && !EventQueue.isDispatchThread()) {
                PackageNode packageNode = this;
                synchronized (packageNode) {
                    while (!this.childrenFetched) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        private List<MutableTreeNode> _loadChildList() {
            ArrayList<MutableTreeNode> nodes;
            block7: {
                nodes = new ArrayList<MutableTreeNode>();
                try {
                    for (String pkg : ClassPackageTreePanel.this.getPackages(this.pkgName)) {
                        String childPackage = this.pkgName.length() == 0 ? pkg : this.pkgName + '.' + pkg;
                        if (childPackage == null || !ClassPackageTreePanel.this._filter.acceptPackage(childPackage)) continue;
                        nodes.add(new PackageNode(childPackage));
                    }
                    if ((ClassPackageTreePanel.this.mode & 2) > 0) {
                        for (String cname : ClassPackageTreePanel.this.getClassesInPackage(this.pkgName)) {
                            JavaClass cls;
                            if (!this.pkgName.isEmpty()) {
                                cname = this.pkgName + '.' + cname;
                            }
                            if ((cls = ClassPackageTreePanel.this._jmgr.getClass(cname)) == null || !ClassPackageTreePanel.this._filter.acceptClass(cls)) continue;
                            nodes.add(new ClassNode(cls));
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    Assert.printStackTrace((Throwable)t);
                    if (!(t instanceof ThreadDeath)) break block7;
                    throw (ThreadDeath)t;
                }
            }
            return nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _finishChildLoad(Object obj) {
            Object list;
            try {
                if (obj instanceof List) {
                    list = (List)obj;
                    if (list.isEmpty()) {
                        if (this.pkgName.isEmpty()) {
                            String label = DialogsArb.getString((int)12);
                            this.add(new DefaultMutableTreeNode(label));
                        }
                    } else {
                        for (Object o : (List)obj) {
                            this.add((MutableTreeNode)o);
                        }
                    }
                }
            }
            finally {
                list = this;
                synchronized (list) {
                    this.childrenFetched = true;
                    this.notifyAll();
                }
                TreePath[] sel = ClassPackageTreePanel.this.selModel.getSelectionPaths();
                ClassPackageTreePanel.this.pkgModel.reload(this);
                ClassPackageTreePanel.this.selModel.setSelectionPaths(sel);
            }
        }

        @Override
        public Object getUserObject() {
            return this.displayName;
        }
    }

    private class ProgressNode
    extends DefaultMutableTreeNode {
        private ProgressNode() {
        }

        @Override
        public String toString() {
            return DialogsArb.getString((int)20);
        }
    }
}

