/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.task;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferChunkTask;
import oracle.dbtools.transfer.task.TransferEndAdminTask;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferSubTask;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.util.Logger;

public class TransferControlTask
extends TransferSubTask {
    private IRaptorTaskRunMode mode;
    private FileSet fileSet;
    private Location targetLocation;
    private String targetDir;
    private TransferTask transferTask;
    private long adminTaskSize;
    private boolean endAdminTaskQueued;
    private List<FileInfo> fileInfos = new ArrayList<FileInfo>();
    private List<FileChunk> fileChunks = new ArrayList<FileChunk>();
    private volatile int parallelismMin;
    private volatile int parallelismMax;
    private volatile int parallelism;
    private volatile int nextChunk;
    private int retryLimit = 3;
    private long begTime;
    private volatile long lastCount;
    private volatile double lastSpeed;
    private volatile long lastTime;
    private String transferId;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("-yyyyMMdd-HHmmss");
    private int workingQueueCount;
    private boolean multiSession = true;
    private Map<Location, Boolean> locationPool = new HashMap<Location, Boolean>();
    private List<Location> deadLocations = new ArrayList<Location>();
    private boolean parallelismLocked;
    private Map<FileChunk, Integer> chunkRetryCount = new HashMap<FileChunk, Integer>();
    private static DecimalFormat df = new DecimalFormat("#0.00");

    TransferControlTask(String name, IRaptorTaskRunMode mode, FileSet fileSet, Location targetLocation, String targetDir, TransferTask transferTask) {
        super(name, true, mode);
        this.mode = mode;
        this.fileSet = fileSet;
        this.targetLocation = targetLocation;
        this.setTargetDir(targetDir);
        this.transferTask = transferTask;
    }

    private void setTargetDir(String theTargetDir) {
        this.targetDir = theTargetDir;
        if (this.targetDir.indexOf("\\") != -1) {
            if (!this.targetDir.endsWith("\\")) {
                this.targetDir = this.targetDir + "\\";
            }
        } else if (!this.targetDir.endsWith("/")) {
            this.targetDir = this.targetDir + "/";
        }
    }

    protected Void doWork() throws TaskException {
        try {
            this.initialize();
            this.determineInitialStrategy();
            this.startTransfer();
        }
        catch (Exception e) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
            throw new TaskException((Throwable)e);
        }
        return null;
    }

    private void initialize() throws IOException {
        this.initTransferId();
        this.fileSet.getLocation().connect();
        this.targetLocation.connect();
        this.locationPool.put(this.targetLocation, true);
        long payloadSize = this.fileSet.getTotalSize();
        this.adminTaskSize = (long)((double)payloadSize * 0.05);
        this.setProgressMonitor(this.transferTask.getProgressMonitor());
        this.getProgressMonitor().setMax(payloadSize + 2L * this.adminTaskSize);
        this.setMultiSession(this.transferTask.isMultiSession());
        this.setParallelism(this.transferTask.getParallelism());
        this.setParallelismLocked(this.transferTask.isParallelismLocked());
    }

    private void initTransferId() {
        this.transferId = "Transfer";
        String hostName = System.getProperty("HOSTNAME");
        if (hostName != null && !hostName.isEmpty()) {
            this.transferId = this.transferId + '-' + hostName;
        }
        this.transferId = this.transferId + DATE_FORMAT.format(new Date());
        Logger.info(((Object)((Object)this)).getClass(), (String)this.transferId);
    }

    private void determineInitialStrategy() throws IOException {
        for (FileInfo fileInfo : this.fileSet.getFileInfos(this.targetLocation, this.targetDir)) {
            this.fileInfos.add(fileInfo);
            this.fileChunks.addAll(fileInfo.getFileChunks());
        }
        this.doPreprocessingOnTarget(this.fileInfos, this.targetLocation, this.targetDir);
        for (FileInfo fileInfo : this.fileInfos) {
            if (fileInfo.isTransferred()) {
                this.getProgressMonitor().count(fileInfo.getLength());
                continue;
            }
            long count = 0L;
            for (FileChunk chunk : fileInfo.getFileChunks()) {
                if (!chunk.isTransferred()) continue;
                count += chunk.getSize();
            }
            this.getProgressMonitor().count(count);
        }
    }

    private void doPreprocessingOnTarget(List<FileInfo> fileInfos, Location targetLocation, String targetDir) throws IOException {
        targetLocation.doPreProcessing(this.transferId, fileInfos, targetDir);
    }

    private void startTransfer() throws IOException {
        this.lastTime = this.begTime = System.nanoTime();
        this.queueNextTransferTask();
        this.getProgressMonitor().setProgressOffset(this.adminTaskSize);
        this.lastCount = this.adminTaskSize;
    }

    private boolean queueFinished() {
        return this.workingQueueCount == 0;
    }

    private void queueNextTransferTask() throws IOException {
        TransferChunkTask task = this.getNextChunkTask();
        if (task != null) {
            ++this.workingQueueCount;
            this.transferTask.addTask(task);
        } else if (this.queueFinished() && !this.endAdminTaskQueued) {
            this.endAdminTaskQueued = true;
            this.cleanupLocationPool();
            this.queueEndAdminTask();
        }
    }

    private void queueEndAdminTask() throws IOException {
        TransferEndAdminTask task = new TransferEndAdminTask(this.transferId, this.fileInfos, this.targetLocation, this.targetDir, this.mode);
        task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent event) {
            }

            public void taskFailed(RaptorTaskEvent event) {
                Throwable t = event.getThrowable();
                if (t != null) {
                    if (t instanceof TransferRestartRequest) {
                        Logger.info(((Object)((Object)this)).getClass(), (Throwable)t);
                        TransferControlTask.this.restart();
                    } else {
                        Logger.severe(((Object)((Object)this)).getClass(), (Throwable)t);
                    }
                }
            }

            public void taskFinished(RaptorTaskEvent event) {
                TransferControlTask.this.getProgressMonitor().count(TransferControlTask.this.adminTaskSize);
                Logger.info(((Object)((Object)this)).getClass(), (String)("parallelism=" + (TransferControlTask.this.parallelismMin - 1) + (TransferControlTask.this.parallelismLocked ? " (LOCKED)" : "-" + (TransferControlTask.this.parallelismMax - 1))));
            }
        });
        this.transferTask.addTask(task);
    }

    private TransferChunkTask getNextChunkTask() {
        while (this.nextChunk < this.fileChunks.size()) {
            FileChunk chunk;
            if ((chunk = this.fileChunks.get(this.nextChunk++)).isTransferred()) continue;
            return this.getChunkTask(chunk);
        }
        return null;
    }

    private TransferChunkTask getChunkTask(final FileChunk fileChunk) {
        Location tgtLocation = this.getAvailableTargetLocation();
        final TransferChunkTask task = new TransferChunkTask(fileChunk, tgtLocation, this.mode);
        FileInfo fileInfo = fileChunk.getFileInfo();
        TransferTaskProgressMonitor fileProgressMonitor = fileInfo.getProgressMonitor();
        if (null == fileProgressMonitor) {
            fileProgressMonitor = new TransferTaskProgressMonitor(this.getProgressMonitor());
            fileInfo.setProgressMonitor(fileProgressMonitor);
        }
        task.setProgressMonitor(new TransferTaskProgressMonitor(fileProgressMonitor));
        task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent event) {
            }

            public void taskFailed(RaptorTaskEvent event) {
                if (event.getThrowable() != null) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)event.getThrowable());
                }
                long count = task.getProgressMonitor().getCount();
                TransferControlTask.this.getProgressMonitor().count(-count);
                TransferControlTask.this.locationPool.put(task.getTargetLocation(), true);
                TransferControlTask.this.requeue(fileChunk);
            }

            public void taskFinished(RaptorTaskEvent event) {
                try {
                    TransferControlTask.this.locationPool.put(task.getTargetLocation(), true);
                    TransferControlTask.this.chunkFinished(fileChunk);
                }
                catch (IOException e) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
        });
        return task;
    }

    public boolean isMultiSession() {
        return this.multiSession;
    }

    public void setMultiSession(boolean multiSession) {
        this.multiSession = multiSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location getAvailableTargetLocation() {
        if (!this.isMultiSession() || !this.targetLocation.isCloneable()) {
            return this.targetLocation;
        }
        Location tgtLocation = null;
        for (Location location : this.locationPool.keySet()) {
            if (!this.locationPool.get(location).booleanValue()) continue;
            try {
                location.connect();
                tgtLocation = location;
                break;
            }
            catch (IOException e) {
                this.deadLocations.add(location);
            }
            finally {
                this.locationPool.put(location, false);
            }
        }
        for (Location deadLocation : this.deadLocations) {
            this.locationPool.remove(deadLocation);
            deadLocation.disconnect();
        }
        this.deadLocations.clear();
        if (null == tgtLocation) {
            tgtLocation = this.targetLocation.clone();
            try {
                tgtLocation.connect();
                this.locationPool.put(tgtLocation, false);
            }
            catch (IOException e) {
                tgtLocation = this.targetLocation;
            }
        }
        return tgtLocation;
    }

    private void cleanupLocationPool() {
        for (Location location : this.locationPool.keySet()) {
            if (this.targetLocation == location) continue;
            location.disconnect();
        }
        this.locationPool.clear();
        this.locationPool.put(this.targetLocation, true);
    }

    protected synchronized void chunkFinished(FileChunk fileChunk) throws IOException {
        --this.workingQueueCount;
        long curCount = this.getProgressMonitor().getCount();
        long maxCount = this.getProgressMonitor().getMax();
        double curPct = (double)(curCount * 100L) / (double)maxCount;
        if (curCount == this.lastCount) {
            this.queueNextTransferTask();
            return;
        }
        long curTime = System.nanoTime();
        double time = (double)(curTime - this.lastTime) / 1.0E9;
        double timeTot = (double)(curTime - this.begTime) / 1.0E9;
        double curSpeed = (double)(curCount - this.lastCount) / time;
        double avgSpeed = ((double)curCount - (double)this.adminTaskSize) / timeTot;
        double pctChange = 0.0;
        if (this.lastSpeed == 0.0) {
            if (0 < this.getParallelism() && this.isParallelismLocked()) {
                Logger.info(((Object)((Object)this)).getClass(), (String)("Preset locked parallelism (" + (this.parallelism - 1) + ") 1st chunk speed: " + TransferControlTask.inByteFormat(curSpeed)));
            } else {
                boolean slowNetwork;
                boolean wasParallelismLocked = this.isParallelismLocked();
                this.setParallelismLocked(false);
                boolean bl = slowNetwork = curSpeed < 4194304.0;
                if (slowNetwork) {
                    this.setParallelism(5);
                } else {
                    this.setParallelism(7);
                }
                Logger.info(((Object)((Object)this)).getClass(), (String)("Determine initial parallelism (" + (this.parallelism - 1) + ") from 1st chunk speed: " + TransferControlTask.inByteFormat(curSpeed)));
                this.setParallelismLocked(wasParallelismLocked);
            }
            int p = this.getParallelism();
            for (int n = 1; n < p; ++n) {
                this.queueNextTransferTask();
            }
        } else {
            pctChange = curSpeed * 100.0 / this.lastSpeed;
            double hysteresis = 20.0;
            if (pctChange > 100.0 + hysteresis && this.getParallelism() < 9) {
                this.setParallelism(this.parallelism + 1);
                this.queueNextTransferTask();
            }
            if (pctChange < 100.0 - 2.0 * hysteresis && this.getParallelism() > this.getMinParallelism()) {
                this.setParallelism(this.parallelism - 1);
            } else {
                this.queueNextTransferTask();
            }
            if (this.workingQueueCount == 0) {
                this.queueNextTransferTask();
            }
        }
        Logger.fine(((Object)((Object)this)).getClass(), (String)(fileChunk.getName() + ", curPct=" + df.format(curPct) + ", parallelism=" + this.parallelism + ", lastSpeed=" + TransferControlTask.inByteFormat(this.lastSpeed) + ", curSpeed =" + TransferControlTask.inByteFormat(curSpeed) + ", pctChange=" + df.format(pctChange) + ", avgSpeed=" + TransferControlTask.inByteFormat(avgSpeed)));
        this.lastCount = curCount;
        this.lastSpeed = curSpeed;
        this.lastTime = curTime;
    }

    protected boolean isParallelismLocked() {
        return this.parallelismLocked;
    }

    protected void setParallelismLocked(boolean parallelismLocked) {
        this.parallelismLocked = parallelismLocked;
    }

    protected int getMinParallelism() {
        return this.parallelismMin;
    }

    protected int getParallelism() {
        return this.parallelism;
    }

    protected void setParallelism(int newParallelism) {
        if (this.isParallelismLocked()) {
            return;
        }
        if (0 == this.parallelism) {
            this.parallelismMin = newParallelism;
        }
        this.parallelism = newParallelism;
        this.transferTask.setParallelism(this.parallelism);
        if (this.parallelismMin > this.parallelism) {
            this.parallelismMin = this.parallelism;
        }
        if (this.parallelismMax < this.parallelism) {
            this.parallelismMax = this.parallelism;
        }
        Logger.fine(((Object)((Object)this)).getClass(), (String)String.valueOf(this.parallelism - 1));
    }

    protected synchronized void requeue(FileChunk fileChunk) {
        if (this.retries(fileChunk) < this.retryLimit) {
            this.transferTask.addTask(this.getChunkTask(fileChunk));
        } else {
            --this.workingQueueCount;
            Logger.severe(((Object)((Object)this)).getClass(), (String)("Retry limit exhausted for: " + fileChunk.getName()));
            try {
                this.queueNextTransferTask();
            }
            catch (IOException e) {
                Logger.severe(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
    }

    protected synchronized void restart() {
        long redoProgress = 0L;
        for (FileChunk chunk : this.fileChunks) {
            if (chunk.isTransferred()) continue;
            redoProgress -= chunk.getSize();
        }
        this.getProgressMonitor().count(redoProgress);
        try {
            this.lastSpeed = 0.0;
            this.nextChunk = 0;
            this.endAdminTaskQueued = false;
            this.queueNextTransferTask();
        }
        catch (IOException e) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    private int retries(FileChunk fileChunk) {
        Integer count = this.chunkRetryCount.get(fileChunk);
        if (null == count) {
            count = 0;
        }
        this.chunkRetryCount.put(fileChunk, count + 1);
        return count;
    }

    public static String inByteFormat(double size) {
        double tmp = size / 1024.0;
        if (tmp < 1.0) {
            return df.format(tmp * 1024.0) + " B";
        }
        if ((tmp /= 1024.0) < 1.0) {
            return df.format(tmp * 1024.0) + " KiB";
        }
        if ((tmp /= 1024.0) < 1.0) {
            return df.format(tmp * 1024.0) + " MiB";
        }
        if ((tmp /= 1024.0) < 1.0) {
            return df.format(tmp * 1024.0) + " GiB";
        }
        return df.format(tmp) + " TiB";
    }

    protected void tearDown() {
        super.tearDown();
    }
}

