/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;

public class DataFileScriptGenerator {
    private static final Class<?> clazz = DataFileScriptGenerator.class;
    private static final String SQUOTE = "'";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String SPACE = " ";
    private static final String EOL = "\n";
    private static final String SOURCE_FILES = "<SourceFiles>";
    private static final String SOURCE_CHUNK_FILES = "<SourceChunkFiles>";
    private static final String TARGET_DIR = "<TargetDir>";
    private static final String LOG_FILE = "<LogFile>";
    private static DecimalFormat df = new DecimalFormat("#0.0000");
    private static final String PASS_TOKEN = "PASSED";
    private static final String CHECK_CHUNK_TOKEN = "CHECK_CHUNK";
    public static final int RESTART_REQUEST = 2;
    public static final int CHECK_CHUNK_REQUEST = 5;

    public static String generatePreTransferScript(List<FileInfo> fileInfos, String targetDir, String logFile) {
        String shellScript = DataFileScriptGenerator.generateScript(fileInfos, targetDir, logFile);
        shellScript = shellScript + "preTransfer\n";
        return shellScript;
    }

    public static String generatePostTransferScript(List<FileInfo> fileInfos, String targetDir, String logFile) {
        String shellScript = DataFileScriptGenerator.generateScript(fileInfos, targetDir, logFile);
        shellScript = shellScript + "postTransfer\n";
        return shellScript;
    }

    public static String generateSignatureCheckScript(List<FileInfo> fileInfos, String targetDir, String logFile) {
        String shellScript = DataFileScriptGenerator.generateScript(fileInfos, targetDir, logFile, false, false);
        shellScript = shellScript + "signatureCheck\n";
        return shellScript;
    }

    private static String generateScript(List<FileInfo> fileInfos, String targetDir, String logFile) {
        return DataFileScriptGenerator.generateScript(fileInfos, targetDir, logFile, true, false);
    }

    private static String generateScript(List<FileInfo> fileInfos, String targetDir, String logFile, boolean includeChunks, boolean chunkCheckRequested) {
        String shellScript = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(DataFileScriptGenerator.class.getResourceAsStream("ShellScript.txt")));
            String line = reader.readLine();
            while (line != null) {
                shellScript = line.contains(SOURCE_FILES) ? shellScript + line.replace(SOURCE_FILES, DataFileScriptGenerator.getSourceFileData(fileInfos)) : (line.contains(SOURCE_CHUNK_FILES) ? (includeChunks ? shellScript + line.replace(SOURCE_CHUNK_FILES, DataFileScriptGenerator.getChunkFileData(fileInfos, chunkCheckRequested)) : shellScript + line.replace(SOURCE_CHUNK_FILES, "('dummy dummy')\n")) : (line.contains(TARGET_DIR) ? shellScript + line.replace(TARGET_DIR, targetDir) : (line.contains(LOG_FILE) ? shellScript + line.replace(LOG_FILE, logFile) : shellScript + line)));
                shellScript = shellScript + EOL;
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            Logger.severe(clazz, (String)"Unable to open script template file.", (Throwable)e);
        }
        return shellScript;
    }

    private static CharSequence getSourceFileData(List<FileInfo> fileInfos) {
        StringBuilder buf = new StringBuilder();
        buf.append(LPAREN).append(EOL);
        for (FileInfo fileInfo : fileInfos) {
            buf.append(SQUOTE);
            buf.append(fileInfo.getPath().getFileName().toString());
            buf.append(SPACE).append(fileInfo.getMd5());
            buf.append(SPACE).append(fileInfo.getFileChunks().size());
            buf.append(SPACE).append(fileInfo.getTargetDir());
            buf.append(SPACE).append(String.valueOf(!fileInfo.isTransferred()));
            buf.append(SPACE).append(fileInfo.getLength());
            buf.append(SQUOTE).append(EOL);
        }
        buf.append(RPAREN).append(EOL);
        return buf.toString();
    }

    private static CharSequence getChunkFileData(List<FileInfo> fileInfos, boolean chunkCheckRequested) {
        StringBuilder buf = new StringBuilder();
        buf.append(LPAREN).append(EOL);
        long start = System.nanoTime();
        for (FileInfo fileInfo : fileInfos) {
            for (FileChunk chunk : fileInfo.getFileChunks()) {
                if (chunkCheckRequested) {
                    if (!chunk.isChunkCheckRequested()) continue;
                    chunk.calculateMd5();
                    buf.append(SQUOTE);
                    buf.append(chunk.getName());
                    buf.append(SPACE).append(chunk.getMd5());
                    buf.append(SQUOTE).append(EOL);
                    continue;
                }
                buf.append(SQUOTE);
                buf.append(chunk.getName());
                buf.append(SPACE).append(chunk.getMd5());
                buf.append(SQUOTE).append(EOL);
            }
        }
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        Logger.info(DataFileScriptGenerator.class, (String)(df.format(elapsed) + " seconds"));
        buf.append(RPAREN).append(EOL);
        return buf.toString();
    }

    public static void evaluate(List<FileInfo> fileInfos, ScriptOutput result) throws IOException, TransferRestartRequest {
        Logger.fine(clazz, (String)("result.stdout = \"" + result.stdout + "\""));
        Logger.fine(clazz, (String)("result.stderr = \"" + result.stderr + "\""));
        Logger.fine(clazz, (String)("result.rc = \"" + result.rc + "\""));
        Map<String, FileInfo> fileMap = DataFileScriptGenerator.getMappedFileList(fileInfos);
        Map<String, FileChunk> chunkMap = DataFileScriptGenerator.getMappedChunkList(fileInfos);
        if (null == result.stdout) {
            throw new IOException("No stdout result to evaluate.");
        }
        BufferedReader logReader = new BufferedReader(new StringReader(result.stdout));
        String line = null;
        for (FileChunk chunk : chunkMap.values()) {
            chunk.setChunkCheckRequested(false);
        }
        while ((line = logReader.readLine()) != null) {
            if (!line.startsWith(PASS_TOKEN) && !line.startsWith(CHECK_CHUNK_TOKEN)) continue;
            String[] words = line.split(SPACE);
            if (words.length != 2) {
                throw new IOException("Invalid result log format: " + line);
            }
            String name = words[1];
            FileInfo fileInfo = fileMap.get(name);
            if (fileInfo != null) {
                fileInfo.setTransferred(true);
                for (FileChunk chunk : fileInfo.getFileChunks()) {
                    chunk.setTransferred(true);
                }
                continue;
            }
            FileChunk chunk = chunkMap.get(name);
            if (chunk != null) {
                if (line.startsWith(PASS_TOKEN)) {
                    chunk.setTransferred(true);
                    continue;
                }
                if (!line.startsWith(CHECK_CHUNK_TOKEN)) continue;
                chunk.setChunkCheckRequested(true);
                continue;
            }
            throw new IOException("FileChunk not found: " + name);
        }
        if (2 == result.rc) {
            throw new TransferRestartRequest();
        }
        if (5 != result.rc && result.rc != 0) {
            throw new IOException(result.stderr);
        }
    }

    public static Map<String, FileInfo> getMappedFileList(List<FileInfo> fileInfos) {
        HashMap<String, FileInfo> files = new HashMap<String, FileInfo>();
        for (FileInfo fileInfo : fileInfos) {
            files.put(fileInfo.getPath().getFileName().toString(), fileInfo);
        }
        return files;
    }

    public static Map<String, FileChunk> getMappedChunkList(List<FileInfo> fileInfos) {
        HashMap<String, FileChunk> chunks = new HashMap<String, FileChunk>();
        for (FileInfo fileInfo : fileInfos) {
            for (FileChunk chunk : fileInfo.getFileChunks()) {
                chunks.put(chunk.getName(), chunk);
            }
        }
        return chunks;
    }

    public static String generateChunkCheckScript(List<FileInfo> fileInfos, String targetDir, String logFile) {
        String shellScript = DataFileScriptGenerator.generateScript(fileInfos, targetDir, logFile, true, true);
        shellScript = shellScript + "md5sum_check SourceChunkFiles\n";
        return shellScript;
    }
}

