/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.completer.Completer;
import jline.internal.Configuration;
import jline.internal.Preconditions;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class FileNameCompleter
implements Completer {
    private ScriptRunnerContext _ctx;
    private static final boolean OS_IS_WINDOWS;

    public FileNameCompleter(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        File file;
        if (buffer == null) {
            buffer = "";
        } else if (!(buffer.toLowerCase().startsWith("@") || buffer.toLowerCase().startsWith("start") || buffer.toLowerCase().startsWith("!") || buffer.toLowerCase().startsWith("host") || buffer.toLowerCase().startsWith("load") || buffer.toLowerCase().startsWith("cd") || buffer.toLowerCase().startsWith("get") || buffer.toLowerCase().startsWith("save") || buffer.toLowerCase().startsWith("store"))) {
            return -1;
        }
        Preconditions.checkNotNull(candidates);
        if (OS_IS_WINDOWS) {
            buffer = buffer.replace('/', '\\');
        }
        String[] tokens = buffer.split("\\s+|@");
        int tokenAtCursor = this.getTokenAtcursor(tokens, buffer, cursor);
        String translated = "";
        if (tokens.length > 0) {
            translated = tokens[tokenAtCursor];
        }
        String token2Complete = translated;
        File homeDir = this.getUserHome();
        if (translated.startsWith("~") || translated.startsWith("~" + this.separator())) {
            try {
                translated = translated.replaceFirst("~", homeDir.getCanonicalPath());
            }
            catch (IOException iOException) {}
        } else if (!new File(translated).isAbsolute()) {
            String cwd = this.getUserDir().getAbsolutePath();
            translated = cwd + this.separator() + translated;
        } else if (!new File(translated).isDirectory()) {
            String tmp = this._ctx.prependCD(translated.substring(1));
            if (!new File(tmp).isDirectory()) {
                int pos = translated.lastIndexOf(File.separator) + File.separator.length();
                token2Complete = translated.substring(0, pos);
            } else {
                translated = tmp;
            }
        }
        if (translated.endsWith("..")) {
            translated = translated + File.separator;
            ++cursor;
            buffer = buffer.replace("..", "../");
            token2Complete = token2Complete + File.separator;
            candidates.add("../");
        }
        File dir = (file = new File(translated)).isDirectory() ? file : file.getParentFile();
        File[] entries = dir == null ? new File[]{} : dir.listFiles();
        return this.matchFiles(buffer, cursor, token2Complete, translated, entries, candidates);
    }

    private int getTokenAtcursor(String[] tokens, String buffer, int cursor) {
        for (int y = 0; y < tokens.length; ++y) {
            String regex = tokens[y];
            if (regex.trim().length() <= 0) continue;
            regex = regex.replace("\\", "\\\\");
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(buffer);
            while (m.find()) {
                if (m.start() > cursor || cursor > m.end()) continue;
                return y;
            }
        }
        return 0;
    }

    protected String separator() {
        return File.separator;
    }

    protected File getUserHome() {
        return Configuration.getUserHome();
    }

    protected File getUserDir() {
        return new File(this._ctx.prependCD(""));
    }

    protected int matchFiles(String buffer, int cursor, String token2Complete, String translated, File[] files, List<CharSequence> candidates) {
        if (files == null) {
            return -1;
        }
        int matches = 0;
        for (File file : files) {
            if (!file.getAbsolutePath().startsWith(translated)) continue;
            ++matches;
        }
        for (File file : files) {
            if (!file.getAbsolutePath().startsWith(translated)) continue;
            String name = file.getName() + (matches == 1 && file.isDirectory() ? this.separator() : " ");
            candidates.add(this.render(file, name).toString());
        }
        if (token2Complete.contains(File.separator)) {
            return buffer.lastIndexOf(File.separator) + File.separator.length();
        }
        return cursor - token2Complete.length();
    }

    protected CharSequence render(File file, CharSequence name) {
        return name;
    }

    static {
        String os = Configuration.getOsName();
        OS_IS_WINDOWS = os.contains("windows");
    }
}

