/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.clone;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import jline.NoInterruptUnixTerminal;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.CursorBuffer;
import jline.console.KillRing;
import jline.console.completer.Completer;
import jline.console.history.History;
import jline.internal.Configuration;
import jline.internal.InputStreamReader;
import jline.internal.Log;
import jline.internal.Nullable;
import jline.internal.Preconditions;
import jline.internal.Urls;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.console.clone.CandidateListCompletionHandler;
import oracle.dbtools.raptor.console.clone.CompletionHandler;
import oracle.dbtools.raptor.console.clone.ConsoleKeys;
import oracle.dbtools.raptor.console.clone.DbtoolsNonBlockingInputStream;
import oracle.dbtools.raptor.console.clone.IAcceptTypeHandler;
import oracle.dbtools.raptor.console.clone.KeyMap;
import oracle.dbtools.raptor.console.clone.Operation;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.IndexBuilder;
import oracle.dbtools.raptor.utils.IsATTYWrap;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiOutputStream;

public class DbtoolsConsoleReader {
    public int maxBufferDrawn = 1;
    private IBuffer multilineBuffer = null;
    protected boolean editNow = false;
    public static final String JLINE_NOBELL = "jline.nobell";
    public static final String JLINE_ESC_TIMEOUT = "jline.esc.timeout";
    public static final String JLINE_INPUTRC = "jline.inputrc";
    public static final String INPUT_RC = ".inputrc";
    public static final String DEFAULT_INPUT_RC = "/etc/inputrc";
    public static final char BACKSPACE = '\b';
    public static final char RESET_LINE = '\r';
    public static final char KEYBOARD_BELL = '\u0007';
    public static final char NULL_MASK = '\u0000';
    public static final int TAB_WIDTH = 4;
    private final Terminal terminal;
    private Writer out;
    private final CursorBuffer buf = new CursorBuffer();
    private String prompt;
    private int promptLen;
    private boolean expandEvents = true;
    private boolean bellEnabled = !Configuration.getBoolean((String)"jline.nobell", (boolean)true);
    private boolean handleUserInterrupt = false;
    private Character mask;
    private Character echoCharacter;
    private StringBuffer searchTerm = null;
    private String previousSearchTerm = "";
    private int searchIndex = -1;
    private DbtoolsNonBlockingInputStream in;
    private long escapeTimeout;
    private Reader reader;
    private char charSearchChar = '\u0000';
    private char charSearchLastInvokeChar = '\u0000';
    private char charSearchFirstInvokeChar = '\u0000';
    private String yankBuffer = "";
    private KillRing killRing = new KillRing();
    private String encoding;
    private String outEncoding;
    private boolean recording;
    private String macro = "";
    private String appName;
    private URL inputrcUrl;
    private ConsoleKeys consoleKeys;
    private String commentBegin = null;
    private boolean skipLF = false;
    private boolean copyPasteDetection = false;
    private State state = State.NORMAL;
    protected boolean historyReturned = false;
    private String basePrompt = "";
    protected Redraw redrawDetails;
    private boolean redrawComplete;
    private boolean runNow = false;
    private boolean clearCompletions = false;
    private IAcceptTypeHandler acceptHandler = null;
    public static final String JLINE_COMPLETION_THRESHOLD = "jline.completion.threshold";
    private final List<Completer> completers = new LinkedList<Completer>();
    private CompletionHandler completionHandler = new CandidateListCompletionHandler();
    private int autoprintThreshold = Configuration.getInteger((String)"jline.completion.threshold", (int)100);
    private boolean paginationEnabled;
    private MultiLineHistory history = null;
    private boolean historyEnabled = true;
    public static final String CR = Configuration.getLineSeparator();
    private final Map<Character, ActionListener> triggeredActions = new HashMap<Character, ActionListener>();
    private Thread maskThread;
    protected boolean fullRedraw = false;
    private String clearScreenMode = "top";

    public boolean justDidHistory() {
        return this.historyReturned;
    }

    public void resetHistoryFlag() {
        this.historyReturned = false;
    }

    public DbtoolsConsoleReader() throws IOException {
        this(null, new FileInputStream(FileDescriptor.in), System.out, null);
    }

    public DbtoolsConsoleReader(InputStream in, OutputStream out) throws IOException {
        this(null, in, out, null);
    }

    public DbtoolsConsoleReader(InputStream in, OutputStream out, Terminal term) throws IOException {
        this(null, in, out, term);
    }

    public DbtoolsConsoleReader(@Nullable String appName, InputStream in, OutputStream out, @Nullable Terminal term) throws IOException {
        this(appName, in, out, term, null);
    }

    public DbtoolsConsoleReader(@Nullable String appName, InputStream in, OutputStream out, @Nullable Terminal term, @Nullable String encoding) throws IOException {
        this.appName = appName != null ? appName : "JLine";
        String string = this.encoding = encoding != null ? encoding : Configuration.getEncoding();
        if (System.getProperty("os.name").startsWith("Windows") && IsATTYWrap.isSTDINATTY() == 0) {
            TerminalFactory.registerFlavor((TerminalFactory.Flavor)TerminalFactory.Flavor.UNIX, NoInterruptUnixTerminal.class);
            this.terminal = term != null ? term : new LikeTerminal(){
                Terminal t = TerminalFactory.get();

                public void disableInterruptCharacter() {
                }

                public void enableInterruptCharacter() {
                }

                @Override
                public Terminal getT() {
                    return this.t;
                }

                @Override
                public InputStream wrapInIfNeeded(InputStream in) throws IOException {
                    return in;
                }
            };
        } else {
            TerminalFactory.registerFlavor((TerminalFactory.Flavor)TerminalFactory.Flavor.UNIX, NoInterruptUnixTerminal.class);
            this.terminal = term != null ? term : TerminalFactory.get();
        }
        this.outEncoding = this.terminal.getOutputEncoding() != null ? this.terminal.getOutputEncoding() : this.encoding;
        this.out = new OutputStreamWriter(this.terminal.wrapOutIfNeeded(out), this.outEncoding);
        this.setInput(in);
        this.inputrcUrl = this.getInputRc();
        this.consoleKeys = new ConsoleKeys(this.appName, this.inputrcUrl);
        this.in.setKeyMap(this.consoleKeys.getKeys());
    }

    public void setBasePrompt(String prompt) {
        this.basePrompt = prompt;
    }

    private URL getInputRc() throws IOException {
        String path = Configuration.getString((String)JLINE_INPUTRC);
        if (path == null) {
            File f = new File(Configuration.getUserHome(), INPUT_RC);
            if (!f.exists()) {
                f = new File(DEFAULT_INPUT_RC);
            }
            return f.toURI().toURL();
        }
        return Urls.create((String)path);
    }

    public KeyMap getKeys() {
        return this.consoleKeys.getKeys();
    }

    void setInput(InputStream in) throws IOException {
        boolean nonBlockingEnabled;
        this.escapeTimeout = Configuration.getLong((String)JLINE_ESC_TIMEOUT, (long)100L);
        boolean bl = nonBlockingEnabled = this.escapeTimeout > 0L && this.terminal.isSupported() && in != null;
        if (this.in != null) {
            this.in.shutdown();
        }
        InputStream wrapped = this.terminal.wrapInIfNeeded(in);
        this.in = DbtoolsNonBlockingInputStream.getInstance(wrapped, nonBlockingEnabled);
        this.reader = new InputStreamReader((InputStream)this.in, this.encoding);
    }

    public void shutdown() {
        if (this.in != null) {
            this.in.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    public InputStream getInput() {
        return this.in;
    }

    public Writer getOutput() {
        return this.out;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public CursorBuffer getCursorBuffer() {
        return this.buf;
    }

    public void setExpandEvents(boolean expand) {
        this.expandEvents = expand;
    }

    public boolean getExpandEvents() {
        return this.expandEvents;
    }

    public void setCopyPasteDetection(boolean onoff) {
        this.copyPasteDetection = onoff;
    }

    public boolean isCopyPasteDetectionEnabled() {
        return this.copyPasteDetection;
    }

    public void setBellEnabled(boolean enabled) {
        this.bellEnabled = enabled;
    }

    public boolean getBellEnabled() {
        return this.bellEnabled;
    }

    public void setHandleUserInterrupt(boolean enabled) {
        this.handleUserInterrupt = enabled;
    }

    public boolean getHandleUserInterrupt() {
        return this.handleUserInterrupt;
    }

    public void setCommentBegin(String commentBegin) {
        this.commentBegin = commentBegin;
    }

    public String getCommentBegin() {
        String str = this.commentBegin;
        if (str == null && (str = this.consoleKeys.getVariable("comment-begin")) == null) {
            str = "#";
        }
        return str;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.promptLen = prompt == null ? 0 : this.getPromptLength(this.stripAnsi(this.lastLine(prompt)));
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setEchoCharacter(Character c) {
        this.echoCharacter = c;
    }

    public Character getEchoCharacter() {
        return this.echoCharacter;
    }

    protected final boolean resetLine() throws IOException {
        char c;
        if (this.buf.cursor == 0) {
            return false;
        }
        StringBuilder killed = new StringBuilder();
        while (this.buf.cursor > 0 && (c = this.buf.current()) != '\u0000') {
            killed.append(c);
            this.backspace();
        }
        String copy = killed.reverse().toString();
        this.killRing.addBackwards(copy);
        return true;
    }

    int getCursorPosition() {
        return this.promptLen + this.buf.cursor;
    }

    private String lastLine(String str) {
        if (str == null) {
            return "";
        }
        int last = str.lastIndexOf("\n");
        if (last >= 0) {
            return str.substring(last + 1, str.length());
        }
        return str;
    }

    private String stripAnsiNo32(String str) {
        if (str == null) {
            return "";
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AnsiOutputStream aos = new AnsiOutputStream(baos){

                public void processCursorRight(int count) throws IOException {
                }
            };
            aos.write(str.getBytes());
            aos.flush();
            return baos.toString();
        }
        catch (IOException e) {
            return str;
        }
    }

    private String stripAnsi(String str) {
        if (str == null) {
            return "";
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AnsiOutputStream aos = new AnsiOutputStream((OutputStream)baos);
            aos.write(str.getBytes());
            aos.flush();
            return baos.toString();
        }
        catch (IOException e) {
            return str;
        }
    }

    public final boolean setCursorPosition(int position) throws IOException {
        if (position == this.buf.cursor) {
            return true;
        }
        return this.moveCursor(position - this.buf.cursor) != 0;
    }

    public void setBuffer(String buffer) throws IOException {
        if (buffer.equals(this.buf.buffer.toString())) {
            return;
        }
        int sameIndex = 0;
        int l1 = buffer.length();
        int l2 = this.buf.buffer.length();
        for (int i = 0; i < l1 && i < l2 && buffer.charAt(i) == this.buf.buffer.charAt(i); ++i) {
            ++sameIndex;
        }
        int diff = this.buf.cursor - sameIndex;
        if (diff < 0) {
            this.moveToEnd();
            diff = this.buf.buffer.length() - sameIndex;
        }
        this.backspace(diff);
        this.killLine();
        this.buf.buffer.setLength(sameIndex);
        this.putString(buffer.substring(sameIndex));
    }

    private void setBuffer(CharSequence buffer) throws IOException {
        this.setBuffer(String.valueOf(buffer));
    }

    private void setBufferKeepPos(String buffer) throws IOException {
        int pos = this.buf.cursor;
        this.setBuffer(buffer);
        this.setCursorPosition(pos);
    }

    private void setBufferKeepPos(CharSequence buffer) throws IOException {
        this.setBufferKeepPos(String.valueOf(buffer));
    }

    public final void drawLine() throws IOException {
        String prompt = this.getPrompt();
        if (prompt != null) {
            this.print(prompt);
        }
        this.print(this.buf.buffer.toString());
        if (this.buf.length() != this.buf.cursor) {
            this.back(this.buf.length() - this.buf.cursor - 1);
        }
        this.drawBuffer();
    }

    public final void redrawLine() throws IOException {
        this.print(13);
        this.drawLine();
    }

    final String finishBuffer() throws IOException {
        String str;
        String historyLine = str = this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine());
        if (this.expandEvents) {
            try {
                str = this.expandEvents(str);
                historyLine = str.replace("!", "\\!");
                historyLine = historyLine.replaceAll("^\\^", "\\\\^");
            }
            catch (IllegalArgumentException e) {
                Log.error((Object[])new Object[]{"Could not expand event", e});
                this.beep();
                this.buf.clear();
                str = "";
            }
        }
        this.mask = null;
        this.history.moveToEnd();
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return str;
    }

    protected String expandEvents(String str) throws IOException {
        StringBuilder sb = new StringBuilder();
        block16: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    char nextChar;
                    if (i + 1 < str.length() && ((nextChar = str.charAt(i + 1)) == '!' || nextChar == '^' && i == 0)) {
                        c = nextChar;
                        ++i;
                    }
                    sb.append(c);
                    continue block16;
                }
                case '!': {
                    if (i + 1 < str.length()) {
                        c = str.charAt(++i);
                        boolean neg = false;
                        String rep = null;
                        switch (c) {
                            case '!': {
                                if (this.history.size() == 0) {
                                    throw new IllegalArgumentException("!!: event not found");
                                }
                                rep = this.history.get(this.history.index() - 1).toString();
                                break;
                            }
                            case '#': {
                                sb.append(sb.toString());
                                break;
                            }
                            case '?': {
                                int i1 = str.indexOf(63, i + 1);
                                if (i1 < 0) {
                                    i1 = str.length();
                                }
                                String sc = str.substring(i + 1, i1);
                                i = i1;
                                int idx = this.searchBackwards(sc);
                                if (idx < 0) {
                                    throw new IllegalArgumentException("!?" + sc + ": event not found");
                                }
                                rep = this.history.get(idx).toString();
                                break;
                            }
                            case '$': {
                                if (this.history.size() == 0) {
                                    throw new IllegalArgumentException("!$: event not found");
                                }
                                String previous = this.history.get(this.history.index() - 1).toString().trim();
                                int lastSpace = previous.lastIndexOf(32);
                                if (lastSpace != -1) {
                                    rep = previous.substring(lastSpace + 1);
                                    break;
                                }
                                rep = previous;
                                break;
                            }
                            case '\t': 
                            case ' ': {
                                sb.append('!');
                                sb.append(c);
                                break;
                            }
                            case '-': {
                                neg = true;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int i1 = ++i;
                                while (i < str.length() && (c = str.charAt(i)) >= '0' && c <= '9') {
                                    ++i;
                                }
                                int idx = 0;
                                try {
                                    idx = Integer.parseInt(str.substring(i1, i));
                                }
                                catch (NumberFormatException e) {
                                    throw new IllegalArgumentException((neg ? "!-" : "!") + str.substring(i1, i) + ": event not found");
                                }
                                if (neg) {
                                    if (idx > 0 && idx <= this.history.size()) {
                                        rep = this.history.get(this.history.index() - idx).toString();
                                        break;
                                    }
                                    throw new IllegalArgumentException((neg ? "!-" : "!") + str.substring(i1, i) + ": event not found");
                                }
                                if (idx > this.history.index() - this.history.size() && idx <= this.history.index()) {
                                    rep = this.history.get(idx - 1).toString();
                                    break;
                                }
                                throw new IllegalArgumentException((neg ? "!-" : "!") + str.substring(i1, i) + ": event not found");
                            }
                            default: {
                                String ss = str.substring(i);
                                i = str.length();
                                int idx = this.searchBackwards(ss, this.history.index(), true);
                                if (idx < 0) {
                                    throw new IllegalArgumentException("!" + ss + ": event not found");
                                }
                                rep = this.history.get(idx).toString();
                            }
                        }
                        if (rep == null) continue block16;
                        sb.append(rep);
                        continue block16;
                    }
                    sb.append(c);
                    continue block16;
                }
                case '^': {
                    if (i == 0) {
                        int i1 = str.indexOf(94, i + 1);
                        int i2 = str.indexOf(94, i1 + 1);
                        if (i2 < 0) {
                            i2 = str.length();
                        }
                        if (i1 > 0 && i2 > 0) {
                            String s1 = str.substring(i + 1, i1);
                            String s2 = str.substring(i1 + 1, i2);
                            String s = this.history.get(this.history.index() - 1).toString().replace(s1, s2);
                            sb.append(s);
                            i = i2 + 1;
                            continue block16;
                        }
                    }
                    sb.append(c);
                    continue block16;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String result = sb.toString();
        if (!str.equals(result)) {
            this.print(result);
            this.println();
            this.flush();
        }
        return result;
    }

    public final void putString(CharSequence str) throws IOException {
        this.buf.write(str);
        if (this.mask == null) {
            this.print(str);
        } else if (this.mask.charValue() != '\u0000') {
            this.print(this.mask.charValue(), str.length());
        }
        this.drawBuffer();
    }

    private void drawBuffer(int clear) throws IOException {
        if (this.buf.cursor > this.buf.length()) {
            this.buf.cursor = this.buf.length();
        }
        if (this.buf.cursor < 0) {
            this.buf.cursor = 0;
        }
        if (this.buf.cursor != this.buf.length() || clear != 0) {
            char[] chars = this.buf.buffer.substring(this.buf.cursor).toCharArray();
            if (this.mask != null) {
                Arrays.fill(chars, this.mask.charValue());
            }
            if (this.terminal.hasWeirdWrap()) {
                int width = this.terminal.getWidth();
                int pos = this.getCursorPosition();
                for (int i = 0; i < chars.length; ++i) {
                    this.print((int)chars[i]);
                    if ((pos + i + 1) % width != 0) continue;
                    this.print(32);
                    this.print(13);
                }
            } else {
                this.print(chars);
            }
            this.clearAhead(clear, chars.length);
            if (this.terminal.isAnsiSupported()) {
                if (chars.length > 0) {
                    this.back(chars.length);
                }
            } else {
                this.back(chars.length);
            }
        }
        if (this.terminal.hasWeirdWrap()) {
            int width = this.terminal.getWidth();
            if (this.getCursorPosition() > 0 && this.getCursorPosition() % width == 0 && this.buf.cursor == this.buf.length() && clear == 0) {
                this.print(32);
                this.print(13);
            }
        }
    }

    private void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private void clearAhead(int num, int delta) throws IOException {
        if (num == 0) {
            return;
        }
        if (this.terminal.isAnsiSupported()) {
            int i;
            int width = this.terminal.getWidth();
            int screenCursorCol = this.getCursorPosition() + delta;
            this.printAnsiSequence("K");
            int curCol = screenCursorCol % width;
            int endCol = (screenCursorCol + num - 1) % width;
            int lines = num / width;
            if (endCol < curCol) {
                ++lines;
            }
            for (i = 0; i < lines; ++i) {
                this.printAnsiSequence("B");
                this.printAnsiSequence("2K");
            }
            for (i = 0; i < lines; ++i) {
                this.printAnsiSequence("A");
            }
            return;
        }
        this.print(' ', num);
        this.back(num);
    }

    protected void back(int num) throws IOException {
        if (num == 0) {
            return;
        }
        if (this.terminal.isAnsiSupported()) {
            int width = this.getTerminal().getWidth();
            int cursor = this.getCursorPosition();
            int realCursor = cursor + num;
            int realCol = realCursor % width;
            int newCol = cursor % width;
            int moveup = num / width;
            int delta = realCol - newCol;
            if (delta < 0) {
                ++moveup;
            }
            if (moveup > 0) {
                this.printAnsiSequence(moveup + "A");
            }
            this.printAnsiSequence(1 + newCol + "G");
            return;
        }
        this.print('\b', num);
    }

    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (Exception e) {
            try {
                this.out = new OutputStreamWriter(this.terminal.wrapOutIfNeeded((OutputStream)System.out), this.outEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public void write(char[] chars) {
        try {
            this.out.write(chars);
        }
        catch (Exception e) {
            try {
                this.out = new OutputStreamWriter(this.terminal.wrapOutIfNeeded((OutputStream)System.out), this.outEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private void write(int c) {
        try {
            this.out.write(c);
        }
        catch (Exception e) {
            try {
                this.out = new OutputStreamWriter(this.terminal.wrapOutIfNeeded((OutputStream)System.out), this.outEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private void write(String string) {
        try {
            this.out.write(string);
        }
        catch (Exception e) {
            try {
                this.out = new OutputStreamWriter(this.terminal.wrapOutIfNeeded((OutputStream)System.out), this.outEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private int backspaceAll() throws IOException {
        return this.backspace(Integer.MAX_VALUE);
    }

    private int backspace(int num) throws IOException {
        if (this.buf.cursor == 0) {
            if (num > 0 && this.multilineBuffer.getCurrentLine() > 1) {
                String s = this.buf.buffer.toString();
                this.multilineBuffer.delete(this.multilineBuffer.getCurrentLine());
                this.multilineBuffer.setCurrentLine(this.multilineBuffer.getCurrentLine() - 1);
                int cursorPos = this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length();
                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()) + s);
                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.UP, cursorPos, 0, CursorState.NORMAL, true);
                this.redrawDetails.setDontReDraw(false);
                this.fullRedraw = true;
                this.clearBufferLines();
            }
            return 0;
        }
        int count = 0;
        int termwidth = this.getTerminal().getWidth();
        int lines = this.getCursorPosition() / termwidth;
        count = this.moveCursor(-1 * num) * -1;
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + count);
        this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
        if (this.getCursorPosition() / termwidth != lines && this.terminal.isAnsiSupported()) {
            this.printAnsiSequence("K");
        }
        this.drawBuffer(count);
        return count;
    }

    public boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    protected boolean moveToEnd() throws IOException {
        if (this.buf.cursor == this.buf.length()) {
            return true;
        }
        return this.moveCursor(this.buf.length() - this.buf.cursor) > 0;
    }

    private boolean deleteCurrentCharacter() throws IOException {
        if (this.buf.length() == 0 || this.buf.cursor == this.buf.length()) {
            if (this.multilineBuffer.getCurrentLine() >= 1 && this.multilineBuffer.getCurrentLine() < this.multilineBuffer.size()) {
                int cursorPos = this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length();
                String previous = this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine());
                String next = this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine() + 1);
                this.multilineBuffer.delete(this.multilineBuffer.getCurrentLine() + 1);
                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), previous + " " + next);
                this.multilineBuffer.setTermLine(this.multilineBuffer.getTermLine() + 1, this.getTerminal().getHeight());
                this.buf.buffer.setLength(0);
                this.buf.buffer.append(previous + next);
                this.buf.cursor = previous.length();
                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.DOWN, cursorPos, 0, CursorState.NORMAL, false);
                this.redrawDetails.setDontReDraw(false);
                this.fullRedraw = true;
                this.clearBufferLines();
                this.redrawBuffer(this.redrawDetails, this.multilineBuffer);
            }
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private void clearBufferLines() {
        try {
            if (this.multilineBuffer.size() - 1 > 0) {
                this.write(Ansi.ansi().cursorUp(this.multilineBuffer.size() - 1).toString());
                this.flush();
            }
            for (int i = 0; i < this.multilineBuffer.size() - 1; ++i) {
                try {
                    this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
                    this.flush();
                    this.write(Ansi.ansi().cursorDown(1).toString());
                    this.flush();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean viRubout(int count) throws IOException {
        boolean ok = true;
        for (int i = 0; ok && i < count; ++i) {
            ok = this.backspace();
        }
        return ok;
    }

    private boolean viDelete(int count) throws IOException {
        boolean ok = true;
        for (int i = 0; ok && i < count; ++i) {
            ok = this.deleteCurrentCharacter();
        }
        return ok;
    }

    private boolean viChangeCase(int count) throws IOException {
        boolean ok = true;
        for (int i = 0; ok && i < count; ++i) {
            boolean bl = ok = this.buf.cursor < this.buf.buffer.length();
            if (!ok) continue;
            char ch = this.buf.buffer.charAt(this.buf.cursor);
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            } else if (Character.isLowerCase(ch)) {
                ch = Character.toUpperCase(ch);
            }
            this.buf.buffer.setCharAt(this.buf.cursor, ch);
            this.drawBuffer(1);
            this.moveCursor(1);
        }
        return ok;
    }

    private boolean viChangeChar(int count, int c) throws IOException {
        if (c < 0 || c == 27 || c == 3) {
            return true;
        }
        boolean ok = true;
        for (int i = 0; ok && i < count; ++i) {
            boolean bl = ok = this.buf.cursor < this.buf.buffer.length();
            if (!ok) continue;
            this.buf.buffer.setCharAt(this.buf.cursor, (char)c);
            this.drawBuffer(1);
            if (i >= count - 1) continue;
            this.moveCursor(1);
        }
        return ok;
    }

    private boolean viPreviousWord(int count) throws IOException {
        boolean ok = true;
        if (this.buf.cursor == 0) {
            return false;
        }
        int pos = this.buf.cursor - 1;
        for (int i = 0; pos > 0 && i < count; ++i) {
            while (pos > 0 && this.isWhitespace(this.buf.buffer.charAt(pos))) {
                --pos;
            }
            while (pos > 0 && !this.isDelimiter(this.buf.buffer.charAt(pos - 1))) {
                --pos;
            }
            if (pos <= 0 || i >= count - 1) continue;
            --pos;
        }
        this.setCursorPosition(pos);
        return ok;
    }

    private boolean viDeleteTo(int startPos, int endPos, boolean isChange) throws IOException {
        if (startPos == endPos) {
            return true;
        }
        if (endPos < startPos) {
            int tmp = endPos;
            endPos = startPos;
            startPos = tmp;
        }
        this.setCursorPosition(startPos);
        this.buf.cursor = startPos;
        this.buf.buffer.delete(startPos, endPos);
        this.drawBuffer(endPos - startPos);
        if (!isChange && startPos > 0 && startPos == this.buf.length()) {
            this.moveCursor(-1);
        }
        return true;
    }

    private boolean viYankTo(int startPos, int endPos) throws IOException {
        int cursorPos = startPos;
        if (endPos < startPos) {
            int tmp = endPos;
            endPos = startPos;
            startPos = tmp;
        }
        if (startPos == endPos) {
            this.yankBuffer = "";
            return true;
        }
        this.yankBuffer = this.buf.buffer.substring(startPos, endPos);
        this.setCursorPosition(cursorPos);
        return true;
    }

    private boolean viPut(int count) throws IOException {
        if (this.yankBuffer.length() == 0) {
            return true;
        }
        if (this.buf.cursor < this.buf.buffer.length()) {
            this.moveCursor(1);
        }
        for (int i = 0; i < count; ++i) {
            this.putString(this.yankBuffer);
        }
        this.moveCursor(-1);
        return true;
    }

    private boolean viCharSearch(int count, int invokeChar, int ch) throws IOException {
        if (ch < 0 || invokeChar < 0) {
            return false;
        }
        char searchChar = (char)ch;
        if (invokeChar == 59 || invokeChar == 44) {
            if (this.charSearchChar == '\u0000') {
                return false;
            }
            if (this.charSearchLastInvokeChar == ';' || this.charSearchLastInvokeChar == ',') {
                if (this.charSearchLastInvokeChar != invokeChar) {
                    this.charSearchFirstInvokeChar = this.switchCase(this.charSearchFirstInvokeChar);
                }
            } else if (invokeChar == 44) {
                this.charSearchFirstInvokeChar = this.switchCase(this.charSearchFirstInvokeChar);
            }
            searchChar = this.charSearchChar;
        } else {
            this.charSearchChar = searchChar;
            this.charSearchFirstInvokeChar = (char)invokeChar;
        }
        this.charSearchLastInvokeChar = (char)invokeChar;
        boolean isForward = Character.isLowerCase(this.charSearchFirstInvokeChar);
        boolean stopBefore = Character.toLowerCase(this.charSearchFirstInvokeChar) == 't';
        boolean ok = false;
        if (isForward) {
            block0: while (count-- > 0) {
                for (int pos = this.buf.cursor + 1; pos < this.buf.buffer.length(); ++pos) {
                    if (this.buf.buffer.charAt(pos) != searchChar) continue;
                    this.setCursorPosition(pos);
                    ok = true;
                    continue block0;
                }
            }
            if (ok) {
                if (stopBefore) {
                    this.moveCursor(-1);
                }
                if (this.isInViMoveOperationState()) {
                    this.moveCursor(1);
                }
            }
        } else {
            block2: while (count-- > 0) {
                for (int pos = this.buf.cursor - 1; pos >= 0; --pos) {
                    if (this.buf.buffer.charAt(pos) != searchChar) continue;
                    this.setCursorPosition(pos);
                    ok = true;
                    continue block2;
                }
            }
            if (ok && stopBefore) {
                this.moveCursor(1);
            }
        }
        return ok;
    }

    private char switchCase(char ch) {
        if (Character.isUpperCase(ch)) {
            return Character.toLowerCase(ch);
        }
        return Character.toUpperCase(ch);
    }

    private final boolean isInViMoveOperationState() {
        return this.state == State.VI_CHANGE_TO || this.state == State.VI_DELETE_TO || this.state == State.VI_YANK_TO;
    }

    private boolean viNextWord(int count) throws IOException {
        int pos = this.buf.cursor;
        int end = this.buf.buffer.length();
        for (int i = 0; pos < end && i < count; ++i) {
            while (pos < end && !this.isDelimiter(this.buf.buffer.charAt(pos))) {
                ++pos;
            }
            if (i >= count - 1 && this.state == State.VI_CHANGE_TO) continue;
            while (pos < end && this.isDelimiter(this.buf.buffer.charAt(pos))) {
                ++pos;
            }
        }
        this.setCursorPosition(pos);
        return true;
    }

    private boolean viEndWord(int count) throws IOException {
        int pos = this.buf.cursor;
        int end = this.buf.buffer.length();
        for (int i = 0; pos < end && i < count; ++i) {
            if (pos < end - 1 && !this.isDelimiter(this.buf.buffer.charAt(pos)) && this.isDelimiter(this.buf.buffer.charAt(pos + 1))) {
                ++pos;
            }
            while (pos < end && this.isDelimiter(this.buf.buffer.charAt(pos))) {
                ++pos;
            }
            while (pos < end - 1 && !this.isDelimiter(this.buf.buffer.charAt(pos + 1))) {
                ++pos;
            }
        }
        this.setCursorPosition(pos);
        return true;
    }

    private boolean previousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private boolean nextWord() throws IOException {
        while (this.isDelimiter(this.buf.nextChar()) && this.moveCursor(1) != 0) {
        }
        while (!this.isDelimiter(this.buf.nextChar()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private boolean unixWordRubout(int count) throws IOException {
        boolean success = true;
        StringBuilder killed = new StringBuilder();
        while (count > 0) {
            char c;
            if (this.buf.cursor == 0) {
                success = false;
                break;
            }
            while (this.isWhitespace(this.buf.current()) && (c = this.buf.current()) != '\u0000') {
                killed.append(c);
                this.backspace();
            }
            while (!this.isWhitespace(this.buf.current()) && (c = this.buf.current()) != '\u0000') {
                killed.append(c);
                this.backspace();
            }
            --count;
        }
        String copy = killed.reverse().toString();
        this.killRing.addBackwards(copy);
        return success;
    }

    private String insertComment(boolean isViMode) throws IOException {
        String comment = this.getCommentBegin();
        this.setCursorPosition(0);
        this.putString(comment);
        if (isViMode) {
            this.consoleKeys.setKeyMap("vi-insert");
        }
        return this.accept();
    }

    private boolean insert(int count, CharSequence str) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.buf.write(str);
            if (this.mask == null) {
                this.print(str);
                continue;
            }
            if (this.mask.charValue() == '\u0000') continue;
            this.print(this.mask.charValue(), str.length());
        }
        this.drawBuffer();
        return true;
    }

    private int viSearch(char searchChar) throws IOException {
        int i;
        int start;
        boolean isForward = searchChar == '/';
        CursorBuffer origBuffer = this.buf.copy();
        this.setCursorPosition(0);
        this.killLine();
        this.putString(Character.toString(searchChar));
        this.flush();
        boolean isAborted = false;
        boolean isComplete = false;
        int ch = -1;
        while (!isAborted && !isComplete && (ch = this.readCharacter()) != -1) {
            switch (ch) {
                case 27: {
                    isAborted = true;
                    break;
                }
                case 8: 
                case 127: {
                    this.backspace();
                    if (this.buf.cursor != 0) break;
                    isAborted = true;
                    break;
                }
                case 10: 
                case 13: {
                    isComplete = true;
                    break;
                }
                default: {
                    this.putString(Character.toString((char)ch));
                }
            }
            this.flush();
        }
        if (ch == -1 || isAborted) {
            this.setCursorPosition(0);
            this.killLine();
            this.putString(origBuffer.buffer);
            this.setCursorPosition(origBuffer.cursor);
            return -1;
        }
        String searchTerm = this.buf.buffer.substring(1);
        int idx = -1;
        int end = this.history.index();
        int n = start = end <= this.history.size() ? 0 : end - this.history.size();
        if (isForward) {
            for (i = start; i < end; ++i) {
                if (!this.history.get(i).toString().contains(searchTerm)) continue;
                idx = i;
                break;
            }
        } else {
            for (i = end - 1; i >= start; --i) {
                if (!this.history.get(i).toString().contains(searchTerm)) continue;
                idx = i;
                break;
            }
        }
        if (idx == -1) {
            this.setCursorPosition(0);
            this.killLine();
            this.putString(origBuffer.buffer);
            this.setCursorPosition(0);
            return -1;
        }
        this.setCursorPosition(0);
        this.killLine();
        this.putString(this.history.get(idx));
        this.setCursorPosition(0);
        this.flush();
        isComplete = false;
        while (!isComplete && (ch = this.readCharacter()) != -1) {
            boolean forward = isForward;
            switch (ch) {
                case 80: 
                case 112: {
                    forward = !isForward;
                }
                case 78: 
                case 110: {
                    int i2;
                    boolean isMatch = false;
                    if (forward) {
                        for (i2 = idx + 1; !isMatch && i2 < end; ++i2) {
                            if (!this.history.get(i2).toString().contains(searchTerm)) continue;
                            idx = i2;
                            isMatch = true;
                        }
                    } else {
                        for (i2 = idx - 1; !isMatch && i2 >= start; --i2) {
                            if (!this.history.get(i2).toString().contains(searchTerm)) continue;
                            idx = i2;
                            isMatch = true;
                        }
                    }
                    if (!isMatch) break;
                    this.setCursorPosition(0);
                    this.killLine();
                    this.putString(this.history.get(idx));
                    this.setCursorPosition(0);
                    break;
                }
                default: {
                    isComplete = true;
                }
            }
            this.flush();
        }
        return ch;
    }

    private void insertClose(String s) throws IOException {
        this.putString(s);
        int closePosition = this.buf.cursor;
        this.moveCursor(-1);
        this.viMatch();
        if (this.in.isNonBlockingEnabled()) {
            // empty if block
        }
        this.setCursorPosition(closePosition);
    }

    private boolean viMatch() throws IOException {
        int pos = this.buf.cursor;
        if (pos == this.buf.length()) {
            return false;
        }
        int type = this.getBracketType(this.buf.buffer.charAt(pos));
        int move = type < 0 ? -1 : 1;
        int count = 1;
        if (type == 0) {
            return false;
        }
        while (count > 0) {
            if ((pos += move) < 0 || pos >= this.buf.buffer.length()) {
                return false;
            }
            int curType = this.getBracketType(this.buf.buffer.charAt(pos));
            if (curType == type) {
                ++count;
                continue;
            }
            if (curType != -type) continue;
            --count;
        }
        if (move > 0 && this.isInViMoveOperationState()) {
            ++pos;
        }
        this.setCursorPosition(pos);
        return true;
    }

    private int getBracketType(char ch) {
        switch (ch) {
            case '[': {
                return 1;
            }
            case ']': {
                return -1;
            }
            case '{': {
                return 2;
            }
            case '}': {
                return -2;
            }
            case '(': {
                return 3;
            }
            case ')': {
                return -3;
            }
        }
        return 0;
    }

    private boolean deletePreviousWord() throws IOException {
        char c;
        StringBuilder killed = new StringBuilder();
        while (this.isDelimiter(c = this.buf.current()) && c != '\u0000') {
            killed.append(c);
            this.backspace();
        }
        while (!this.isDelimiter(c = this.buf.current()) && c != '\u0000') {
            killed.append(c);
            this.backspace();
        }
        String copy = killed.reverse().toString();
        this.killRing.addBackwards(copy);
        return true;
    }

    private boolean deleteNextWord() throws IOException {
        char c;
        StringBuilder killed = new StringBuilder();
        while (this.isDelimiter(c = this.buf.nextChar()) && c != '\u0000') {
            killed.append(c);
            this.delete();
        }
        while (!this.isDelimiter(c = this.buf.nextChar()) && c != '\u0000') {
            killed.append(c);
            this.delete();
        }
        String copy = killed.toString();
        this.killRing.add(copy);
        return true;
    }

    private boolean capitalizeWord() throws IOException {
        char c;
        boolean first = true;
        int i = 1;
        while (this.buf.cursor + i - 1 < this.buf.length() && !this.isDelimiter(c = this.buf.buffer.charAt(this.buf.cursor + i - 1))) {
            this.buf.buffer.setCharAt(this.buf.cursor + i - 1, first ? Character.toUpperCase(c) : Character.toLowerCase(c));
            first = false;
            ++i;
        }
        this.drawBuffer();
        this.moveCursor(i - 1);
        return true;
    }

    private boolean upCaseWord() throws IOException {
        char c;
        int i = 1;
        while (this.buf.cursor + i - 1 < this.buf.length() && !this.isDelimiter(c = this.buf.buffer.charAt(this.buf.cursor + i - 1))) {
            this.buf.buffer.setCharAt(this.buf.cursor + i - 1, Character.toUpperCase(c));
            ++i;
        }
        this.drawBuffer();
        this.moveCursor(i - 1);
        return true;
    }

    private boolean downCaseWord() throws IOException {
        char c;
        int i = 1;
        while (this.buf.cursor + i - 1 < this.buf.length() && !this.isDelimiter(c = this.buf.buffer.charAt(this.buf.cursor + i - 1))) {
            this.buf.buffer.setCharAt(this.buf.cursor + i - 1, Character.toLowerCase(c));
            ++i;
        }
        this.drawBuffer();
        this.moveCursor(i - 1);
        return true;
    }

    private boolean transposeChars(int count) throws IOException {
        while (count > 0) {
            if (this.buf.cursor == 0 || this.buf.cursor == this.buf.buffer.length()) {
                return false;
            }
            int first = this.buf.cursor - 1;
            int second = this.buf.cursor;
            char tmp = this.buf.buffer.charAt(first);
            this.buf.buffer.setCharAt(first, this.buf.buffer.charAt(second));
            this.buf.buffer.setCharAt(second, tmp);
            this.moveInternal(-1);
            this.drawBuffer();
            this.moveInternal(2);
            --count;
        }
        return true;
    }

    public boolean isKeyMap(String name) {
        KeyMap map = this.consoleKeys.getKeys();
        KeyMap mapByName = this.consoleKeys.getKeyMaps().get(name);
        if (mapByName == null) {
            return false;
        }
        return map == mapByName;
    }

    public String accept() throws IOException {
        this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString().replaceAll("\\xA0+", " "));
        if (this.historyReturned) {
            this.multilineBuffer.setBufferSafe(this.getMultilineBuffer().getBufferList());
        }
        if (this.multilineBuffer.getCurrentLine() < this.multilineBuffer.size() || this.multilineBuffer.getCurrentLine() != this.multilineBuffer.size() || this.buf.cursor != this.buf.length()) {
            this.getMultilineBuffer().replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.substring(0, this.buf.cursor));
            this.multilineBuffer.addAtIndex(this.multilineBuffer.getCurrentLine(), this.buf.buffer.substring(this.buf.cursor));
            this.multilineBuffer.setCurrentLine(this.multilineBuffer.getCurrentLine() + 1);
            this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.DOWN, this.buf.cursor, 0, CursorState.END_GOING_RIGHT, false);
        } else {
            this.moveToEnd();
            if (!this.fullRedraw && this.multilineBuffer.getBuffer().trim().length() > 0) {
                this.println();
                if (this.multilineBuffer.size() >= this.maxBufferDrawn) {
                    this.maxBufferDrawn = this.multilineBuffer.size();
                }
            }
            this.flush();
            if (this.historyReturned) {
                this.println();
                this.flush();
            }
        }
        return this.finishBuffer();
    }

    private void abort() throws IOException {
        this.beep();
        this.buf.clear();
        this.println();
        this.redrawLine();
    }

    public int moveCursor(int num) throws IOException {
        int where = num;
        this.historyReturned = false;
        if (!this.redrawComplete) {
            this.getMultilineBuffer().replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
        }
        if (this.buf.cursor == 0 && where <= 0) {
            this.fullRedraw = true;
            if (this.getMultilineBuffer().getCurrentLine() == 1) {
                this.beep();
            } else if (this.getMultilineBuffer().getCurrentLine() > 1 && !this.redrawComplete) {
                this.getMultilineBuffer().setCurrentLine(this.getMultilineBuffer().getCurrentLine() + where);
                this.getMultilineBuffer().setTermLine(this.getMultilineBuffer().getTermLine() + where, this.getTerminal().getHeight());
                this.setRedraw(this.getMultilineBuffer().getCurrentLine(), MoveState.UP, this.getCursorBuffer().cursor, where, CursorState.START_GOING_LEFT, false);
            }
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && where >= 0) {
            this.fullRedraw = true;
            if (this.multilineBuffer.getCurrentLine() == this.multilineBuffer.size()) {
                this.beep();
            } else if (this.getMultilineBuffer().getCurrentLine() < this.getMultilineBuffer().size() && !this.redrawComplete) {
                this.getMultilineBuffer().setCurrentLine(this.getMultilineBuffer().getCurrentLine() + where);
                this.getMultilineBuffer().setTermLine(this.getMultilineBuffer().getTermLine() + where, this.getTerminal().getHeight());
                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.DOWN, this.getCursorBuffer().cursor, where, CursorState.END_GOING_RIGHT, false);
            }
            return 0;
        }
        if (this.buf.cursor + where < 0) {
            where = -this.buf.cursor;
        } else if (this.buf.cursor + where > this.buf.buffer.length()) {
            where = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(where);
        if (where != 0 && this.historyReturned) {
            this.multilineBuffer.startEditingAfterHistory();
            this.multilineBuffer.setTermLine(this.getTerminal().getHeight(), this.getTerminal().getHeight());
        }
        return where;
    }

    public void setRedraw(ArrayList<String> candidates) {
        this.redrawDetails = new Redraw(this.multilineBuffer.getCurrentLine(), this.buf.cursor, false);
        this.redrawDetails.setCandidates(candidates);
        this.redrawDetails.setDontReDraw(false);
        this.fullRedraw = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setRedraw(int currentLine, MoveState direction, int bufferLoc, int where, CursorState cursorState, boolean delete) {
        int newBufferLoc = bufferLoc;
        int newBufferLength = this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length();
        switch (direction) {
            case UP: {
                switch (cursorState) {
                    case END_GOING_RIGHT: {
                        newBufferLoc = 0;
                        break;
                    }
                    case START_GOING_LEFT: {
                        newBufferLoc = newBufferLength;
                        break;
                    }
                    case NORMAL: {
                        if (bufferLoc <= newBufferLength) break;
                        newBufferLoc = newBufferLength;
                        break;
                    }
                }
                break;
            }
            case DOWN: {
                switch (cursorState) {
                    case END_GOING_RIGHT: {
                        newBufferLoc = 0;
                        break;
                    }
                    case START_GOING_LEFT: {
                        newBufferLoc = newBufferLength;
                        break;
                    }
                    case NORMAL: {
                        if (bufferLoc <= newBufferLength) break;
                        newBufferLoc = newBufferLength;
                        break;
                    }
                }
                break;
            }
            case SAME: {
                switch (cursorState) {
                    case END_GOING_RIGHT: {
                        newBufferLoc = 0;
                        break;
                    }
                    case START_GOING_LEFT: {
                        newBufferLoc = newBufferLength;
                        break;
                    }
                    case NORMAL: {
                        if (bufferLoc <= newBufferLength) break;
                        newBufferLoc = newBufferLength;
                    }
                }
                break;
            }
        }
        this.redrawDetails = new Redraw(currentLine, newBufferLoc, delete);
        this.redrawDetails.setDontReDraw(true);
    }

    protected boolean moveToStart() throws IOException {
        if (this.buf.cursor == 0) {
            return true;
        }
        return this.moveCursor(0 - this.buf.cursor) > 0;
    }

    private void moveInternal(int where) throws IOException {
        this.buf.cursor += where;
        if (this.terminal.isAnsiSupported()) {
            if (where < 0) {
                this.back(Math.abs(where));
            } else {
                int oldLine;
                int width = this.getTerminal().getWidth();
                int cursor = this.getCursorPosition();
                int newLine = cursor / width;
                if (newLine > (oldLine = (cursor - where) / width)) {
                    this.printAnsiSequence(newLine - oldLine + "B");
                }
                this.printAnsiSequence(1 + cursor % width + "G");
            }
            return;
        }
        if (where < 0) {
            int len = 0;
            for (int i = this.buf.cursor; i < this.buf.cursor - where; ++i) {
                if (this.buf.buffer.charAt(i) == '\t') {
                    len += 4;
                    continue;
                }
                ++len;
            }
            char[] chars = new char[len];
            Arrays.fill(chars, '\b');
            this.write(chars);
            return;
        }
        if (this.buf.cursor == 0) {
            return;
        }
        if (this.mask == null) {
            this.print(this.buf.buffer.substring(this.buf.cursor - where, this.buf.cursor).toCharArray());
            return;
        }
        char c = this.mask.charValue();
        if (this.mask.charValue() == '\u0000') {
            return;
        }
        this.print(c, Math.abs(where));
    }

    public final boolean replace(int num, String replacement) {
        this.buf.buffer.replace(this.buf.cursor - num, this.buf.cursor, replacement);
        try {
            this.moveCursor(-num);
            this.drawBuffer(Math.max(0, num - replacement.length()));
            this.moveCursor(replacement.length());
            this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length(), 0, CursorState.NORMAL, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final int readCharacter() throws IOException {
        int c = this.reader.read();
        if (c >= 0) {
            Log.trace((Object[])new Object[]{"Keystroke: ", c});
            if (this.terminal.isSupported()) {
                this.clearEcho(c);
            }
        }
        return c;
    }

    private int clearEcho(int c) throws IOException {
        if (!this.terminal.isEchoEnabled()) {
            return 0;
        }
        int num = this.countEchoCharacters(c);
        this.back(num);
        this.drawBuffer(num);
        return num;
    }

    private int countEchoCharacters(int c) {
        if (c == 9) {
            int tabStop = 8;
            int position = this.getCursorPosition();
            return tabStop - position % tabStop;
        }
        return this.getPrintableCharacters(c).length();
    }

    private StringBuilder getPrintableCharacters(int ch) {
        StringBuilder sbuff = new StringBuilder();
        if (ch >= 32) {
            if (ch < 127) {
                sbuff.append(ch);
            } else if (ch == 127) {
                sbuff.append('^');
                sbuff.append('?');
            } else {
                sbuff.append('M');
                sbuff.append('-');
                if (ch >= 160) {
                    if (ch < 255) {
                        sbuff.append((char)(ch - 128));
                    } else {
                        sbuff.append('^');
                        sbuff.append('?');
                    }
                } else {
                    sbuff.append('^');
                    sbuff.append((char)(ch - 128 + 64));
                }
            }
        } else {
            sbuff.append('^');
            sbuff.append((char)(ch + 64));
        }
        return sbuff;
    }

    public final int readCharacter(char ... allowed) throws IOException {
        char c;
        Arrays.sort(allowed);
        while (Arrays.binarySearch(allowed, c = (char)this.readCharacter()) < 0) {
        }
        return c;
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character mask) throws IOException {
        return this.readLine(null, mask);
    }

    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    public boolean setKeyMap(String name) {
        return this.consoleKeys.setKeyMap(name);
    }

    public String getKeyMap() {
        return this.consoleKeys.getKeys().getName();
    }

    public String readLine(String prompt, Character mask) throws IOException {
        if (this.editNow) {
            this.multilineBuffer.resetBuffer(this.multilineBuffer.getBufferSafe().getBufferList());
            this.multilineBuffer.setCurrentLine(this.multilineBuffer.getBufferSafe().getCurrentLine());
            this.multilineBuffer.setTermLine(this.multilineBuffer.getBufferSafe().getTermLine(), this.getTerminal().getHeight());
            this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length(), 0, CursorState.NORMAL, false);
            this.redrawBuffer(this.redrawDetails, this.multilineBuffer);
            this.historyReturned = false;
            this.editNow = false;
        }
        this.redrawComplete = false;
        if (this.multilineBuffer.isEmpty()) {
            this.multilineBuffer.add("");
            this.multilineBuffer.setCurrentLine(1);
            this.multilineBuffer.setTermLine(this.multilineBuffer.getCurrentLine(), this.getTerminal().getHeight());
            this.maxBufferDrawn = 0;
        } else if (this.multilineBuffer.getCurrentLine() == this.multilineBuffer.size() && this.buf.cursor == this.buf.length() && (this.buf.length() > 0 || this.buf.cursor == 0)) {
            this.multilineBuffer.addAtIndex(this.multilineBuffer.getCurrentLine() + 1, "");
            this.setCurrentLine(this.multilineBuffer.getCurrentLine() + 1);
            this.multilineBuffer.setTermLine(this.multilineBuffer.getCurrentLine(), this.getTerminal().getHeight());
        }
        int repeatCount = 0;
        this.mask = mask;
        if (this.multilineBuffer.getCurrentLine() == 1) {
            this.setPrompt(this.basePrompt);
        } else {
            this.setPrompt(IndexBuilder.getIndex(this.multilineBuffer.getCurrentLine(), this.multilineBuffer.getCurrentLine()));
        }
        try {
            if (!this.terminal.isSupported()) {
                this.beforeReadLine(prompt, mask);
            }
            try {
                if (this.multilineBuffer.size() != 1 || this.multilineBuffer.getBufferString().trim().length() != 0) {
                    this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.DOWN, this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length(), 0, CursorState.END_GOING_RIGHT, false);
                } else {
                    this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length(), 0, CursorState.NORMAL, false);
                }
                this.bellEnabled = true;
                this.redrawBuffer(this.redrawDetails, this.multilineBuffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.redrawDetails = null;
            this.redrawComplete = false;
            if (!this.terminal.isSupported()) {
                String string = this.readLineSimple();
                return string;
            }
            String originalPrompt = this.prompt;
            this.state = State.NORMAL;
            boolean success = true;
            StringBuilder sb = new StringBuilder();
            Stack<Character> pushBackChar = new Stack<Character>();
            while (true) {
                Object o;
                int c;
                int n = c = pushBackChar.isEmpty() ? this.readCharacter() : (int)((Character)pushBackChar.pop()).charValue();
                if (c == -1) {
                    String string = null;
                    return string;
                }
                sb.appendCodePoint(c);
                if (this.recording) {
                    this.macro = this.macro + new String(new int[]{c}, 0, 1);
                }
                if ((o = this.getKeys().getBound(sb)) != null && !this.recording && !(o instanceof KeyMap)) {
                    if (o != Operation.YANK_POP && o != Operation.YANK) {
                        this.killRing.resetLastYank();
                    }
                    if (o != Operation.KILL_LINE && o != Operation.KILL_WHOLE_LINE && o != Operation.BACKWARD_KILL_WORD && o != Operation.KILL_WORD && o != Operation.UNIX_LINE_DISCARD && o != Operation.UNIX_WORD_RUBOUT) {
                        this.killRing.resetLastKill();
                    }
                }
                if (o != null && o == Operation.DO_LOWERCASE_VERSION) {
                    sb.setLength(sb.length() - 1);
                    sb.append(Character.toLowerCase((char)c));
                    o = this.getKeys().getBound(sb);
                }
                if (o != null && o instanceof KeyMap) {
                    if (c != 27 || !pushBackChar.isEmpty() || !this.in.isNonBlockingEnabled() || this.in.peek(this.escapeTimeout) != -2 || (o = ((KeyMap)o).getAnotherKey()) == null || o instanceof KeyMap) continue;
                    sb.setLength(0);
                }
                while (o == null && sb.length() > 0) {
                    c = sb.charAt(sb.length() - 1);
                    sb.setLength(sb.length() - 1);
                    Object o2 = this.getKeys().getBound(sb);
                    if (!(o2 instanceof KeyMap) || (o = ((KeyMap)o2).getAnotherKey()) == null) continue;
                    pushBackChar.push(Character.valueOf((char)c));
                }
                if (o == null) continue;
                Log.trace((Object[])new Object[]{"Binding: ", o});
                if (o instanceof String) {
                    String macro = (String)o;
                    for (int i = 0; i < macro.length(); ++i) {
                        pushBackChar.push(Character.valueOf(macro.charAt(macro.length() - 1 - i)));
                    }
                    sb.setLength(0);
                    continue;
                }
                if (o instanceof ActionListener) {
                    ((ActionListener)o).actionPerformed(null);
                    sb.setLength(0);
                    continue;
                }
                if (this.state == State.SEARCH || this.state == State.FORWARD_SEARCH) {
                    int cursorDest = -1;
                    switch ((Operation)((Object)o)) {
                        case ABORT: {
                            this.state = State.NORMAL;
                            this.buf.clear();
                            this.buf.buffer.append(this.searchTerm);
                            break;
                        }
                        case REVERSE_SEARCH_HISTORY: {
                            this.state = State.SEARCH;
                            if (this.searchTerm.length() == 0) {
                                this.searchTerm.append(this.previousSearchTerm);
                            }
                            if (this.searchIndex <= 0) break;
                            this.searchIndex = this.searchBackwards(this.searchTerm.toString(), this.searchIndex);
                            break;
                        }
                        case FORWARD_SEARCH_HISTORY: {
                            this.state = State.FORWARD_SEARCH;
                            if (this.searchTerm.length() == 0) {
                                this.searchTerm.append(this.previousSearchTerm);
                            }
                            if (this.searchIndex <= -1 || this.searchIndex >= this.history.size() - 1) break;
                            this.searchIndex = this.searchForwards(this.searchTerm.toString(), this.searchIndex);
                            break;
                        }
                        case BACKWARD_DELETE_CHAR: {
                            if (this.searchTerm.length() <= 0) break;
                            this.searchTerm.deleteCharAt(this.searchTerm.length() - 1);
                            if (this.state == State.SEARCH) {
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                break;
                            }
                            this.searchIndex = this.searchForwards(this.searchTerm.toString());
                            break;
                        }
                        case SELF_INSERT: {
                            this.searchTerm.appendCodePoint(c);
                            if (c == 32) {
                                this.redrawDetails = new Redraw(this.multilineBuffer.getCurrentLine(), this.multilineBuffer.getCursor(), false);
                            }
                            if (this.state == State.SEARCH) {
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                break;
                            }
                            this.searchIndex = this.searchForwards(this.searchTerm.toString());
                            break;
                        }
                        default: {
                            if (this.searchIndex != -1) {
                                this.history.moveTo(this.searchIndex);
                                cursorDest = this.history.current().toString().indexOf(this.searchTerm.toString());
                            }
                            this.state = State.NORMAL;
                        }
                    }
                    if (this.state == State.SEARCH || this.state == State.FORWARD_SEARCH) {
                        if (this.searchTerm.length() == 0) {
                            if (this.state == State.SEARCH) {
                                this.printSearchStatus("", "");
                            } else {
                                this.printForwardSearchStatus("", "");
                            }
                            this.searchIndex = -1;
                        } else if (this.searchIndex == -1) {
                            this.beep();
                            this.printSearchStatus(this.searchTerm.toString(), "");
                        } else if (this.state == State.SEARCH) {
                            this.printSearchStatus(this.searchTerm.toString(), this.history.get(this.searchIndex).toString());
                        } else {
                            this.printForwardSearchStatus(this.searchTerm.toString(), this.history.get(this.searchIndex).toString());
                        }
                    } else {
                        this.restoreLine(originalPrompt, cursorDest);
                    }
                }
                if (this.state != State.SEARCH && this.state != State.FORWARD_SEARCH) {
                    boolean isArgDigit = false;
                    int count = repeatCount == 0 ? 1 : repeatCount;
                    success = true;
                    if (o instanceof Operation) {
                        Operation op = (Operation)((Object)o);
                        int cursorStart = this.buf.cursor;
                        State origState = this.state;
                        switch (op) {
                            case COMPLETE: {
                                boolean isTabLiteral = false;
                                if (this.copyPasteDetection && c == 9 && (!pushBackChar.isEmpty() || this.in.isNonBlockingEnabled() && this.in.peek(this.escapeTimeout) != -2)) {
                                    isTabLiteral = true;
                                }
                                if (!isTabLiteral) {
                                    success = this.complete();
                                    break;
                                }
                                this.putString(sb);
                                break;
                            }
                            case POSSIBLE_COMPLETIONS: {
                                this.printCompletionCandidates();
                                break;
                            }
                            case BEGINNING_OF_LINE: {
                                success = this.setCursorPosition(0);
                                break;
                            }
                            case YANK: {
                                success = this.yank();
                                break;
                            }
                            case YANK_POP: {
                                success = this.yankPop();
                                break;
                            }
                            case KILL_LINE: {
                                success = this.killLine();
                                break;
                            }
                            case KILL_WHOLE_LINE: {
                                success = this.setCursorPosition(0) && this.killLine();
                                break;
                            }
                            case CLEAR_SCREEN: {
                                this.multilineBuffer.setTermLine(1, this.getTerminal().getHeight());
                                success = this.clearScreen(this.clearScreenMode);
                                this.redrawLine();
                                break;
                            }
                            case OVERWRITE_MODE: {
                                this.buf.setOverTyping(!this.buf.isOverTyping());
                                break;
                            }
                            case SELF_INSERT: {
                                this.putString(sb);
                                if (c != 32 || !this.clearCompletions) break;
                                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
                                this.redrawDetails = new Redraw(this.multilineBuffer.getCurrentLine(), this.buf.cursor, false);
                                this.clearCompletions = false;
                                break;
                            }
                            case ACCEPT_LINE: {
                                if (this.multilineBuffer.getCurrentLine() > 0 && this.multilineBuffer.getCurrentLine() < this.multilineBuffer.size() || this.multilineBuffer.getCurrentLine() == this.multilineBuffer.size() && this.buf.cursor < this.buf.length()) {
                                    this.acceptBuffer();
                                    if (this.isRunBufferNow()) {
                                        String string = this.accept();
                                        return string;
                                    }
                                } else {
                                    String string = this.accept();
                                    return string;
                                }
                            }
                            case ABORT: {
                                if (this.searchTerm != null) break;
                                this.abort();
                                break;
                            }
                            case INTERRUPT: {
                                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
                                if (this.clearCompletions) {
                                    this.redrawDetails = new Redraw(this.multilineBuffer.getCurrentLine(), this.buf.cursor, false);
                                    this.clearCompletions = false;
                                    break;
                                }
                                this.historyReturned = false;
                                int currentLine = this.multilineBuffer.getCurrentLine();
                                this.multilineBuffer.getBufferSafe().resetBuffer(this.multilineBuffer.getBufferList());
                                this.multilineBuffer.getBufferSafe().setCurrentLine(currentLine);
                                this.multilineBuffer.getBufferSafe().setTermLine(this.multilineBuffer.getTermLine(), this.getTerminal().getHeight());
                                this.multilineBuffer.setCurrentLine(this.multilineBuffer.linesInBuffer());
                                this.multilineBuffer.add(".");
                                this.buf.buffer.setLength(0);
                                this.buf.buffer.append(this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()));
                                this.buf.cursor = this.buf.buffer.length();
                                this.moveCursorToBottom();
                                this.println();
                                this.flush();
                                this.fullRedraw = false;
                                String string = this.accept();
                                return string;
                            }
                            case BUFFER_TOP: {
                                this.historyReturned = false;
                                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
                                this.multilineBuffer.setCurrentLine(1);
                                if (this.multilineBuffer.size() >= this.getTerminal().getHeight()) {
                                    this.multilineBuffer.setTermLine(1, this.getTerminal().getHeight());
                                } else {
                                    this.multilineBuffer.setTermLine(this.getTerminal().getHeight() - this.multilineBuffer.size(), this.getTerminal().getHeight());
                                }
                                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, 0, 0, CursorState.NORMAL, false);
                                break;
                            }
                            case BUFFER_BOTTOM: {
                                this.historyReturned = false;
                                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
                                this.multilineBuffer.setCurrentLine(this.multilineBuffer.linesInBuffer());
                                this.multilineBuffer.setTermLine(this.getTerminal().getHeight(), this.getTerminal().getHeight());
                                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length(), 0, CursorState.NORMAL, false);
                                break;
                            }
                            case BUFFER_EDIT_STOP: {
                                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
                                if (this.clearCompletions) {
                                    this.redrawDetails = new Redraw(this.multilineBuffer.getCurrentLine(), this.buf.cursor, false);
                                    this.clearCompletions = false;
                                    break;
                                }
                                this.historyReturned = false;
                                int currentLine = this.multilineBuffer.getCurrentLine();
                                this.multilineBuffer.getBufferSafe().resetBuffer(this.multilineBuffer.getBufferList());
                                this.multilineBuffer.getBufferSafe().setCurrentLine(currentLine);
                                this.multilineBuffer.getBufferSafe().setTermLine(this.multilineBuffer.getTermLine(), this.getTerminal().getHeight());
                                this.multilineBuffer.setCurrentLine(this.multilineBuffer.linesInBuffer());
                                this.multilineBuffer.add(".");
                                this.buf.buffer.setLength(0);
                                this.buf.buffer.append(this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()));
                                this.buf.cursor = this.buf.buffer.length();
                                this.moveCursorToBottom();
                                this.println();
                                this.flush();
                                this.fullRedraw = false;
                                String string = this.accept();
                                return string;
                            }
                            case BUFFER_EDIT: {
                                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, 0, 0, CursorState.NORMAL, false);
                                this.fullRedraw = true;
                                break;
                            }
                            case RUNSQL: {
                                this.setRunBufferNow(true);
                                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
                                this.moveCursorToBottom();
                                this.println();
                                this.flush();
                                String currentLine = this.finishBuffer();
                                return currentLine;
                            }
                            case VI_MOVE_ACCEPT_LINE: {
                                this.consoleKeys.setKeyMap("vi-insert");
                                if (this.multilineBuffer.getCurrentLine() > 0 && this.multilineBuffer.getCurrentLine() < this.multilineBuffer.size()) {
                                    this.acceptBuffer();
                                } else {
                                    String currentLine = this.accept();
                                    return currentLine;
                                }
                            }
                            case BACKWARD_WORD: {
                                success = this.previousWord();
                                break;
                            }
                            case FORWARD_WORD: {
                                success = this.nextWord();
                                break;
                            }
                            case PREVIOUS_HISTORY: {
                                success = this.moveHistory(false);
                                break;
                            }
                            case VI_PREVIOUS_HISTORY: {
                                success = this.moveHistory(false, count) && this.setCursorPosition(0);
                                break;
                            }
                            case NEXT_HISTORY: {
                                success = this.moveHistory(true);
                                break;
                            }
                            case VI_NEXT_HISTORY: {
                                success = this.moveHistory(true, count) && this.setCursorPosition(0);
                                break;
                            }
                            case BACKWARD_DELETE_CHAR: {
                                success = this.backspace();
                                break;
                            }
                            case EXIT_OR_DELETE_CHAR: {
                                if (this.buf.buffer.length() == 0) {
                                    String currentLine = null;
                                    return currentLine;
                                }
                                success = this.deleteCurrentCharacter();
                                break;
                            }
                            case DELETE_CHAR: {
                                success = this.deleteCurrentCharacter();
                                break;
                            }
                            case BACKWARD_CHAR: {
                                success = this.moveCursor(-count) != 0;
                                break;
                            }
                            case FORWARD_CHAR: {
                                success = this.moveCursor(count) != 0;
                                break;
                            }
                            case UNIX_LINE_DISCARD: {
                                success = this.resetLine();
                                break;
                            }
                            case UNIX_WORD_RUBOUT: {
                                success = this.unixWordRubout(count);
                                break;
                            }
                            case BACKWARD_KILL_WORD: {
                                success = this.deletePreviousWord();
                                break;
                            }
                            case KILL_WORD: {
                                success = this.deleteNextWord();
                                break;
                            }
                            case BEGINNING_OF_HISTORY: {
                                success = this.history.moveToFirst();
                                if (!success) break;
                                this.setBuffer(this.history.current());
                                break;
                            }
                            case END_OF_HISTORY: {
                                success = this.history.moveToLast();
                                if (!success) break;
                                this.setBuffer(this.history.current());
                                break;
                            }
                            case HISTORY_SEARCH_BACKWARD: {
                                this.searchTerm = new StringBuffer(this.buf.upToCursor());
                                this.searchIndex = this.searchBackwards(this.searchTerm.toString(), this.history.index(), true);
                                if (this.searchIndex == -1) {
                                    this.beep();
                                    break;
                                }
                                success = this.history.moveTo(this.searchIndex);
                                if (!success) break;
                                this.setBufferKeepPos(this.history.current());
                                break;
                            }
                            case HISTORY_SEARCH_FORWARD: {
                                this.searchTerm = new StringBuffer(this.buf.upToCursor());
                                int index = this.history.index() + 1;
                                if (index == this.history.size()) {
                                    this.history.moveToEnd();
                                    this.setBufferKeepPos(this.searchTerm.toString());
                                    break;
                                }
                                if (index >= this.history.size()) break;
                                this.searchIndex = this.searchForwards(this.searchTerm.toString(), index, true);
                                if (this.searchIndex == -1) {
                                    this.beep();
                                    break;
                                }
                                success = this.history.moveTo(this.searchIndex);
                                if (!success) break;
                                this.setBufferKeepPos(this.history.current());
                                break;
                            }
                            case REVERSE_SEARCH_HISTORY: {
                                if (this.searchTerm != null) {
                                    this.previousSearchTerm = this.searchTerm.toString();
                                }
                                this.searchTerm = new StringBuffer(this.buf.buffer);
                                this.state = State.SEARCH;
                                if (this.searchTerm.length() > 0) {
                                    this.searchIndex = this.searchBackwards(this.searchTerm.toString());
                                    if (this.searchIndex == -1) {
                                        this.beep();
                                    }
                                    this.printSearchStatus(this.searchTerm.toString(), this.searchIndex > -1 ? this.history.get(this.searchIndex).toString() : "");
                                    break;
                                }
                                this.searchIndex = -1;
                                this.printSearchStatus("", "");
                                break;
                            }
                            case FORWARD_SEARCH_HISTORY: {
                                if (this.searchTerm != null) {
                                    this.previousSearchTerm = this.searchTerm.toString();
                                }
                                this.searchTerm = new StringBuffer(this.buf.buffer);
                                this.state = State.FORWARD_SEARCH;
                                if (this.searchTerm.length() > 0) {
                                    this.searchIndex = this.searchForwards(this.searchTerm.toString());
                                    if (this.searchIndex == -1) {
                                        this.beep();
                                    }
                                    this.printForwardSearchStatus(this.searchTerm.toString(), this.searchIndex > -1 ? this.history.get(this.searchIndex).toString() : "");
                                    break;
                                }
                                this.searchIndex = -1;
                                this.printForwardSearchStatus("", "");
                                break;
                            }
                            case CAPITALIZE_WORD: {
                                success = this.capitalizeWord();
                                break;
                            }
                            case UPCASE_WORD: {
                                success = this.upCaseWord();
                                break;
                            }
                            case DOWNCASE_WORD: {
                                success = this.downCaseWord();
                                break;
                            }
                            case END_OF_LINE: {
                                success = this.moveToEnd();
                                break;
                            }
                            case TAB_INSERT: {
                                this.putString("\t");
                                break;
                            }
                            case RE_READ_INIT_FILE: {
                                this.consoleKeys.loadKeys(this.appName, this.inputrcUrl);
                                break;
                            }
                            case START_KBD_MACRO: {
                                this.recording = true;
                                break;
                            }
                            case END_KBD_MACRO: {
                                this.recording = false;
                                this.macro = this.macro.substring(0, this.macro.length() - sb.length());
                                break;
                            }
                            case CALL_LAST_KBD_MACRO: {
                                for (int i = 0; i < this.macro.length(); ++i) {
                                    pushBackChar.push(Character.valueOf(this.macro.charAt(this.macro.length() - 1 - i)));
                                }
                                sb.setLength(0);
                                break;
                            }
                            case VI_EDITING_MODE: {
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_MOVEMENT_MODE: {
                                if (this.state == State.NORMAL) {
                                    this.moveCursor(-1);
                                }
                                this.consoleKeys.setKeyMap("vi-move");
                                break;
                            }
                            case VI_INSERTION_MODE: {
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_APPEND_MODE: {
                                this.moveCursor(1);
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_APPEND_EOL: {
                                success = this.moveToEnd();
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_EOF_MAYBE: {
                                if (this.buf.buffer.length() == 0) {
                                    String i = null;
                                    return i;
                                }
                                String i = this.accept();
                                return i;
                            }
                            case TRANSPOSE_CHARS: {
                                success = this.transposeChars(count);
                                break;
                            }
                            case INSERT_COMMENT: {
                                String i = this.insertComment(false);
                                return i;
                            }
                            case INSERT_CLOSE_CURLY: {
                                this.insertClose("}");
                                break;
                            }
                            case INSERT_CLOSE_PAREN: {
                                this.insertClose(")");
                                break;
                            }
                            case INSERT_CLOSE_SQUARE: {
                                this.insertClose("]");
                                break;
                            }
                            case VI_INSERT_COMMENT: {
                                String i = this.insertComment(true);
                                return i;
                            }
                            case VI_MATCH: {
                                success = this.viMatch();
                                break;
                            }
                            case VI_SEARCH: {
                                int lastChar = this.viSearch(sb.charAt(0));
                                if (lastChar == -1) break;
                                pushBackChar.push(Character.valueOf((char)lastChar));
                                break;
                            }
                            case VI_ARG_DIGIT: {
                                repeatCount = repeatCount * 10 + sb.charAt(0) - 48;
                                isArgDigit = true;
                                break;
                            }
                            case VI_BEGNNING_OF_LINE_OR_ARG_DIGIT: {
                                if (repeatCount > 0) {
                                    repeatCount = repeatCount * 10 + sb.charAt(0) - 48;
                                    isArgDigit = true;
                                    break;
                                }
                                success = this.setCursorPosition(0);
                                break;
                            }
                            case VI_FIRST_PRINT: {
                                success = this.setCursorPosition(0) && this.viNextWord(1);
                                break;
                            }
                            case VI_PREV_WORD: {
                                success = this.viPreviousWord(count);
                                break;
                            }
                            case VI_NEXT_WORD: {
                                success = this.viNextWord(count);
                                break;
                            }
                            case VI_END_WORD: {
                                success = this.viEndWord(count);
                                break;
                            }
                            case VI_INSERT_BEG: {
                                success = this.setCursorPosition(0);
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_RUBOUT: {
                                success = this.viRubout(count);
                                break;
                            }
                            case VI_DELETE: {
                                success = this.viDelete(count);
                                break;
                            }
                            case VI_DELETE_TO: {
                                if (this.state == State.VI_DELETE_TO) {
                                    success = this.setCursorPosition(0) && this.killLine();
                                    this.state = origState = State.NORMAL;
                                    break;
                                }
                                this.state = State.VI_DELETE_TO;
                                break;
                            }
                            case VI_YANK_TO: {
                                if (this.state == State.VI_YANK_TO) {
                                    this.yankBuffer = this.buf.buffer.toString();
                                    this.state = origState = State.NORMAL;
                                    break;
                                }
                                this.state = State.VI_YANK_TO;
                                break;
                            }
                            case VI_CHANGE_TO: {
                                if (this.state == State.VI_CHANGE_TO) {
                                    success = this.setCursorPosition(0) && this.killLine();
                                    this.state = origState = State.NORMAL;
                                    this.consoleKeys.setKeyMap("vi-insert");
                                    break;
                                }
                                this.state = State.VI_CHANGE_TO;
                                break;
                            }
                            case VI_KILL_WHOLE_LINE: {
                                success = this.setCursorPosition(0) && this.killLine();
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case VI_PUT: {
                                success = this.viPut(count);
                                break;
                            }
                            case VI_CHAR_SEARCH: {
                                int searchChar = c != 59 && c != 44 ? (pushBackChar.isEmpty() ? this.readCharacter() : (int)((Character)pushBackChar.pop()).charValue()) : 0;
                                success = this.viCharSearch(count, c, searchChar);
                                break;
                            }
                            case VI_CHANGE_CASE: {
                                success = this.viChangeCase(count);
                                break;
                            }
                            case VI_CHANGE_CHAR: {
                                success = this.viChangeChar(count, pushBackChar.isEmpty() ? this.readCharacter() : (int)((Character)pushBackChar.pop()).charValue());
                                break;
                            }
                            case VI_DELETE_TO_EOL: {
                                success = this.viDeleteTo(this.buf.cursor, this.buf.buffer.length(), false);
                                break;
                            }
                            case VI_CHANGE_TO_EOL: {
                                success = this.viDeleteTo(this.buf.cursor, this.buf.buffer.length(), true);
                                this.consoleKeys.setKeyMap("vi-insert");
                                break;
                            }
                            case EMACS_EDITING_MODE: {
                                this.consoleKeys.setKeyMap("emacs");
                                break;
                            }
                        }
                    }
                }
                if (this.redrawDetails != null) {
                    this.redrawBuffer(this.redrawDetails, this.getMultilineBuffer());
                    this.redrawDetails = null;
                    this.redrawComplete = false;
                    success = true;
                }
                sb.setLength(0);
                this.flush();
            }
        }
        finally {
            if (!this.terminal.isSupported()) {
                this.afterReadLine();
            }
        }
    }

    private void moveCursorToBottom() throws IOException {
        int lines2MoveDown = this.getTerminal().getHeight() - this.multilineBuffer.getTermLine();
        if (lines2MoveDown > 0) {
            for (int i = 0; i < lines2MoveDown; ++i) {
                try {
                    this.write(Ansi.ansi().cursorDown(1).toString());
                    this.flush();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void setCurrentLine(int lineNumber) {
        if (this.multilineBuffer.size() == 1) {
            this.multilineBuffer.setCurrentLine(this.multilineBuffer.size());
        } else if (lineNumber > 1 && lineNumber <= this.multilineBuffer.size()) {
            this.multilineBuffer.setCurrentLine(lineNumber);
        }
    }

    private void acceptBuffer() throws IOException {
        if (this.isSQLPlusCommand(this.multilineBuffer.getBufferString())) {
            this.multilineBuffer.resetBuffer(this.multilineBuffer.getBufferList());
            this.moveToEnd();
            this.setRunBufferNow(true);
        } else if (this.multilineBuffer.getCurrentLine() > 0 && this.multilineBuffer.getCurrentLine() < this.multilineBuffer.size() || this.multilineBuffer.getCurrentLine() == this.multilineBuffer.size() && this.buf.cursor < this.buf.length()) {
            String left = this.buf.buffer.substring(0, this.buf.cursor);
            String forward = this.buf.buffer.substring(this.buf.cursor);
            if (forward.length() > 0) {
                this.setFullRedraw(Boolean.TRUE);
            }
            this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), left.replaceAll("\\xA0+", " "));
            this.multilineBuffer.addAtIndex(this.multilineBuffer.getCurrentLine(), forward.replaceAll("\\xA0+", " "));
            this.multilineBuffer.setCurrentLine(this.multilineBuffer.getCurrentLine() + 1);
            this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.DOWN, this.buf.cursor, 0, CursorState.END_GOING_RIGHT, false);
        }
    }

    private boolean isSQLPlusCommand(String bufferString) {
        String[] a = bufferString.trim().split("\\s+");
        return a.length > 1 && (a[0].toLowerCase().equals("set") || a[0].toLowerCase().equals("conn") || a[0].toLowerCase().equals("connect") || a[0].toLowerCase().equals("show") || a[0].toLowerCase().equals("start"));
    }

    public String readLineSimple() throws IOException {
        return this.readLineSimple(null, null);
    }

    public String readLineSimple(String prompt) throws IOException {
        return this.readLineSimple(prompt, null);
    }

    public String readLineSimple(String prompt, Character mask) throws IOException {
        StringBuilder buff = new StringBuilder();
        StringBuilder filterBuff = new StringBuilder();
        if (prompt != null && prompt.length() > 0) {
            this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
            this.flush();
            this.write(prompt);
            this.flush();
        }
        String result = null;
        while (result == null) {
            int i = this.readCharacter();
            Object o = this.getKeys().getBound(new StringBuffer((char)i));
            if (i == 8 || i == 127 || o == Operation.BACKWARD_DELETE_CHAR) {
                if (buff.length() > 0) {
                    if (mask == null) {
                        buff = new StringBuilder(this.stripAnsiNo32(buff.toString()));
                    }
                    buff.deleteCharAt(buff.length() - 1);
                    filterBuff = new StringBuilder(buff);
                    this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
                    this.flush();
                    this.write(prompt);
                    if (mask == null) {
                        this.write(buff.toString());
                    } else {
                        this.write(buff.toString().replaceAll(".", mask.toString()));
                    }
                    this.flush();
                    continue;
                }
                this.beep();
                continue;
            }
            if (i == 3 || i == 4 || o != null && (o == Operation.INTERRUPT || o == Operation.EXIT_OR_DELETE_CHAR)) {
                this.write("\n");
                this.flush();
                return null;
            }
            if (this.skipLF && i == 10) {
                this.skipLF = false;
                i = this.readCharacter();
            }
            if (i == -1 && buff.length() == 0) {
                return null;
            }
            if (i == -1 || i == 10) {
                result = this.stripAnsiNo32(buff.toString());
                continue;
            }
            if (i == 13) {
                this.skipLF = true;
                result = this.stripAnsiNo32(buff.toString());
                continue;
            }
            buff.append((char)i);
            if (mask == null) {
                StringBuilder newBuff = new StringBuilder(this.stripAnsiNo32(buff.toString()));
                if (buff != null && !newBuff.toString().equals(filterBuff.toString())) {
                    this.print(newBuff.substring(filterBuff.length()));
                    filterBuff = newBuff;
                }
            } else {
                this.print((int)mask.charValue());
            }
            this.flush();
        }
        this.write("\n");
        this.flush();
        return result;
    }

    public String readLineSimpleMultiline(String prompt) throws IOException {
        return this.readLineSimple(prompt, null, true);
    }

    public String readLineSimple(String prompt, Character mask, boolean multiline) throws IOException {
        String interrim = this.readLineSimple(prompt, mask);
        while (multiline) {
            if (this.in.peek(20L) == -1) {
                return interrim;
            }
            String subsequent = this.readLineSimple("", mask);
            if (subsequent == null) {
                subsequent = "";
                continue;
            }
            interrim = interrim + "\n" + subsequent;
        }
        return interrim;
    }

    public boolean addCompleter(Completer completer) {
        return this.completers.add(completer);
    }

    public boolean removeCompleter(Completer completer) {
        return this.completers.remove(completer);
    }

    public Collection<Completer> getCompleters() {
        return Collections.unmodifiableList(this.completers);
    }

    public void setCompletionHandler(CompletionHandler handler) {
        this.completionHandler = (CompletionHandler)Preconditions.checkNotNull((Object)handler);
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    protected boolean complete() throws IOException {
        Completer comp;
        this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
        if (this.completers.size() == 0) {
            return false;
        }
        LinkedList<CharSequence> candidates = new LinkedList<CharSequence>();
        String bufstr = this.buf.buffer.toString();
        int cursor = this.buf.cursor;
        int position = -1;
        Iterator<Completer> iterator = this.completers.iterator();
        while (iterator.hasNext() && (position = (comp = iterator.next()).complete(bufstr, cursor, candidates)) == -1) {
        }
        if (candidates.size() > 0) {
            this.fullRedraw = true;
        }
        return candidates.size() != 0 && this.getCompletionHandler().complete(this, candidates, position);
    }

    protected void printCompletionCandidates() throws IOException {
        if (this.completers.size() == 0) {
            return;
        }
        LinkedList<CharSequence> candidates = new LinkedList<CharSequence>();
        String bufstr = this.buf.buffer.toString();
        int cursor = this.buf.cursor;
        for (Completer comp : this.completers) {
            if (comp.complete(bufstr, cursor, candidates) != -1) break;
        }
        CandidateListCompletionHandler.printCandidates(this, candidates);
        this.drawLine();
    }

    public void setAutoprintThreshold(int threshold) {
        this.autoprintThreshold = threshold;
    }

    public int getAutoprintThreshold() {
        return this.autoprintThreshold;
    }

    public void setPaginationEnabled(boolean enabled) {
        this.paginationEnabled = enabled;
    }

    public boolean isPaginationEnabled() {
        return this.paginationEnabled;
    }

    public void setHistory(MultiLineHistory history) {
        this.history = history;
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistoryEnabled(boolean enabled) {
        this.historyEnabled = enabled;
    }

    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    private boolean moveHistory(boolean next, int count) throws IOException {
        boolean ok = true;
        for (int i = 0; i < count && (ok = this.moveHistory(next)); ++i) {
        }
        return ok;
    }

    private boolean moveHistory(boolean next) throws IOException {
        if (!(this.multilineBuffer.getCurrentLine() >= this.multilineBuffer.size() && this.buf.cursor >= this.buf.length() || this.historyReturned)) {
            if (!this.redrawComplete) {
                this.multilineBuffer.replace(this.multilineBuffer.getCurrentLine(), this.buf.buffer.toString());
            }
            if (next && !this.multilineBuffer.next()) {
                return false;
            }
            if (!next && !this.multilineBuffer.previous()) {
                return false;
            }
            if (next) {
                this.getMultilineBuffer().setTermLine(this.getMultilineBuffer().getTermLine() + 1, this.getTerminal().getHeight());
                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.DOWN, this.getCursorBuffer().cursor, 0, CursorState.NORMAL, false);
            } else {
                this.getMultilineBuffer().setTermLine(this.getMultilineBuffer().getTermLine() - 1, this.getTerminal().getHeight());
                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.UP, this.getCursorBuffer().cursor, 0, CursorState.NORMAL, false);
            }
        } else {
            if (!next && !this.history.previous()) {
                return false;
            }
            if (next && !this.history.next()) {
                this.multilineBuffer.resetBuffer("");
                this.multilineBuffer.setTermLine(this.getTerminal().getHeight(), this.getTerminal().getHeight());
                this.history.moveToEnd();
                this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length(), 0, CursorState.NORMAL, false);
                this.historyReturned = true;
                return false;
            }
            this.multilineBuffer.resetBuffer(this.history.getItem(this.history.index() + (next ? 0 : 1)));
            this.multilineBuffer.setTermLine(this.getTerminal().getHeight(), this.getTerminal().getHeight());
            this.setRedraw(this.multilineBuffer.getCurrentLine(), MoveState.SAME, this.multilineBuffer.getLine(this.multilineBuffer.getCurrentLine()).length(), 0, CursorState.NORMAL, false);
            this.historyReturned = true;
        }
        this.fullRedraw = true;
        return true;
    }

    private void print(int c) throws IOException {
        if (c == 9) {
            char[] chars = new char[4];
            Arrays.fill(chars, ' ');
            this.write(chars);
            return;
        }
        this.write(c);
    }

    private void print(char ... buff) throws IOException {
        char[] chars;
        int len = 0;
        for (char c : buff) {
            if (c == '\t') {
                len += 4;
                continue;
            }
            ++len;
        }
        if (len == buff.length) {
            chars = buff;
        } else {
            chars = new char[len];
            int pos = 0;
            for (char c : buff) {
                if (c == '\t') {
                    Arrays.fill(chars, pos, pos + 4, ' ');
                    pos += 4;
                    continue;
                }
                chars[pos] = c;
                ++pos;
            }
        }
        this.write(chars);
    }

    private void print(char c, int num) throws IOException {
        if (num == 1) {
            this.print((int)c);
        } else {
            char[] chars = new char[num];
            Arrays.fill(chars, c);
            this.print(chars);
        }
    }

    public final void print(CharSequence s) throws IOException {
        this.print(((CharSequence)Preconditions.checkNotNull((Object)s)).toString().toCharArray());
    }

    public final void println(CharSequence s) throws IOException {
        this.print(((CharSequence)Preconditions.checkNotNull((Object)s)).toString().toCharArray());
        this.println();
    }

    public final void println() throws IOException {
        this.print(CR);
    }

    public final boolean delete() throws IOException {
        if (this.buf.cursor == this.buf.buffer.length()) {
            return false;
        }
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + 1);
        this.drawBuffer(1);
        return true;
    }

    public boolean killLine() throws IOException {
        int cp = this.buf.cursor;
        int len = this.buf.buffer.length();
        if (cp >= len) {
            return false;
        }
        int num = len - cp;
        this.clearAhead(num, 0);
        char[] killed = new char[num];
        this.buf.buffer.getChars(cp, cp + num, killed, 0);
        this.buf.buffer.delete(cp, cp + num);
        String copy = new String(killed);
        this.killRing.add(copy);
        return true;
    }

    public boolean yank() throws IOException {
        String yanked = this.killRing.yank();
        if (yanked == null) {
            return false;
        }
        this.putString(yanked);
        return true;
    }

    public boolean yankPop() throws IOException {
        if (!this.killRing.lastYank()) {
            return false;
        }
        String current = this.killRing.yank();
        if (current == null) {
            return false;
        }
        this.backspace(current.length());
        String yanked = this.killRing.yankPop();
        if (yanked == null) {
            return false;
        }
        this.putString(yanked);
        return true;
    }

    public boolean clearScreen(String position) throws IOException {
        if (!this.terminal.isAnsiSupported()) {
            return false;
        }
        this.printAnsiSequence("2J");
        if (position.equals("top")) {
            this.printAnsiSequence("1;1H");
        } else if (position.equals("bottom")) {
            this.write(Ansi.ansi().cursorDown(this.terminal.getHeight()).toString());
            this.flush();
        }
        return true;
    }

    public boolean clearScreen() throws IOException {
        if (!this.terminal.isAnsiSupported()) {
            return false;
        }
        this.printAnsiSequence("2J");
        this.printAnsiSequence("1;1H");
        return true;
    }

    public void beep() throws IOException {
        if (this.bellEnabled) {
            this.print(7);
            this.flush();
        }
    }

    public boolean paste() throws IOException {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            return false;
        }
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String value;
            Object content = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (content == null) {
                try {
                    content = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (content == null) {
                return false;
            }
            if (content instanceof Reader) {
                String line;
                value = "";
                BufferedReader read = new BufferedReader((Reader)content);
                while ((line = read.readLine()) != null) {
                    if (value.length() > 0) {
                        value = value + "\n";
                    }
                    value = value + line;
                }
            } else {
                value = content.toString();
            }
            if (value == null) {
                return true;
            }
            this.putString(value);
            return true;
        }
        catch (UnsupportedFlavorException e) {
            Log.error((Object[])new Object[]{"Paste failed: ", e});
            return false;
        }
    }

    public void addTriggeredAction(char c, ActionListener listener) {
        this.triggeredActions.put(Character.valueOf(c), listener);
    }

    public void printColumns(Collection<? extends CharSequence> items) throws IOException {
        ArrayList<String> candidates = new ArrayList<String>();
        if (items == null || items.isEmpty()) {
            return;
        }
        int width = this.getTerminal().getWidth();
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        Log.debug((Object[])new Object[]{"Max width: ", maxWidth += 3});
        StringBuilder buff = new StringBuilder();
        for (CharSequence charSequence : items) {
            if (buff.length() + maxWidth > width) {
                candidates.add(buff.toString());
                buff.setLength(0);
            }
            buff.append(charSequence.toString());
            for (int i = 0; i < maxWidth - charSequence.length(); ++i) {
                buff.append(' ');
            }
        }
        if (buff.length() > 0) {
            candidates.add(buff.toString());
            if (this.maxBufferDrawn < this.getTerminal().getHeight() && candidates.size() + this.multilineBuffer.size() > this.maxBufferDrawn) {
                ++this.maxBufferDrawn;
            }
        }
        this.setRedraw(candidates);
    }

    private void beforeReadLine(String prompt, Character mask) {
        if (mask != null && this.maskThread == null) {
            final String fullPrompt = "\r" + prompt + "                                                   \r" + prompt;
            this.maskThread = new Thread(){

                @Override
                public void run() {
                    while (!3.interrupted()) {
                        try {
                            Writer out = DbtoolsConsoleReader.this.getOutput();
                            DbtoolsConsoleReader.this.write(fullPrompt);
                            DbtoolsConsoleReader.this.flush();
                            3.sleep(3L);
                        }
                        catch (IOException e) {
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            };
            this.maskThread.setPriority(10);
            this.maskThread.setDaemon(true);
            this.maskThread.start();
        }
    }

    private void afterReadLine() {
        if (this.maskThread != null && this.maskThread.isAlive()) {
            this.maskThread.interrupt();
        }
        this.maskThread = null;
    }

    public void resetPromptLine(String prompt, String buffer, int cursorDest) throws IOException {
        this.moveToEnd();
        this.buf.buffer.append(this.prompt);
        int promptLength = 0;
        if (this.prompt != null) {
            promptLength = this.prompt.length();
        }
        this.buf.cursor += promptLength;
        this.setPrompt("");
        this.backspaceAll();
        this.setPrompt(prompt);
        this.redrawLine();
        this.setBuffer(buffer);
        if (cursorDest < 0) {
            cursorDest = buffer.length();
        }
        this.setCursorPosition(cursorDest);
        this.flush();
    }

    public void printSearchStatus(String searchTerm, String match) throws IOException {
        this.printSearchStatus(searchTerm, match, "(reverse-i-search)`");
    }

    public void printForwardSearchStatus(String searchTerm, String match) throws IOException {
        this.printSearchStatus(searchTerm, match, "(i-search)`");
    }

    private void printSearchStatus(String searchTerm, String match, String searchLabel) throws IOException {
        String prompt = searchLabel + searchTerm + "': ";
        int cursorDest = match.indexOf(searchTerm);
        this.resetPromptLine(prompt, match, cursorDest);
    }

    public void restoreLine(String originalPrompt, int cursorDest) throws IOException {
        String prompt = this.lastLine(originalPrompt);
        String buffer = this.buf.buffer.toString();
        this.resetPromptLine(prompt, buffer, cursorDest);
    }

    public int searchBackwards(String searchTerm, int startIndex) {
        return this.searchBackwards(searchTerm, startIndex, false);
    }

    public int searchBackwards(String searchTerm) {
        return this.searchBackwards(searchTerm, this.history.index());
    }

    public int searchBackwards(String searchTerm, int startIndex, boolean startsWith) {
        ListIterator<History.Entry> it = this.history.entries(startIndex);
        while (it.hasPrevious()) {
            History.Entry e = it.previous();
            if (!(startsWith ? e.value().toString().startsWith(searchTerm) : e.value().toString().contains(searchTerm))) continue;
            return e.index();
        }
        return -1;
    }

    public int searchForwards(String searchTerm, int startIndex) {
        return this.searchForwards(searchTerm, startIndex, false);
    }

    public int searchForwards(String searchTerm) {
        return this.searchForwards(searchTerm, this.history.index());
    }

    public int searchForwards(String searchTerm, int startIndex, boolean startsWith) {
        if (startIndex >= this.history.size()) {
            startIndex = this.history.size() - 1;
        }
        ListIterator<History.Entry> it = this.history.entries(startIndex);
        if (this.searchIndex != -1 && it.hasNext()) {
            it.next();
        }
        while (it.hasNext()) {
            History.Entry e = it.next();
            if (!(startsWith ? e.value().toString().startsWith(searchTerm) : e.value().toString().contains(searchTerm))) continue;
            return e.index();
        }
        return -1;
    }

    private boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    private boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    private void printAnsiSequence(String sequence) throws IOException {
        this.print(27);
        this.print(91);
        this.print(sequence);
        this.flush();
    }

    public IBuffer getMultilineBuffer() {
        return this.multilineBuffer;
    }

    public void setMultilineBuffer(IBuffer buffer) {
        this.multilineBuffer = buffer;
        this.multilineBuffer.setReadLineBuffer(this.buf);
    }

    public boolean isNotBottomAddLine() {
        return this.multilineBuffer.getCurrentLine() <= this.multilineBuffer.size();
    }

    public void resetEditor() {
        this.historyReturned = false;
        this.basePrompt = "";
    }

    public void redrawBuffer(IBuffer buffer) throws IOException {
        this.redrawBuffer(this.redrawDetails, buffer);
    }

    private void redrawBuffer(Redraw rd, IBuffer buffer) throws IOException {
        int startLine;
        int newLines2Draw = 0;
        int predictions = 0;
        if (rd.candidates != null) {
            predictions = rd.candidates.size();
            this.clearCompletions = true;
        }
        int n = startLine = this.getTerminal().getHeight() - buffer.size() >= 0 ? this.getTerminal().getHeight() - buffer.size() + 1 : 0;
        if (rd.dontRedraw()) {
            startLine = -1;
        }
        int bufferLoc = 0;
        if (buffer.getBuffer().trim().length() > 0 && this.fullRedraw) {
            this.clearBufferLines();
            if (buffer.size() + predictions > this.maxBufferDrawn) {
                if (this.maxBufferDrawn < buffer.size() + predictions) {
                    if (buffer.size() + predictions > this.getTerminal().getHeight()) {
                        newLines2Draw = this.getTerminal().getHeight() - this.maxBufferDrawn;
                        this.maxBufferDrawn = this.getTerminal().getHeight();
                    } else {
                        newLines2Draw = buffer.size() + predictions - this.maxBufferDrawn;
                        this.maxBufferDrawn = buffer.size() + predictions;
                    }
                }
                this.printNewLinesAtBottom(newLines2Draw);
            }
            if (this.historyReturned || rd.delete) {
                this.resetMaxDrawnbuffer();
            }
            bufferLoc = rd.getBufferLoc();
            int n2 = startLine = this.getTerminal().getHeight() - buffer.size() >= 0 ? this.getTerminal().getHeight() - buffer.size() + 1 : 0;
            if (rd.isDelete()) {
                this.clearLine(startLine);
            }
            this.splatBuffer(startLine, buffer, rd);
        } else {
            this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
            this.flush();
            this.writeLine(buffer, this.multilineBuffer.getCurrentLine() - 1, false);
        }
        this.redrawComplete = true;
        this.resetCurrentCursorLine(startLine, buffer, bufferLoc);
        this.redrawDetails = null;
    }

    private void resetMaxDrawnbuffer() throws IOException {
        this.write(Ansi.ansi().cursor(0, 0).toString());
        this.flush();
        int height = this.getTerminal().getHeight();
        int start = height - this.maxBufferDrawn;
        if (start >= 0 && start <= height) {
            this.write(Ansi.ansi().cursor(start, 0).toString());
            this.flush();
            int line2Reset = height - start;
            for (int i = 0; i < line2Reset; ++i) {
                this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).cursorDown(1).toString());
                this.flush();
            }
        }
    }

    private void printNewLinesAtBottom(int newLines2Draw) throws IOException {
        if (newLines2Draw > 0) {
            this.write(Ansi.ansi().cursor(this.getTerminal().getHeight(), 0).toString());
            this.flush();
            for (int i = 0; i < newLines2Draw; ++i) {
                this.println();
            }
            this.flush();
        }
    }

    private int getCharCount(String s) {
        int chars = 0;
        for (int i = 0; i < s.length(); ++i) {
            char charCode = s.charAt(i);
            if ((charCode & 0xF800) == 55296) {
                ++chars;
                ++i;
                continue;
            }
            ++chars;
        }
        return chars;
    }

    private void resetCurrentCursorLine(int startLine, IBuffer buffer, int bufferLocation) throws IOException {
        int localPromptLen;
        if (startLine >= 0) {
            this.write(Ansi.ansi().cursor(startLine, 0).toString());
            this.flush();
            if (startLine > 0) {
                if (buffer.getCurrentLine() - 1 > 0) {
                    this.write(Ansi.ansi().cursorDown(buffer.getCurrentLine() - 1).toString());
                }
                this.flush();
            } else if (startLine == 0 && buffer.getTermLine() > 1) {
                this.write(Ansi.ansi().cursorDown(buffer.getTermLine() - 1).toString());
                this.flush();
            }
        }
        if (buffer.getCurrentLine() == 1) {
            this.setPrompt(this.basePrompt);
        } else {
            this.setPrompt(IndexBuilder.getIndex(buffer.getCurrentLine(), buffer.getCurrentLine()));
        }
        this.promptLen = localPromptLen = this.getPromptLength();
        this.buf.buffer.setLength(0);
        this.buf.buffer.append(buffer.getLine(buffer.getCurrentLine()));
        this.buf.cursor = bufferLocation;
        this.flush();
        this.setCursorPosition(bufferLocation);
        this.flush();
        if (this.fullRedraw) {
            this.write(Ansi.ansi().cursorLeft(this.getTerminal().getWidth()).toString());
            this.flush();
            this.write(Ansi.ansi().cursorRight(this.getPromptLength() + bufferLocation).toString());
            this.flush();
        }
    }

    private int getPromptLength() {
        int x = this.stripAnsi(this.getPrompt()).length();
        if (this.getCharCount(this.stripAnsi(this.getPrompt())) < this.stripAnsi(this.getPrompt()).length()) {
            x = this.getCharCount(this.stripAnsi(this.getPrompt()));
        }
        return x;
    }

    private int getPromptLength(String s) {
        if (this.getCharCount(s) < s.length()) {
            return this.getCharCount(s);
        }
        return s.length();
    }

    private void splatBuffer(int startLine, IBuffer buffer, Redraw rd) throws IOException {
        if (this.historyReturned) {
            this.historySplat(startLine, buffer, rd);
        } else if (startLine > 1 || rd.getCompletions() != null && rd.getCompletions().size() > 0 && startLine - rd.getCompletions().size() > 1) {
            this.smallSplat(startLine, buffer, rd);
        } else {
            this.bigSplat(buffer, rd);
        }
    }

    private void writeLine(IBuffer buffer, int lineNumber, boolean clearNextLine) throws IOException {
        if (++lineNumber == 1) {
            this.write(this.basePrompt + buffer.getLine(lineNumber));
            this.flush();
        } else if (this.fullRedraw) {
            this.write(IndexBuilder.getIndex(lineNumber, buffer.getCurrentLine()) + buffer.getLine(lineNumber));
            this.flush();
        } else {
            this.write(IndexBuilder.getIndex(lineNumber, 1));
            this.flush();
        }
        if (clearNextLine) {
            this.write(Ansi.ansi().cursorDown(1).toString());
            this.flush();
            this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
            this.flush();
        }
    }

    private void historySplat(int startLine, IBuffer buffer, Redraw rd) throws IOException {
        this.write(Ansi.ansi().cursor(startLine, 0).toString());
        this.flush();
        this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
        this.flush();
        int index = 0;
        if (buffer.size() > this.getTerminal().getHeight()) {
            for (int i = index = buffer.getCurrentLine() - this.getTerminal().getHeight(); i < buffer.size(); ++i) {
                this.writeLine(buffer, i, i + 1 < buffer.size());
            }
        } else {
            int i;
            index = buffer.size() - this.getTerminal().getHeight() + startLine;
            int n = i = index > 0 ? index - 1 : 0;
            while (i < buffer.size()) {
                this.writeLine(buffer, i, i + 1 < buffer.size());
                ++i;
            }
        }
    }

    private void smallSplat(int startLine, IBuffer buffer, Redraw rd) throws IOException {
        if (rd.getCompletions() != null) {
            this.smallPaintPredictions(startLine, buffer, rd);
        } else {
            this.resetMaxDrawnbuffer();
            this.write(Ansi.ansi().cursor(startLine, 0).toString());
            this.flush();
            this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
            this.flush();
        }
        for (int i = 0; i < buffer.size(); ++i) {
            this.writeLine(buffer, i, i < buffer.size() - 1);
        }
    }

    private void smallPaintPredictions(int startLine, IBuffer buffer, Redraw rd) throws IOException {
        if (this.maxBufferDrawn < buffer.size() + rd.getCompletions().size() && this.maxBufferDrawn < this.getTerminal().getHeight() && buffer.size() + rd.getCompletions().size() > this.getTerminal().getHeight()) {
            this.printNewLinesAtBottom(this.getTerminal().getHeight() - this.maxBufferDrawn);
            this.maxBufferDrawn = this.getTerminal().getHeight();
        }
        this.resetMaxDrawnbuffer();
        if (rd.getCompletions().size() > 0) {
            if ((startLine -= rd.getCompletions().size()) < 1) {
                startLine = 1;
            }
            if (startLine > this.getTerminal().getHeight()) {
                startLine = this.getTerminal().getHeight() - 1;
            }
            this.write(Ansi.ansi().cursor(startLine, 0).toString());
            this.flush();
            this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
            this.flush();
            Iterator<String> it = rd.getCompletions().iterator();
            do {
                this.write(it.next());
                this.write(Ansi.ansi().cursorDown(1).toString());
                this.flush();
                this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
                this.flush();
            } while (it.hasNext());
        }
        this.clearCompletions = true;
    }

    private void bigSplat(IBuffer buffer, Redraw rd) throws IOException {
        block15: {
            int topLineNumber;
            int bottom;
            block13: {
                int top2;
                int cursorLine;
                block14: {
                    int top = 1;
                    bottom = this.getTerminal().getHeight();
                    int currentline = rd.getLine();
                    cursorLine = buffer.getTermLine();
                    int lines2TopFromCurrentLine = cursorLine - top;
                    topLineNumber = currentline - lines2TopFromCurrentLine - 1;
                    this.write(Ansi.ansi().cursor(top, 0).toString());
                    this.flush();
                    this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
                    this.flush();
                    if (rd.getCompletions() == null || rd.getCompletions().size() <= 0) break block13;
                    int lines = rd.getCompletions().size();
                    if (lines2TopFromCurrentLine - lines <= 0) break block14;
                    int lines2ShowAtTop = cursorLine - lines - 1;
                    for (int i = 0; i < lines2ShowAtTop; ++i) {
                        this.writeLine(buffer, topLineNumber, true);
                        ++topLineNumber;
                    }
                    Iterator<String> it = rd.getCompletions().iterator();
                    while (it.hasNext()) {
                        this.write(it.next());
                        this.write(Ansi.ansi().cursorDown(1).toString());
                        this.flush();
                        this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
                        this.flush();
                        ++topLineNumber;
                    }
                    for (int i = buffer.getTermLine(); i < bottom; ++i) {
                        if (i == bottom - 1) {
                            this.writeLine(buffer, topLineNumber, false);
                        } else {
                            this.writeLine(buffer, topLineNumber, true);
                        }
                        ++topLineNumber;
                    }
                    this.clearCompletions = true;
                    break block15;
                }
                for (int i = top2 = topLineNumber; i < top2 + cursorLine; ++i) {
                    this.writeLine(buffer, topLineNumber, true);
                    ++topLineNumber;
                }
                Iterator<String> it = rd.getCompletions().iterator();
                while (it.hasNext()) {
                    this.write(it.next());
                    this.write(Ansi.ansi().cursorDown(1).toString());
                    this.flush();
                    this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
                    this.flush();
                    ++topLineNumber;
                }
                if (topLineNumber - top2 >= this.getTerminal().getHeight()) break block15;
                for (int i = buffer.getTermLine() + rd.getCompletions().size(); i < bottom; ++i) {
                    if (i == bottom - 1) {
                        this.writeLine(buffer, topLineNumber, false);
                    } else {
                        this.writeLine(buffer, topLineNumber, true);
                    }
                    ++topLineNumber;
                }
                break block15;
            }
            for (int i = 0; i < bottom; ++i) {
                if (i == bottom - 1) {
                    this.writeLine(buffer, topLineNumber, false);
                } else {
                    this.writeLine(buffer, topLineNumber, true);
                }
                ++topLineNumber;
            }
        }
    }

    private void clearLine(int startLine) throws IOException {
        this.write(Ansi.ansi().cursor(startLine, 0).toString());
        this.flush();
        this.write(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + Ansi.ansi().a('\r').toString());
        this.flush();
    }

    public boolean isRunBufferNow() {
        return this.runNow;
    }

    public void setRunBufferNow(boolean runNow) {
        this.runNow = runNow;
    }

    public void resetRedraw() {
        this.fullRedraw = false;
    }

    public void setFullRedraw(boolean redraw) {
        this.fullRedraw = redraw;
    }

    public String readNonBlockingText() {
        try {
            return this.in.fullRead(true);
        }
        catch (IOException e) {
            return "";
        }
    }

    public void setClearScreenMode(String mode) {
        this.clearScreenMode = mode;
    }

    public IAcceptTypeHandler getAcceptHandler() {
        return this.acceptHandler;
    }

    public void setAcceptHandler(IAcceptTypeHandler acceptHandler) {
        this.acceptHandler = acceptHandler;
    }

    public static abstract class LikeTerminal
    implements Terminal {
        public abstract Terminal getT();

        public void init() throws Exception {
            this.getT().init();
        }

        public void restore() throws Exception {
            this.getT().restore();
        }

        public void reset() throws Exception {
            this.getT().reset();
        }

        public boolean isSupported() {
            return this.getT().isSupported();
        }

        public int getWidth() {
            return this.getT().getWidth();
        }

        public int getHeight() {
            return this.getT().getHeight();
        }

        public boolean isAnsiSupported() {
            return this.getT().isAnsiSupported();
        }

        public OutputStream wrapOutIfNeeded(OutputStream out) {
            return this.getT().wrapOutIfNeeded(out);
        }

        public InputStream wrapInIfNeeded(InputStream in) throws IOException {
            return this.getT().wrapInIfNeeded(in);
        }

        public boolean hasWeirdWrap() {
            return this.getT().hasWeirdWrap();
        }

        public boolean isEchoEnabled() {
            return this.getT().isEchoEnabled();
        }

        public void setEchoEnabled(boolean enabled) {
            this.getT().setEchoEnabled(enabled);
        }

        public String getOutputEncoding() {
            return this.getT().getOutputEncoding();
        }
    }

    public class Redraw {
        private int line = 0;
        private int bufferLoc = 0;
        private boolean delete = false;
        private ArrayList<String> candidates;
        private boolean dontReDraw = false;

        public Redraw(int currentLine, int newBufferLoc, boolean delete) {
            this.setLine(currentLine);
            this.setBufferLoc(newBufferLoc);
            this.setDelete(delete);
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getBufferLoc() {
            return this.bufferLoc;
        }

        public ArrayList<String> getCompletions() {
            return this.candidates;
        }

        public void setBufferLoc(int bufferLoc) {
            this.bufferLoc = bufferLoc;
        }

        public boolean isDelete() {
            return this.delete;
        }

        public void setDelete(boolean delete) {
            this.delete = delete;
        }

        public void setCandidates(ArrayList<String> candidates) {
            this.candidates = candidates;
        }

        public boolean dontRedraw() {
            return this.dontReDraw;
        }

        public final void setDontReDraw(boolean dontReDraw) {
            this.dontReDraw = dontReDraw;
        }
    }

    public static enum CursorState {
        END_GOING_RIGHT,
        START_GOING_LEFT,
        NORMAL;

    }

    public static enum MoveState {
        UP,
        DOWN,
        SAME;

    }

    private static enum State {
        NORMAL,
        SEARCH,
        FORWARD_SEARCH,
        VI_YANK_TO,
        VI_DELETE_TO,
        VI_CHANGE_TO;

    }
}

