/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.IOnConnection;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.scriptrunner.cmdline.NLSLANGParser;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.util.Logger;

@Restricted(level=Restricted.Level.R4)
public class NLSLANGListener
extends AForAllStmtsCommand
implements IOnConnection {
    private static String sql = "alter session set {0} = {1}";
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_NLSLANG;

    public NLSLANGListener() {
        super(m_cmdStmtSubType);
    }

    @Override
    public boolean runOnConnect(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (NLSLANGParser.isNLSLangSet()) {
            ctx.putProperty("NLS_LANG", NLSLANGParser.getNLSLANG());
            Logger.info(this.getClass(), Messages.getString("NLSLANGListener.1") + NLSLANGParser.getNLSLANG() + Messages.getString("NLSLANGListener.2"));
            Logger.info(this.getClass(), Messages.getString("NLSLANGListener.3") + NLSLANGParser.getNLSLanguage() + Messages.getString("NLSLANGListener.4"));
            Logger.info(this.getClass(), Messages.getString("NLSLANGListener.5") + NLSLANGParser.getNLSTerritory() + Messages.getString("NLSLANGListener.6") + Boolean.toString(NLSLANGParser.isValidTerritory(NLSLANGParser.getNLSTerritory())) + Messages.getString("NLSLANGListener.7"));
            Logger.info(this.getClass(), Messages.getString("NLSLANGListener.8") + NLSLANGParser.getNLSEncoding() + Messages.getString("NLSLANGListener.9"));
            if (NLSLANGParser.isNLSLangValid() && NLSLANGParser.isValidLanguage(NLSLANGParser.getNLSLanguage())) {
                this.setLanguage(conn, ctx, NLSLANGParser.getNLSLanguage());
            }
            if (NLSLANGParser.isNLSLangValid() && NLSLANGParser.isValidTerritory(NLSLANGParser.getNLSTerritory())) {
                this.setTerritory(conn, ctx, NLSLANGParser.getNLSTerritory());
            }
            if (NLSLANGParser.isNLSLangValid() && NLSLANGParser.isValidCharacterSet(NLSLANGParser.getNLSEncoding())) {
                this.setEncoding(conn, ctx, NLSLANGParser.getNLSEncoding());
            }
        } else {
            Logger.info(this.getClass(), Messages.getString("NLSLANGListener.10"));
        }
        return false;
    }

    private void setEncoding(Connection conn, ScriptRunnerContext ctx, String nlsEncoding) {
        try {
            ctx.setEncoding(nlsEncoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTerritory(Connection conn, ScriptRunnerContext ctx, String nlsTerritory) {
        try {
            conn.createStatement().execute(MessageFormat.format(sql, Messages.getString("NLSLANGListener.11"), nlsTerritory));
        }
        catch (SQLException e) {
            Logger.warn(this.getClass(), e);
        }
    }

    private void setLanguage(Connection conn, ScriptRunnerContext ctx, String nlsLanguage) {
        try {
            conn.createStatement().execute(MessageFormat.format(sql, Messages.getString("NLSLANGListener.12"), nlsLanguage));
        }
        catch (SQLException e) {
            Logger.warn(this.getClass(), e);
        }
    }

    @Override
    public boolean runOnDisconnect(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.endEvent(conn, ctx, cmd);
        if (this instanceof IOnConnection && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT)) {
            this.runOnConnect(conn, ctx, cmd);
        }
    }
}

