/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class OCICommand
extends CommandListener
implements IHelp {
    private static final String OCI_CMD = "oci";
    private static final String OCI_PROFILE_NAME = "oci.profile.name";

    @Override
    public String getCommand() {
        return OCI_CMD;
    }

    @Override
    public String getHelp() {
        return Messages.getString("OCI_CMD_HELP");
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (OCICommand.matches(OCI_CMD, cmd.getSql())) {
            block35: {
                String[] parts = cmd.getSql().replace("\n", "").split("\\s+");
                if (parts.length > 1 && parts[1].equalsIgnoreCase("profile") && parts.length != 3) {
                    try {
                        OCIProfiles p = new OCIProfiles();
                        ctx.write(Messages.getString("OCI_PROFILES"));
                        for (String profile : p.getProfiles()) {
                            ctx.write("\t" + profile + "\n");
                        }
                    }
                    catch (IOException e) {
                        ctx.write(e.getLocalizedMessage() + "\n");
                    }
                } else if (parts.length == 3 && parts[1].equalsIgnoreCase("profile")) {
                    try {
                        OCIProfiles p = new OCIProfiles();
                        if (p.getProfiles().contains(parts[2])) {
                            ctx.putProperty(OCI_PROFILE_NAME, parts[2]);
                            break block35;
                        }
                        ctx.write(Messages.getString("OCI_PROFILE_INVALID"));
                    }
                    catch (IOException e) {
                        ctx.write(e.getLocalizedMessage() + "\n");
                    }
                } else if (ctx.getProperty(OCI_PROFILE_NAME) != null && (parts.length == 4 || parts.length == 5)) {
                    try {
                        String ct;
                        OCIProfiles p = new OCIProfiles();
                        OCIRESTClient client = p.getOciClient((String)ctx.getProperty(OCI_PROFILE_NAME));
                        OCIRequest req = null;
                        if (parts.length == 4) {
                            req = new OCIRequest.Builder().host(parts[1]).method(parts[2]).target(parts[3]).build();
                        } else if (parts.length == 5) {
                            req = new OCIRequest.Builder().host(parts[1]).method(parts[2]).bodyFile(new File(parts[3])).target(parts[4]).build();
                        }
                        CloseableHttpResponse response = client.getResponse(req);
                        ctx.write("Status:" + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + "\n");
                        HttpEntity ent = response.getEntity();
                        String string = ct = ent != null && ent.getContentType() != null ? ent.getContentType().getValue() : "application/octect";
                        if (ct.equals("application/json")) {
                            String ret = response != null && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
                            ctx.write(ret + "\n");
                            break block35;
                        }
                        if (ent == null || ent.getContentLength() == 0L) break block35;
                        String responseFileName = req.getFinalPath() == null || req.getFinalPath().trim().equals("") ? "response.oci" : req.getFinalPath();
                        Path responsePath = FileUtils.getNewOrExistingPath(ctx, responseFileName);
                        ctx.write(MessageFormat.format(Messages.getString("OCI_FILE_SAVED"), responsePath.toAbsolutePath()));
                        try (InputStream inputStream = ent.getContent();){
                            Files.copy(inputStream, responsePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (InvalidKeyException e) {
                        ctx.write(e.getLocalizedMessage() + "\n");
                    }
                    catch (SignatureException e) {
                        ctx.write(e.getLocalizedMessage() + "\n");
                    }
                    catch (UnsupportedEncodingException e) {
                        ctx.write(e.getLocalizedMessage() + "\n");
                    }
                    catch (GeneralSecurityException e) {
                        ctx.write(e.getLocalizedMessage() + "\n");
                    }
                    catch (IOException e) {
                        ctx.write(e.getLocalizedMessage() + "\n");
                    }
                } else {
                    ctx.write(Messages.getString("OCI_CMD_HELP") + "\n");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

