/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetCodescan
extends CommandListener
implements IHelp,
IShowCommand,
IStoreCommand {
    private static final String SQLINJECTION = "sqlinjection";
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final String OFF = "off";
    private static final String ON = "on";
    boolean bad = false;

    @Override
    public String getCommand() {
        return "CODESCAN";
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString("SETCODESCAN");
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] bits = cmd.getSql().split("\\s+");
        if (bits.length < 2) {
            return false;
        }
        if (!bits[0].toLowerCase().equals("set")) {
            return false;
        }
        if (!bits[1].toLowerCase().equals("code") && !bits[1].toLowerCase().equals("codescan")) {
            return false;
        }
        int recognized = 2;
        try {
            while (recognized < bits.length) {
                block6 : switch (bits[recognized].toLowerCase()) {
                    case "all": {
                        ++recognized;
                        ctx.putProperty("sqlcl.codescan.all", ALL);
                        ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.TRUE);
                        break;
                    }
                    case "none": {
                        ++recognized;
                        ctx.putProperty("sqlcl.codescan.all", NONE);
                        ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.FALSE);
                        break;
                    }
                    case "sqlinjection": {
                        switch (bits[++recognized].toLowerCase()) {
                            case "on": {
                                ++recognized;
                                ctx.removeProperty("sqlcl.codescan.all");
                                ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.TRUE);
                                break block6;
                            }
                            case "off": {
                                ++recognized;
                                ctx.removeProperty("sqlcl.codescan.all");
                                ctx.putProperty("sqlcl.codescan.SQLINJECTION", Boolean.FALSE);
                                break block6;
                            }
                        }
                        ctx.write("Invalid SET CODESCAN SQLINJECTION option\n");
                        ctx.write(this.getHelp());
                        return true;
                    }
                    default: {
                        ctx.write("Invalid SET CODESCAN option\n");
                        ctx.write(this.getHelp());
                        return true;
                    }
                }
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ctx.write("Invalid SET CODESCAN option\n");
            ctx.write(this.getHelp());
            return true;
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"code", "codescan"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Object allObj = ctx.getProperty("sqlcl.codescan.all");
        ctx.write("CODESCAN");
        if (allObj instanceof String) {
            String all = (String)allObj;
            ctx.write(" " + all);
        }
        ctx.write("\n");
        Object sqlinjObj = ctx.getProperty("sqlcl.codescan.SQLINJECTION");
        boolean sqlinj = sqlinjObj == null ? true : Boolean.parseBoolean(sqlinjObj.toString());
        ctx.write("\tsqlinjection " + (sqlinj ? ON : OFF) + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        Object allObj = ctx.getProperty("sqlcl.codescan.all");
        if (allObj instanceof String) {
            return "set codescan " + (String)allObj + "\n";
        }
        Object sqlinjObj = ctx.getProperty("sqlcl.codescan.SQLINJECTION");
        boolean sqlinj = sqlinjObj == null ? true : Boolean.parseBoolean(sqlinjObj.toString());
        return "set codescan sqlinjection " + (sqlinj ? ON : OFF) + "\n";
    }
}

