/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.console.MultiLineHistory;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class SetHistory
extends CommandListener
implements IHelp,
IShowCommand,
IStoreCommand {
    private static final String SHOW = "show";
    private static final String FAILS = "fails";
    private static final String NOFAILS = "nofails";
    private static final String LIMIT = "limit";
    private static final String BLACKLIST = "blacklist";
    private static final String DEFAULT = "default";
    private static final String OFF = "off";
    private static final String ON = "on";
    boolean bad = false;

    @Override
    public String getCommand() {
        return "HISTORY";
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString("SETHISTORY");
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("sethistory") || cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("sethist")) {
            String[] parts = cmd.getSQLOrig().split("\\s+");
            if (parts.length == 3) {
                String[] bits = cmd.getSql().split("\\s+");
                if (bits.length > 2) {
                    switch (bits[2].toLowerCase()) {
                        case "on": {
                            ctx.putProperty("sqlcl.batch.nohistory", Boolean.FALSE);
                            return true;
                        }
                        case "off": {
                            ctx.putProperty("sqlcl.batch.nohistory", Boolean.TRUE);
                            return true;
                        }
                        case "fails": {
                            MultiLineHistory.getInstance().allowFailures(Boolean.TRUE);
                            return true;
                        }
                        case "nofails": {
                            MultiLineHistory.getInstance().allowFailures(Boolean.FALSE);
                            return true;
                        }
                    }
                    ctx.write("Invalid set history option");
                    ctx.write(this.getHelp());
                    return true;
                }
            } else {
                if (parts.length > 3) {
                    block19 : switch (parts[2].toLowerCase()) {
                        case "fails": {
                            if (parts.length > 4) {
                                try {
                                    int x = Integer.parseInt(parts[4]);
                                    if (x < Integer.MAX_VALUE && x >= 5) {
                                        MultiLineHistory.getInstance().setMaxFailSize(x);
                                        break;
                                    }
                                    ctx.write("History Fails limit is a number >= 5\n");
                                    ctx.write(this.getHelp());
                                }
                                catch (NumberFormatException e) {
                                    if (parts[4].equalsIgnoreCase(DEFAULT)) {
                                        MultiLineHistory.getInstance().setMaxFailSize(20);
                                        break;
                                    }
                                    ctx.write("History: Invalid number for history fail limit");
                                    ctx.write(this.getHelp());
                                }
                                break;
                            }
                            ctx.write(this.getHelp());
                            break;
                        }
                        case "limit": {
                            switch (parts[3].toLowerCase()) {
                                case "off": 
                                case "default": {
                                    MultiLineHistory.getInstance().setMaxItems(100);
                                    break block19;
                                }
                            }
                            try {
                                int x = Integer.parseInt(parts[3]);
                                if (x < Integer.MAX_VALUE && x >= 10) {
                                    MultiLineHistory.getInstance().setMaxSize(x);
                                    break;
                                }
                                ctx.write("History limit is a number >= 10");
                                ctx.write(this.getHelp());
                            }
                            catch (NumberFormatException e) {
                                ctx.write("History: Invalid number for history limit");
                                ctx.write(this.getHelp());
                            }
                            break;
                        }
                        case "blacklist": {
                            switch (parts[3].toLowerCase()) {
                                case "default": {
                                    if (parts.length == 4) {
                                        MultiLineHistory.getInstance().setBlackList(MultiLineHistory.getInstance().getBaseBlackList());
                                    } else {
                                        String list = this.getList(parts, 4, ctx);
                                        if (!this.bad) {
                                            MultiLineHistory.getInstance().setBaseBlackList(list);
                                        } else {
                                            ctx.write("Unknown command in history blacklist\n");
                                            this.bad = false;
                                        }
                                    }
                                    return true;
                                }
                            }
                            String list = this.getList(parts, 3, ctx);
                            if (!this.bad) {
                                ctx.putProperty(this.getCommand(), list);
                                MultiLineHistory.getInstance().setBlackList(list);
                            } else {
                                ctx.write("Unknown command in history blacklist\n");
                                this.bad = false;
                            }
                            return true;
                        }
                        default: {
                            ctx.write(this.getHelp());
                        }
                    }
                    return true;
                }
                ctx.write(this.getHelp());
                return true;
            }
        }
        return false;
    }

    private String getList(String[] parts, int x, ScriptRunnerContext ctx) {
        this.bad = false;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = x; i < parts.length; ++i) {
            String blackList = parts[i];
            String[] cmds = blackList.split(",");
            if (cmds.length == 1 && cmds[0].toLowerCase().equals("none") || cmds.length <= 0) continue;
            for (String acmd : cmds) {
                if (!(SQLStatementTypes.spaceRequiredTokens.containsKey(acmd.toLowerCase().trim()) || SetHistory.matches("set", acmd.toLowerCase()) || SetHistory.matches(SHOW, acmd.toLowerCase().trim()))) {
                    ctx.write(MessageFormat.format(Messages.getString("SetNoHistory.9"), acmd));
                    this.bad = true;
                    continue;
                }
                list.add(acmd);
            }
        }
        return this.csv(list, ',');
    }

    public String csv(List<?> list, char delimiter) {
        StringBuilder b = new StringBuilder();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                b.append(list.get(i).toString());
                if (i == list.size() - 1) continue;
                b.append(delimiter);
            }
        }
        return b.toString();
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"hist", "history"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (Boolean.parseBoolean(ctx.getProperty("sqlcl.batch.nohistory").toString())) {
            ctx.write("HISTORY disabled\n");
            return true;
        }
        ctx.write("HISTORY\n\tenabled\n");
        if (ctx.getProperty("sqlcl.batch.nohistory") != null) {
            ctx.write("\tblacklist: " + MultiLineHistory.getInstance().getNoHistory() + "\n");
        } else if (MultiLineHistory.getInstance().getBaseBlackList().length() > 0) {
            ctx.write(MessageFormat.format("\tblacklist: default ({0})\n", MultiLineHistory.getInstance().getBaseBlackList()));
        } else {
            ctx.write("\tblacklist: default \n");
        }
        if (MultiLineHistory.getInstance().showFailures()) {
            ctx.write(MessageFormat.format("\tShow failed statements:({0} statements)\n", MultiLineHistory.getInstance().getMaxFails()));
        } else {
            ctx.write("\tDo not show failed statements\n");
        }
        if (MultiLineHistory.getInstance().getMaxItems() != 100) {
            ctx.write(MessageFormat.format("\tMax Size: {0}\n", MultiLineHistory.getInstance().getMaxItems()));
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (Boolean.parseBoolean(ctx.getProperty("sqlcl.batch.nohistory").toString())) {
            return "set history OFF\n";
        }
        StringBuilder sb = new StringBuilder();
        if (ctx.getProperty("sqlcl.batch.nohistory") != null) {
            sb.append(MessageFormat.format("set history blacklist {0}\n", MultiLineHistory.getInstance().getNoHistory()));
        } else {
            sb.append(MessageFormat.format("set history blacklist {0}\n", MultiLineHistory.getInstance().getBaseBlackList()));
        }
        if (MultiLineHistory.getInstance().showFailures()) {
            sb.append("set history fails\n");
        } else {
            sb.append("set history nofails\n");
        }
        if (MultiLineHistory.getInstance().getMaxItems() != 100) {
            sb.append(MessageFormat.format("set history limit {0}\n", MultiLineHistory.getInstance().getMaxItems()));
        } else {
            sb.append(MessageFormat.format("set history limit {0}\n", 100));
        }
        return sb.toString();
    }
}

