/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.ListPrinter;
import oracle.dbtools.raptor.utils.ValueComparator;
import org.fusesource.jansi.Ansi;

public class AnsiColorListPrinter
extends ListPrinter {
    private List<ValueComparator> comps;

    @Override
    public void setScriptContext(ScriptRunnerContext ctx) {
        this.comps = null;
        String[] formatterOptions = (String[])ctx.getProperty("sql.format.full");
        String conf = null;
        if (formatterOptions != null) {
            for (String s : formatterOptions) {
                if (!s.startsWith("-config=")) continue;
                conf = s.substring(s.indexOf("=") + 1);
            }
        }
        if (conf != null) {
            Path f = FileUtils.getFilePath(ctx, conf);
            if (f != null && f.toFile().exists()) {
                try {
                    byte[] jsonData = Files.readAllBytes(f);
                    Map m = JSON.std.mapFrom((Object)jsonData);
                    String highlights = JSON.std.asString(m.get("highlights"));
                    JSON json = JSON.std.with(new JSON.Feature[]{JSON.Feature.USE_FIELDS}).with(new JSON.Feature[]{JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY});
                    this.comps = json.listOfFrom(ValueComparator.class, (Object)highlights);
                    if (this.comps != null && this.comps.size() > 0) {
                        this.forcePrintValue(true);
                    }
                }
                catch (Exception e) {
                    ctx.write(MessageFormat.format(Messages.getString("SQLFORMAT.ANSI.BADFILE"), conf, e.getLocalizedMessage()));
                }
            } else {
                ctx.write(MessageFormat.format(Messages.getString("SQLFORMAT.ANSI.BADFILE"), conf, ""));
            }
        }
    }

    @Override
    public void printListofList(ScriptRunnerContext ctx, String title, List<List<?>> rows) {
        if (title != null) {
            ctx.write(Ansi.ansi().format(title, new Object[0]).reset() + "\n");
        }
        this.printListofList(ctx, rows);
    }

    @Override
    public void printHeaders(OutputStreamWriter out, int[] widths, int i, List<?> headers, List<Boolean> isNumber) throws IOException {
        int j = 0;
        String headerLine = "";
        for (Object col : headers) {
            String header = null;
            header = col.toString().indexOf("@|") >= 0 && col.toString().indexOf("|@") > 0 ? Ansi.ansi().render(col.toString()).reset().toString() : Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).render(col.toString()).reset().toString();
            out.write(String.join((CharSequence)"", Collections.nCopies(widths[j] - col.toString().length() + 1, " ")) + header);
            headerLine = headerLine + String.join((CharSequence)"", Collections.nCopies(widths[j] + 1, "_")) + " ";
            out.write(" ");
            ++j;
        }
        out.write("\n");
        out.write(headerLine);
        out.write("\n");
    }

    @Override
    public void writeBoldUnderlineFormat(ScriptRunnerContext ctx, String col, int width) {
        ctx.write(Ansi.ansi().bold().a(Ansi.Attribute.UNDERLINE).format("%-" + width + "s", new Object[]{col}).reset().toString());
        ctx.write(" ");
    }

    @Override
    public void printValue(OutputStreamWriter out, int width, String val, boolean isNumber) throws IOException {
        String align = isNumber ? "" : "-";
        ValueComparator match = null;
        String decoratedVal = val;
        if (this.comps != null && this.comps.size() > 0) {
            for (ValueComparator v : this.comps) {
                if (v.getType().equalsIgnoreCase("regex") && val.matches(v.getTest())) {
                    match = v;
                    Pattern pattern = Pattern.compile(v.getTest());
                    Matcher matcher = pattern.matcher(val);
                    String s = null;
                    int lastMatchPos = 0;
                    while (matcher.find()) {
                        int start = matcher.start();
                        int end = matcher.end();
                        s = (s == null ? "" : s) + val.substring(lastMatchPos, start);
                        s = s + Ansi.ansi().render("@|" + match.getColor() + " " + val.substring(start, end) + "|@").toString();
                        lastMatchPos = end;
                    }
                    decoratedVal = s = s + val.substring(lastMatchPos);
                    break;
                }
                if (v.getType().equalsIgnoreCase("exact") && val.equals(v.getTest())) {
                    match = v;
                    decoratedVal = Ansi.ansi().render("@|" + match.getColor() + " " + (val != null ? val : " ") + "|@").toString();
                    break;
                }
                if (v.getType().equalsIgnoreCase("startWith") && val.startsWith(v.getTest())) {
                    match = v;
                    decoratedVal = val.replaceFirst(v.getTest(), Ansi.ansi().render("@|" + match.getColor() + " " + v.getTest() + "|@").toString());
                    break;
                }
                if (v.getType().equalsIgnoreCase("endsWith") && val.endsWith(v.getTest())) {
                    match = v;
                    decoratedVal = val.substring(0, val.lastIndexOf(v.getTest())) + Ansi.ansi().render("@|" + match.getColor() + " " + v.getTest() + "|@").toString();
                    break;
                }
                if (!v.getType().equalsIgnoreCase("contains") || !val.contains(v.getTest())) continue;
                match = v;
                decoratedVal = val.replaceAll(v.getTest(), Ansi.ansi().render("@|" + match.getColor() + " " + v.getTest() + "|@").toString());
                break;
            }
        }
        if (match == null && val != null && val.toString().indexOf("@|") >= 0 && val.toString().indexOf("|@") > 0) {
            decoratedVal = Ansi.ansi().render(val).toString();
        }
        String s = null;
        s = isNumber ? String.join((CharSequence)"", Collections.nCopies(width - val.length() + 1, " ")) + decoratedVal : decoratedVal + String.join((CharSequence)"", Collections.nCopies(width - val.length() + 1, " "));
        out.write(s);
    }
}

