/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlmonitor.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.sqlmonitor.SqlMonitorArb;
import oracle.dbtools.sqlmonitor.editor.SqlMonitorEditor;
import oracle.dbtools.sqlmonitor.models.DetailTreeModel;
import oracle.dbtools.sqlmonitor.models.TabColumnInfo;
import oracle.dbtools.sqlmonitor.nodes.DetailTreeNode;
import oracle.dbtools.sqlmonitor.panels.Messages;
import oracle.dss.gauge.Gauge;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;

public class DetailTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JTreeTable tbl;
    public String _sqlId;
    public int _sessionId;
    public int _sessionSerial;
    private Connection _conn;
    public DetailTreeModel mdl;
    SqlMonitorEditor _editor = null;
    private static final TableCellRenderer cellRenderer = new CellRenderer();
    private static final TableCellRenderer timeLineRenderer = new timeLineRenderer();
    private static final TableCellRenderer cpuRenderer = new cpuRenderer();

    public DetailTreePanel(Connection connection, String string, int n, int n2) {
        this._sqlId = string;
        this._sessionId = n;
        this._sessionSerial = n2;
        this._conn = connection;
        this.init();
    }

    public DetailTreeModel getModel() {
        return this.mdl;
    }

    private void init() {
        Serializable serializable;
        this.mdl = new DetailTreeModel(this._conn, this._sqlId, this._sessionId, this._sessionSerial);
        this.tbl = new JTreeTable((TreeTableModel)this.mdl);
        this.tbl.setAutoResizeMode(4);
        this.tbl.setCellSelectionEnabled(true);
        this.tbl.setColumnSelectionAllowed(true);
        this.tbl.setRowSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.tbl);
        jScrollPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiersEx() == 128) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)new JScrollPane(new JTextArea(DetailTreePanel.this.mdl._xml)), (String)SqlMonitorArb.getString("XML_DIALOG_TITLE"), null);
                }
            }
        });
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setSize(200, 300);
        for (int i = 1; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
            serializable = this.tbl.getColumnModel().getColumn(i);
            if (i == 4) {
                serializable.setCellRenderer(timeLineRenderer);
                continue;
            }
            if (i == 9) {
                serializable.setCellRenderer(cpuRenderer);
                continue;
            }
            if (i == 10) continue;
            serializable.setCellRenderer(cellRenderer);
        }
        JTree jTree = this.tbl.getTree();
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new NodeRenderer());
        jTree.setShowsRootHandles(true);
        serializable = this.tbl.getBackground();
        jScrollPane.setBackground((Color)serializable);
        jScrollPane.getViewport().setBackground((Color)serializable);
        this.setLayout(new GridBagLayout());
        this.expandTree();
        this.initColumnWidths();
        JPanel jPanel = this.getOverviewPanel();
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        if (this.mdl._osuser != null) {
            this.add((Component)this.getUserPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.1, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        } else {
            this.add((Component)new JLabel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.1, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        }
        JPanel jPanel2 = this.getSqlPanel();
        jPanel2.setSize(jPanel.getSize());
        jPanel2.setPreferredSize(jPanel.getPreferredSize());
        this.add((Component)jPanel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.1, 17, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 0, 10), 0, 0));
    }

    private JPanel getSqlPanel() {
        JPanel jPanel = new JPanel();
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setText("");
        basicEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)highlightEditorPlugin);
        basicEditorPane.setText(this.mdl.sql);
        basicEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 22, 32);
        jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel getUserPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), SqlMonitorArb.getString("USER"));
        titledBorder.setTitlePosition(1);
        jPanel.setBorder(titledBorder);
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("USER_NAME")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel(this.mdl._user);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("OS_USER")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(this.mdl._osuser);
        font = jLabel2.getFont();
        jLabel2.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("PROCESS")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel(this.mdl._process);
        font = jLabel3.getFont();
        jLabel3.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("MACHINE")), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel4 = new JLabel(this.mdl._machine);
        font = jLabel4.getFont();
        jLabel4.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel4, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("PROGRAM")), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel5 = new JLabel(String.valueOf(this.mdl._program));
        font = jLabel5.getFont();
        jLabel5.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel5, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("MODULE")), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel6 = new JLabel(this.mdl._module);
        font = jLabel6.getFont();
        jLabel6.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel6, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("CLIENT_INFO")), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel7 = new JLabel(this.mdl._client);
        font = jLabel7.getFont();
        jLabel7.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel7, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel getOverviewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), SqlMonitorArb.getString("OVERVIEW"));
        titledBorder.setTitlePosition(1);
        jPanel.setBorder(titledBorder);
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("SQL_ID")), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel(this.mdl._sqlId);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("START")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(this.mdl.execution_started);
        font = jLabel2.getFont();
        jLabel2.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("LAST")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel(this.mdl.last_refresh_time);
        font = jLabel3.getFont();
        jLabel3.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("EXEC_ID")), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel4 = new JLabel(this.mdl.execution_id);
        font = jLabel4.getFont();
        jLabel4.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel4, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("SESSION")), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel5 = new JLabel(String.valueOf(this.mdl._sessionId));
        font = jLabel5.getFont();
        jLabel5.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel5, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("FETCH")), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel6 = new JLabel(this.mdl.user_fetch_count);
        font = jLabel6.getFont();
        jLabel6.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel6, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlMonitorArb.getString("STATUS")), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel7 = new JLabel(this.mdl.status);
        font = jLabel7.getFont();
        jLabel7.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel7, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    public void initColumnWidths() {
        try {
            TabColumnInfo tabColumnInfo = TabColumnInfo.read();
            for (int i = 0; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
                TableColumn tableColumn = this.tbl.getColumnModel().getColumn(i);
                Object object = tableColumn.getHeaderValue();
                if (object != null && tabColumnInfo.columnWidths.get(object) != null) {
                    tableColumn.setPreferredWidth(tabColumnInfo.columnWidths.get(object));
                    continue;
                }
                tableColumn.setPreferredWidth(i == 0 ? 300 : 200);
            }
        }
        catch (Exception exception) {
            for (int i = 0; i < this.tbl.getColumnModel().getColumnCount(); ++i) {
                this.tbl.getColumnModel().getColumn(i).setPreferredWidth(i == 0 ? 300 : 200);
            }
        }
        this.tbl.getColumnModel().setColumnMargin(10);
    }

    public void expandTree() {
        JTree jTree = this.tbl.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            jTree.expandPath(treePath);
        }
    }

    public void refresh() {
        this.getModel().refresh();
    }

    class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        NodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            jLabel.setIcon(this.getNodeIcon(object));
            try {
                DetailTreeNode detailTreeNode = (DetailTreeNode)object;
                if (detailTreeNode.color != null) {
                    jLabel.setForeground(detailTreeNode.color);
                } else {
                    jLabel.setForeground(Color.BLACK);
                }
                jLabel.setToolTipText(detailTreeNode.tooltip());
            }
            catch (Exception exception) {
                jLabel.setForeground(Color.RED);
            }
            this.setBackgroundSelectionColor(DetailTreePanel.this.tbl.getBackground());
            return jLabel;
        }

        protected Icon getNodeIcon(Object object) {
            Icon icon = null;
            if (object instanceof DetailTreeNode) {
                DetailTreeNode detailTreeNode = (DetailTreeNode)object;
                if (detailTreeNode.active) {
                    icon = SqlMonitorArb.getIcon("ACTIVE_ICON");
                }
            }
            return icon;
        }
    }

    private static class timeLineRenderer
    extends DefaultTableCellRenderer {
        private Gauge _gauge;
        private static final long serialVersionUID = 1L;

        timeLineRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "/");
            if (this._gauge == null) {
                this._gauge = new Gauge();
            }
            Double d = Double.parseDouble(stringTokenizer.nextToken());
            Double d2 = Double.parseDouble(stringTokenizer.nextToken());
            Double d3 = Double.parseDouble(stringTokenizer.nextToken());
            Object[] objectArray = new Object[]{""};
            Object[][] objectArray2 = new Object[5][1];
            objectArray2[0][0] = d;
            objectArray2[1][0] = 0;
            objectArray2[2][0] = d;
            objectArray2[3][0] = d2;
            objectArray2[4][0] = d3 + d2;
            Object[] objectArray3 = new Object[]{"value", "min", "max", "low", "high"};
            Object[] objectArray4 = new Object[]{"DST_METRIC", "DST_MINIMUM", "DST_MAXIMUM", "DST_THRESHOLD", "DST_THRESHOLD"};
            this._gauge.setGridData(objectArray4, objectArray3, objectArray, objectArray2);
            this._gauge.setToolTipText(MessageFormat.format(Messages.getString("DetailTreePanel.10"), Double.toString(d), Double.toString(d2), Double.toString(d3)));
            this._gauge.getTopLabel().setPosition(0);
            this._gauge.getBottomLabel().setPosition(0);
            this._gauge.getMetricLabel().setPosition(0);
            this._gauge.getTickLabel().setContent(0);
            this._gauge.getTickMark().setContent(0);
            this._gauge.getCommonGauge().setVisualEffects(0);
            this._gauge.getCommonGauge().setGaugeSetAlignment(0);
            this._gauge.getThreshold().setFillColor(0, Color.WHITE);
            this._gauge.getThreshold().setFillColor(1, Color.BLUE);
            this._gauge.getThreshold().setBorderColor(1, Color.WHITE);
            this._gauge.getThreshold().setFillColor(2, Color.WHITE);
            this._gauge.getPlotArea().setBorderColor(Color.WHITE);
            this._gauge.getPlotArea().setFillColor(Color.WHITE);
            this._gauge.getGaugeBackground().setBorderColor(Color.WHITE);
            this._gauge.getGaugeBackground().setFillColor(Color.WHITE);
            this._gauge.getIndicator().setBarBorderColor(Color.WHITE);
            this._gauge.getIndicator().setBarFillColor(Color.WHITE);
            this._gauge.getIndicator().setBaseBorderColor(Color.WHITE);
            this._gauge.getIndicator().setBaseFillColor(Color.WHITE);
            this._gauge.getIndicator().setBorderColor(Color.WHITE);
            this._gauge.getIndicator().setFillColor(Color.WHITE);
            this._gauge.setGaugeType(1);
            return this._gauge;
        }
    }

    private static class cpuRenderer
    extends DefaultTableCellRenderer {
        private Gauge _gauge;
        private static final long serialVersionUID = 1L;

        cpuRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "/");
            if (this._gauge == null) {
                this._gauge = new Gauge();
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            float f = Float.parseFloat(stringTokenizer.nextToken());
            Object[] objectArray = new Object[]{""};
            Object[][] objectArray2 = new Object[5][1];
            objectArray2[0][0] = Float.valueOf(f);
            objectArray2[1][0] = 0;
            objectArray2[2][0] = 100;
            objectArray2[3][0] = 0;
            objectArray2[4][0] = 100;
            Object[] objectArray3 = new Object[]{"value", "min", "max", "low", "high"};
            Object[] objectArray4 = new Object[]{"DST_METRIC", "DST_MINIMUM", "DST_MAXIMUM", "DST_THRESHOLD", "DST_THRESHOLD"};
            this._gauge.setGridData(objectArray4, objectArray3, objectArray, objectArray2);
            this._gauge.setToolTipText(MessageFormat.format(Messages.getString("DetailTreePanel.7"), n3, n4, Float.valueOf(f)));
            this._gauge.getTopLabel().setPosition(0);
            this._gauge.getBottomLabel().setPosition(0);
            this._gauge.getMetricLabel().setPosition(0);
            this._gauge.getTickLabel().setContent(0);
            this._gauge.getTickMark().setContent(0);
            this._gauge.getCommonGauge().setVisualEffects(0);
            this._gauge.getCommonGauge().setGaugeSetAlignment(0);
            this._gauge.getThreshold().setFillColor(0, Color.WHITE);
            this._gauge.getThreshold().setFillColor(1, Color.WHITE);
            this._gauge.getThreshold().setBorderColor(1, Color.WHITE);
            this._gauge.getThreshold().setFillColor(2, Color.WHITE);
            this._gauge.getPlotArea().setBorderColor(Color.WHITE);
            this._gauge.getPlotArea().setFillColor(Color.WHITE);
            this._gauge.getGaugeBackground().setBorderColor(Color.WHITE);
            this._gauge.getGaugeBackground().setFillColor(Color.WHITE);
            this._gauge.getIndicator().setBarBorderColor(Color.WHITE);
            this._gauge.getIndicator().setBarFillColor(Color.GREEN);
            this._gauge.getIndicator().setBaseBorderColor(Color.WHITE);
            this._gauge.getIndicator().setBaseFillColor(Color.WHITE);
            this._gauge.getIndicator().setBorderColor(Color.WHITE);
            this._gauge.getIndicator().setFillColor(Color.WHITE);
            this._gauge.setGaugeType(1);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this._gauge, new GridBagConstraints(0, 0, 1, 1, 10.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            JLabel jLabel = new JLabel(String.valueOf(f));
            jPanel.setBackground(Color.WHITE);
            jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 2.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.setToolTipText(MessageFormat.format(Messages.getString("DetailTreePanel.8"), n3, n4, Float.valueOf(f)));
            return jPanel;
        }
    }

    private static class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CellRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            try {
                Long.valueOf((String)object);
                jLabel.setHorizontalAlignment(4);
            }
            catch (Exception exception) {
                jLabel.setHorizontalAlignment(2);
            }
            if (n2 == 7) {
                StringTokenizer stringTokenizer = new StringTokenizer(object == null ? " / " : object.toString(), "/");
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                jLabel.setToolTipText(SqlMonitorArb.getString("MEMORY") + " " + string + " / " + SqlMonitorArb.getString("MAX_MEM") + string2);
            } else if (n2 == 8) {
                StringTokenizer stringTokenizer = new StringTokenizer(object == null ? " / " : object.toString(), "/");
                String string = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                jLabel.setToolTipText(SqlMonitorArb.getString("TEMP") + " " + string + " / " + SqlMonitorArb.getString("MAX_TEMP") + string3);
            } else {
                jLabel.setToolTipText((String)(object == null ? "" : object));
            }
            return jLabel;
        }
    }
}

