/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.vhv.VHVPropertiesPanel;
import oracle.ide.vhv.VHVViewer;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class VHVPropertiesWindow
extends DockableWindow {
    public static final String VIEW_NAME = "VHVPropertiesDockable";
    public static final ViewId VIEW_ID = new ViewId("VHVPropertiesDockable", "VHVPropertiesDockable");
    private static VHVPropertiesWindow _instance;
    private VHVViewer _viewer;
    private JPanel _gui;
    static final String LAYOUT_SHOW_PROPERTIES = "Layout.ShowVHVProperties";

    VHVPropertiesWindow() {
        super(VIEW_ID.getId());
        this.setType(0);
        _instance = this;
        IdeMainWindow mainWindow = Ide.getMainWindow();
        mainWindow.addActiveViewListener(new ActiveViewListener(){

            public void activeViewChanged(ActiveViewEvent ave) {
                VHVPropertiesWindow.this.setActiveView(ave.getNewView());
            }
        });
        this.setActiveView(mainWindow.getIdeMainWindowView());
    }

    public int getDefaultVisibility(Layout layout) {
        String property = layout.getProperty(LAYOUT_SHOW_PROPERTIES, Boolean.FALSE.toString());
        boolean show = Boolean.valueOf(property);
        return show ? 1 : 0;
    }

    public static final VHVPropertiesWindow getInstance() {
        return _instance;
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public String getTitleName() {
        return VHVArb.getString(107);
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"settings.png");
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = new JPanel(new BorderLayout());
            this._gui.add(VHVPropertiesPanel.getInstance().getGUI(), "Center");
            this._updatePropertiesPanel();
        }
        return this._gui;
    }

    private void setActiveView(View view) {
        if (!(view instanceof VHVViewer)) {
            return;
        }
        if (view == this._viewer) {
            return;
        }
        this._viewer = (VHVViewer)view;
        if (this._gui != null) {
            this._updatePropertiesPanel();
        }
    }

    private void _updatePropertiesPanel() {
        if (this._viewer == null) {
            return;
        }
        VHVPropertiesPanel.getInstance().setINameHelper(this._viewer.getVHVControl());
        VHVPropertiesPanel.getInstance().setGraphElement(this._viewer.isInProgress() ? null : this._viewer.getVHVControl().getSelectedGraphElement(), this._viewer.getVHVControl().getCustomizer().isShowStandardProperties());
    }

    public void close() {
        super.close();
    }

    public static final void updatePropertiesPanel() {
        VHVPropertiesWindow instance = VHVPropertiesWindow.getInstance();
        if (instance != null) {
            instance._updatePropertiesPanel();
        }
    }
}

