/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports;

public enum Access {
    EXPORTED("exported"),
    RESTRICTED("restricted"),
    CONCEALED("concealed");

    private String lowerCase;

    private Access(String lowerCase) {
        this.lowerCase = lowerCase;
    }

    public static Access valueOfIgnoreCase(String string) {
        for (Access constant : (Access[])Access.class.getEnumConstants()) {
            if (!constant.lowerCase.equalsIgnoreCase(string)) continue;
            return constant;
        }
        throw new IllegalArgumentException("expected \"exported\", \"resricted\", or \"concealed\" (ignoring case): actual \"" + string + '\"');
    }

    public boolean isExported() {
        return this == EXPORTED;
    }

    public boolean isRestricted() {
        return this == RESTRICTED;
    }

    public boolean isConcealed() {
        return this == CONCEALED;
    }

    public boolean isExportedOrRestricted() {
        return this != CONCEALED;
    }

    public boolean isConcealedOrRestricted() {
        return this != EXPORTED;
    }

    public String toUpperCase() {
        return this.toString();
    }

    public String toLowerCase() {
        return this.lowerCase;
    }

    public String toString() {
        return this.toLowerCase();
    }

    public static boolean isExported(Access access) {
        return access != null && access.isExported();
    }

    public static boolean isRestricted(Access access) {
        return access != null && access.isRestricted();
    }

    public static boolean isConcealed(Access access) {
        return access != null && access.isConcealed();
    }

    public static boolean isExportedOrRestricted(Access access) {
        return access != null && access.isExportedOrRestricted();
    }

    public static boolean isExportedOrNull(Access access) {
        return access == null || access.isExported();
    }

    public static boolean isConcealedOrRestricted(Access access) {
        return access != null && access.isConcealedOrRestricted();
    }

    public static boolean isConcealedOrNull(Access access) {
        return access == null || access.isConcealed();
    }

    public static int ordinal(Access access) {
        return access != null ? access.ordinal() : Integer.MAX_VALUE;
    }

    public static boolean isMoreExported(Access left, Access right) {
        return Access.ordinal(left) < Access.ordinal(right);
    }

    public static boolean isMoreConcealed(Access left, Access right) {
        return Access.ordinal(left) > Access.ordinal(right);
    }

    public static Access mostExported(Access left, Access right) {
        return Access.ordinal(left) < Access.ordinal(right) ? left : right;
    }

    public static Access mostConcealed(Access left, Access right) {
        return Access.ordinal(left) < Access.ordinal(right) ? right : left;
    }

    public static Access mostExported(Access ... values) {
        Access access = values[0];
        int ordinal = Access.ordinal(access);
        for (int i = 1; i < values.length; ++i) {
            Access a = values[i];
            int o = Access.ordinal(a);
            if (o >= ordinal) continue;
            ordinal = o;
            access = a;
        }
        return access;
    }

    public static Access mostConcealed(Access ... values) {
        Access access = values[0];
        int ordinal = Access.ordinal(access);
        for (int i = 1; i < values.length; ++i) {
            Access a = values[i];
            int o = Access.ordinal(a);
            if (o <= ordinal) continue;
            ordinal = o;
            access = a;
        }
        return access;
    }

    public static int compare(Access left, Access right) {
        return Integer.compare(Access.ordinal(left), Access.ordinal(right));
    }
}

