/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.ObjIntConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.classpath.AnnotationAccessPolicy;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.ClassPathRoot;
import oracle.javatools.exports.classpath.Constructor;
import oracle.javatools.exports.classpath.Element;
import oracle.javatools.exports.classpath.Field;
import oracle.javatools.exports.classpath.FileTree;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.ModelScope;
import oracle.javatools.exports.classpath.NestedFileSystemPool;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.common.StringPool;
import oracle.javatools.exports.common.StringSegment;
import oracle.javatools.exports.common.StringSegmentIterator;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.IllegalNameException;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.util.UnexpectedExceptionError;

public class BaselineReaderWriter {
    private static final int BASELINE_FORMAT = 3;
    private static final int BASELINE_SUPPORTED_FORMAT = 3;
    private static final Charset BASELINE_ENCODING = StandardCharsets.UTF_8;
    private static final String[] NO_STRINGS = new String[0];

    public void write(ClassPathModel model, ExportDomain domain, Path middlewareHome, Path path) throws CommandException {
        try (BufferedWriter writer = this.createBaselineWriter(path);){
            EnumMap<BaselineProperty, String> baselineProperties = new EnumMap<BaselineProperty, String>(BaselineProperty.class);
            baselineProperties.put(BaselineProperty.FORMAT, String.valueOf(3));
            baselineProperties.put(BaselineProperty.ENCODING, String.valueOf(BASELINE_ENCODING));
            baselineProperties.put(BaselineProperty.FLAGS, String.valueOf(2));
            baselineProperties.put(BaselineProperty.SOURCE, model.getSource());
            baselineProperties.put(BaselineProperty.ROOTS, String.valueOf(model.getRoots().size()));
            for (Map.Entry entry : baselineProperties.entrySet()) {
                writer.write("PROPERTY ");
                writer.write(entry.getKey().toString());
                writer.write(" ");
                String value = (String)entry.getValue();
                if (value == null) {
                    value = "";
                }
                writer.write(value);
                writer.newLine();
            }
            for (ExportDomain.Subdomain subdomain : domain.getSubdomains()) {
                writer.write("DOMAIN ");
                writer.write(subdomain.getName());
                String[] exceptions = subdomain.getExceptions();
                for (int i = 0; i < exceptions.size(); ++i) {
                    writer.write(i == 0 ? 32 : 44);
                    writer.write(exceptions.get(i));
                }
                writer.newLine();
            }
            for (ClassPathModel.LibraryDescription library : model.getLibraries()) {
                writer.write("LIBRARY ");
                writer.write(library.getId());
                writer.write(32);
                writer.write(library.getPath());
                writer.write(" \"");
                writer.write(library.getName());
                writer.write(34);
                for (String alias : library.getAliases()) {
                    writer.write(" \"");
                    writer.write(alias);
                    writer.write(34);
                }
                writer.newLine();
            }
            int rootCount = 0;
            int rootJdkCount = 0;
            HashMap<ClassPathRoot, Integer> rootIndexes = new HashMap<ClassPathRoot, Integer>();
            for (ClassPathRoot root : model.getRoots()) {
                ClassPathRoot.Status status = root.getStatus();
                if (!root.isControlled() && (status != ClassPathRoot.Status.JDK || rootJdkCount++ > 0)) continue;
                rootIndexes.put(root, ++rootCount);
                writer.write("ROOT ");
                writer.write(Integer.toString(rootCount));
                writer.write(32);
                writer.write(status.toString());
                if (status != ClassPathRoot.Status.JDK) {
                    writer.write(32);
                    writer.write(Paths.relativize(root.getPath(), middlewareHome));
                    writer.write(32);
                    writer.write(Integer.toString(root.getTypeNameCount()));
                }
                writer.newLine();
            }
            FlagsWriter flagsWriter = new FlagsWriter(writer);
            for (Package packag : model.getControlledPackages()) {
                writer.write(packag.getKind().toUpperCase());
                writer.write(32);
                packag.getName().writeQualifiedHybridName(writer);
                writer.write(32);
                packag.encodeFlags(flagsWriter);
                writer.newLine();
                for (Type type : packag.getControlledTypes()) {
                    writer.write(type.getKind().toUpperCase());
                    writer.write(32);
                    type.getName().writeQualifiedHybridName(writer);
                    writer.write(32);
                    writer.write(String.valueOf(rootIndexes.get(type.getRoot())));
                    writer.write(32);
                    type.encodeFlags(flagsWriter);
                    Iterator<Type> interfaces = type.getInterfaces().iterator();
                    if (!type.isInterface()) {
                        Type superClass = type.getSuperClass();
                        if (interfaces.hasNext() || !superClass.getName().equals(TypeName.JAVA_LANG_OBJECT)) {
                            writer.write(32);
                            superClass.getName().writeQualifiedHybridName(writer);
                        }
                    }
                    int separator = 32;
                    while (interfaces.hasNext()) {
                        writer.write(separator);
                        interfaces.next().getName().writeQualifiedHybridName(writer);
                        separator = 44;
                    }
                    writer.newLine();
                    for (Member<?> member : type.getDeclaredMembers()) {
                        assert (member.isExportable());
                        assert (!member.isEscalated() || member.getEscalation() != Member.Escalation.NONE);
                        assert (!member.isSuppressed() || member.getEscalation() != Member.Escalation.NONE);
                        writer.write(member.getKind().toUpperCase());
                        writer.write(32);
                        member.getResolvedName().writeQualifiedHybridName(writer);
                        writer.write(32);
                        member.encodeFlags(flagsWriter);
                        block5 : switch (member.getKind()) {
                            case METHOD: {
                                writer.write(32);
                                Method method = (Method)member;
                                Type returnType = method.getReturnType();
                                TypeName returnTypeName = returnType != null ? returnType.getName() : method.getReturnTypeName();
                                returnTypeName.writeQualifiedHybridName(writer);
                                break;
                            }
                            case FIELD: {
                                writer.write(32);
                                Field field = (Field)member;
                                Type fieldType = field.getFieldType();
                                TypeName fieldTypeName = fieldType != null ? fieldType.getName() : field.getFieldTypeName();
                                fieldTypeName.writeQualifiedHybridName(writer);
                                if (field.getConstantValue() == null) break;
                                writer.write(32);
                                switch (fieldType.getSimpleName()) {
                                    case "char": {
                                        writer.write(BaselineReaderWriter.encode(field.getConstantValue().toString(), '\''));
                                        break block5;
                                    }
                                    case "String": {
                                        writer.write(BaselineReaderWriter.encode(field.getConstantValue().toString(), '\"'));
                                        break block5;
                                    }
                                }
                                writer.write(field.getConstantValue().toString());
                            }
                        }
                        writer.newLine();
                    }
                }
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new CommandException(e, "Baseline file %s not created: %s", path, e);
        }
    }

    protected BufferedWriter createBaselineWriter(Path path) throws IOException {
        Path zipPath = path;
        String entryName = zipPath.getFileName().toString();
        if (entryName.endsWith(".zip")) {
            entryName = entryName.substring(0, entryName.length() - 4);
        } else {
            zipPath = zipPath.resolveSibling(entryName + ".zip");
        }
        ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(zipPath.toFile()));
        zipStream.setLevel(9);
        ZipEntry entry = new ZipEntry(entryName);
        zipStream.putNextEntry(entry);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)zipStream, BASELINE_ENCODING));
    }

    /*
     * Unable to fully structure code
     */
    public static ClassPathModel read(Path baselinePath, Path middlewareHome, List<ClassPathRoot> bootRoots, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, StringPool commentPool, Log log) throws CommandException {
        EMPTY_ROOT_LINE_ARRAY = new RootLine[]{};
        if (bootRoots == null) {
            throw new IllegalStateException("boot class path not specified");
        }
        version = 1;
        flagsVersion = 1;
        source = "unspecified";
        lines = new ArrayList<Line>(1024);
        domain = new ExportDomain(new String[0]);
        libraries = new TreeSet<ClassPathModel.LibraryDescription>();
        rootLines = EMPTY_ROOT_LINE_ARRAY;
        try {
            reader = BaselineReaderWriter.createBaselineReader(baselinePath);
            var16_17 = null;
            try {
                lineCount = 0;
                line = reader.readLine();
                while (line != null) {
                    block143: {
                        block145: {
                            ++lineCount;
                            i = new StringSegmentIterator(line, ' ', new StringSegmentIterator.Option[]{StringSegmentIterator.Option.TRIM});
                            if (!i.hasNext() || (segment = i.next()).charAt(0) == '#') break block143;
                            kind = segment.toEnum(Kind.class);
                            if (kind != null) break block145;
                            log.warning("baseline-syntax", "invalid keyword \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                            break block143;
                        }
                        try {
                            block17 : switch (1.$SwitchMap$oracle$javatools$exports$classpath$BaselineReaderWriter$Kind[kind.ordinal()]) {
                                case 1: {
                                    segment = i.next();
                                    propertyName = segment.toEnum(BaselineProperty.class);
                                    if (propertyName == null) {
                                        log.warning("baseline-unrecognized-property", "unrecognized property name \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), line}).scope(baselinePath);
                                        break;
                                    }
                                    switch (1.$SwitchMap$oracle$javatools$exports$classpath$BaselineReaderWriter$BaselineProperty[propertyName.ordinal()]) {
                                        case 1: {
                                            segment = i.next();
                                            version = segment.toNatural();
                                            if (version >= 1 && version <= 3) break;
                                            log.warning("baseline-unrecognized-version", "unrecognized format version \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), line}).scope(baselinePath);
                                            break block17;
                                        }
                                        case 2: {
                                            segment = i.next();
                                            flagsVersion = segment.toNatural();
                                            if (flagsVersion >= 1 && flagsVersion <= 2) break;
                                            log.warning("baseline-unrecognized-version", "unrecognized flag format version \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), line}).scope(baselinePath);
                                            break block17;
                                        }
                                        case 3: {
                                            segment = i.remainder();
                                            source = segment.toString();
                                            break block17;
                                        }
                                        case 4: {
                                            segment = i.next();
                                            count = segment.toNatural();
                                            if (count < 0) {
                                                log.warning("baseline-invalid-count", "invalid root count %s at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                                break block17;
                                            }
                                            rootLines = count > 0 ? new RootLine[count] : EMPTY_ROOT_LINE_ARRAY;
                                        }
                                    }
                                    break;
                                }
                                case 2: {
                                    segment = i.next();
                                    subdomainName = segment.toString();
                                    exceptions = Collections.emptySet();
                                    if (i.hasNext()) {
                                        exceptions = new TreeSet<T>();
                                        for (StringSegment exception : new StringSegmentIterator(i.next(), ',', new StringSegmentIterator.Option[]{StringSegmentIterator.Option.TRIM})) {
                                            exceptions.add(exception.toString());
                                        }
                                    }
                                    domain.addSubdomain(subdomainName, exceptions);
                                    break;
                                }
                                case 3: {
                                    segment = i.next();
                                    id = segment.toString();
                                    segment = i.next();
                                    path = segment.toString();
                                    segment = i.remainder();
                                    if (segment.charAt(0) != '\"') {
                                        log.warning("baseline-unquoted-name", "unquoted library name at %s:%d", new Object[]{new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    openQuote = 0;
                                    closeQuote = segment.indexOf('\"', openQuote + 1);
                                    if (closeQuote < 0) {
                                        log.warning("baseline-invalid-library", "misquoted library name at %s:%d", new Object[]{new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    name = segment.toString(openQuote + 1, closeQuote);
                                    aliases = Collections.emptyList();
                                    while (closeQuote < segment.getLength() - 1) {
                                        openQuote = closeQuote + 1;
                                        while (Character.isWhitespace(segment.charAt(openQuote))) {
                                            ++openQuote;
                                        }
                                        if (segment.charAt(openQuote) != '\"') {
                                            log.warning("baseline-invalid-library", "misquoted library alias at %s:%d", new Object[]{new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                            continue;
                                        }
                                        closeQuote = segment.indexOf('\"', openQuote + 1);
                                        if (closeQuote < 0) {
                                            log.warning("baseline-invalid-library", "misquoted library name at %s:%d", new Object[]{new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                            continue;
                                        }
                                        if (aliases.isEmpty()) {
                                            aliases = new ArrayList<T>();
                                        }
                                        aliases.add(segment.toString(openQuote + 1, closeQuote));
                                    }
                                    library = new ClassPathModel.LibraryDescription(id, path, name, aliases.isEmpty() != false ? BaselineReaderWriter.NO_STRINGS : aliases.toArray(new String[aliases.size()]));
                                    if (!libraries.add(library)) {
                                        log.warning("baseline-duplicate-library", "duplicate library %s at %s:%d", new Object[]{id, new PathKey(baselinePath), line}).scope(baselinePath);
                                    }
                                    break;
                                }
                                case 4: {
                                    segment = i.next();
                                    rootIndex = segment.toNatural();
                                    if (rootIndex < 0) {
                                        log.warning("baseline-invalid-root", "invalid root index \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    v0 = status = "JAR".equals(segment.toString()) != false ? ClassPathRoot.Status.FILE : segment.toEnum(ClassPathRoot.Status.class);
                                    if (status == null) {
                                        log.warning("baseline-invalid-root", "invalid root status \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    if (status == ClassPathRoot.Status.JDK) {
                                        lines.add(new RootLine(rootIndex, status, null, 0, lineCount));
                                        break;
                                    }
                                    segment = i.next();
                                    path = segment.toString();
                                    segment = i.next();
                                    typeCount = segment.toNatural();
                                    if (typeCount < 0) {
                                        log.warning("baseline-invalid-root", "invalid root type count \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    rootLine = new RootLine(rootIndex, status, path, typeCount, lineCount);
                                    lines.add(rootLine);
                                    rootCount = rootLines.length;
                                    if (rootIndex >= rootCount) {
                                        v1 = rootLines;
                                        rootLines = new RootLine[rootIndex + 16];
                                        System.arraycopy(v1, 0, rootLines, 0, rootCount);
                                    }
                                    if (rootLines[rootIndex] != null) {
                                        rootLine.addTypes(rootLines[rootIndex]);
                                    }
                                    rootLines[rootIndex] = rootLine;
                                    break;
                                }
                                case 5: {
                                    segment = i.next();
                                    try {
                                        name = nameSpace.packageNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-package", "invalid package name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    flags = Element.decodeFlags(ElementKind.PACKAGE, segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), flagsVersion);
                                    if (flags == '\u0000') {
                                        log.warning("baseline-invalid-package", "invalid package flags \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    lines.add(new PackageLine(name, flags, lineCount));
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    segment = i.next();
                                    try {
                                        typeName = nameSpace.typeNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-type", "invalid type name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    rootIndex = segment.toNatural();
                                    if (rootIndex <= 0) {
                                        log.warning("baseline-invalid-type", "invalid root index \"%s\" for type %s at %s:%d", new Object[]{segment.toString(), typeName, new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    rootCount = rootLines.length;
                                    if (rootIndex >= rootCount) {
                                        if (rootIndex > 32767) {
                                            log.warning("baseline-invalid-type", "invalid root index \"%d\" for type %s at %s:%d", new Object[]{rootIndex, typeName, new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                            break;
                                        }
                                        v2 = rootLines;
                                        rootLines = new RootLine[rootIndex + 1];
                                        System.arraycopy(v2, 0, rootLines, 0, rootCount);
                                        rootLines[rootIndex] = new RootLine(rootIndex, null, null, 16, lineCount);
                                    } else if (rootLines[rootIndex] == null) {
                                        rootLines[rootIndex] = new RootLine(rootIndex, null, null, 16, lineCount);
                                    }
                                    segment = i.next();
                                    flags = Element.decodeFlags(Kind.access$000(kind), segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), flagsVersion);
                                    if (flags == '\u0000') {
                                        log.warning("baseline-invalid-type", "invalid type flags \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    superClass = TypeName.JAVA_LANG_OBJECT;
                                    interfaces = TypeName.EMPTY_ARRAY;
                                    if (!i.hasNext()) ** GOTO lbl226
                                    try {
                                        if (kind == Kind.CLASS) {
                                            segment = i.next();
                                            superClass = nameSpace.typeNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                        }
                                        if (i.hasNext()) {
                                            segment = i.next();
                                            iterator = new StringSegmentIterator(segment, ',', new StringSegmentIterator.Option[0]);
                                            interfaces = BaselineReaderWriter.collectInterfaceNames(iterator, 0, nameSpace);
                                        }
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-type", "invalid super type name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
lbl226:
                                    // 3 sources

                                    lines.add(new TypeLine(kind, typeName, rootIndex, flags, (TypeName)superClass, interfaces, lineCount));
                                    rootLines[rootIndex].addType(typeName);
                                    break;
                                }
                                case 8: {
                                    break;
                                }
                                case 9: {
                                    segment = i.next();
                                    try {
                                        memberName = nameSpace.constructorNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-constructor", "invalid constructor name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    flags = Element.decodeFlags(ElementKind.CONSTRUCTOR, segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), flagsVersion);
                                    if (flags == '\u0000') {
                                        log.warning("baseline-invalid-constructor", "invalid constructor flags \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    lines.add(new MemberLine(kind, memberName, flags, null, lineCount));
                                    break;
                                }
                                case 10: {
                                    segment = i.next();
                                    try {
                                        memberName = nameSpace.methodNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-method", "invalid method name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    flags = Element.decodeFlags(ElementKind.METHOD, segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), flagsVersion);
                                    if (flags == '\u0000') {
                                        log.warning("baseline-invalid-method", "invalid method flags \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    try {
                                        type = nameSpace.typeNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-type", "invalid return type name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    lines.add(new MemberLine(kind, memberName, flags, type, lineCount));
                                    break;
                                }
                                case 11: {
                                    segment = i.next();
                                    try {
                                        memberName = nameSpace.fieldNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-field", "invalid field name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    flags = Element.decodeFlags(ElementKind.FIELD, segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), flagsVersion);
                                    if (flags == '\u0000') {
                                        log.warning("baseline-invalid-field", "invalid field flags \"%s\" at %s:%d", new Object[]{segment.toString(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    segment = i.next();
                                    try {
                                        type = nameSpace.typeNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
                                    }
                                    catch (IllegalNameException e) {
                                        log.warning("baseline-invalid-field", "invalid field type name \"%s\" at %s:%d", new Object[]{e.getName(), new PathKey(baselinePath), lineCount}).scope(baselinePath);
                                        break;
                                    }
                                    constantValue = null;
                                    if (type.isPrimitiveOrString()) {
                                        try {
                                            segment = i.remainder();
                                            try {
                                                superClass = type.getSimpleName();
                                                interfaces = -1;
                                                switch (superClass.hashCode()) {
                                                    case 64711720: {
                                                        if (!superClass.equals("boolean")) break;
                                                        interfaces = 0;
                                                        break;
                                                    }
                                                    case 3039496: {
                                                        if (!superClass.equals("byte")) break;
                                                        interfaces = 1;
                                                        break;
                                                    }
                                                    case 3052374: {
                                                        if (!superClass.equals("char")) break;
                                                        interfaces = 2;
                                                        break;
                                                    }
                                                    case 109413500: {
                                                        if (!superClass.equals("short")) break;
                                                        interfaces = 3;
                                                        break;
                                                    }
                                                    case 104431: {
                                                        if (!superClass.equals("int")) break;
                                                        interfaces = 4;
                                                        break;
                                                    }
                                                    case 3327612: {
                                                        if (!superClass.equals("long")) break;
                                                        interfaces = 5;
                                                        break;
                                                    }
                                                    case 97526364: {
                                                        if (!superClass.equals("float")) break;
                                                        interfaces = 6;
                                                        break;
                                                    }
                                                    case -1325958191: {
                                                        if (!superClass.equals("double")) break;
                                                        interfaces = 7;
                                                        break;
                                                    }
                                                    case -1808118735: {
                                                        if (!superClass.equals("String")) break;
                                                        interfaces = 8;
                                                    }
                                                }
                                                switch (interfaces) {
                                                    case 0: {
                                                        if (!segment.toString().equalsIgnoreCase("true") && !segment.toString().equalsIgnoreCase("false")) {
                                                            throw new IllegalArgumentException();
                                                        }
                                                        constantValue = Boolean.valueOf(segment.toString());
                                                        break;
                                                    }
                                                    case 1: {
                                                        constantValue = Byte.parseByte(segment.toString());
                                                        break;
                                                    }
                                                    case 2: {
                                                        string = BaselineReaderWriter.decode(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), 39);
                                                        if (string.length() != 1) {
                                                            throw new IllegalArgumentException();
                                                        }
                                                        constantValue = Character.valueOf(string.charAt(0));
                                                        break;
                                                    }
                                                    case 3: {
                                                        constantValue = Short.parseShort(segment.toString());
                                                        break;
                                                    }
                                                    case 4: {
                                                        constantValue = Integer.parseInt(segment.toString());
                                                        break;
                                                    }
                                                    case 5: {
                                                        constantValue = Long.parseLong(segment.toString());
                                                        break;
                                                    }
                                                    case 6: {
                                                        constantValue = Float.valueOf(Float.parseFloat(segment.toString()));
                                                        break;
                                                    }
                                                    case 7: {
                                                        constantValue = Double.parseDouble(segment.toString());
                                                        break;
                                                    }
                                                    case 8: {
                                                        constantValue = BaselineReaderWriter.decode(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset(), 34);
                                                        break;
                                                    }
                                                    default: {
                                                        constantValue = null;
                                                        break;
                                                    }
                                                }
                                            }
                                            catch (IllegalArgumentException e) {
                                                log.warning("baseline-invalid-constant", "invalid %s constant value \"%s\" at %s:%d", new Object[]{type.getSimpleName(), segment.toString(), new PathKey(baselinePath), lineCount});
                                                constantValue = null;
                                            }
                                        }
                                        catch (NoSuchElementException e) {
                                            // empty catch block
                                        }
                                    }
                                    lines.add(new FieldLine(kind, memberName, flags, type, constantValue, lineCount));
                                    break;
                                }
                                case 12: {
                                    break;
                                }
                            }
                        }
                        catch (NoSuchElementException e) {
                            log.warning("baseline-incomplete-line", "incomplete line at %s:%d", new Object[]{new PathKey(baselinePath), lineCount}).scope(baselinePath);
                        }
                    }
                    line = reader.readLine();
                }
                lines.add(new EndLine(lineCount));
            }
            catch (Throwable lineCount) {
                var16_17 = lineCount;
                throw lineCount;
            }
            finally {
                if (reader != null) {
                    if (var16_17 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable lineCount) {
                            var16_17.addSuppressed(lineCount);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Baseline %s not read: %s", new Object[]{baselinePath, e});
        }
        if (version < 3) {
            throw new CommandException("obsolete baseline format version \"%d\" at %s", new Object[]{version, baselinePath});
        }
        Collections.sort(lines);
        scope = new ModelScope(baselinePath);
        packages = new TreeMap<PackageName, Package>();
        rootsByIndex = new ClassPathRoot[rootLines.length];
        rootsByPath = new LinkedHashMap<PathKey, ClassPathRoot>();
        pendingPackage = null;
        pendingType = null;
        members = null;
        memberAccessTypes = null;
        membersEscalated = false;
        accessPolicy = new AnnotationAccessPolicy("all", domain);
        skipping = false;
        block96: for (i = 0; i < lines.size(); ++i) {
            line = (Line)lines.get(i);
            lines.set(i, null);
            kind = line.getKind();
            switch (1.$SwitchMap$oracle$javatools$exports$classpath$BaselineReaderWriter$Kind[kind.ordinal()]) {
                case 5: 
                case 6: 
                case 7: 
                case 12: {
                    if (pendingType == null) break;
                    pendingType.addMembers(members.values(), memberAccessTypes, membersEscalated);
                    predecessorType = pendingPackage.addOrGetType(pendingType);
                    if (predecessorType != pendingType) {
                        log.warning("baseline-duplicate-type", "duplicate type %s declared at %s:%d", new Object[]{pendingType.getName(), new PathKey(baselinePath), line.getLine()}).scope(baselinePath);
                    }
                    pendingType = null;
                }
            }
            switch (1.$SwitchMap$oracle$javatools$exports$classpath$BaselineReaderWriter$Kind[kind.ordinal()]) {
                case 4: {
                    rootLine = (RootLine)line;
                    status = rootLine.getStatus();
                    if (status == ClassPathRoot.Status.JDK) {
                        if (bootRoots == null) continue block96;
                        for (ClassPathRoot root : bootRoots) {
                            rootsByPath.putIfAbsent(root.getReferencePath(), root);
                        }
                        bootRoots = null;
                        continue block96;
                    }
                    typeCount = rootLine.getTypeCount();
                    if (typeCount == 0) continue block96;
                    index = rootLine.getIndex();
                    path = rootLine.getPath();
                    rootPath = middlewareHome.resolve(path);
                    fileTree = new FileTree(rootLine.getTypeBuffer(), rootLine.getTypeCount());
                    root = new ClassPathRoot(scope, rootPath, status, fileTree, accessPolicy, nameSpace, new NestedFileSystemPool(), log);
                    rootsByPath.putIfAbsent(root.getReferencePath(), root);
                    rootsByIndex[index] = root;
                    continue block96;
                }
                case 5: {
                    packageLine = (PackageLine)line;
                    pendingPackage = new Package(packageLine.getName(), packageLine.getFlags());
                    packages.put(pendingPackage.getName(), pendingPackage);
                    skipping = false;
                    continue block96;
                }
                case 6: 
                case 7: {
                    typeLine = (TypeLine)line;
                    skipping = false;
                    typeName = typeLine.getName();
                    if (pendingPackage == null || !typeName.getPackage().equals(pendingPackage.getName())) {
                        log.warning("baseline-missing-package", "package %s from type %s not declared before %s:%d", new Object[]{typeName.getPackage(), typeName.getBinaryName(), new PathKey(baselinePath), typeLine.getLine()}).scope(baselinePath);
                        skipping = true;
                        continue block96;
                    }
                    outerType = null;
                    outerTypeName = typeName.getOuterType();
                    if (outerTypeName != null && (outerType = pendingPackage.getType(outerTypeName)) == null) {
                        log.warning("baseline-missing-type", "outer type %s from type %s not declared before %s:%d", new Object[]{outerTypeName, typeName, new PathKey(baselinePath), typeLine.getLine()}).scope(baselinePath);
                        skipping = true;
                        continue block96;
                    }
                    try {
                        rootIndex = typeLine.getRootIndex();
                        if (rootIndex >= rootsByIndex.length) {
                            throw new NumberFormatException();
                        }
                        root = rootsByIndex[rootIndex];
                        if (root == null) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warning("baseline-invalid-root", "invalid root index %d for type %s at %s:%d", new Object[]{typeLine.getRootIndex(), typeName, new PathKey(baselinePath), typeLine.getLine()}).scope(baselinePath);
                        continue block96;
                    }
                    pendingType = new Type(pendingPackage, outerType, root, typeName, typeLine.getFlags(), typeLine.getSuperClass(), typeLine.getInterfaces());
                    members = new TreeMap<MemberName, Member>();
                    memberAccessTypes = EnumSet.noneOf(Access.class);
                    membersEscalated = false;
                    continue block96;
                }
                case 8: {
                    continue block96;
                }
                case 9: 
                case 10: 
                case 11: {
                    if (skipping) continue block96;
                    memberLine = (MemberLine)line;
                    memberName = memberLine.getName();
                    if (pendingPackage == null || !memberName.getPackage().equals(pendingPackage.getName())) {
                        log.warning("baseline-missing-package", "package %s from member %s not declared before %s:%d", new Object[]{memberName.getPackage(), memberName.getBinaryName(), new PathKey(baselinePath), line.getLine()}).scope(baselinePath);
                        skipping = true;
                        continue block96;
                    }
                    if (pendingType == null || !memberName.getType().equals(pendingType.getName())) {
                        log.warning("baseline-missing-type", "type %s from member %s not declared before %s:%d", new Object[]{memberName.getType(), memberName.getBinaryName(), new PathKey(baselinePath), line.getLine()}).scope(baselinePath);
                        skipping = true;
                        continue block96;
                    }
                    memberTypeName = memberLine.getType();
                    switch (1.$SwitchMap$oracle$javatools$exports$classpath$BaselineReaderWriter$Kind[kind.ordinal()]) {
                        case 9: {
                            member = new Constructor(pendingType, (ConstructorName)memberName, memberLine.getFlags());
                            break;
                        }
                        case 10: {
                            member = new Method(pendingType, (MethodName)memberName, memberLine.getFlags(), memberTypeName);
                            break;
                        }
                        case 11: {
                            member = new Field(pendingType, (FieldName)memberName, memberTypeName, ((FieldLine)memberLine).getConstantValue(), memberLine.getFlags());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("kind " + (Object)kind);
                        }
                    }
                    memberAccess = member.getAccess();
                    if (memberAccess != null) {
                        if (!member.isSuppressed() || !memberAccess.isConcealed()) {
                            memberAccessTypes.add(memberAccess);
                        }
                        membersEscalated |= member.isEscalated();
                    }
                    members.put(member.getName(), member);
                    continue block96;
                }
                case 12: {
                    continue block96;
                }
                default: {
                    log.warning("baseline-unrecognized-kind", "unrecognized kind \"%s\" at %s:%d", new Object[]{kind, new PathKey(baselinePath), line.getLine()}).scope(baselinePath);
                }
            }
        }
        return new ClassPathModel(source, domain, libraries, rootsByPath, packages, nameSpace, nestedFileSystemPool, commentPool, log);
    }

    protected static BufferedReader createBaselineReader(Path baselinePath) throws IOException {
        String fileName = baselinePath.getFileName().toString();
        if (fileName.endsWith(".zip")) {
            ZipEntry entry;
            ZipFile zip = new ZipFile(baselinePath.toFile());
            String entryName = fileName.substring(0, fileName.length() - 4);
            switch (zip.size()) {
                case 0: {
                    throw new IOException("no entries found in " + baselinePath.toString());
                }
                case 1: {
                    entry = zip.entries().nextElement();
                    break;
                }
                default: {
                    entry = zip.getEntry(entryName);
                    if (entry != null) break;
                    throw new IOException("entry " + entryName + " not found in " + baselinePath.toString());
                }
            }
            return new BufferedReader(new InputStreamReader(zip.getInputStream(entry), BASELINE_ENCODING));
        }
        return Files.newBufferedReader(baselinePath, BASELINE_ENCODING);
    }

    private static TypeName[] collectInterfaceNames(StringSegmentIterator iterator, int count, NameSpace nameSpace) {
        if (!iterator.hasNext()) {
            return count != 0 ? new TypeName[count] : TypeName.EMPTY_ARRAY;
        }
        StringSegment segment = iterator.next();
        TypeName name = nameSpace.typeNameHybrid(segment.getBackingString(), segment.getSegmentOffset(), segment.getSegmentEndOffset());
        TypeName[] array = BaselineReaderWriter.collectInterfaceNames(iterator, count + 1, nameSpace);
        array[count] = name;
        return array;
    }

    static String encode(String string, char quote) {
        StringBuilder builder = new StringBuilder();
        builder.append(quote);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c <= '\u001f' || c == '\u007f' || c >= '\u0080') {
                switch (c) {
                    case '\b': {
                        builder.append("\\b");
                        break;
                    }
                    case '\t': {
                        builder.append("\\t");
                        break;
                    }
                    case '\n': {
                        builder.append("\\n");
                        break;
                    }
                    case '\f': {
                        builder.append("\\f");
                        break;
                    }
                    case '\r': {
                        builder.append("\\r");
                        break;
                    }
                    case '\\': {
                        builder.append("\\\\");
                        break;
                    }
                    default: {
                        builder.append('\\').append('u').append(String.format("%04X", c));
                        break;
                    }
                }
                continue;
            }
            builder.append(c);
        }
        builder.append(quote);
        return builder.toString();
    }

    private static String decode(String string, int offset, int endOffset, int quote) {
        StringBuilder builder = new StringBuilder();
        if (endOffset - offset > 1 && string.charAt(offset) == quote && string.charAt(endOffset - 1) == quote) {
            ++offset;
            --endOffset;
        }
        int state = 0;
        int code = 0;
        block17: for (int i = offset; i < endOffset; ++i) {
            char c = string.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\\') {
                        state = -1;
                        continue block17;
                    }
                    builder.append(c);
                    continue block17;
                }
                case -1: {
                    switch (c) {
                        case 'u': {
                            code = 0;
                            state = 1;
                            continue block17;
                        }
                        case 'b': {
                            builder.append('\b');
                            state = 0;
                            continue block17;
                        }
                        case 't': {
                            builder.append('\t');
                            state = 0;
                            continue block17;
                        }
                        case 'n': {
                            builder.append('\n');
                            state = 0;
                            continue block17;
                        }
                        case 'f': {
                            builder.append('\f');
                            state = 0;
                            continue block17;
                        }
                        case 'r': {
                            builder.append('\r');
                            state = 0;
                            continue block17;
                        }
                        case '\\': {
                            builder.append('\\');
                            state = 0;
                            continue block17;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case 1: {
                    int digit = Character.digit(c, 16);
                    if (digit < 0) {
                        throw new IllegalArgumentException();
                    }
                    code = code * 16 + digit;
                    ++state;
                    continue block17;
                }
                case 2: {
                    int digit = Character.digit(c, 16);
                    if (digit < 0) {
                        throw new IllegalArgumentException();
                    }
                    code = code * 16 + digit;
                    ++state;
                    continue block17;
                }
                case 3: {
                    int digit = Character.digit(c, 16);
                    if (digit < 0) {
                        throw new IllegalArgumentException();
                    }
                    code = code * 16 + digit;
                    ++state;
                    continue block17;
                }
                case 4: {
                    int digit = Character.digit(c, 16);
                    if (digit < 0) {
                        throw new IllegalArgumentException();
                    }
                    code = code * 16 + digit;
                    builder.append((char)code);
                    state = 0;
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException();
        }
        return builder.toString();
    }

    private static class FlagsWriter
    implements ObjIntConsumer<String> {
        private final Writer writer;

        public FlagsWriter(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void accept(String s, int i) {
            try {
                if (i > 0) {
                    this.writer.write(44);
                }
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new UnexpectedExceptionError(e);
            }
        }
    }

    private static class EndLine
    extends Line {
        public EndLine(int line) {
            super(line);
        }

        @Override
        public Kind getKind() {
            return Kind.EOT;
        }

        @Override
        public int compareToSame(Line that) {
            return 0;
        }

        @Override
        protected StringBuilder toString(StringBuilder builder) {
            builder.setLength(builder.length() - 1);
            return builder;
        }
    }

    private static class FieldLine
    extends MemberLine {
        private Object constantValue;

        public FieldLine(Kind kind, MemberName name, char flags, TypeName type, Object constantValue, int line) {
            super(kind, name, flags, type, line);
            this.constantValue = constantValue;
        }

        public Object getConstantValue() {
            return this.constantValue;
        }
    }

    private static class MemberLine
    extends ElementLine {
        private Kind kind;
        private MemberName name;
        private char flags;
        private TypeName type;

        public MemberLine(Kind kind, MemberName name, char flags, TypeName type, int line) {
            super(line);
            this.kind = kind;
            this.name = name;
            this.flags = flags;
            this.type = type;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public MemberName getName() {
            return this.name;
        }

        public char getFlags() {
            return this.flags;
        }

        public TypeName getType() {
            return this.type;
        }
    }

    private static class TypeLine
    extends ElementLine {
        private Kind kind;
        private TypeName name;
        private int rootIndex;
        private char flags;
        private TypeName superClass;
        private TypeName[] interfaces;

        public TypeLine(Kind kind, TypeName name, int rootIndex, char flags, TypeName superClass, TypeName[] interfaces, int line) {
            super(line);
            this.kind = kind;
            this.name = name;
            this.rootIndex = rootIndex;
            this.flags = flags;
            this.superClass = superClass;
            this.interfaces = interfaces;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public TypeName getName() {
            return this.name;
        }

        public int getRootIndex() {
            return this.rootIndex;
        }

        public char getFlags() {
            return this.flags;
        }

        public TypeName getSuperClass() {
            return this.superClass;
        }

        public TypeName[] getInterfaces() {
            return this.interfaces;
        }
    }

    private static class PackageLine
    extends ElementLine {
        private PackageName name;
        private char flags;

        public PackageLine(PackageName name, char flags, int line) {
            super(line);
            this.name = name;
            this.flags = flags;
        }

        @Override
        public Kind getKind() {
            return Kind.PACKAGE;
        }

        @Override
        public PackageName getName() {
            return this.name;
        }

        public char getFlags() {
            return this.flags;
        }
    }

    private static abstract class ElementLine
    extends Line {
        public ElementLine(int line) {
            super(line);
        }

        public abstract ElementName getName();

        @Override
        public int compareToSame(Line that) {
            return this.getName().compareTo(((ElementLine)that).getName());
        }

        @Override
        protected StringBuilder toString(StringBuilder builder) {
            return builder.append(this.getName());
        }
    }

    private static class RootLine
    extends Line {
        private final int index;
        private final ClassPathRoot.Status status;
        private final String path;
        private int expectedCount;
        private TypeName[] typeBuffer;
        private int typeCount;

        public RootLine(int index, ClassPathRoot.Status status, String path, int expectedCount, int line) {
            super(line);
            this.index = index;
            this.path = path;
            this.status = status;
            this.expectedCount = expectedCount;
            this.typeBuffer = TypeName.EMPTY_ARRAY;
        }

        public void addType(TypeName type) {
            if (this.typeBuffer.length == 0) {
                this.typeBuffer = new TypeName[Math.max(this.expectedCount, 1)];
            } else if (this.typeCount == this.typeBuffer.length) {
                this.typeBuffer = new TypeName[this.typeCount << 1];
                System.arraycopy(this.typeBuffer, 0, this.typeBuffer, 0, this.typeCount);
            }
            this.typeBuffer[this.typeCount++] = type;
        }

        public void addTypes(RootLine that) {
            assert (this.typeBuffer.length == 0 && this.typeCount == 0 && that.typeCount > 0 && that.status == null);
            this.typeBuffer = new TypeName[Math.max(this.expectedCount, that.typeCount)];
            System.arraycopy(that.typeBuffer, 0, this.typeBuffer, 0, that.typeCount);
        }

        @Override
        public Kind getKind() {
            return Kind.ROOT;
        }

        public int getIndex() {
            return this.index;
        }

        public ClassPathRoot.Status getStatus() {
            return this.status;
        }

        public String getPath() {
            return this.path;
        }

        public int getTypeCount() {
            return this.typeCount;
        }

        public TypeName[] getTypeBuffer() {
            return this.typeBuffer;
        }

        @Override
        public int compareToSame(Line that) {
            return Integer.compare(this.index, ((RootLine)that).index);
        }

        @Override
        protected StringBuilder toString(StringBuilder builder) {
            return builder.append(this.index).append(' ').append(this.path);
        }
    }

    private static abstract class Line
    implements Comparable<Line> {
        private final int line;

        public Line(int line) {
            this.line = line;
        }

        public abstract Kind getKind();

        public int getLine() {
            return this.line;
        }

        @Override
        public int compareTo(Line that) {
            int comparison = Integer.compare(this.getKind().weight, that.getKind().weight);
            if (comparison != 0) {
                return comparison;
            }
            return this.compareToSame(that);
        }

        protected abstract int compareToSame(Line var1);

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append((Object)this.getKind()).append(" ");
            return this.toString(builder).toString();
        }

        protected abstract StringBuilder toString(StringBuilder var1);
    }

    public static enum Kind {
        PROPERTY(0),
        LIBRARY(1),
        DOMAIN(2),
        ROOT(3),
        PACKAGE(4, ElementKind.PACKAGE),
        CLASS(4, ElementKind.CLASS),
        INTERFACE(4, ElementKind.INTERFACE),
        RESOURCE(4),
        CONSTRUCTOR(4, ElementKind.CONSTRUCTOR),
        METHOD(4, ElementKind.METHOD),
        FIELD(4, ElementKind.FIELD),
        EOT(5);

        private int weight;
        private ElementKind kind;

        private Kind(int weight) {
            this(weight, null);
        }

        private Kind(int weight, ElementKind kind) {
            this.weight = weight;
            this.kind = kind;
        }

        static /* synthetic */ ElementKind access$000(Kind x0) {
            return x0.kind;
        }
    }

    private static enum BaselineProperty {
        FORMAT,
        ENCODING,
        FLAGS,
        SOURCE,
        ROOTS,
        PATH,
        HOST,
        USER;

    }
}

