/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.Collections;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.util.NullArgumentException;

public class Field
extends Member<Field> {
    private final FieldName name;
    private final TypeName fieldTypeName;
    private final Object constantValue;
    private Type fieldType;

    Field(Type parent, FieldName name, TypeName fieldTypeName, Object constantValue, boolean isStatic, boolean isFinal, Member.Escalation escalation, boolean deprecated, Access access, boolean escalated, boolean suppressed, String accessComment) {
        super(parent, escalation, deprecated, access, escalated, suppressed, accessComment);
        if (fieldTypeName == null) {
            throw new NullArgumentException("fieldTypeName null");
        }
        this.set('\b', isStatic);
        this.set('\u0002', isFinal);
        this.name = name;
        this.fieldTypeName = fieldTypeName;
        this.constantValue = this.isConstant() ? constantValue : null;
    }

    Field(Type parent, FieldName name, TypeName fieldTypeName, Object constantValue, char flags) {
        super(parent, flags);
        if (fieldTypeName == null) {
            throw new NullArgumentException("fieldTypeName null");
        }
        this.name = name;
        this.fieldTypeName = fieldTypeName;
        this.constantValue = this.isConstant() ? constantValue : null;
    }

    @Override
    public FieldName getName() {
        return this.name;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.FIELD;
    }

    @Override
    void resolve() {
        this.getFieldType();
    }

    @Override
    public TypeName getMemberTypeName() {
        return this.fieldTypeName;
    }

    @Override
    public Type getMemberType() {
        return this.getFieldType();
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public boolean isVariableArity() {
        return false;
    }

    @Override
    public MemberName getResolvedName() {
        return this.name;
    }

    @Override
    public Iterable<Type> getParameterTypes() {
        return Collections.emptyList();
    }

    public final boolean isConstant() {
        return this.isStatic() && this.isFinal() && this.fieldTypeName.isPrimitiveOrString();
    }

    public TypeName getFieldTypeName() {
        return this.fieldTypeName;
    }

    public Type getFieldType() {
        if (this.fieldType == null) {
            this.fieldType = this.getModel().findType(this.fieldTypeName, "field type", this.getName());
        }
        return this.fieldType;
    }

    public Object getConstantValue() {
        return this.constantValue;
    }
}

