/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.classpath.ClassPathRoot;
import oracle.javatools.exports.classpath.Constructor;
import oracle.javatools.exports.classpath.Conversions;
import oracle.javatools.exports.classpath.Field;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.OverrideEquivalentMethod;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.TypeOrMember;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.common.Iterables;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.TypeExportSpecification;

public class Type
extends TypeOrMember {
    public static final Comparator<Type> COMPARATOR = Type::compareTo;
    public static final Comparator<Type> UNQUALIFIED_COMPARATOR = Type::compareToUnqualified;
    private final Package parent;
    private final ClassPathRoot root;
    private final Type outerOrComponentType;
    private final TypeName name;
    private final TypeName superClassName;
    private final TypeName[] interfaceNames;
    private ClassPathRoot[] roots;
    private Type superClass;
    private Type[] interfaces;
    private Set<Type> extendingTypes = Collections.emptySet();
    private Member<?>[] declaredMembers;
    private static final ClassPathRoot[] EMPTY_ROOTS = new ClassPathRoot[0];
    private static final TypeName[] ARRAY_INTERFACE_NAMES = new TypeName[]{TypeName.JAVA_LANG_CLONEABLE, TypeName.JAVA_IO_SERIALIZABLE};
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final AtomicInteger typesCreated = new AtomicInteger();
    private static final List<TypeName> PRIMITIVES = Arrays.asUnmodifiableList(TypeName.INT, TypeName.BOOLEAN, TypeName.BYTE, TypeName.CHAR, TypeName.SHORT, TypeName.LONG, TypeName.FLOAT, TypeName.DOUBLE);
    private static final Comparator<Object> MEMBER_NAME_COMPARATOR = (left, right) -> {
        MemberName leftName = left instanceof MemberName ? (MemberName)left : ((Member)left).getName();
        MemberName rightName = right instanceof MemberName ? (MemberName)right : ((Member)right).getName();
        return leftName.compareToUnqualified(rightName);
    };

    public static int getTypesCreatedCount() {
        return typesCreated.intValue();
    }

    Type(Package parent, Type outerType, ClassPathRoot root, TypeName name, int modifiers, TypeName superClassName, TypeName[] interfaceNames, boolean exportable, boolean jdk, Access access, boolean deprecated, String accessComment, Access extension) {
        super(deprecated, exportable, access, accessComment);
        assert (superClassName == null || superClassName.getFormat() != NameFormat.SOURCE);
        if (name.isArray()) {
            throw new IllegalStateException("use array type constructor");
        }
        if (PRIMITIVES.contains(name)) {
            throw new IllegalStateException("use primitive type constructor");
        }
        if (Access.isMoreExported(extension, access)) {
            throw new IllegalStateException("extension inconsistent with access");
        }
        this.parent = parent;
        this.root = root;
        this.roots = root != null ? root.singletonArray() : EMPTY_ROOTS;
        this.outerOrComponentType = outerType;
        this.name = name;
        this.set('\u0400', true);
        boolean isInterface = Modifier.isInterface(modifiers);
        this.set('\u0800', isInterface);
        this.set('\b', Modifier.isStatic(modifiers));
        this.set('\u0004', Modifier.isAbstract(modifiers));
        this.set('\u0002', Modifier.isFinal(modifiers));
        this.set('\u0200', jdk);
        this.setAccess('\u0007', extension);
        TypeName typeName = this.superClassName = name.equals(TypeName.JAVA_LANG_OBJECT) ? null : superClassName;
        if (interfaceNames.length > 0) {
            this.interfaceNames = interfaceNames;
        } else {
            this.interfaceNames = TypeName.EMPTY_ARRAY;
            this.interfaces = EMPTY_TYPE_ARRAY;
        }
        typesCreated.incrementAndGet();
    }

    Type(Package parent, Type outerType, ClassPathRoot root, TypeName name, char flags, TypeName superClassName, TypeName[] interfaceNames) {
        super(flags);
        assert (superClassName == null || superClassName.getFormat() != NameFormat.SOURCE);
        this.parent = parent;
        this.root = root;
        this.roots = EMPTY_ROOTS;
        this.outerOrComponentType = outerType;
        this.name = name;
        TypeName typeName = this.superClassName = name.equals(TypeName.JAVA_LANG_OBJECT) ? null : superClassName;
        if (interfaceNames.length > 0) {
            this.interfaceNames = interfaceNames;
        } else {
            this.interfaceNames = TypeName.EMPTY_ARRAY;
            this.interfaces = EMPTY_TYPE_ARRAY;
        }
        typesCreated.incrementAndGet();
    }

    Type(Type componentType, NameSpace nameSpace) {
        super(false, componentType.isExportable(), null, null);
        this.parent = componentType.getPackage();
        this.root = null;
        this.roots = EMPTY_ROOTS;
        this.outerOrComponentType = componentType;
        this.name = nameSpace.arrayNameGetOrCreate(componentType.getName());
        this.superClassName = TypeName.JAVA_LANG_OBJECT;
        this.interfaceNames = ARRAY_INTERFACE_NAMES;
        this.declaredMembers = new Member[2];
        this.declaredMembers[0] = new Method(this, nameSpace.methodNameHybrid(this.name, "clone()"), TypeName.JAVA_LANG_OBJECT, false, false, false, Member.Escalation.NONE, false, null, false, false, null);
        this.declaredMembers[1] = new Field(this, nameSpace.fieldName(this.name, "length"), TypeName.INT, null, false, true, Member.Escalation.NONE, false, null, false, false, null);
    }

    Type(Package parent, TypeName name) {
        super(false, true, null, null);
        if (name.isArray()) {
            throw new IllegalStateException("use array type constructor");
        }
        if (!PRIMITIVES.contains(name)) {
            throw new IllegalStateException(name + " not primitive type");
        }
        if (!parent.isDefault()) {
            throw new IllegalStateException("not default package");
        }
        this.parent = parent;
        this.root = null;
        this.roots = EMPTY_ROOTS;
        this.outerOrComponentType = null;
        this.name = name;
        this.superClassName = null;
        this.interfaceNames = TypeName.EMPTY_ARRAY;
        this.interfaces = EMPTY_TYPE_ARRAY;
        this.declaredMembers = EMPTY_MEMBERS;
    }

    Type(Package parent, TypeName name, ClassPathRoot root) {
        super(false, false, null, null);
        this.set('\u0800', true);
        this.parent = parent;
        this.root = root;
        this.roots = root != null ? root.singletonArray() : EMPTY_ROOTS;
        this.outerOrComponentType = null;
        this.name = name;
        this.superClassName = name.equals(TypeName.JAVA_LANG_OBJECT) ? null : TypeName.JAVA_LANG_OBJECT;
        this.interfaceNames = TypeName.EMPTY_ARRAY;
        this.interfaces = EMPTY_TYPE_ARRAY;
        this.declaredMembers = EMPTY_MEMBERS;
    }

    void addMembers(Collection<Member<?>> members, EnumSet<Access> memberAccessTypes, boolean hasEscalatedMembers) {
        if (this.declaredMembers != null) {
            throw new IllegalStateException("members already added");
        }
        this.declaredMembers = members.toArray(EMPTY_MEMBERS);
        this.set('\u1000', memberAccessTypes.contains((Object)Access.EXPORTED));
        this.set('\u2000', memberAccessTypes.contains((Object)Access.RESTRICTED));
        this.set('\u4000', memberAccessTypes.contains((Object)Access.CONCEALED));
        this.set('\u8000', hasEscalatedMembers);
    }

    void addExtendingType(Type type) {
        switch (this.extendingTypes.size()) {
            case 0: {
                this.extendingTypes = Collections.singleton(type);
                break;
            }
            case 1: {
                this.extendingTypes = new HashSet<Type>(this.extendingTypes);
                this.extendingTypes.add(type);
                break;
            }
            default: {
                this.extendingTypes.add(type);
            }
        }
    }

    @Override
    public TypeName getName() {
        return this.name;
    }

    @Override
    public ElementKind getKind() {
        return this.isInterface() ? ElementKind.INTERFACE : ElementKind.CLASS;
    }

    @Override
    public Package getParent() {
        return this.parent;
    }

    @Override
    public Package getPackage() {
        return this.parent;
    }

    @Override
    public boolean containsExported() {
        return this.is('\u1000');
    }

    @Override
    public boolean containsRestricted() {
        return this.is('\u2000');
    }

    @Override
    public boolean containsConcealed() {
        return this.is('\u4000');
    }

    @Override
    public boolean hasOrContainsExported() {
        return this.getAccess() == Access.EXPORTED || this.getExtension() == Access.EXPORTED || this.containsExported();
    }

    @Override
    public boolean hasOrContainsRestricted() {
        return this.getAccess() == Access.RESTRICTED || this.getExtension() == Access.RESTRICTED || this.containsRestricted();
    }

    @Override
    public boolean hasOrContainsConcealed() {
        return this.getAccess() == Access.CONCEALED || this.getExtension() == Access.CONCEALED || this.containsConcealed();
    }

    @Override
    public void resolve() {
        this.getSuperClass();
        this.getInterfaces();
        for (Member<?> member : this.declaredMembers) {
            if (!member.isExportable()) continue;
            member.resolve();
        }
    }

    @Override
    public boolean isJDK() {
        return this.is('\u0200');
    }

    public final boolean isAbstract() {
        return this.is('\u0004');
    }

    public final boolean isFinal() {
        return this.is('\u0002');
    }

    public final boolean isStatic() {
        return this.is('\b');
    }

    public boolean isReferenceType() {
        return this.is('\u0400');
    }

    public boolean isClass() {
        return this.is('\u0400') && !this.is('\u0800');
    }

    public boolean isUnresolved() {
        return !this.is('\u0400') && this.is('\u0800');
    }

    public boolean isInterface() {
        return this.is('\u0400') && this.is('\u0800');
    }

    public boolean isPrimitive() {
        return !this.is('\u0400') && !this.is('\u0800') && !this.name.isArray();
    }

    public boolean isPrimitiveOrString() {
        return this.isPrimitive() || this.name.equals(TypeName.JAVA_LANG_STRING);
    }

    public boolean isArray() {
        return this.name.isArray();
    }

    public boolean isInner() {
        return this.outerOrComponentType != null && !this.isArray();
    }

    public boolean isInnerStatic() {
        return this.outerOrComponentType != null && !this.isArray() && this.isStatic();
    }

    public ClassPathRoot getRoot() {
        return this.root;
    }

    public Iterable<ClassPathRoot> getRoots() {
        return Arrays.asUnmodifiableList(this.roots);
    }

    public Scope getScope() {
        return this.root != null ? this.root.getScope() : null;
    }

    public Type getOuterType() {
        return this.isArray() ? null : this.outerOrComponentType;
    }

    public Type getComponentType() {
        return this.isArray() ? this.outerOrComponentType : null;
    }

    public boolean isNonStaticInnerClass() {
        return !this.isStatic() && this.getOuterType() != null;
    }

    public Access getExtension() {
        Access extension = this.getAccess('\u0007');
        return extension != null ? extension : this.getAccess();
    }

    public Access getExtension(Access restrictedAs) {
        Access extension = this.getExtension();
        return Access.isRestricted(extension) ? restrictedAs : extension;
    }

    void addOccludedRoot(ClassPathRoot root, Package packag) {
        TypeExportSpecification typeSpecification;
        if (Arrays.contains(this.roots, root)) {
            return;
        }
        int count = this.roots.length;
        this.roots = new ClassPathRoot[count + 1];
        System.arraycopy(this.roots, 0, this.roots, 0, count);
        this.roots[count] = root;
        if (!this.isExportable()) {
            return;
        }
        ExportSpecification thatSpecification = root.getAccessPolicy().getExportSpecification();
        if (thatSpecification == null) {
            return;
        }
        if (thatSpecification.equals(this.roots[count - 1].getAccessPolicy().getExportSpecification())) {
            return;
        }
        PackageExportSpecification thatPackageSpecification = thatSpecification.getPackage(packag.getName());
        TypeExportSpecification thatTypeSpecification = thatPackageSpecification.getType(this.name);
        Access thisAccess = this.getAccess();
        Access thatAccess = thatTypeSpecification.getAccess();
        if (!Access.isExportedOrRestricted(thatAccess)) {
            return;
        }
        boolean wasSelfOrMemberExported = this.hasOrContainsExported();
        boolean wasSelfOrMemberRestricted = this.hasOrContainsRestricted();
        boolean wasSelfOrMemberConcealed = this.hasOrContainsConcealed();
        boolean wasSelfOrMemberEscalated = this.hasOrContainsEscalated();
        if (Access.isExportedOrRestricted(thisAccess)) {
            TypeExportSpecification thisTypeSpecification = this.inferExportSpecification(Access.RESTRICTED, false);
            Merge<TypeExportSpecification> merge = thisTypeSpecification.merge(thatTypeSpecification);
            typeSpecification = merge.getValue();
            if (typeSpecification == thisTypeSpecification) {
                return;
            }
        } else {
            typeSpecification = thatTypeSpecification;
        }
        EnumSet<Access> memberAccesses = EnumSet.noneOf(Access.class);
        boolean memberEscalations = false;
        for (Member<?> member : this.getDeclaredMembers()) {
            Access memberAccess = typeSpecification.getMember(member.getName());
            boolean memberEscalated = false;
            boolean memberSuppressed = false;
            Access defaultAccess = Access.CONCEALED;
            boolean memberAccessExplicit = false;
            switch (member.getEscalation()) {
                case PUBLIC: {
                    Access access = defaultAccess = typeSpecification.getExtension() != null ? typeSpecification.getExtension() : typeSpecification.getAccess();
                    if (member instanceof Constructor) {
                        memberAccessExplicit = typeSpecification.isMemberExplicit(member.getName());
                    }
                }
                case DEFAULT: {
                    if (!(member instanceof Constructor)) {
                        memberAccessExplicit = typeSpecification.isMemberExplicit(member.getName());
                    }
                }
                case PRIVATE: {
                    boolean bl = memberSuppressed = defaultAccess == Access.CONCEALED;
                    if (!Access.isMoreExported(memberAccess, defaultAccess) || (memberEscalated = memberAccessExplicit)) break;
                    memberAccess = defaultAccess;
                }
            }
            if (!memberSuppressed || !memberAccess.isConcealed()) {
                memberAccesses.add(memberAccess);
            }
            memberEscalations |= memberEscalated;
            member.setAccess('\u0005', memberAccess);
            member.set('\u0400', memberSuppressed);
            member.set('\u0200', memberEscalated);
        }
        this.setAccess('\u0005', typeSpecification.getAccess());
        this.setAccess('\u0007', typeSpecification.getExtension());
        this.set('\u1000', memberAccesses.contains((Object)Access.EXPORTED));
        this.set('\u2000', memberAccesses.contains((Object)Access.RESTRICTED));
        this.set('\u4000', memberAccesses.contains((Object)Access.CONCEALED));
        this.set('\u8000', memberEscalations);
        if (wasSelfOrMemberExported != this.hasOrContainsExported()) {
            assert (!wasSelfOrMemberExported);
            packag.addExportedMember();
        }
        if (wasSelfOrMemberRestricted != this.hasOrContainsRestricted()) {
            assert (!wasSelfOrMemberRestricted);
            packag.addRestrictedMember();
        }
        if (wasSelfOrMemberConcealed != this.hasOrContainsConcealed()) {
            assert (wasSelfOrMemberConcealed);
            int concealedMemberCount = packag.removeConcealedMember();
            assert (concealedMemberCount >= 0);
        }
        if (wasSelfOrMemberEscalated != this.hasOrContainsEscalated()) {
            if (wasSelfOrMemberEscalated) {
                int escalatedMemberCount = packag.removeEscalatedMember();
                assert (escalatedMemberCount >= 0);
            } else {
                packag.addEscalatedMember();
            }
        }
    }

    TypeExportSpecification inferExportSpecification(Access restrictedAs, boolean resolve) {
        Access defaultMemberAccess;
        Map<MemberName, Access> members;
        Access access = this.getAccess(restrictedAs);
        if (access == null) {
            return TypeExportSpecification.DEFAULT_NULL;
        }
        if (this.hasOrContainsConsistentAccess()) {
            switch (access) {
                case EXPORTED: {
                    return TypeExportSpecification.DEFAULT_EXPORTED;
                }
                case RESTRICTED: {
                    return TypeExportSpecification.DEFAULT_RESTRICTED;
                }
                case CONCEALED: {
                    return TypeExportSpecification.DEFAULT_CONCEALED;
                }
            }
        }
        if (this.containsConsistentAccess(restrictedAs)) {
            members = Collections.emptyMap();
            defaultMemberAccess = this.getMemberAccess(restrictedAs);
        } else {
            members = new LinkedHashMap();
            for (Member<?> member : this.getDeclaredMembers()) {
                if (!member.isExportedOrRestricted(restrictedAs)) continue;
                members.put(resolve ? member.getResolvedName() : member.getName(), member.getAccess(restrictedAs));
            }
            defaultMemberAccess = Access.CONCEALED;
        }
        return new TypeExportSpecification(access, this.getExtension(restrictedAs), members, defaultMemberAccess);
    }

    Type getSuperClass() {
        if (this.superClass != null) {
            return this.superClass;
        }
        if (this.superClassName == null) {
            return null;
        }
        this.superClass = this.getModel().findType(this.superClassName, "superclass", this.getName());
        this.superClass.addExtendingType(this);
        return this.superClass;
    }

    public Iterable<Type> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new Type[this.interfaceNames.length];
            for (int i = 0; i < this.interfaceNames.length; ++i) {
                Type type = this.getModel().findType(this.interfaceNames[i], "interface", this.getName());
                type.addExtendingType(this);
                this.interfaces[i] = type;
            }
        }
        return Arrays.asUnmodifiableList(this.interfaces);
    }

    public boolean isSubtypeOf(Type supertype) {
        return Conversions.isWideningReferenceConversion(this, supertype);
    }

    public boolean isSupertypeOf(Type subtype) {
        return Conversions.isWideningReferenceConversion(subtype, this);
    }

    public Iterable<Type> getExtendingTypes() {
        return this.extendingTypes;
    }

    public Iterable<Member<?>> getDeclaredMembers() {
        return Arrays.asUnmodifiableList(this.declaredMembers);
    }

    public <M extends Member<M>> M getDeclaredMember(MemberName name) {
        int index = Arrays.binarySearch(this.declaredMembers, name, MEMBER_NAME_COMPARATOR);
        return (M)(index >= 0 ? this.declaredMembers[index] : null);
    }

    public Constructor getDeclaredConstructor(ConstructorName name) {
        int index = Arrays.binarySearch(this.declaredMembers, name, MEMBER_NAME_COMPARATOR);
        return index >= 0 ? (Constructor)this.declaredMembers[index] : null;
    }

    public Iterable<Constructor> getDeclaredConstructors() {
        return Iterables.filteredIterable(this.declaredMembers, m -> m.getKind().isConstructor(), m -> (Constructor)m);
    }

    public Collection<Constructor> getApplicableConstructors(ConstructorName constructorName) {
        return this.getApplicableConstructors(constructorName, Iterables.iterable(this.getModel().findTypes(constructorName.getParameters(), "parameter type", constructorName)));
    }

    public Collection<Constructor> getApplicableConstructors(ConstructorName constructorName, Iterable<Type> parameterTypes) {
        ArrayList<Constructor> replacements = new ArrayList<Constructor>();
        Conversions.ConversionCategory replacementCategory = Conversions.ConversionCategory.INCOMPATIBLE;
        for (Constructor constructor : this.getDeclaredConstructors()) {
            Conversions.ConversionCategory c = Conversions.memberConversionCategory(constructorName, parameterTypes, constructor);
            assert (c != Conversions.ConversionCategory.IDENTICAL);
            if (c == Conversions.ConversionCategory.INCOMPATIBLE) continue;
            switch (Integer.signum(c.compareTo(replacementCategory))) {
                case 1: {
                    replacementCategory = c;
                    replacements = new ArrayList();
                }
                case 0: {
                    replacements.add(constructor);
                }
            }
        }
        return Conversions.maximallySpecificConstructor(replacements);
    }

    public Method getDeclaredMethod(MethodName name) {
        int index = Arrays.binarySearch(this.declaredMembers, name, MEMBER_NAME_COMPARATOR);
        return index >= 0 ? (Method)this.declaredMembers[index] : null;
    }

    public OverrideEquivalentMethod getDeclaredOrInheritedMethod(MethodName name) {
        Method method = this.getDeclaredMethod(name);
        if (method != null) {
            return new OverrideEquivalentMethod(method);
        }
        return this.getInheritedMethod(name);
    }

    public OverrideEquivalentMethod getInheritedMethod(MethodName name) {
        Type superClass = this.getSuperClass();
        Iterable<Type> superInterfaces = this.getInterfaces();
        return Type.getMethod(name, superClass, superInterfaces);
    }

    static OverrideEquivalentMethod getMethod(MethodName name, Type superClass, Iterable<Type> superInterfaces) {
        Type c;
        OverrideEquivalentMethod methods = new OverrideEquivalentMethod(name);
        int layer = 0;
        for (c = superClass; c != null; c = c.getSuperClass()) {
            Method method = c.getDeclaredMethod(name);
            if (method != null) {
                methods.collect(layer, method);
                if (!methods.isEmpty()) {
                    return methods;
                }
            }
            ++layer;
        }
        Type.interfaceInheritedMethods(superInterfaces, name, methods, layer);
        if (!methods.isEmpty()) {
            return methods;
        }
        for (c = superClass; c != null; c = c.getSuperClass()) {
            Type.interfaceInheritedMethods(c.getInterfaces(), name, methods, ++layer);
            if (methods.isEmpty()) continue;
            return methods;
        }
        return methods;
    }

    private static void interfaceInheritedMethods(Iterable<Type> interfaces, MethodName name, OverrideEquivalentMethod methods, int layer) {
        for (Type type : interfaces) {
            Method method = type.getDeclaredMethod(name);
            if (method != null) {
                if (method.isStatic()) {
                    return;
                }
                methods.collect(layer, method);
                continue;
            }
            Type.interfaceInheritedMethods(type.getInterfaces(), name, methods, layer);
        }
    }

    public Iterable<Method> getDeclaredMethods(String simpleMethodName) {
        return Iterables.filteredIterable(this.declaredMembers, m -> m.getKind().isMethod() && simpleMethodName.equals(m.getSimpleName()), m -> (Method)m);
    }

    public Iterable<OverrideEquivalentMethod> getDeclaredOrInheritedMethods(String simpleMethodName) {
        Type clas;
        TreeMap<Object, OverrideEquivalentMethod> methods = new TreeMap<Object, OverrideEquivalentMethod>(MEMBER_NAME_COMPARATOR);
        int layer = 0;
        for (clas = this; clas != null; clas = clas.getSuperClass()) {
            for (Method method : clas.getDeclaredMethods(simpleMethodName)) {
                MethodName name = method.getName();
                methods.computeIfAbsent(name, v -> new OverrideEquivalentMethod(name)).collect(layer, method);
            }
            ++layer;
        }
        for (clas = this; clas != null; clas = clas.getSuperClass()) {
            for (Type interfac : clas.getInterfaces()) {
                for (Method method : interfac.getDeclaredMethods(simpleMethodName)) {
                    MethodName name = method.getName();
                    methods.computeIfAbsent(name, v -> new OverrideEquivalentMethod(name)).collect(layer, method);
                }
            }
            ++layer;
        }
        return methods.values();
    }

    public Collection<OverrideEquivalentMethod> getApplicableMethods(MethodName methodName) {
        return this.getApplicableMethods(methodName, Iterables.iterable(this.getModel().findTypes(methodName.getParameters(), "parameter type", methodName)));
    }

    public Collection<OverrideEquivalentMethod> getApplicableMethods(MethodName methodName, Iterable<Type> parameterTypes) {
        ArrayList<OverrideEquivalentMethod> replacements = new ArrayList<OverrideEquivalentMethod>();
        Conversions.ConversionCategory replacementCategory = Conversions.ConversionCategory.INCOMPATIBLE;
        for (OverrideEquivalentMethod methodOem : this.getDeclaredOrInheritedMethods(methodName.getSimpleName())) {
            Method method = methodOem.getMethod();
            Conversions.ConversionCategory c = Conversions.memberConversionCategory(methodName, parameterTypes, method);
            if (c == Conversions.ConversionCategory.INCOMPATIBLE) continue;
            switch (Integer.signum(c.compareTo(replacementCategory))) {
                case 1: {
                    replacementCategory = c;
                    replacements = new ArrayList();
                }
                case 0: {
                    replacements.add(methodOem);
                }
            }
        }
        return Conversions.maximallySpecificMethod(replacements);
    }

    public Field getDeclaredField(FieldName fieldName) {
        return (Field)this.getDeclaredMember(fieldName);
    }

    public Field getDeclaredOrInheritedField(FieldName fieldName) {
        Type c;
        Field field = this.getDeclaredField(fieldName);
        if (field != null) {
            return field;
        }
        for (c = this.getSuperClass(); c != null; c = c.getSuperClass()) {
            field = c.getDeclaredField(fieldName);
            if (field == null) continue;
            return field;
        }
        for (c = this; c != null; c = c.getSuperClass()) {
            for (Type i : c.getInterfaces()) {
                field = i.getDeclaredOrInheritedField(fieldName);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public int compareTo(Type that) {
        return this.getName().compareTo(that.getName());
    }

    public int compareToUnqualified(Type that) {
        return this.getName().compareToUnqualified(that.getName());
    }
}

