/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.comment;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import oracle.ide.net.URLFileSystem;

public class RemediationCommentsWriter {
    public static final Type ELEMENT = Type.ELEMENT;
    public static final Type ATTRIBUTE = Type.ATTRIBUTE;
    private Type commentType = Type.ELEMENT;
    private Charset encoding = StandardCharsets.UTF_8;
    private boolean sorted;

    public Type getCommentType() {
        return this.commentType;
    }

    public void setCommentType(Type commentType) {
        this.commentType = commentType;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void write(Map<String, String> comments, URL url) throws IOException {
        this.write(comments, URLFileSystem.openOutputStream(url));
    }

    public void write(Map<String, String> comments, Path path) throws IOException {
        this.write(comments, Files.newOutputStream(path, new OpenOption[0]));
    }

    private void write(Map<String, String> comments, OutputStream stream) throws IOException {
        Object[] keys = comments.keySet().toArray(new String[comments.size()]);
        if (this.sorted) {
            Arrays.sort(keys);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, this.encoding));){
            writer.write("<?xml version=\"1.0\" encoding=\"");
            writer.write(this.encoding.name());
            writer.write("\" ?>");
            writer.newLine();
            writer.write("<lib-comments xmlns=\"http://xmlns.oracle.com/ide/comment\"");
            int keyCount = 0;
            block13: for (Object key : keys) {
                String value = comments.get(key);
                if (value == null || (value = value.trim()).isEmpty()) continue;
                if (keyCount++ == 0) {
                    writer.write(">");
                }
                RemediationCommentsWriter.newLine(1, writer);
                writer.write("<comment");
                RemediationCommentsWriter.writeAttribute("name", key, writer);
                switch (this.commentType) {
                    case ELEMENT: {
                        writer.write(">");
                        RemediationCommentsWriter.newLine(2, writer);
                        this.writeElementText(value, writer);
                        RemediationCommentsWriter.newLine(1, writer);
                        writer.write("</comment>");
                        continue block13;
                    }
                    case ATTRIBUTE: {
                        RemediationCommentsWriter.writeAttribute("comment", value, writer);
                        writer.write("/>");
                    }
                }
            }
            if (keyCount == 0) {
                writer.write("/>");
            } else {
                writer.newLine();
                writer.write("</lib-comments>");
            }
            writer.newLine();
        }
    }

    private void writeElementText(String text, BufferedWriter writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        block5: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    builder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block5;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        writer.write(builder.toString());
    }

    private static void writeAttribute(String name, Object value, BufferedWriter writer) throws IOException {
        int quote;
        writer.write(32);
        writer.write(name);
        writer.write("=");
        String text = value != null ? value.toString() : "";
        String singleQuote = "&apos;";
        String doubleQuote = "&quot;";
        if (text.indexOf(34) >= 0 && text.indexOf(39) < 0) {
            quote = 39;
            doubleQuote = "\"";
        } else {
            quote = 34;
            singleQuote = "'";
        }
        writer.write(quote);
        StringBuilder builder = new StringBuilder();
        block6: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    builder.append(doubleQuote);
                    continue block6;
                }
                case '\'': {
                    builder.append(singleQuote);
                    continue block6;
                }
                case '<': {
                    builder.append("&lt;");
                    continue block6;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block6;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        writer.write(builder.toString());
        writer.write(quote);
    }

    private static void newLine(int depth, BufferedWriter writer) throws IOException {
        writer.newLine();
        for (int i = 0; i < depth; ++i) {
            writer.write("  ");
        }
    }

    public static enum Type {
        ELEMENT,
        ATTRIBUTE;

    }
}

