/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.function.Function;

public class ComparisonIterators {
    public static <E extends Comparable<E>> ComparisonIterator<E> iterator(Iterable<E> left, Iterable<E> right) {
        return new ComparisonIterator<E>(left, right, Comparator.naturalOrder());
    }

    public static <E> ComparisonIterator<E> iterator(Iterable<E> left, Iterable<E> right, Comparator<? super E> comparator) {
        return new ComparisonIterator<E>(left, right, comparator);
    }

    public static <C, E extends Comparable<E>> ComparisonIterator<E> iterator(C left, C right, Function<C, Iterable<E>> mapper) {
        return new ComparisonIterator<E>(mapper.apply(left), mapper.apply(right), Comparator.naturalOrder());
    }

    public static <C, E> ComparisonIterator<E> iterator(C left, C right, Function<C, Iterable<E>> mapper, Comparator<? super E> comparator) {
        return new ComparisonIterator<E>(mapper.apply(left), mapper.apply(right), comparator);
    }

    public static <K extends Comparable<K>, V> MapComparisonIterator<K, V> mapIterator(SortedMap<K, V> left, SortedMap<K, V> right) {
        return new MapComparisonIterator<K, V>(left, right, Comparator.naturalOrder());
    }

    public static <K, V> MapComparisonIterator<K, V> mapIterator(SortedMap<K, V> left, SortedMap<K, V> right, Comparator<? super K> comparator) {
        return new MapComparisonIterator<K, V>(left, right, comparator);
    }

    public static <T, K extends Comparable<K>, V> MapComparisonIterator<K, V> mapIterator(T left, T right, Function<T, SortedMap<K, V>> mapper) {
        return new MapComparisonIterator<K, V>(mapper.apply(left), mapper.apply(right), Comparator.naturalOrder());
    }

    public static <T, K, V> MapComparisonIterator<K, V> mapIterator(T left, T right, Function<T, SortedMap<K, V>> mapper, Comparator<? super K> comparator) {
        return new MapComparisonIterator<K, V>(mapper.apply(left), mapper.apply(right), comparator);
    }

    public static class MapComparisonIterator<K, V> {
        private final Comparator<? super K> comparator;
        private Iterator<Map.Entry<K, V>> iLeft;
        private Iterator<Map.Entry<K, V>> iRight;
        private Map.Entry<K, V> left;
        private Map.Entry<K, V> right;
        private Map.Entry<K, V> nextLeft;
        private Map.Entry<K, V> nextRight;

        public MapComparisonIterator(SortedMap<K, V> left, SortedMap<K, V> right, Comparator<? super K> comparator) {
            this.comparator = comparator;
            if (left != null && !left.isEmpty()) {
                this.iLeft = left.entrySet().iterator();
                this.nextLeft = this.iLeft.next();
            }
            if (right != null && !right.isEmpty()) {
                this.iRight = right.entrySet().iterator();
                this.nextRight = this.iRight.next();
            }
        }

        public boolean hasNext() {
            return this.nextLeft != null || this.nextRight != null;
        }

        public Comparison next() {
            if (this.nextLeft == null) {
                if (this.nextRight == null) {
                    throw new NoSuchElementException();
                }
                this.left = null;
                this.right = this.nextRight;
                this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
                return Comparison.GREATER_THAN;
            }
            if (this.nextRight == null) {
                this.left = this.nextLeft;
                this.right = null;
                this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
                return Comparison.LESS_THAN;
            }
            int comparison = this.comparator.compare(this.nextLeft.getKey(), this.nextRight.getKey());
            if (comparison < 0) {
                this.left = this.nextLeft;
                this.right = null;
                this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
                return Comparison.LESS_THAN;
            }
            if (comparison > 0) {
                this.left = null;
                this.right = this.nextRight;
                this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
                return Comparison.GREATER_THAN;
            }
            this.left = this.nextLeft;
            this.right = this.nextRight;
            this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
            this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
            return Comparison.EQUAL;
        }

        public Map.Entry<K, V> left() {
            return this.left;
        }

        public Map.Entry<K, V> right() {
            return this.right;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ComparisonIterator<E>
    implements Iterator<Comparison> {
        private Comparator<? super E> comparator;
        private Iterator<E> iLeft;
        private Iterator<E> iRight;
        private E left;
        private E right;
        private E nextLeft;
        private E nextRight;

        public ComparisonIterator(Iterable<E> left, Iterable<E> right, Comparator<? super E> comparator) {
            Iterator<E> i;
            this.comparator = comparator;
            if (left != null && (i = left.iterator()).hasNext()) {
                this.iLeft = i;
                this.nextLeft = this.iLeft.next();
            }
            if (right != null && (i = right.iterator()).hasNext()) {
                this.iRight = i;
                this.nextRight = this.iRight.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLeft != null || this.nextRight != null;
        }

        @Override
        public Comparison next() {
            if (this.nextLeft == null) {
                if (this.nextRight == null) {
                    throw new NoSuchElementException();
                }
                this.left = null;
                this.right = this.nextRight;
                this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
                return Comparison.GREATER_THAN;
            }
            if (this.nextRight == null) {
                this.left = this.nextLeft;
                this.right = null;
                this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
                return Comparison.LESS_THAN;
            }
            int comparison = this.comparator.compare(this.nextLeft, this.nextRight);
            if (comparison < 0) {
                this.left = this.nextLeft;
                this.right = null;
                this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
                return Comparison.LESS_THAN;
            }
            if (comparison > 0) {
                this.left = null;
                this.right = this.nextRight;
                this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
                return Comparison.GREATER_THAN;
            }
            this.left = this.nextLeft;
            this.right = this.nextRight;
            this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
            this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
            return Comparison.EQUAL;
        }

        public E left() {
            return this.left;
        }

        public E right() {
            return this.right;
        }

        @Override
        public void remove() {
        }
    }

    public static enum Comparison {
        LESS_THAN,
        EQUAL,
        GREATER_THAN;

    }
}

