/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.library.LibraryScope;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.LinkType;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.SpecificationScope;
import org.xml.sax.SAXException;

public class ClassPathEntry {
    private final URL url;
    private final LinkType type;
    private final String key;
    private final boolean deriveFromManifestClassPath;
    private final int line;
    private final LibraryDependency dependency;
    private final ClassPathEntry manifestEntry;
    private Object resolvingLibrary;
    private ExportSpecification exportSpecification;
    private Map<String, String> embeddedRemediationComments;
    private boolean resolved;

    public ClassPathEntry(URL url, LinkType type, String key, boolean deriveFromManifestClassPath, int line) {
        this.url = url;
        this.type = type;
        this.key = key != null ? key : "";
        this.deriveFromManifestClassPath = deriveFromManifestClassPath;
        this.line = line;
        this.manifestEntry = null;
        this.dependency = null;
        boolean bl = this.resolved = type == LinkType.NULL;
        if (this.resolved) {
            this.embeddedRemediationComments = Collections.emptyMap();
        }
    }

    Merge<ClassPathEntry> merge(ClassPathEntry that, String type) {
        if (!that.resolved) {
            throw new IllegalStateException("this not resolved: " + this);
        }
        if (!this.resolved) {
            throw new IllegalStateException("that not resolved: " + that);
        }
        Merge<ClassPathEntry> merge = new Merge<ClassPathEntry>(this, that, "%s %s", type, this.url);
        ExportSpecification thisSpecification = this.exportSpecification;
        ExportSpecification thatSpecification = that.exportSpecification;
        Merge<ExportSpecification> specificationMerge = ExportSpecification.merge(new Scope("entry merge"), thisSpecification, thatSpecification);
        merge.addMerge(specificationMerge);
        this.exportSpecification = specificationMerge.getValue();
        merge.complete(this);
        return merge;
    }

    ClassPathEntry(URL url, ClassPathEntry manifestEntry, ClassPathEntry suppliedEntry) {
        this.url = url;
        this.type = suppliedEntry.type;
        this.key = "";
        this.deriveFromManifestClassPath = false;
        this.line = suppliedEntry.line;
        this.manifestEntry = manifestEntry;
        this.resolved = true;
        this.resolvingLibrary = suppliedEntry.resolvingLibrary;
        this.dependency = null;
        this.exportSpecification = suppliedEntry.exportSpecification;
        this.embeddedRemediationComments = suppliedEntry.embeddedRemediationComments;
    }

    ClassPathEntry(LibraryDependency dependency, URL url, ClassPathEntry dependencyEntry) {
        boolean export = dependencyEntry != null && dependency.isReexported();
        this.url = url;
        this.type = export ? dependencyEntry.type : LinkType.NULL;
        this.key = "";
        this.deriveFromManifestClassPath = false;
        this.line = -1;
        this.manifestEntry = null;
        this.dependency = dependency;
        this.resolvingLibrary = dependency.getLibrary();
        this.resolved = true;
        this.exportSpecification = export ? dependencyEntry.exportSpecification : null;
        this.embeddedRemediationComments = export ? dependencyEntry.embeddedRemediationComments : Collections.emptyMap();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public URL getUrl() {
        return this.url;
    }

    public LinkType getType() {
        return this.type;
    }

    public boolean isSupplied() {
        return this.manifestEntry == null && this.dependency == null;
    }

    public boolean isManifest() {
        return this.manifestEntry != null;
    }

    public boolean isDependency() {
        return this.dependency != null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isDeriveFromManifestClassPath() {
        return this.deriveFromManifestClassPath;
    }

    public LibraryDependency getDependency() {
        return this.dependency;
    }

    public void resolve(FileExportLibrary library, Map<String, ExportSpecification> libraryExportSpecifications, ExportSpecificationReader specificationReader, RemediationCommentsReader commentsReader, Log log) {
        if (this.resolved) {
            return;
        }
        this.resolvingLibrary = library;
        this.resolved = true;
        LibraryScope libraryScope = new LibraryScope(null, library);
        switch (this.type) {
            case NONE: {
                this.exportSpecification = new ExportSpecification(new SpecificationScope((Scope)libraryScope, LinkType.NONE), Access.CONCEALED, specificationReader.getExportDomain());
                break;
            }
            case EMBEDDED: {
                URL specificationUrl = URLFactory.newURL(this.url, "META-INF/lib-exports.xml");
                try {
                    this.exportSpecification = specificationReader.read(new SpecificationScope(libraryScope, LinkType.EMBEDDED, null, specificationUrl, null), specificationUrl, URLFileSystem.openInputStream(specificationUrl), log);
                }
                catch (FileNotFoundException e) {
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, LinkType.EMBEDDED, null, this.url, e.getMessage()), Access.CONCEALED, specificationReader.getExportDomain());
                    log.error("library-entry-embedded", "embedded export specification META-INF/lib-exports.xml not found in %s (%s:%d)", URLFileSystem.getPlatformPathName(this.url), URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, LinkType.EMBEDDED, null, this.url, e.getMessage()), Access.CONCEALED, specificationReader.getExportDomain());
                    log.error("library-entry-embedded", "embedded export specification META-INF/lib-exports.xml not read in %s: %s (%s:%d)", URLFileSystem.getPlatformPathName(this.url), e, URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                }
                break;
            }
            case LIBRARY: {
                this.exportSpecification = libraryExportSpecifications.get(this.key);
                if (this.exportSpecification != null) break;
                if (libraryExportSpecifications.containsKey(this.key)) {
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, LinkType.LIBRARY, this.key, null, "failed"), Access.CONCEALED, specificationReader.getExportDomain());
                    break;
                }
                if (this.key.isEmpty()) {
                    log.error("library-entry-key", "<export-specification> with default key (no key attribute or key=\"\") not found (%s:%d)", URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                    this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, LinkType.LIBRARY, this.key, null, "missing"), Access.CONCEALED, specificationReader.getExportDomain());
                    break;
                }
                log.error("library-entry-key", "<export-specification> with key=\"%s\" not found (%s:%d)", this.key, URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                this.exportSpecification = new ExportSpecification(new SpecificationScope(libraryScope, LinkType.LIBRARY, this.key, null, "missing"), Access.CONCEALED, specificationReader.getExportDomain());
                break;
            }
            case ALL: {
                this.exportSpecification = new ExportSpecification(new SpecificationScope((Scope)libraryScope, LinkType.ALL), Access.EXPORTED, specificationReader.getExportDomain());
                break;
            }
            default: {
                this.exportSpecification = null;
            }
        }
        switch (this.type) {
            case EMBEDDED: {
                URL commentUrl = URLFactory.newURL(this.url, "META-INF/lib-comments.xml");
                try {
                    this.embeddedRemediationComments = commentsReader.read(commentUrl, URLFileSystem.openInputStream(commentUrl), log);
                }
                catch (FileNotFoundException e) {
                    this.embeddedRemediationComments = Collections.emptyMap();
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.embeddedRemediationComments = Collections.emptyMap();
                    log.error("embedded-comments-not-read", "embedded remediation comments file META-INF/lib-comments.xml not read in %s: %s (%s:%d)", URLFileSystem.getPlatformPathName(this.url), e, URLFileSystem.getPlatformPathName(library.getOrigin()), this.line).scope(library);
                }
                break;
            }
            default: {
                this.embeddedRemediationComments = Collections.emptyMap();
            }
        }
    }

    public ExportSpecification getResolvedExportSpecification() {
        if (!this.resolved) {
            throw new IllegalStateException("entry not resolved");
        }
        return this.exportSpecification;
    }

    public Map<String, String> getResolvedRemediationComments() {
        if (!this.resolved) {
            throw new IllegalStateException("entry not resolved");
        }
        return this.embeddedRemediationComments;
    }

    public boolean equals(Object that) {
        return that instanceof ClassPathEntry && URLFileSystem.equals(this.url, ((ClassPathEntry)that).url);
    }

    public int hashCode() {
        return URLFileSystem.hashCode(this.url);
    }

    public String toString() {
        String kind = this.isSupplied() ? "supplied" : (this.isDependency() ? "dependency" : (this.isManifest() ? "manifest" : "unknown"));
        String path = URLFileSystem.getPlatformPathName(this.url);
        return kind + " " + (Object)((Object)this.type) + " entry " + path;
    }
}

