/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.LibraryDependency;

public interface ExportLibrary {
    public URL getOrigin();

    public String getId();

    public String getName();

    public String getDescription();

    public Collection<ClassPathEntry> getSuppliedClassPath();

    public Collection<ClassPathEntry> getResolvedClassPath();

    public Map<String, List<URL>> getExportSpecificationPaths();

    public List<URL> getRemediationCommentsPaths();

    public Map<String, String> getResolvedRemediationComments();

    default public int getResolvedManifestClassPathCount() {
        return 0;
    }

    public Collection<LibraryDependency> getDependencies();

    /*
     * Enabled aggressive block sorting
     */
    public static String syntheticId(URL url, String name) {
        String fileName;
        if (url == null) return ExportLibrary.syntheticId("oracle.", name);
        if (JarUtil.isJarURL(url)) {
            url = JarUtil.getJarFileURL(url);
        }
        if ((fileName = URLFileSystem.getFileName(url)).endsWith(".jar")) {
            return ExportLibrary.syntheticId(fileName.substring(0, fileName.length() - ".jar".length()), name);
        }
        if (!fileName.endsWith(".library")) return ExportLibrary.syntheticId("oracle.", name);
        int i = 0;
        while ((url = URLFileSystem.getParent(url)) != null) {
            String directoryName = URLFileSystem.getFileName(url);
            switch (++i) {
                case 1: {
                    if ("libraries".equals(directoryName)) break;
                    return ExportLibrary.syntheticId("oracle.", name);
                }
                case 2: {
                    break;
                }
                case 3: {
                    if ("plugins".equals(directoryName)) break;
                    return ExportLibrary.syntheticId("oracle.", name);
                }
                case 4: {
                    return ExportLibrary.syntheticId("oracle." + directoryName, name);
                }
            }
        }
        return ExportLibrary.syntheticId("oracle.", name);
    }

    public static String syntheticId(String prefix, String name) {
        StringBuilder builder = new StringBuilder(prefix.toLowerCase());
        if (!prefix.isEmpty()) {
            builder.append('.');
        }
        boolean boundary = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                builder.append(Character.toLowerCase(c));
                boundary = false;
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                builder.append(c);
                boundary = false;
                continue;
            }
            if (!boundary) {
                builder.append('-');
            }
            boundary = true;
        }
        int last = builder.length() - 1;
        if (builder.charAt(last) == '-') {
            builder.setLength(last);
        }
        return builder.toString();
    }
}

