/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.specification.LinkType;

public class ExportLibraryWriter {
    private static final List<String> ARCHIVE_SUFFIXES = Arrays.asList(".jar", ".war", ".ear", ".zip");
    private Charset encoding = StandardCharsets.UTF_8;

    public ExportLibraryWriter() {
    }

    public ExportLibraryWriter(Charset encoding) {
        this.encoding = encoding;
    }

    public void write(FileExportLibrary library, File file) throws IOException {
        this.write(file, library.getId(), library.getName(), library.getDescription(), library.getFlags(), library.getSuppliedClassPath(), library.getExportSpecificationPaths(), library.getRemediationCommentsPaths(), library.getDependencies(), library.getSourcePath(), library.getDocPath());
    }

    public void write(File file, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<URL> remediationCommentPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        this.write(new FileOutputStream(file), URLFactory.newFileURL(file.getParentFile()), id, name, description, flags, suppliedClassPath, exportSpecificationPaths, remediationCommentPaths, dependencies, sourcePath, docPath);
    }

    public void write(URL url, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<URL> remediationCommentPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        this.write(URLFileSystem.openOutputStream(url), URLFileSystem.getParent(url), id, name, description, flags, suppliedClassPath, exportSpecificationPaths, remediationCommentPaths, dependencies, sourcePath, docPath);
    }

    public void write(Path path, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<URL> remediationCommentPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, this.encoding, new OpenOption[0]);){
            this.write(writer, URLFactory.newDirURL(path.getParent().toString()), id, name, description, flags, suppliedClassPath, exportSpecificationPaths, remediationCommentPaths, dependencies, sourcePath, docPath);
        }
    }

    public void write(OutputStream stream, URL contextUrl, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<URL> remediationCommentPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, this.encoding));){
            this.write(writer, contextUrl, id, name, description, flags, suppliedClassPath, exportSpecificationPaths, remediationCommentPaths, dependencies, sourcePath, docPath);
        }
    }

    private void write(BufferedWriter writer, URL contextUrl, String id, String name, String description, Set<FileExportLibrary.LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, Collection<URL> remediationCommentPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(this.encoding.name());
        writer.write("\" ?>");
        ExportLibraryWriter.newLine(0, writer);
        writer.write("<library");
        ExportLibraryWriter.writeAttribute("name", name, writer);
        ExportLibraryWriter.writeAttribute("id", id, writer);
        for (FileExportLibrary.LibraryFlag libraryFlag : flags) {
            ExportLibraryWriter.writeAttribute(libraryFlag.getAttributeName(), true, writer);
        }
        ExportLibraryWriter.writeAttribute("xmlns", "http://xmlns.oracle.com/jdeveloper/1013/manifest-libraries", writer);
        writer.write(">");
        ExportLibraryWriter.newLine(1, writer);
        if (description != null && !description.isEmpty()) {
            writer.write("<description>");
            writer.write(description);
            writer.write("</description>");
        } else {
            writer.write("<description/>");
        }
        for (ClassPathEntry classPathEntry : suppliedClassPath) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<classpath");
            switch (classPathEntry.getType()) {
                case NONE: {
                    ExportLibraryWriter.writeAttribute("export", "none", writer);
                    break;
                }
                case EMBEDDED: {
                    ExportLibraryWriter.writeAttribute("export", "embedded", writer);
                    break;
                }
                case LIBRARY: {
                    ExportLibraryWriter.writeAttribute("export", "library", writer);
                    break;
                }
                case ALL: {
                    ExportLibraryWriter.writeAttribute("export", "all", writer);
                    break;
                }
            }
            if (classPathEntry.isDeriveFromManifestClassPath()) {
                ExportLibraryWriter.writeAttribute("manifest", true, writer);
            }
            if (classPathEntry.getType() == LinkType.LIBRARY && !classPathEntry.getKey().isEmpty()) {
                ExportLibraryWriter.writeAttribute("key", classPathEntry.getKey(), writer);
            }
            writer.write(">");
            writer.write(ExportLibraryWriter.toPath(classPathEntry.getUrl(), contextUrl));
            writer.write("</classpath>");
        }
        for (Map.Entry entry : exportSpecificationPaths.entrySet()) {
            for (URL url : (List)entry.getValue()) {
                ExportLibraryWriter.newLine(1, writer);
                writer.write("<export-specification");
                if (!((String)entry.getKey()).isEmpty()) {
                    ExportLibraryWriter.writeAttribute("key", entry.getKey(), writer);
                }
                writer.write(">");
                writer.write(ExportLibraryWriter.toPath(url, contextUrl));
                writer.write("</export-specification>");
            }
        }
        for (URL uRL : remediationCommentPaths) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<remediation-comments>");
            writer.write(ExportLibraryWriter.toPath(uRL, contextUrl));
            writer.write("</remediation-comments>");
        }
        for (LibraryDependency libraryDependency : dependencies) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<dependency");
            if (libraryDependency.isReexported()) {
                ExportLibraryWriter.writeAttribute("reexport", libraryDependency.isReexported(), writer);
            }
            writer.write(62);
            writer.write(libraryDependency.getId());
            writer.write("</dependency>");
        }
        for (URL uRL : sourcePath) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<sourcepath>");
            writer.write(ExportLibraryWriter.toPath(uRL, contextUrl));
            writer.write("</sourcepath>");
        }
        for (URL uRL : docPath) {
            ExportLibraryWriter.newLine(1, writer);
            writer.write("<docpath>");
            writer.write(ExportLibraryWriter.toPath(uRL, contextUrl));
            writer.write("</docpath>");
        }
        ExportLibraryWriter.newLine(0, writer);
        writer.write("</library>");
        ExportLibraryWriter.newLine(0, writer);
    }

    private static void writeAttribute(String name, Object value, BufferedWriter writer) throws IOException {
        writer.write(32);
        writer.write(name);
        writer.write("=\"");
        if (value != null) {
            writer.write(value.toString());
        }
        writer.write(34);
    }

    private static void newLine(int depth, BufferedWriter writer) throws IOException {
        writer.newLine();
        for (int i = 0; i < depth; ++i) {
            writer.write("  ");
        }
    }

    protected static String toPath(URL url, URL contextUrl) {
        switch (url.getProtocol()) {
            case "jar": 
            case "zip": 
            case "ear": 
            case "war": {
                if (url.getAuthority() != null && !url.getAuthority().isEmpty()) {
                    return url.toExternalForm();
                }
                String path = url.getPath();
                if (!path.startsWith("file:")) {
                    return url.toExternalForm();
                }
                int entryIndex = (path = path.substring("file:".length())).indexOf("!/");
                if (entryIndex < 0) {
                    return url.toExternalForm();
                }
                String filePath = path.substring(0, entryIndex);
                String entryPath = path.substring(entryIndex + 2);
                filePath = URLFileSystem.toRelativeSpec(URLFactory.newFileURL(filePath), contextUrl);
                int dot = filePath.lastIndexOf(46);
                if (entryPath.isEmpty() && url.getQuery() == null && url.getRef() == null && dot >= 0 && ARCHIVE_SUFFIXES.contains(filePath.substring(dot))) {
                    return filePath;
                }
                StringBuilder builder = new StringBuilder(filePath);
                builder.append("!/").append(entryPath);
                if (url.getQuery() != null) {
                    builder.append('?').append(url.getQuery());
                }
                if (url.getRef() != null) {
                    builder.append("#").append(url.getRef());
                }
                return builder.toString();
            }
            case "file": {
                if (url.getAuthority() != null && !url.getAuthority().isEmpty()) {
                    return url.toExternalForm();
                }
                String path = URLFileSystem.toRelativeSpec(URLFactory.newFileURL(url.getPath()), contextUrl);
                if (url.getQuery() == null && url.getRef() == null) {
                    return path;
                }
                StringBuilder builder = new StringBuilder(path);
                if (url.getQuery() != null) {
                    builder.append('?').append(url.getQuery());
                }
                if (url.getRef() != null) {
                    builder.append("#").append(url.getRef());
                }
                return builder.toString();
            }
        }
        return url.toExternalForm();
    }
}

