/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.library.LibraryScope;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.LinkType;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.SpecificationScope;
import org.xml.sax.SAXException;

public class FileExportLibrary
implements ExportLibrary {
    private final URL origin;
    private final String extensionId;
    private final String name;
    private final String syntheticId;
    private final String id;
    private final String description;
    private final EnumSet<LibraryFlag> flags;
    private final Collection<ClassPathEntry> suppliedClassPath;
    private final Map<String, List<URL>> exportSpecificationPaths;
    private final List<URL> remediationCommentsPaths;
    private final Collection<LibraryDependency> dependencies;
    private final List<URL> sourcePath;
    private final List<URL> docPath;
    private final List<URL> endorsedDirectoriesPath;
    private final List<URL> endorsedSourcePath;
    private final List<URL> endorsedDocPath;
    private ClassPathEntry[] resolvedClassPath;
    private Map<String, String> resolvedRemediationComments;
    private boolean resolvedDependencies;
    private int resolvedManifestClassPathCount;
    private static AtomicInteger namelessCount = new AtomicInteger();
    private static final List<String> ARCHIVE_SUFFIXES = Arrays.asList(".jar", ".war", ".ear", ".zip");

    public FileExportLibrary(URL origin, String extensionId, String name, String id, String description, EnumSet<LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, List<URL> remediationCommentsPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath, List<URL> endorsedDirectoriesPath, List<URL> endorsedSourcePath, List<URL> endorsedDocPath) {
        this(origin, extensionId, name, null, id, description, flags, suppliedClassPath, exportSpecificationPaths, remediationCommentsPaths, dependencies, sourcePath, docPath, endorsedDirectoriesPath, endorsedSourcePath, endorsedDocPath);
    }

    public FileExportLibrary(URL origin, String extensionId, String name, String syntheticId, String id, String description, EnumSet<LibraryFlag> flags, Collection<ClassPathEntry> suppliedClassPath, Map<String, List<URL>> exportSpecificationPaths, List<URL> remediationCommentsPaths, Collection<LibraryDependency> dependencies, List<URL> sourcePath, List<URL> docPath, List<URL> endorsedDirectoriesPath, List<URL> endorsedSourcePath, List<URL> endorsedDocPath) {
        assert (!exportSpecificationPaths.containsKey(null));
        if (name == null) {
            String string = name = origin != null ? URLFileSystem.getName(origin) : "unnamed-" + namelessCount.incrementAndGet();
        }
        if (syntheticId == null) {
            syntheticId = extensionId != null ? ExportLibrary.syntheticId(extensionId, name) : ExportLibrary.syntheticId(origin, name);
        }
        this.origin = origin;
        this.extensionId = extensionId;
        this.syntheticId = syntheticId;
        this.id = id;
        this.name = name;
        this.description = description;
        this.flags = flags;
        this.suppliedClassPath = suppliedClassPath;
        this.exportSpecificationPaths = exportSpecificationPaths;
        this.remediationCommentsPaths = remediationCommentsPaths;
        this.dependencies = dependencies;
        this.sourcePath = sourcePath;
        this.docPath = docPath;
        this.endorsedDirectoriesPath = endorsedDirectoriesPath;
        this.endorsedSourcePath = endorsedSourcePath;
        this.endorsedDocPath = endorsedDocPath;
    }

    public void resolve(ExportSpecificationReader specificationReader, RemediationCommentsReader commentsReader, Function<String, ?> libraryResolver, Log log) {
        this.resolve(new IdentityHashMap<ExportLibrary, Boolean>(), specificationReader, commentsReader, libraryResolver, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void resolve(Map<ExportLibrary, Boolean> resolvingLibraries, ExportSpecificationReader specificationReader, RemediationCommentsReader commentsReader, Function<String, ?> libraryResolver, Log log) {
        String predecessor;
        String value;
        Map<String, String> comments;
        if (this.resolvedDependencies) {
            return;
        }
        this.resolvedDependencies = true;
        HashMap<String, ExportSpecification> resolvedExportSpecifications = new HashMap<String, ExportSpecification>();
        LibraryScope libraryScope = new LibraryScope(null, this);
        for (Map.Entry<String, List<URL>> entry : this.exportSpecificationPaths.entrySet()) {
            ExportSpecification mergedSpecification;
            ArrayList<ExportSpecification> specifications = new ArrayList<ExportSpecification>();
            for (URL uRL : entry.getValue()) {
                String key;
                try {
                    specifications.add(specificationReader.read(new SpecificationScope(libraryScope, LinkType.LIBRARY, entry.getKey(), uRL, null), uRL, URLFileSystem.openInputStream(uRL), log));
                }
                catch (FileNotFoundException e) {
                    resolvedExportSpecifications.put(entry.getKey(), null);
                    key = entry.getKey().isEmpty() ? "default key" : "key \"" + entry.getKey() + '\"';
                    log.error("library-exports-absent", "library export specification %s for %s not found", URLFileSystem.getPlatformPathName(uRL), key).scope(this.origin);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    resolvedExportSpecifications.put(entry.getKey(), null);
                    key = entry.getKey().isEmpty() ? "default key" : "key \"" + entry.getKey() + '\"';
                    log.error("library-exports-unread", "library export specification %s for %s not read", URLFileSystem.getPlatformPathName(uRL), key).scope(this.origin);
                }
            }
            switch (specifications.size()) {
                case 0: {
                    mergedSpecification = null;
                    break;
                }
                case 1: {
                    mergedSpecification = (ExportSpecification)specifications.get(0);
                    break;
                }
                default: {
                    void var12_21;
                    mergedSpecification = (ExportSpecification)specifications.get(0);
                    boolean bl = true;
                    while (var12_21 < specifications.size()) {
                        ExportSpecification specification = (ExportSpecification)specifications.get((int)var12_21);
                        Merge<ExportSpecification> merge = ExportSpecification.merge(new SpecificationScope(libraryScope, LinkType.LIBRARY, entry.getKey()), mergedSpecification, specification);
                        mergedSpecification = merge.getValue();
                        if (merge.getSeverity() == Severity.ERROR) {
                            log.message(merge.getSeverity(), "library-merge-key", "%s", merge.getDescription(Severity.WARNING));
                        }
                        ++var12_21;
                    }
                    break block4;
                }
            }
            resolvedExportSpecifications.put(entry.getKey(), mergedSpecification);
        }
        this.resolvedRemediationComments = Collections.emptyMap();
        for (URL uRL : this.remediationCommentsPaths) {
            try {
                comments = commentsReader.read(uRL, URLFileSystem.openInputStream(uRL), log);
                if (comments.isEmpty()) continue;
                if (this.resolvedRemediationComments.isEmpty()) {
                    this.resolvedRemediationComments = new HashMap<String, String>(comments);
                    continue;
                }
                for (Map.Entry entry : comments.entrySet()) {
                    value = (String)entry.getValue();
                    predecessor = this.resolvedRemediationComments.putIfAbsent((String)entry.getKey(), value);
                    if (predecessor == null || predecessor.equals(value)) continue;
                    log.warning("library-duplicate-comment", "duplicate remediation comment for %s in %s: \"%s\" preceded by \"%s\"", entry.getKey(), URLFileSystem.getPlatformPathName(uRL), value, predecessor).scope(this);
                }
            }
            catch (FileNotFoundException e) {
                log.error("library-comments-absent", "remediation comments file %s not found", URLFileSystem.getPlatformPathName(uRL)).scope(this);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.error("library-comments-unread", "remediation comments file %s not read", URLFileSystem.getPlatformPathName(uRL)).scope(this);
            }
        }
        for (ClassPathEntry classPathEntry : this.suppliedClassPath) {
            classPathEntry.resolve(this, resolvedExportSpecifications, specificationReader, commentsReader, log);
            comments = classPathEntry.getResolvedRemediationComments();
            if (comments.isEmpty()) continue;
            if (this.resolvedRemediationComments.isEmpty()) {
                this.resolvedRemediationComments = new HashMap<String, String>(comments);
                continue;
            }
            for (Map.Entry entry : comments.entrySet()) {
                value = (String)entry.getValue();
                predecessor = this.resolvedRemediationComments.putIfAbsent((String)entry.getKey(), value);
                if (predecessor == null || predecessor.equals(value)) continue;
                log.warning("library-duplicate-comment", "duplicate remediation comment for %s in %s: \"%s\" preceded by \"%s\"", entry.getKey(), URLFileSystem.getPlatformPathName(classPathEntry.getUrl()), value, predecessor).scope(this);
            }
        }
        Merge<Object> merge = new Merge<Object>(null, null, "class path of library %s", this);
        LinkedHashMap<ClassPathEntry, ClassPathEntry> linkedHashMap = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
        HashSet<ClassPathEntry> expandedEntries = new HashSet<ClassPathEntry>();
        for (ClassPathEntry classPathEntry : this.suppliedClassPath) {
            ClassPathEntry existingEntry;
            if (classPathEntry.isDeriveFromManifestClassPath()) {
                ++this.resolvedManifestClassPathCount;
            }
            if ((existingEntry = linkedHashMap.putIfAbsent(classPathEntry, classPathEntry)) != null) {
                merge.addMerge(existingEntry.merge(classPathEntry, "duplicated supplied entry"));
            }
            if (!classPathEntry.isDeriveFromManifestClassPath() || !expandedEntries.add(classPathEntry)) continue;
            FileExportLibrary.accumulateManifestClasspath(classPathEntry, classPathEntry, expandedEntries, linkedHashMap, merge, log, this);
        }
        resolvingLibraries.put(this, true);
        try {
            for (LibraryDependency libraryDependency : this.getDependencies()) {
                ClassPathEntry existingEntry;
                ClassPathEntry newEntry;
                Object resolvedLibrary = libraryDependency.resolve(libraryResolver);
                if (resolvedLibrary == null) {
                    log.error("library-dependency-absent", "library dependency %s not found in library %s (\"%s\"): %s", libraryDependency.getId(), this.getId(), this.getName(), this.getOrigin()).scope(this);
                    continue;
                }
                if (resolvedLibrary instanceof ExportLibrary) {
                    if (resolvedLibrary instanceof FileExportLibrary) {
                        FileExportLibrary exportLibrary = (FileExportLibrary)resolvedLibrary;
                        Boolean resolving = resolvingLibraries.putIfAbsent(exportLibrary, true);
                        if (resolving == null) {
                            exportLibrary.resolve(resolvingLibraries, specificationReader, commentsReader, libraryResolver, log);
                        } else if (resolving.booleanValue()) {
                            log.error("library-dependency-cycle", "dependency cycle at library %s (%s)", exportLibrary.getName(), exportLibrary.getId()).scope(this);
                            continue;
                        }
                    }
                    for (ClassPathEntry dependencyEntry : ((ExportLibrary)resolvedLibrary).getResolvedClassPath()) {
                        newEntry = new ClassPathEntry(libraryDependency, dependencyEntry.getUrl(), dependencyEntry);
                        existingEntry = linkedHashMap.putIfAbsent(newEntry, newEntry);
                        if (existingEntry == null) continue;
                        merge.addMerge(existingEntry.merge(newEntry, "duplicated dependency entry"));
                    }
                    continue;
                }
                try {
                    for (URL url : (URLPath)resolvedLibrary.getClass().getMethod("getClassPath", new Class[0]).invoke(resolvedLibrary, new Object[0])) {
                        newEntry = new ClassPathEntry(libraryDependency, url, null);
                        existingEntry = linkedHashMap.putIfAbsent(newEntry, newEntry);
                        if (existingEntry == null) continue;
                        merge.addMerge(existingEntry.merge(newEntry, "duplicated dependency entry"));
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                }
            }
        }
        finally {
            resolvingLibraries.put(this, false);
        }
        this.resolvedClassPath = linkedHashMap.values().toArray(new ClassPathEntry[linkedHashMap.size()]);
        merge.complete(null);
        if (merge.getSeverity() == Severity.ERROR) {
            log.message(merge.getSeverity(), "library-merge-classpath", "%s", merge.getDescription(Severity.WARNING));
        }
    }

    static void accumulateManifestClasspath(ClassPathEntry suppliedEntry, ClassPathEntry manifestEntry, Set<ClassPathEntry> expandedEntries, Map<ClassPathEntry, ClassPathEntry> resolvedClassPath, Merge<Void> merge, Log log, Object scope) {
        URL containerUrl = manifestEntry.getUrl();
        URL manifestUrl = URLFactory.newJarURL(containerUrl, "META-INF/MANIFEST.MF");
        try {
            String paths;
            String[] stringArray = null;
            try (InputStream stream = URLFileSystem.openInputStream(manifestUrl);){
                paths = new Manifest(stream).getMainAttributes().getValue("Class-Path");
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            if (paths == null) {
                return;
            }
            URL context = FileExportLibrary.getContextUrl(containerUrl);
            for (String entryPath : paths.split(" +")) {
                ClassPathEntry newEntry;
                ClassPathEntry existingEntry;
                boolean archive;
                URL entryUrl;
                if (entryPath.isEmpty() || !URLFileSystem.exists(entryUrl = FileExportLibrary.resolve(entryPath, context))) continue;
                int dot = entryPath.lastIndexOf(46);
                boolean bl = archive = dot >= 0 && ARCHIVE_SUFFIXES.contains(entryPath.substring(dot));
                if (archive) {
                    entryUrl = URLFactory.newJarURL(entryUrl, "");
                }
                if ((existingEntry = resolvedClassPath.putIfAbsent(newEntry = new ClassPathEntry(entryUrl, manifestEntry, suppliedEntry), newEntry)) != null) {
                    merge.addMerge(existingEntry.merge(newEntry, "duplicated manifest entry"));
                }
                if (!expandedEntries.add(newEntry)) continue;
                FileExportLibrary.accumulateManifestClasspath(suppliedEntry, newEntry, expandedEntries, resolvedClassPath, merge, log, scope);
            }
        }
        catch (FileNotFoundException paths) {
        }
        catch (IOException e) {
            log.error("library-manifest-unread", "manifest of %s not read: %s", manifestEntry, e).scope(scope);
        }
    }

    public boolean isResolved() {
        return this.resolvedDependencies;
    }

    @Override
    public URL getOrigin() {
        return this.origin;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    @Override
    public String getId() {
        return this.id != null && !this.id.isEmpty() ? this.id : this.syntheticId;
    }

    public String getSyntheticId() {
        return this.syntheticId;
    }

    public boolean isIdSynthetic() {
        return this.id == null || this.id.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public EnumSet<LibraryFlag> getFlags() {
        return this.flags;
    }

    public boolean isSet(LibraryFlag flag) {
        return this.flags.contains((Object)flag);
    }

    @Override
    public Collection<ClassPathEntry> getSuppliedClassPath() {
        return this.suppliedClassPath;
    }

    @Override
    public Map<String, List<URL>> getExportSpecificationPaths() {
        return this.exportSpecificationPaths;
    }

    @Override
    public List<URL> getRemediationCommentsPaths() {
        return this.remediationCommentsPaths;
    }

    @Override
    public Collection<LibraryDependency> getDependencies() {
        return this.dependencies;
    }

    public List<URL> getSourcePath() {
        return this.sourcePath;
    }

    public List<URL> getDocPath() {
        return this.docPath;
    }

    public List<URL> getEndorsedDirectoriesPath() {
        return this.endorsedDirectoriesPath;
    }

    public List<URL> getEndorsedSourcePath() {
        return this.endorsedSourcePath;
    }

    public List<URL> getEndorsedDocPath() {
        return this.endorsedDocPath;
    }

    @Override
    public Collection<ClassPathEntry> getResolvedClassPath() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return Arrays.asUnmodifiableList(this.resolvedClassPath);
    }

    @Override
    public Map<String, String> getResolvedRemediationComments() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return this.resolvedRemediationComments;
    }

    @Override
    public int getResolvedManifestClassPathCount() {
        if (!this.resolvedDependencies) {
            throw new IllegalStateException("classpath not resolved");
        }
        return this.resolvedManifestClassPathCount;
    }

    public String toString() {
        return this.name + " (" + this.getId() + " at " + URLFileSystem.getPlatformPathName(this.origin) + ")";
    }

    private static URL resolve(String path, URL contextUrl) {
        URL fileUrl = FileExportLibrary.isAbsolute(path) ? URLFactory.newFileURL(path) : URLFactory.newURL(contextUrl, path);
        return fileUrl;
    }

    protected static boolean isAbsolute(String path) {
        return path.startsWith("/") || path.length() >= 2 && path.charAt(1) == ':';
    }

    private static URL getContextUrl(URL url) {
        if (JarUtil.isJarURL(url) && JarUtil.getJarEntry(url).isEmpty()) {
            url = JarUtil.getJarFileURL(url);
        }
        return URLFileSystem.getParent(url);
    }

    public static enum LibraryFlag {
        DEPLOYED,
        LOCKED,
        HIDDEN,
        LAZY;


        public String getAttributeName() {
            return this.toString().toLowerCase();
        }
    }
}

