/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.TypeName;

public final class ConstructorName
extends MemberName {
    private TypeName[] parameters;
    private boolean varargs;
    private int hashCode;

    ConstructorName(TypeName parent, TypeName[] parameters, boolean varargs) {
        super(parent);
        assert (!Arrays.contains(parameters, null)) : parent.getQualifiedHybridName() + Arrays.toString(parameters);
        assert (!varargs || parameters.length > 0 && parameters[parameters.length - 1].isArray()) : parent.getQualifiedHybridName() + Arrays.toString(parameters);
        this.parameters = parameters.length > 0 ? parameters : TypeName.EMPTY_ARRAY;
        this.varargs = varargs;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CONSTRUCTOR;
    }

    @Override
    public int getArity() {
        return this.parameters.length;
    }

    @Override
    public boolean isVariableArity() {
        return this.varargs;
    }

    @Override
    public boolean isFixedArity() {
        return !this.varargs;
    }

    @Override
    public TypeName[] getParameters() {
        return this.parameters;
    }

    @Override
    public String getSimpleName() {
        return "";
    }

    @Override
    public String getSourceName() {
        StringBuilder builder = new StringBuilder(this.getParent().getSimpleName());
        return this.appendSourceParameters(builder, this.parameters, this.varargs).toString();
    }

    @Override
    public String getQualifiedSourceName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedNameLength() + this.getParametersLength(this.parameters, this.varargs));
        this.getType().appendQualifiedSourceName(builder);
        this.appendSourceParameters(builder, this.parameters, this.varargs);
        return builder.toString();
    }

    @Override
    public void writeSourceName(Writer writer) throws IOException {
        writer.write(this.getParent().getSimpleName());
        this.writeSourceParameters(writer, this.parameters, this.varargs);
    }

    @Override
    public void writeQualifiedSourceName(Writer writer) throws IOException {
        this.getParent().writeQualifiedSourceName(writer);
        this.writeSourceParameters(writer, this.parameters, this.varargs);
    }

    @Override
    public String getBinaryName() {
        StringBuilder builder = new StringBuilder();
        return this.appendBinaryParameters(builder, this.parameters, this.varargs).toString();
    }

    @Override
    public String getQualifiedBinaryName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedNamePrefixLength() + this.getParametersLength(this.parameters, this.varargs));
        this.getType().appendQualifiedBinaryNamePrefix(builder);
        this.appendBinaryParameters(builder, this.parameters, this.varargs);
        return builder.toString();
    }

    @Override
    public String getHybridName() {
        StringBuilder builder = new StringBuilder(this.getHybridParametersLength(this.parameters, this.varargs));
        this.appendHybridParameters(builder, this.parameters, this.varargs);
        return builder.toString();
    }

    @Override
    public String getQualifiedHybridName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedHybridNamePrefixLength() + this.getHybridParametersLength(this.parameters, this.varargs));
        this.getType().appendQualifiedHybridNamePrefix(builder);
        this.appendHybridParameters(builder, this.parameters, this.varargs);
        return builder.toString();
    }

    @Override
    public void writeHybridName(Writer writer) throws IOException {
        this.writeHybridParameters(writer, this.parameters, this.varargs);
    }

    @Override
    public final int compareToUnqualified(MemberName that) {
        switch (that.getKind()) {
            case CONSTRUCTOR: {
                return this.compareParameters(this.getParameters(), that.getParameters(), this.varargs, ((ConstructorName)that).varargs);
            }
            case METHOD: {
                return -1;
            }
            case FIELD: {
                return -1;
            }
        }
        throw new IllegalStateException("unexpected kind " + (Object)((Object)that.getKind()));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ConstructorName)) {
            return false;
        }
        ConstructorName that = (ConstructorName)object;
        if (this.parameters.length != that.parameters.length) {
            return false;
        }
        if (!this.getParent().equals(that.getParent())) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].equals(that.parameters[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.getParent().hashCode();
        for (TypeName parameter : this.parameters) {
            this.hashCode = this.hashCode * 31 + parameter.hashCode();
        }
        return this.hashCode;
    }
}

