/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

public enum ElementKind {
    PACKAGE("package", false, false),
    CLASS("class", true, false),
    INTERFACE("interface", true, false),
    CONSTRUCTOR("constructor", false, true),
    METHOD("method", false, true),
    FIELD("field", false, true);

    private final String lowerCase;
    private final boolean type;
    private final boolean member;

    private ElementKind(String lowerCase, boolean type, boolean member) {
        this.lowerCase = lowerCase;
        this.type = type;
        this.member = member;
    }

    public static ElementKind valueOfIgnoreCase(String string) {
        return ElementKind.valueOf(string.toUpperCase());
    }

    public boolean isType() {
        return this.type;
    }

    public boolean isMember() {
        return this.member;
    }

    public boolean isPackage() {
        return this == PACKAGE;
    }

    public boolean isClass() {
        return this == CLASS;
    }

    public boolean isInterface() {
        return this == INTERFACE;
    }

    public boolean isConstructor() {
        return this == CONSTRUCTOR;
    }

    public boolean isMethod() {
        return this == METHOD;
    }

    public boolean isField() {
        return this == FIELD;
    }

    public String toLowerCase() {
        return this.lowerCase;
    }

    public String toUpperCase() {
        return this.toString();
    }
}

