/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.name.TypeOrMemberName;

public abstract class MemberName
extends TypeOrMemberName {
    public static final Comparator<MemberName> COMPARATOR = (left, right) -> left.compareTo((MemberName)right);
    public static final Comparator<MemberName> UNQUALIFIED_COMPARATOR = (left, right) -> left.compareToUnqualified((MemberName)right);
    private TypeName parent;

    MemberName(TypeName parent) {
        this.parent = parent;
    }

    @Override
    public final int getLevel() {
        return 2;
    }

    @Override
    public final ElementName getParent() {
        return this.parent;
    }

    @Override
    public final PackageName getPackage() {
        return this.parent.getPackage();
    }

    @Override
    public TypeName getType() {
        return this.parent;
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public boolean isMember() {
        return true;
    }

    public abstract ElementKind getKind();

    @Override
    public abstract String getSourceName();

    public abstract int getArity();

    public abstract boolean isVariableArity();

    public abstract boolean isFixedArity();

    public abstract TypeName[] getParameters();

    public int getParametersLength(TypeName[] parameters, boolean varargs) {
        if (parameters.length == 0) {
            return 2;
        }
        int length = 2 + parameters.length - 1;
        for (int i = 0; i < parameters.length; ++i) {
            length += parameters[i].getQualifiedNameLength();
        }
        if (varargs) {
            ++length;
        }
        return length;
    }

    @Override
    public void writeQualifiedSourceName(Writer writer) throws IOException {
        this.parent.writeQualifiedSourceName(writer);
        writer.write(46);
        this.writeSourceName(writer);
    }

    protected final StringBuilder appendSourceParameters(StringBuilder builder, TypeName[] parameters, boolean varargs) {
        builder.append('(');
        int last = parameters.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            if (!varargs || i != last) {
                parameters[i].appendQualifiedSourceName(builder);
                continue;
            }
            parameters[i].getComponentType().appendQualifiedSourceName(builder).append("...");
        }
        builder.append(')');
        return builder;
    }

    protected final void writeSourceParameters(Writer writer, TypeName[] parameters, boolean varargs) throws IOException {
        writer.write(40);
        int last = parameters.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (i > 0) {
                writer.write(44);
            }
            TypeName parameterTypeName = parameters[i];
            if (!varargs || i != last) {
                parameterTypeName.writeQualifiedSourceName(writer);
                continue;
            }
            parameterTypeName.getComponentType().writeQualifiedSourceName(writer);
            writer.write("...");
        }
        writer.write(41);
    }

    protected final StringBuilder appendBinaryParameters(StringBuilder builder, TypeName[] parameters, boolean varargs) {
        builder.append('(');
        int last = parameters.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            if (!varargs || i != last) {
                parameters[i].appendQualifiedBinaryName(builder);
                continue;
            }
            parameters[i].getComponentType().appendQualifiedBinaryName(builder).append("...");
        }
        builder.append(')');
        return builder;
    }

    public int getHybridParametersLength(TypeName[] parameters, boolean varargs) {
        if (parameters.length == 0) {
            return 2;
        }
        int length = 2 + parameters.length - 1;
        for (int i = 0; i < parameters.length; ++i) {
            length += parameters[i].getQualifiedHybridNameLength();
        }
        if (varargs) {
            ++length;
        }
        return length;
    }

    protected final StringBuilder appendHybridParameters(StringBuilder builder, TypeName[] parameters, boolean varargs) {
        builder.append('(');
        int last = parameters.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            if (!varargs || i != last) {
                parameters[i].appendQualifiedHybridName(builder);
                continue;
            }
            parameters[i].getComponentType().appendQualifiedHybridName(builder).append("...");
        }
        builder.append(')');
        return builder;
    }

    public abstract void writeHybridName(Writer var1) throws IOException;

    @Override
    public void writeQualifiedHybridName(Writer writer) throws IOException {
        this.parent.writeQualifiedHybridNamePrefix(writer);
        this.writeHybridName(writer);
    }

    protected final void writeHybridParameters(Writer writer, TypeName[] parameters, boolean varargs) throws IOException {
        writer.write(40);
        int last = parameters.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (i > 0) {
                writer.write(44);
            }
            TypeName parameterTypeName = parameters[i];
            if (!varargs || i != last) {
                parameterTypeName.writeQualifiedHybridName(writer);
                continue;
            }
            parameterTypeName.getComponentType().writeQualifiedHybridName(writer);
            writer.write("...");
        }
        writer.write(41);
    }

    @Override
    public final int compareTo(ElementName that) {
        switch (that.getLevel()) {
            case 0: {
                int comparison = this.getPackage().compareTo(that.getPackage());
                return comparison != 0 ? comparison : 1;
            }
            case 1: {
                int comparison = this.parent.compareTo(that);
                return comparison != 0 ? comparison : 1;
            }
            case 2: {
                int comparison = this.parent.compareTo(((MemberName)that).parent);
                return comparison != 0 ? comparison : this.compareToUnqualified((MemberName)that);
            }
        }
        throw new IllegalStateException("illegal level " + that.getLevel() + " in " + that);
    }

    @Override
    public final int compareTo(MemberName that) {
        int comparison = this.getType().compareTo(that.getType());
        return comparison != 0 ? comparison : this.compareToUnqualified(that);
    }

    public abstract int compareToUnqualified(MemberName var1);

    protected final int compareParameters(TypeName[] thisParameters, TypeName[] thatParameters, boolean thisVarargs, boolean thatVarargs) {
        if (thisParameters.length + thatParameters.length == 0) {
            return 0;
        }
        for (int i = 0; i < Math.min(thisParameters.length, thatParameters.length); ++i) {
            int comparison = this.compareParameter(thisParameters[i], thatParameters[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        int comparison = thisParameters.length - thatParameters.length;
        if (comparison != 0) {
            comparison = comparison < 0 ? Character.compare(')', ',') : Character.compare(',', ')');
        }
        return comparison;
    }

    private int compareParameter(TypeName left, TypeName right) {
        if (left == right) {
            return 0;
        }
        PackageName leftPackage = left.getPackage();
        PackageName rightPackage = right.getPackage();
        if (leftPackage.isDefault()) {
            if (rightPackage.isDefault()) {
                return left.getBinaryName().compareTo(right.getBinaryName());
            }
            int comparison = left.getBinaryName().compareTo(rightPackage.getBinaryName());
            return comparison != 0 ? comparison : -1;
        }
        if (rightPackage.isDefault()) {
            int comparison = leftPackage.getBinaryName().compareTo(right.getBinaryName());
            return comparison != 0 ? comparison : 1;
        }
        return left.compareTo(right);
    }
}

