/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.exports.name.ArrayTypeName;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.IllegalNameException;
import oracle.javatools.exports.name.InnerTypeName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;

public class NameSpace {
    private static final NameSpace DEFAULT_NAME_FACTORY = new NameSpace();
    private final Map<String, String> identifiers = new HashMap<String, String>();
    private final Map<String, PackageName> packages = new HashMap<String, PackageName>();
    private final Map<String, List<TypeName>> types = new HashMap<String, List<TypeName>>();
    private final TypeName[] parameters = new TypeName[256];
    private static final Map<TypeName, TypeName[][]> typeNameArrayPool = new HashMap<TypeName, TypeName[][]>();
    private static final char SENTINEL = '\uffff';
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] VOID = "void".toCharArray();
    private static final String JAVA_LANG = PackageName.JAVA_LANG.getSourceName();

    public static NameSpace defaultNameSpace() {
        return DEFAULT_NAME_FACTORY;
    }

    public NameSpace() {
        for (PackageName packageName : PackageName.INITIAL_PACKAGES) {
            this.packages.put(packageName.getSourceName(), packageName);
        }
        for (ElementName elementName : TypeName.INITIAL_TYPES) {
            this.types.put(((TypeName)elementName).getSourceName(), Collections.singletonList(elementName));
        }
    }

    private synchronized String simpleIdentifier(String identifier) {
        if ((identifier = identifier.trim()).isEmpty()) {
            throw new IllegalNameException("identifier", "END-OF-NAME", identifier);
        }
        String predecessor = this.identifiers.get(identifier);
        if (predecessor != null) {
            return predecessor;
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            throw new IllegalNameException("identifier", 0, identifier);
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (Character.isJavaIdentifierPart(identifier.charAt(i))) continue;
            throw new IllegalNameException("identifier character or END-OF-NAME", i, identifier);
        }
        this.identifiers.put(identifier, identifier);
        return identifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized PackageName packageNameSource(String name) {
        PackageName predecessor = this.packages.get(name);
        if (predecessor != null) {
            return predecessor;
        }
        boolean S0 = false;
        boolean S1 = true;
        int P0 = 2;
        int F = 3;
        int state = 0;
        int offset = 0;
        int endOffset = name.length();
        StringBuilder builder = null;
        int packageEnd = 0;
        int index = 0;
        block6: while (true) {
            char c = index == endOffset ? (char)'\uffff' : (char)name.charAt(index);
            switch (state) {
                case 0: {
                    if (Character.isJavaIdentifierStart(c)) {
                        offset = index;
                        state = 2;
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    if (c == '\uffff') {
                        return PackageName.DEFAULT_PACKAGE;
                    }
                    throw new IllegalNameException("identifier or END-OF-NAME", 0, name);
                }
                case 1: {
                    if (Character.isJavaIdentifierStart(c)) {
                        if (builder != null) {
                            builder.append(c);
                        }
                        state = 2;
                        break;
                    }
                    if (!Character.isWhitespace(c)) {
                        throw new IllegalNameException("identifier", 0, name);
                    }
                    if (builder != null) break;
                    builder = new StringBuilder(endOffset).append(name, offset, index);
                    break;
                }
                case 2: {
                    if (Character.isJavaIdentifierPart(c)) {
                        if (builder == null) break;
                        builder.append(c);
                        break;
                    }
                    if (c == '.') {
                        if (builder != null) {
                            builder.append(c);
                        }
                        state = 1;
                        break;
                    }
                    if (c == '/') {
                        if (builder == null) {
                            builder = new StringBuilder(endOffset).append(name, offset, index);
                        }
                        builder.append('.');
                        state = 1;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        packageEnd = index;
                        state = 3;
                        break;
                    }
                    if (c != '\uffff') {
                        throw new IllegalNameException("identifier character, '.', or END-OF-NAME", index, name);
                    }
                    packageEnd = index;
                    break block6;
                }
                case 3: {
                    if (c == '.' || c == '/') {
                        if (builder == null) {
                            builder = new StringBuilder(endOffset).append(name, offset, index);
                        }
                        builder.append('.');
                        state = 1;
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    if (c == '\uffff') break block6;
                    throw new IllegalNameException("'.' or END-OF-NAME", index, name);
                }
            }
            ++index;
        }
        name = builder == null ? name.substring(offset, packageEnd) : builder.toString();
        name = this.identifiers.computeIfAbsent(name, k -> k);
        return this.packages.computeIfAbsent(name, k -> new PackageName((String)k));
    }

    public PackageName packageNameHybrid(String name) {
        return this.packageNameHybrid(name, 0, name.length(), null);
    }

    public PackageName packageNameHybrid(String string, int offset, int endOffset) {
        return this.packageNameHybrid(string, offset, endOffset, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TypeName typeNameSource(PackageName packag, String name) {
        int SENTINEL = 65535;
        StringBuilder builder = null;
        State state = State.S0;
        int offset = 0;
        int endOffset = name.length();
        boolean dot = false;
        boolean dollar = false;
        int depth = 0;
        TypeName typeName = null;
        block9: for (int index = 0; index <= endOffset; ++index) {
            char c = index == endOffset ? (char)'\uffff' : (char)name.charAt(index);
            switch (state) {
                case S0: {
                    assert (typeName == null);
                    assert (builder == null);
                    if (Character.isJavaIdentifierStart(c)) {
                        offset = index;
                        state = State.P;
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    throw new IllegalNameException("identifier", index, name);
                }
                case S1: {
                    assert (typeName != null);
                    if (Character.isJavaIdentifierStart(c)) {
                        if (builder != null) {
                            builder.append(c);
                        }
                        state = State.P;
                        break;
                    }
                    if (!Character.isWhitespace(c)) {
                        throw new IllegalNameException("identifier", index, name);
                    }
                    if (builder != null) break;
                    builder = new StringBuilder(name.length()).append(name, offset, index);
                    break;
                }
                case P: {
                    NameFormat format;
                    if (Character.isJavaIdentifierPart(c)) {
                        if (builder != null) {
                            builder.append(c);
                        }
                        if (c != 36) break;
                        dollar = true;
                        break;
                    }
                    if (c == '.') {
                        typeName = this.typeNameGetOrCreate(packag, typeName, NameFormat.HYBRID, builder == null ? name.substring(offset, index) : builder.toString());
                        state = State.S1;
                        break;
                    }
                    if (c == '<') {
                        assert (depth == 0);
                        format = typeName == null && dollar ? NameFormat.BINARY : NameFormat.HYBRID;
                        typeName = this.typeNameGetOrCreate(packag, typeName, format, builder == null ? name.substring(offset, index) : builder.toString());
                        ++depth;
                        state = State.G0;
                        break;
                    }
                    if (c == '[') {
                        format = typeName == null && dollar ? NameFormat.BINARY : NameFormat.HYBRID;
                        typeName = this.typeNameGetOrCreate(packag, typeName, format, builder == null ? name.substring(offset, index) : builder.toString());
                        state = State.A2;
                        break;
                    }
                    if (c == '\uffff') {
                        format = typeName == null && dollar ? NameFormat.BINARY : NameFormat.HYBRID;
                        typeName = this.typeNameGetOrCreate(packag, typeName, format, builder == null ? name.substring(offset, index) : builder.toString());
                        break block9;
                    }
                    if (!Character.isWhitespace(c)) {
                        throw new IllegalNameException("identifier character, '.', '<', '[', or END-OF-NAME", index, name);
                    }
                    state = State.X;
                    break;
                }
                case X: {
                    NameFormat format;
                    assert (builder != null);
                    if (c == '.') {
                        typeName = this.typeNameGetOrCreate(packag, typeName, NameFormat.HYBRID, builder == null ? name.substring(offset, index) : builder.toString());
                        builder.append('.');
                        state = State.S1;
                        break;
                    }
                    if (c == '<') {
                        format = typeName == null && dollar ? NameFormat.BINARY : NameFormat.HYBRID;
                        typeName = this.typeNameGetOrCreate(packag, typeName, format, builder == null ? name.substring(offset, index) : builder.toString());
                        ++depth;
                        state = State.G0;
                        break;
                    }
                    if (c == '[') {
                        format = typeName == null && dollar ? NameFormat.BINARY : NameFormat.HYBRID;
                        typeName = this.typeNameGetOrCreate(packag, typeName, format, builder == null ? name.substring(offset, index) : builder.toString());
                        state = State.A2;
                        break;
                    }
                    if (c == '\uffff') {
                        format = typeName == null && dollar ? NameFormat.BINARY : NameFormat.HYBRID;
                        typeName = this.typeNameGetOrCreate(packag, typeName, format, builder == null ? name.substring(offset, index) : builder.toString());
                        break block9;
                    }
                    if (Character.isWhitespace(c)) break;
                    throw new IllegalNameException("identifier character, '.', '<', '[', or END-OF-NAME", index, name);
                }
                case G0: {
                    assert (builder != null);
                    assert (depth > 0);
                    if (c == '<') {
                        ++depth;
                        break;
                    }
                    if (c == '>') {
                        if (--depth != 0) break;
                        state = State.A0;
                        break;
                    }
                    if (c != '\uffff') break;
                    throw new IllegalNameException("matching '>'", index, name, offset, endOffset);
                }
                case A0: {
                    if (c == '[') {
                        state = State.A2;
                        break;
                    }
                    if (c == '\uffff') break block9;
                    if (Character.isWhitespace(c)) break;
                    throw new IllegalNameException("'[' or END-OF-NAME", index, name, offset, endOffset);
                }
                case A2: {
                    if (c == ']') {
                        typeName = this.arrayNameGetOrCreate(typeName);
                        state = State.A0;
                        break;
                    }
                    if (Character.isWhitespace(c)) break;
                    throw new IllegalNameException("']'", index, name);
                }
            }
        }
        assert (typeName != null);
        return typeName;
    }

    public TypeName typeNameBinary(String name) {
        return this.typeNameBinary(name, 0, name.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized TypeName typeNameBinary(String string, int offset, int endOffset) {
        TypeName typeName;
        PackageName packageName;
        NameFormat format;
        if (endOffset - offset == 16 && string.regionMatches(offset, "java/lang/", 0, 10)) {
            switch (string.charAt(offset + 10)) {
                case 'O': {
                    if (!string.regionMatches(offset + 11, "bject", 0, 5)) break;
                    return TypeName.JAVA_LANG_OBJECT;
                }
                case 'S': {
                    if (!string.regionMatches(offset + 11, "tring", 0, 5)) break;
                    return TypeName.JAVA_LANG_STRING;
                }
            }
        }
        int SENTINEL = 65535;
        StringBuilder builder = null;
        State state = State.S0;
        int array = 0;
        int typeBegin = 0;
        int typeEnd = 0;
        int dollar = 0;
        block11: for (int index = offset; index <= endOffset; ++index) {
            char c = index == endOffset ? (char)'\uffff' : (char)string.charAt(index);
            switch (state) {
                case S0: {
                    assert (builder == null);
                    if (!Character.isJavaIdentifierStart(c)) {
                        throw new IllegalNameException("identifier", index, string);
                    }
                    typeBegin = index - offset;
                    state = State.P;
                    break;
                }
                case S1: {
                    assert (builder != null);
                    if (!Character.isJavaIdentifierStart(c)) {
                        throw new IllegalNameException("identifier", index, string);
                    }
                    builder.append(c);
                    typeBegin = index - offset;
                    state = State.P;
                    break;
                }
                case P: {
                    if (Character.isJavaIdentifierPart(c)) {
                        if (builder != null) {
                            builder.append(c);
                        }
                        if (c != 36) break;
                        dollar = index - offset;
                        break;
                    }
                    if (c == '/') {
                        if (builder == null) {
                            builder = new StringBuilder(string.length()).append(string, offset, index);
                        }
                        builder.append('.');
                        state = State.S1;
                        break;
                    }
                    if (c == '[') {
                        typeEnd = index;
                        state = State.A0;
                        break;
                    }
                    if (c != '\uffff') {
                        throw new IllegalNameException("identifier character, '/', '[', or END-OF-NAME", index, string);
                    }
                    typeEnd = index;
                    break block11;
                }
                case A0: {
                    if (c != ']') {
                        throw new IllegalNameException("']'", index, string, offset, endOffset);
                    }
                    ++array;
                    state = State.A2;
                    break;
                }
                case A2: {
                    if (c == '[') {
                        state = State.A0;
                        break;
                    }
                    if (c == '\uffff') break block11;
                    throw new IllegalNameException("'[' or END-OF-NAME", index, string, offset, endOffset);
                }
            }
        }
        NameFormat nameFormat = format = dollar > 0 ? NameFormat.BINARY : NameFormat.HYBRID;
        if (builder == null) {
            packageName = this.packageNameGetOrCreate(string, offset, offset + Math.max(typeBegin - 1, 0));
            typeName = this.typeNameGetOrCreate(packageName, null, format, string.substring(offset + typeBegin, typeEnd));
        } else {
            packageName = this.packageNameGetOrCreate(builder, 0, Math.max(typeBegin - 1, 0));
            typeName = this.typeNameGetOrCreate(packageName, null, format, builder.substring(typeBegin));
        }
        while (--array >= 0) {
            typeName = this.arrayNameGetOrCreate(typeName);
        }
        return typeName;
    }

    public TypeName typeNameHybrid(PackageName packageName, String string) {
        return this.typeNameHybrid(packageName, string, 0, string.length(), false, null);
    }

    public TypeName typeNameHybrid(String string) {
        return this.typeNameHybrid(string, 0, string.length());
    }

    public TypeName typeNameHybrid(String string, int offset, int endOffset) {
        return this.typeNameHybrid(null, string, offset, endOffset, false, null);
    }

    public TypeName familyName(TypeName typeName) {
        String familyName = typeName.getFamilyName();
        if (familyName == null) {
            return typeName;
        }
        return this.typeNameGetOrCreate(typeName.getPackage(), typeName.getOuterType(), typeName.getFormat(), familyName);
    }

    public synchronized MemberName memberNameHybrid(TypeName type, String name) {
        return this.memberNameHybrid(type, name, 0, name.length(), null);
    }

    public MemberName memberNameHybrid(String string) {
        return this.memberNameHybrid(string, 0, string.length());
    }

    public MemberName memberNameHybrid(String string, int offset, int endOffset) {
        Parse status = new Parse();
        TypeName typeName = this.typeNameHybrid(null, string, offset, endOffset, false, status);
        return this.memberNameHybrid(typeName, string, status.next, endOffset, null);
    }

    public ConstructorName constructorName(TypeName typeName, TypeName[] parameters, boolean varargs) {
        return new ConstructorName(typeName, this.typeNames(parameters), varargs);
    }

    public synchronized ConstructorName constructorNameSource(TypeName type, String name) {
        return (ConstructorName)this.methodOrConstructorSource(type, name, 0, name.length(), MethodOrConstructorCreator.CONSTRUCTOR_CREATOR);
    }

    public ConstructorName constructorNameHybrid(TypeName type, String name) {
        return this.constructorNameHybrid(type, name, 0, name.length(), null);
    }

    public ConstructorName constructorNameHybrid(String name) {
        return this.constructorNameHybrid(name, 0, name.length());
    }

    public ConstructorName constructorNameHybrid(String string, int offset, int endOffset) {
        Parse status = new Parse();
        TypeName typeName = this.typeNameHybrid(null, string, offset, endOffset, false, status);
        return this.constructorNameHybrid(typeName, string, status.next, endOffset, null);
    }

    public synchronized MethodName methodName(TypeName parent, String simpleMethodName, TypeName[] parameters, boolean varargs) {
        return new MethodName(parent, this.simpleIdentifier(simpleMethodName), this.typeNames(parameters), varargs);
    }

    public synchronized MethodName methodName(TypeName parent, String simpleMethodName, TypeName[] parameterBuffer, int parameterCount, boolean varargs) {
        return new MethodName(parent, this.simpleIdentifier(simpleMethodName), this.typeNames(parameterBuffer, parameterCount), varargs);
    }

    public synchronized MethodName methodNameSource(TypeName type, String name) {
        return (MethodName)this.methodOrConstructorSource(type, name, 0, name.length(), MethodOrConstructorCreator.METHOD_CREATOR);
    }

    public MethodName methodNameHybrid(TypeName type, String name) {
        return this.methodNameHybrid(type, name, 0, name.length(), null);
    }

    public MethodName methodNameHybrid(String name) {
        return this.methodNameHybrid(name, 0, name.length());
    }

    public MethodName methodNameHybrid(String string, int offset, int endOffset) {
        Parse status = new Parse();
        TypeName typeName = this.typeNameHybrid(null, string, offset, endOffset, false, status);
        return this.methodNameHybrid(typeName, string, status.next, endOffset, null);
    }

    public synchronized FieldName fieldName(TypeName type, String name) {
        return new FieldName(type, this.simpleIdentifier(name));
    }

    public FieldName fieldNameHybrid(String string) {
        return this.fieldNameHybrid(string, 0, string.length());
    }

    public FieldName fieldNameHybrid(String string, int offset, int endOffset) {
        Parse status = new Parse();
        TypeName typeName = this.typeNameHybrid(null, string, offset, endOffset, false, status);
        return this.fieldNameHybrid(typeName, string, status.next, endOffset, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T extends MemberName> T methodOrConstructorSource(TypeName typeName, String name, int offset, int endOffset, MethodOrConstructorCreator creator) {
        State state;
        int SENTINEL = 65535;
        String methodName = null;
        int parameterCount = 0;
        boolean varargs = false;
        switch (creator) {
            case CONSTRUCTOR_CREATOR: {
                state = State.CS0;
                break;
            }
            case METHOD_CREATOR: {
                state = State.MS;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int index = offset;
        while (state != State.DONE) {
            String parameterName;
            PackageName parameterPackage;
            offset = index;
            int typeBegin = 0;
            int typeEnd = 0;
            int packageSegments = 0;
            int depth = 0;
            int array = 0;
            StringBuilder builder = null;
            block31: while (index <= endOffset) {
                char c = index == endOffset ? (char)'\uffff' : (char)name.charAt(index);
                switch (state) {
                    case CS0: {
                        if (Character.isJavaIdentifierStart(c)) {
                            offset = index;
                            state = State.CP;
                            break;
                        }
                        if (c == '(') {
                            if (typeName == null) {
                                throw new IllegalNameException("identifier", index, name, offset, endOffset);
                            }
                            state = State.S0;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("identifier or '('", index, name, offset, endOffset);
                        break;
                    }
                    case CS1: {
                        if (Character.isJavaIdentifierStart(c)) {
                            offset = index;
                            state = State.CP;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("identifier", index, name, offset, endOffset);
                        break;
                    }
                    case CP: {
                        if (Character.isJavaIdentifierPart(c) || Character.isWhitespace(c)) break;
                        if (c == '.') {
                            state = State.CS1;
                            break;
                        }
                        if (c != 40) throw new IllegalNameException("identifier character, '.', or '('", index, name, offset, endOffset);
                        state = State.S0;
                        break;
                    }
                    case MS: {
                        if (Character.isJavaIdentifierStart(c)) {
                            offset = index;
                            state = State.MP0;
                            break;
                        }
                        if (Character.isWhitespace(c)) break;
                        if (c != 60) throw new IllegalNameException("identifier or '<'", index, name, offset, endOffset);
                        ++depth;
                        state = State.MG0;
                        break;
                    }
                    case MG0: {
                        if (c == '>') {
                            if (--depth != 0) break;
                            state = State.MG1;
                            break;
                        }
                        if (c == '<') {
                            ++depth;
                            break;
                        }
                        if (c == 65535) throw new IllegalNameException("matching '>'", index, name, offset, endOffset);
                        break;
                    }
                    case MG1: {
                        if (Character.isJavaIdentifierStart(c)) {
                            offset = index;
                            state = State.MP0;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("identifier", index, name, offset, endOffset);
                        break;
                    }
                    case MP0: {
                        if (Character.isJavaIdentifierPart(c)) break;
                        if (c == '(') {
                            methodName = this.identifiers.computeIfAbsent(name.substring(offset, index), k -> k);
                            state = State.S0;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("identifier character or '('", index, name, offset, endOffset);
                        methodName = this.identifiers.computeIfAbsent(name.substring(offset, index), k -> k);
                        state = State.MP1;
                        break;
                    }
                    case MP1: {
                        if (c == '(') {
                            state = State.S0;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("'('", index, name, offset, endOffset);
                        break;
                    }
                    case S0: {
                        String string;
                        assert (builder == null);
                        if (Character.isJavaIdentifierStart(c)) {
                            offset = index;
                            ++typeEnd;
                            state = State.P;
                            break;
                        }
                        if (Character.isWhitespace(c)) break;
                        if (c == ')' && parameterCount == 0) {
                            return creator.create(typeName, methodName, this.typeNames(this.parameters, parameterCount), varargs);
                        }
                        if (parameterCount == 0) {
                            string = "identifier or ')'";
                            throw new IllegalNameException(string, index, name, offset, endOffset);
                        }
                        string = "identifier";
                        throw new IllegalNameException(string, index, name, offset, endOffset);
                    }
                    case S1: {
                        if (Character.isJavaIdentifierStart(c)) {
                            if (builder == null) {
                                typeBegin = index - offset;
                                ++typeEnd;
                            } else {
                                typeBegin = builder.length();
                                builder.append(c);
                            }
                            ++packageSegments;
                            state = State.P;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("identifier", index, name, offset, endOffset);
                        if (builder != null) break;
                        builder = new StringBuilder(endOffset - offset).append(name, offset, index);
                        break;
                    }
                    case P: {
                        if (Character.isJavaIdentifierPart(c)) {
                            if (builder != null) {
                                builder.append(c);
                                break;
                            }
                            ++typeEnd;
                            break;
                        }
                        if (c == '.') {
                            state = State.SV;
                            break;
                        }
                        if (Character.isWhitespace(c)) {
                            if (builder == null) {
                                builder = new StringBuilder(endOffset - offset).append(name, offset, index);
                            }
                            state = State.X;
                            break;
                        }
                        if (c == '<') {
                            ++depth;
                            state = State.G0;
                            break;
                        }
                        if (c == '[') {
                            state = State.A2;
                            break;
                        }
                        if (c == ',') {
                            state = State.S0;
                            ++index;
                            break block31;
                        }
                        if (c != 41) throw new IllegalNameException("identifier character, '.', '<', '[', ',', or ')'", index, name, offset, endOffset);
                        state = State.DONE;
                        break;
                    }
                    case X: {
                        assert (builder != null);
                        if (Character.isJavaIdentifierPart(c)) {
                            if (!Character.isJavaIdentifierStart(c)) {
                                throw new IllegalNameException("'<', '[', '.', ',', or ')'", index, name, offset, endOffset);
                            }
                            state = State.X0;
                            break;
                        }
                        if (c == '.') {
                            state = State.SV;
                            break;
                        }
                        if (Character.isWhitespace(c)) break;
                        if (c == '<') {
                            ++depth;
                            state = State.G0;
                            break;
                        }
                        if (c == '[') {
                            state = State.A2;
                            break;
                        }
                        if (c == ',') {
                            state = State.S0;
                            ++index;
                            break block31;
                        }
                        if (c != 41) throw new IllegalNameException("'<', '[', '.', ',', or ')'", index, name, offset, endOffset);
                        state = State.DONE;
                        break;
                    }
                    case SV: {
                        if (Character.isJavaIdentifierStart(c)) {
                            if (builder == null) {
                                typeBegin = index - offset;
                                typeEnd += 2;
                            } else {
                                builder.append('.');
                                typeBegin = builder.length();
                                builder.append(c);
                            }
                            ++packageSegments;
                            state = State.P;
                            break;
                        }
                        if (c == '.') {
                            state = State.V1;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("identifier character or '.'", index + 1, name, offset, endOffset);
                        if (builder == null) {
                            builder = new StringBuilder(endOffset - offset).append(name, offset, index);
                        }
                        builder.append('.');
                        state = State.S1;
                        break;
                    }
                    case G0: {
                        if (c == '>') {
                            if (--depth != 0) break;
                            state = State.A0;
                            break;
                        }
                        if (c == '<') {
                            ++depth;
                            break;
                        }
                        if (c == 65535) throw new IllegalNameException("matching '>'", index, name, offset, endOffset);
                        break;
                    }
                    case A0: {
                        if (c == ',') {
                            state = State.S0;
                            ++index;
                            break block31;
                        }
                        if (c == ')') {
                            state = State.DONE;
                            break;
                        }
                        if (Character.isWhitespace(c)) {
                            state = State.A1;
                            break;
                        }
                        if (c == '[') {
                            state = State.A2;
                            break;
                        }
                        if (c != 46) throw new IllegalNameException("\"[]\", \"...\", ',', or ')'", index, name, offset, endOffset);
                        state = State.V0;
                        break;
                    }
                    case A1: {
                        if (c == ',') {
                            state = State.S0;
                            ++index;
                            break block31;
                        }
                        if (c == ')') {
                            state = State.DONE;
                            break;
                        }
                        if (Character.isJavaIdentifierStart(c)) {
                            state = State.X0;
                            break;
                        }
                        if (c == '[') {
                            state = State.A2;
                            break;
                        }
                        if (c == '.') {
                            state = State.V0;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("\"[]\", \"...\", ',', or ')'", index, name, offset, endOffset);
                        break;
                    }
                    case A2: {
                        if (c == ']') {
                            ++array;
                            state = State.A0;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("']'", index, name, offset, endOffset);
                        break;
                    }
                    case V0: {
                        if (c != 46) throw new IllegalNameException("\"...\"", index - 1, index + 2, name, offset, endOffset);
                        state = State.V1;
                        break;
                    }
                    case V1: {
                        if (c != 46) throw new IllegalNameException("\"...\"", index - 2, index + 1, name, offset, endOffset);
                        ++array;
                        varargs = true;
                        state = State.V2;
                        break;
                    }
                    case V2: {
                        if (c == ')') {
                            state = State.DONE;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("')'", index, name, offset, endOffset);
                        state = State.V3;
                        break;
                    }
                    case V3: {
                        if (c == ')') {
                            state = State.DONE;
                            break;
                        }
                        if (Character.isWhitespace(c)) break;
                        if (!Character.isJavaIdentifierStart(c)) throw new IllegalNameException("')'", index, name, offset, endOffset);
                        state = State.X0;
                        break;
                    }
                    case X0: {
                        if (c == ',' && !varargs) {
                            state = State.S0;
                            ++index;
                            break block31;
                        }
                        if (c == ')') {
                            state = State.DONE;
                            break;
                        }
                        if (Character.isJavaIdentifierPart(c)) break;
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("',' or ')'", index + 1, name, offset, endOffset);
                        state = State.X1;
                        break;
                    }
                    case X1: {
                        if (c == ',' && !varargs) {
                            state = State.S0;
                            ++index;
                            break block31;
                        }
                        if (c == ')') {
                            state = State.DONE;
                            break;
                        }
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("',' or ')'", index + 1, name, offset, endOffset);
                        break;
                    }
                    case DONE: {
                        if (c == '\uffff') break block31;
                        if (!Character.isWhitespace(c)) throw new IllegalNameException("END-OF-NAME", index, name, offset, endOffset);
                    }
                }
                ++index;
            }
            assert (state == State.S0 || state == State.DONE) : "unexpected state " + (Object)((Object)state);
            if (builder == null) {
                parameterPackage = this.packageNameGetOrCreate(name, offset, offset + Math.max(typeBegin - 1, 0));
                parameterName = name.substring(offset + typeBegin, offset + typeEnd);
            } else {
                parameterPackage = this.packageNameGetOrCreate(builder, 0, Math.max(typeBegin - 1, 0));
                parameterName = builder.substring(typeBegin);
            }
            TypeName parameterType = this.typeNameGetOrCreate(parameterPackage, null, packageSegments <= 1 ? NameFormat.HYBRID : NameFormat.SOURCE, parameterName);
            while (--array >= 0) {
                parameterType = this.arrayNameGetOrCreate(parameterType);
            }
            this.parameters[parameterCount] = parameterType;
            ++parameterCount;
        }
        return creator.create(typeName, methodName, this.typeNames(this.parameters, parameterCount), varargs);
    }

    private PackageName packageNameHybrid(String string, int offset, int endOffset, Parse status) {
        PackageState state = PackageState.PS;
        int index = offset;
        while (true) {
            char c = index == endOffset ? (char)'\uffff' : (char)string.charAt(index);
            switch (state) {
                case PS: {
                    if (Character.isJavaIdentifierStart(c)) {
                        state = PackageState.PP;
                        break;
                    }
                    if (c == '\uffff' && status == null && index == offset) {
                        return PackageName.DEFAULT_PACKAGE;
                    }
                    if (c == '/' && status != null && index == offset) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return PackageName.DEFAULT_PACKAGE;
                    }
                    throw new IllegalNameException("identifier", index, string, offset, endOffset);
                }
                case PP: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    if (c == '.') {
                        state = PackageState.PS;
                        break;
                    }
                    if (c == '\uffff' && status == null) {
                        return this.packageNameGetOrCreate(string, offset, index);
                    }
                    if (c == '/' && status != null) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return this.packageNameGetOrCreate(string, offset, index);
                    }
                    String terminator = status == null ? "END-OF-NAME" : "'/'";
                    throw new IllegalNameException("identifier or " + terminator, index, string, offset, endOffset);
                }
                default: {
                    throw new IllegalStateException("unexpected state " + (Object)((Object)state));
                }
            }
            ++index;
        }
    }

    private TypeName typeNameHybrid(PackageName packageName, String string, int offset, int endOffset, boolean parameter, Parse status) {
        TypeState state;
        if (parameter && status == null) {
            throw new IllegalStateException("parameter true requires non-null status");
        }
        if (packageName == PackageName.JAVA_LANG) {
            if (endOffset - offset == 6) {
                switch (string.charAt(offset)) {
                    case 'O': {
                        if (!string.regionMatches(offset + 1, "bject", 0, 5)) break;
                        return TypeName.JAVA_LANG_OBJECT;
                    }
                    case 'S': {
                        if (!string.regionMatches(offset + 1, "tring", 0, 5)) break;
                        return TypeName.JAVA_LANG_STRING;
                    }
                }
            }
            state = TypeState.TS;
        } else {
            state = packageName != null ? TypeState.TS : TypeState.PS0;
        }
        char[] match = null;
        TypeName typeName = null;
        int index = offset;
        while (true) {
            char c = index == endOffset ? (char)'\uffff' : (char)string.charAt(index);
            block4 : switch (state) {
                case PS0: {
                    assert (typeName == null);
                    if (Character.isJavaIdentifierStart(c)) {
                        switch (c) {
                            case 'b': {
                                state = TypeState.PPMATCHB;
                                break block4;
                            }
                            case 'c': {
                                state = TypeState.PPMATCH;
                                match = CHAR;
                                typeName = TypeName.CHAR;
                                break block4;
                            }
                            case 'd': {
                                state = TypeState.PPMATCH;
                                match = DOUBLE;
                                typeName = TypeName.DOUBLE;
                                break block4;
                            }
                            case 'f': {
                                state = TypeState.PPMATCH;
                                match = FLOAT;
                                typeName = TypeName.FLOAT;
                                break block4;
                            }
                            case 'i': {
                                state = TypeState.PPMATCH;
                                match = INT;
                                typeName = TypeName.INT;
                                break block4;
                            }
                            case 'l': {
                                state = TypeState.PPMATCH;
                                match = LONG;
                                typeName = TypeName.LONG;
                                break block4;
                            }
                            case 's': {
                                state = TypeState.PPMATCH;
                                match = SHORT;
                                typeName = TypeName.SHORT;
                                break block4;
                            }
                            case 'v': {
                                state = TypeState.PPMATCH;
                                match = VOID;
                                typeName = TypeName.VOID;
                                break block4;
                            }
                        }
                        state = TypeState.PP;
                        break;
                    }
                    if (c == '/') {
                        packageName = PackageName.DEFAULT_PACKAGE;
                        state = TypeState.TS;
                        break;
                    }
                    throw new IllegalNameException("identifier or '/'", index, string, offset, endOffset);
                }
                case PS1: {
                    assert (typeName == null);
                    if (Character.isJavaIdentifierStart(c)) {
                        state = TypeState.PP;
                        break;
                    }
                    throw new IllegalNameException("identifier", index, string, offset, endOffset);
                }
                case PPMATCHB: {
                    assert (typeName == null);
                    if (c == 'o') {
                        state = TypeState.PPMATCH;
                        match = BOOLEAN;
                        typeName = TypeName.BOOLEAN;
                        break;
                    }
                    state = TypeState.PPMATCH;
                    match = BYTE;
                    typeName = TypeName.BYTE;
                }
                case PPMATCH: {
                    assert (typeName != null);
                    int i = index - offset;
                    if (c == match[i]) {
                        if (i + 1 == match.length) {
                            state = TypeState.PPMATCHED;
                        }
                        break;
                    }
                    state = TypeState.PP;
                    match = null;
                    typeName = null;
                }
                case PP: {
                    assert (typeName == null);
                    if (Character.isJavaIdentifierPart(c)) break;
                    if (c == '.') {
                        state = TypeState.PS1;
                        break;
                    }
                    if (c == '/') {
                        packageName = this.packageNameGetOrCreate(string, offset, index);
                        state = TypeState.TS;
                        break;
                    }
                    throw new IllegalNameException("identifier character, '.', or '/'", index, string, offset, endOffset);
                }
                case PPMATCHED: {
                    assert (typeName != null);
                    if (Character.isJavaIdentifierPart(c)) {
                        match = null;
                        typeName = null;
                        state = TypeState.PP;
                        break;
                    }
                    if (c == '[') {
                        state = TypeState.TA0;
                        break;
                    }
                    if (c == '.' && parameter) {
                        state = TypeState.TV1;
                        break;
                    }
                    if (c == '\uffff' && status == null) {
                        return typeName;
                    }
                    if (c == '/' && status != null && !parameter) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return typeName;
                    }
                    if ((c == ',' || c == ')') & parameter) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return typeName;
                    }
                    String expected = "identifier character, '[', ";
                    expected = expected + (status == null ? "or END-OF-NAME" : (parameter ? "'.', ',', or ')'" : "or '/'"));
                    throw new IllegalNameException(expected, index, string, offset, endOffset);
                }
                case TS: {
                    assert (typeName == null);
                    if (Character.isJavaIdentifierStart(c)) {
                        offset = index;
                        state = TypeState.TP;
                        break;
                    }
                    throw new IllegalNameException("identifier", index, string, offset, endOffset);
                }
                case TSV: {
                    assert (typeName != null);
                    if (Character.isJavaIdentifierStart(c)) {
                        state = TypeState.TP;
                        break;
                    }
                    if (c == '.' && parameter) {
                        state = TypeState.TV2;
                        break;
                    }
                    throw new IllegalNameException("identifier", index, string, offset, endOffset);
                }
                case TP: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    if (c == '.') {
                        typeName = this.typeNameGetOrCreate(packageName, typeName, NameFormat.HYBRID, string.substring(offset, index));
                        state = TypeState.TSV;
                        break;
                    }
                    if (c == '[') {
                        typeName = this.typeNameGetOrCreate(packageName, typeName, NameFormat.HYBRID, string.substring(offset, index));
                        state = TypeState.TA0;
                        break;
                    }
                    if (c == '\uffff' && status == null) {
                        return this.typeNameGetOrCreate(packageName, typeName, NameFormat.HYBRID, string.substring(offset, index));
                    }
                    if (c == '/' && status != null && !parameter) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return this.typeNameGetOrCreate(packageName, null, NameFormat.HYBRID, string.substring(offset, index));
                    }
                    if ((c == ',' || c == ')') & parameter) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return this.typeNameGetOrCreate(packageName, typeName, NameFormat.HYBRID, string.substring(offset, index));
                    }
                    String terminator = status == null ? "or END-OF-NAME" : (parameter ? "',', or ')'" : "or '/'");
                    throw new IllegalNameException("identifier character, '[', " + terminator, index, string, offset, endOffset);
                }
                case TA0: {
                    assert (typeName != null);
                    if (c == ']') {
                        state = TypeState.TA1;
                        typeName = this.arrayNameGetOrCreate(typeName);
                        break;
                    }
                    throw new IllegalNameException("']'", index, string, offset, endOffset);
                }
                case TA1: {
                    assert (typeName != null);
                    if (c == '[') {
                        state = TypeState.TA0;
                        break;
                    }
                    if (c == '.' && parameter) {
                        state = TypeState.TV1;
                        break;
                    }
                    if (c == '\uffff' && status == null) {
                        return typeName;
                    }
                    if (c == '/' && status != null && !parameter) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return typeName;
                    }
                    if ((c == ',' || c == ')') && parameter) {
                        status.varargs = false;
                        status.terminator = c;
                        status.next = index + 1;
                        return typeName;
                    }
                    String terminator = status == null ? " or END-OF-NAME" : (parameter ? ", ',', or ')'" : " or '/'");
                    throw new IllegalNameException("'['" + terminator, index, string, offset, endOffset);
                }
                case TV1: {
                    assert (typeName != null);
                    if (c == '.') {
                        state = TypeState.TV2;
                        break;
                    }
                    throw new IllegalNameException("'.'", index, string, offset, endOffset);
                }
                case TV2: {
                    assert (typeName != null);
                    if (c == '.') {
                        state = TypeState.TV3;
                        typeName = this.arrayNameGetOrCreate(typeName);
                        break;
                    }
                    throw new IllegalNameException("'.'", index, string, offset, endOffset);
                }
                case TV3: {
                    assert (typeName != null);
                    if (c == ')') {
                        status.varargs = true;
                        status.terminator = c;
                        status.next = index + 1;
                        return typeName;
                    }
                    throw new IllegalNameException("')'", index, string, offset, endOffset);
                }
                default: {
                    throw new IllegalStateException("unexpected state " + (Object)((Object)state));
                }
            }
            ++index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstructorName constructorNameHybrid(TypeName typeName, String string, int offset, int endOffset, Parse unused) {
        int c;
        int index = offset;
        int n = c = index >= endOffset ? 65535 : (int)string.charAt(index);
        if (c != 40) {
            throw new IllegalNameException("'('", index, string, offset, endOffset);
        }
        if (++index + 1 == endOffset && string.charAt(index) == ')') {
            return new ConstructorName(typeName, TypeName.EMPTY_ARRAY, false);
        }
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            Parse status = new Parse();
            TypeName[] parameterTypes = this.parameterTypeNamesHybrid(string, index, endOffset, status);
            return new ConstructorName(typeName, parameterTypes, status.varargs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodName methodNameHybrid(TypeName typeName, String string, int offset, int endOffset, Parse unused) {
        char c;
        int index;
        if (offset < endOffset && !Character.isJavaIdentifierStart(string.charAt(offset))) {
            throw new IllegalNameException("identifier", offset, string, offset, endOffset);
        }
        for (index = offset + 1; index < endOffset && (c = string.charAt(index)) != '('; ++index) {
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalNameException("identifier character or '('", index, string, offset, endOffset);
        }
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            String methodName = this.identifiers.computeIfAbsent(string.substring(offset, index), k -> k);
            if (++index + 1 == endOffset && string.charAt(index) == ')') {
                return new MethodName(typeName, methodName, TypeName.EMPTY_ARRAY, false);
            }
            Parse status = new Parse();
            TypeName[] parameterTypes = this.parameterTypeNamesHybrid(string, index, endOffset, status);
            return new MethodName(typeName, methodName, parameterTypes, status.varargs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemberName memberNameHybrid(TypeName typeName, String string, int offset, int endOffset, Parse unused) {
        if (offset >= endOffset) {
            throw new IllegalNameException("identifier or '(", offset, string, offset, endOffset);
        }
        NameSpace nameSpace = this;
        synchronized (nameSpace) {
            boolean varargs;
            TypeName[] parameterTypes;
            String methodName = "";
            int index = offset;
            char c = string.charAt(index);
            if (Character.isJavaIdentifierStart(c)) {
                ++index;
                while (true) {
                    if (index == endOffset) {
                        return this.fieldName(typeName, string.substring(offset, index));
                    }
                    c = string.charAt(index);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    ++index;
                }
                methodName = this.identifiers.computeIfAbsent(string.substring(offset, index), k -> k);
            }
            if (c != '(') {
                throw new IllegalNameException("identifier or '(", index, string, offset, endOffset);
            }
            if (++index + 1 == endOffset && string.charAt(index) == ')') {
                parameterTypes = TypeName.EMPTY_ARRAY;
                varargs = false;
            } else {
                Parse status = new Parse();
                parameterTypes = this.parameterTypeNamesHybrid(string, index, endOffset, status);
                varargs = status.varargs;
            }
            if (methodName.isEmpty()) {
                return new ConstructorName(typeName, parameterTypes, varargs);
            }
            return new MethodName(typeName, methodName, parameterTypes, varargs);
        }
    }

    private TypeName[] parameterTypeNamesHybrid(String string, int offset, int endOffset, Parse status) {
        int parameterCount = 0;
        do {
            this.parameters[parameterCount++] = this.typeNameHybrid(null, string, offset, endOffset, true, status);
            offset = status.next;
        } while (status.terminator == ',');
        if (status.next != endOffset) {
            throw new IllegalNameException("END-OF-NAME", status.next, string, offset, endOffset);
        }
        return this.typeNames(this.parameters, parameterCount);
    }

    private FieldName fieldNameHybrid(TypeName typeName, String string, int offset, int endOffset, Parse unused) {
        int index;
        if (offset < endOffset && !Character.isJavaIdentifierStart(string.charAt(offset))) {
            throw new IllegalNameException("identifier", offset, string, offset, endOffset);
        }
        for (index = offset + 1; index < endOffset; ++index) {
            char c = string.charAt(index);
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalNameException("identifier character or END-OF-NAME", index, string, offset, endOffset);
        }
        return new FieldName(typeName, this.simpleIdentifier(string.substring(offset, index)));
    }

    public synchronized PackageName packageNameGetOrCreate(String name) {
        return this.packages.computeIfAbsent(this.identifiers.computeIfAbsent(name, k -> k), k -> new PackageName((String)k));
    }

    public synchronized PackageName packageNameGetOrCreate(CharSequence name, int offset, int endOffset) {
        int length = endOffset - offset;
        block0 : switch (length) {
            case 9: {
                int i = length;
                while (--i >= 0) {
                    if (name.charAt(offset + i) == JAVA_LANG.charAt(i)) continue;
                    break block0;
                }
                return PackageName.JAVA_LANG;
            }
        }
        return this.packages.computeIfAbsent(this.identifiers.computeIfAbsent(name.subSequence(offset, endOffset).toString(), k -> k), k -> new PackageName((String)k));
    }

    public synchronized TypeName typeNameGetOrCreate(PackageName packageName, TypeName outerType, NameFormat format, String sourceName) {
        List<TypeName> names;
        String predecessor = this.identifiers.putIfAbsent(sourceName, sourceName);
        if (predecessor != null) {
            sourceName = predecessor;
        }
        if ((names = this.types.get(sourceName)) == null) {
            TypeName name = outerType == null ? new TypeName(packageName, format, sourceName) : new InnerTypeName(outerType, format, sourceName);
            this.types.put(sourceName, Collections.singletonList(name));
            return name;
        }
        if (names.size() == 1) {
            TypeName name = names.get(0);
            if (packageName.equals(name.getPackage())) {
                if (format.ordinal() < name.getFormat().ordinal()) {
                    name = outerType == null ? new TypeName(packageName, format, sourceName) : new InnerTypeName(outerType, format, sourceName);
                    this.types.put(sourceName, Collections.singletonList(name));
                }
                return name;
            }
            name = outerType == null ? new TypeName(packageName, format, sourceName) : new InnerTypeName(outerType, format, sourceName);
            names = new ArrayList<TypeName>(names);
            this.types.put(sourceName, names);
            names.add(name);
            return name;
        }
        for (int i = 0; i < names.size(); ++i) {
            TypeName name = names.get(i);
            if (!packageName.equals(name.getPackage())) continue;
            if (format.ordinal() < name.getFormat().ordinal()) {
                name = outerType == null ? new TypeName(packageName, format, sourceName) : new InnerTypeName(outerType, format, sourceName);
                names.set(i, name);
            }
            return name;
        }
        TypeName name = outerType == null ? new TypeName(packageName, format, sourceName) : new InnerTypeName(outerType, format, sourceName);
        names.add(name);
        return name;
    }

    public synchronized TypeName arrayNameGetOrCreate(TypeName componentName) {
        List<TypeName> names;
        PackageName packageName = componentName.getPackage();
        NameFormat format = componentName.getFormat();
        String sourceName = componentName.getSourceName() + "[]";
        String predecessor = this.identifiers.putIfAbsent(sourceName, sourceName);
        if (predecessor != null) {
            sourceName = predecessor;
        }
        if ((names = this.types.get(sourceName)) == null) {
            ArrayTypeName name = new ArrayTypeName(componentName, sourceName);
            this.types.put(sourceName, Collections.singletonList(name));
            return name;
        }
        if (names.size() == 1) {
            TypeName name = names.get(0);
            if (packageName.equals(name.getPackage())) {
                if (format.ordinal() < name.getFormat().ordinal()) {
                    name = new ArrayTypeName(componentName, sourceName);
                    this.types.put(sourceName, Collections.singletonList(name));
                }
                return name;
            }
            name = new ArrayTypeName(componentName, sourceName);
            names = new ArrayList<TypeName>(names);
            this.types.put(sourceName, names);
            names.add(name);
            return name;
        }
        for (int i = 0; i < names.size(); ++i) {
            TypeName name = names.get(i);
            if (!packageName.equals(name.getPackage())) continue;
            if (format.ordinal() < name.getFormat().ordinal()) {
                name = new ArrayTypeName(componentName, sourceName);
                names.set(i, name);
            }
            return name;
        }
        ArrayTypeName name = new ArrayTypeName(componentName, sourceName);
        names.add(name);
        return name;
    }

    public TypeName[] typeNames(TypeName[] typeNames) {
        return this.typeNames(typeNames, typeNames.length);
    }

    public synchronized TypeName[] typeNames(TypeName[] typeNames, int endOffset) {
        if (typeNameArrayPool.isEmpty()) {
            TypeName[][] POOLED_ARRAYS = new TypeName[][]{{TypeName.BYTE}, {this.arrayNameGetOrCreate(TypeName.BYTE)}, {this.arrayNameGetOrCreate(TypeName.BYTE), TypeName.INT, TypeName.INT}, {TypeName.CHAR}, {this.arrayNameGetOrCreate(TypeName.CHAR)}, {this.arrayNameGetOrCreate(TypeName.CHAR), TypeName.INT, TypeName.INT}, {TypeName.SHORT}, {TypeName.INT}, {TypeName.INT, TypeName.INT}, {TypeName.INT, TypeName.JAVA_LANG_STRING}, {TypeName.INT, TypeName.INT, TypeName.INT}, {this.arrayNameGetOrCreate(TypeName.INT)}, {this.arrayNameGetOrCreate(TypeName.INT), TypeName.INT, TypeName.INT}, {TypeName.LONG}, {TypeName.FLOAT}, {TypeName.DOUBLE}, {TypeName.BOOLEAN}, {TypeName.BOOLEAN, TypeName.JAVA_LANG_STRING}, {this.typeNameHybrid("com.bea.xml/SchemaType")}, {this.typeNameHybrid("com.bea.xml/XmlID")}, {this.typeNameHybrid("com.bea.xml/XmlOptions")}, {this.typeNameHybrid("com.bea.xml/XmlString")}, {this.typeNameHybrid("java.io/File")}, {this.typeNameHybrid("java.io/File"), this.typeNameHybrid("com.bea.xml/XmlOptions")}, {this.typeNameHybrid("java.io/Reader")}, {this.typeNameHybrid("java.io/Reader"), this.typeNameHybrid("com.bea.xml/XmlOptions")}, {this.typeNameHybrid("java.io/InputStream")}, {this.typeNameHybrid("java.io/InputStream"), this.typeNameHybrid("com.bea.xml/XmlOptions")}, {this.typeNameHybrid("java.io/Serializable")}, {this.typeNameHybrid("java.lang.annotation/Annotation")}, {this.typeNameHybrid("java.lang/Boolean")}, {this.typeNameHybrid("java.lang/Class")}, {TypeName.JAVA_LANG_OBJECT}, {TypeName.JAVA_LANG_OBJECT, TypeName.JAVA_LANG_OBJECT}, {TypeName.JAVA_LANG_OBJECT, TypeName.JAVA_LANG_OBJECT_ARRAY}, {TypeName.JAVA_LANG_STRING_ARRAY}, {this.typeNameHybrid("java.lang/Runnable")}, {TypeName.JAVA_LANG_STRING}, {TypeName.JAVA_LANG_STRING, TypeName.BOOLEAN}, {TypeName.JAVA_LANG_STRING, TypeName.INT}, {TypeName.JAVA_LANG_STRING, this.typeNameHybrid("com.bea.xml/XmlOptions")}, {TypeName.JAVA_LANG_STRING, TypeName.JAVA_LANG_OBJECT}, {TypeName.JAVA_LANG_STRING, TypeName.JAVA_LANG_STRING}, {TypeName.JAVA_LANG_STRING, this.typeNameHybrid("java.lang/Throwable")}, {TypeName.JAVA_LANG_STRING, TypeName.INT, TypeName.INT}, {TypeName.JAVA_LANG_STRING, TypeName.JAVA_LANG_STRING, TypeName.JAVA_LANG_STRING}, {TypeName.JAVA_LANG_STRING, TypeName.JAVA_LANG_STRING, TypeName.JAVA_LANG_STRING, TypeName.JAVA_LANG_STRING}, {TypeName.JAVA_LANG_STRING_ARRAY}, {this.typeNameHybrid("java.lang/Throwable")}, {this.typeNameHybrid("java.net/URL")}, {this.typeNameHybrid("java.net/URL"), this.typeNameHybrid("com.bea.xml/XmlOptions")}, {this.typeNameHybrid("java.security/PrivilegedAction")}, {this.typeNameHybrid("java.security/PrivilegedExceptionAction")}, {this.typeNameHybrid("java.util/Iterator")}, {this.typeNameHybrid("java.util/Collection")}, {this.typeNameHybrid("java.util/List")}, {this.typeNameHybrid("java.util/Locale")}, {this.typeNameHybrid("java.util/Set")}, {this.typeNameHybrid("java.util/Map")}, {this.typeNameHybrid("javax.el/ValueExpression")}, {this.typeNameHybrid("javax.swing/JComponent")}, {this.typeNameHybrid("javax.xml.namespace/QName")}, {this.typeNameHybrid("javax.xml.stream/XMLStreamReader")}, {this.typeNameHybrid("javax.xml.stream/XMLStreamReader"), this.typeNameHybrid("com.bea.xml/XmlOptions")}, {this.typeNameHybrid("org.apache.myfaces.trinidad.bean/FacesBean")}, {this.typeNameHybrid("org.w3c.dom/Element")}, {this.typeNameHybrid("org.w3c.dom/Node")}, {this.typeNameHybrid("org.w3c.dom/Node"), this.typeNameHybrid("com.bea.xml/XmlOptions")}, {this.typeNameHybrid("org.python.core/PyObject")}, {this.typeNameHybrid("weblogic.xml.stream/XMLInputStream")}, {this.typeNameHybrid("weblogic.xml.stream/XMLInputStream"), this.typeNameHybrid("com.bea.xml/XmlOptions")}, {new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "")}};
            int first = 0;
            TypeName[] firstValue = POOLED_ARRAYS[0];
            TypeName firstKey = firstValue[0];
            for (int next = 1; next < POOLED_ARRAYS.length; ++next) {
                assert (firstValue.length == 1);
                TypeName[] nextValue = POOLED_ARRAYS[next];
                TypeName nextKey = nextValue[0];
                if (nextKey == firstKey) continue;
                TypeName[][] values = new TypeName[next - first][];
                values[0] = firstValue;
                int lastLength = firstValue.length;
                assert (lastLength == 1);
                for (int i = 1; i < next - first; ++i) {
                    TypeName[] value = POOLED_ARRAYS[first + i];
                    assert (value.length >= lastLength);
                    values[i] = value;
                    lastLength = value.length;
                }
                typeNameArrayPool.put(firstKey, values);
                first = next;
                firstValue = nextValue;
                firstKey = nextKey;
            }
        }
        block0 : switch (endOffset) {
            case 0: {
                return TypeName.EMPTY_ARRAY;
            }
            case 1: {
                TypeName[][] values = typeNameArrayPool.get(typeNames[0]);
                if (values == null) break;
                return values[0];
            }
            case 2: {
                TypeName[] value;
                int i;
                TypeName[][] values = typeNameArrayPool.get(typeNames[0]);
                if (values == null) break;
                for (i = 1; i < values.length && (value = values[i]).length == 2; ++i) {
                    if (value[1] != typeNames[1]) continue;
                    return value;
                }
                break;
            }
            case 3: {
                TypeName[] value;
                TypeName[][] values = typeNameArrayPool.get(typeNames[0]);
                if (values == null) break;
                int i = values.length;
                while (--i > 0) {
                    value = values[i];
                    if (value.length > endOffset) continue;
                    if (value.length < endOffset) break block0;
                    if (value[1] != typeNames[1] || value[2] != typeNames[2]) continue;
                    return value;
                }
                break;
            }
            case 4: {
                TypeName[] value;
                TypeName[][] values = typeNameArrayPool.get(typeNames[0]);
                if (values == null) break;
                int i = values.length;
                while (--i > 0 && (value = values[i]).length >= endOffset) {
                    if (value[1] != typeNames[1] || value[2] != typeNames[2] || value[3] != typeNames[3]) continue;
                    return value;
                }
                break;
            }
        }
        if (endOffset == typeNames.length) {
            return typeNames;
        }
        TypeName[] names = new TypeName[endOffset];
        System.arraycopy(typeNames, 0, names, 0, endOffset);
        return names;
    }

    private static enum TypeState {
        PS0,
        PS1,
        PPMATCHB,
        PPMATCH,
        PPMATCHED,
        PP,
        TS,
        TSV,
        TP,
        TA1,
        TA0,
        TV1,
        TV2,
        TV3;

    }

    private static enum PackageState {
        PS,
        PP;

    }

    private static class Parse {
        private boolean varargs;
        private char terminator;
        private int next;

        private Parse() {
        }
    }

    private static enum State {
        MS,
        MG0,
        MG1,
        MP0,
        MP1,
        CS0,
        CS1,
        CP,
        S0,
        S1,
        P,
        X,
        X0,
        X1,
        SV,
        G0,
        A0,
        A1,
        A2,
        V0,
        V1,
        V2,
        V3,
        DONE;

    }

    private static enum MethodOrConstructorCreator {
        CONSTRUCTOR_CREATOR,
        METHOD_CREATOR;


        public <T extends MemberName> T create(TypeName typeName, String methodName, TypeName[] parameterTypeNames, boolean varargs) {
            switch (this) {
                case CONSTRUCTOR_CREATOR: {
                    return (T)new ConstructorName(typeName, parameterTypeNames, varargs);
                }
                case METHOD_CREATOR: {
                    return (T)new MethodName(typeName, methodName, parameterTypeNames, varargs);
                }
            }
            throw new IllegalStateException();
        }
    }
}

